<?php
/*
 * passwd Configuration File
 *
 * This file contains global configuration settings for passwd. Values
 * may be safely edited by hand. Use conf.php.dist as a reference.
 *
 * Strings should be enclosed in 'quotes'.
 * Integers should be given literally (without quotes).
 * Boolean values may be 'true' or 'false'.
 *
 * $Horde: passwd/config/conf.php.dist,v 1.1.1.1.2.3 2003/01/21 01:28:29 ericr Exp $
 */

// Define apps to put in the menu bar.  To include IMP in the menu bar, you
// would add: $conf['menu']['apps'] = array('imp');

$conf['menu']['apps'] = array();

// Should we display a list of backends (defined in config/backends.php) for
// users to choose from?  The options are 'shown' or 'hidden'.  If the list
// is 'hidden' then you can use the 'preferred' mechanism to auto-select
// a backend based on the HTTP virtualhost or another piece of data.  If it
// is 'shown' then the user will be able to pick from any of the backends.

$conf['backend']['backend_list'] = 'hidden';

// Define usernames for which we will refuse to change passwords.
// This may or may not work with realms or virtual hosting, depending on setup

$conf['user']['refused'] = array('root','bin','daemon','adm','lp','shutdown',
     'halt','uucp','ftp','anonymous','nobody','httpd','operator','guest',
     'diginext','bind','courier','cyrus','games','kmem','mailnull','man',
     'mysql','news','postfix','sshd','tty','www');

// Should we perform simple strength tests on the passwords?

$conf['password']['strengthtests'] = true;

// Use a custom hook for modifying the username, or determining a
// default username
// Make sure to update $conf['user']['refused'] to match the username
// format retuned by this function
$conf['hooks']['username'] = false;
$conf['hooks']['default_username'] = false;
