<?php
/**
 * $Horde: moment/sendUpdates.php,v 1.15 2003/09/01 22:56:38 jan Exp $
 *
 * Copyright 2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file LICENSE for license information.
 */

@define('MOMENT_BASE', dirname(__FILE__));
require_once MOMENT_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/Identity.php';
require_once HORDE_BASE . '/lib/iCalendar.php';

$actionID = Horde::getFormData('actionID');
$meetingID = Horde::getFormData('meetingID');
$mode = Horde::getFormData('mode');

/* Create a storage instance. */
$storage = &Moment_Driver::singleton();
$storage->retrieve();

$meeting = $storage->getMeeting($meetingID);
if (is_a($meeting, 'PEAR_Error')) {
    $notification->push(_("Invalid Meeting ID."), 'horde.error');
    header('Location: ' . Horde::applicationUrl('list.php'));
    exit;
}

if (!array_key_exists('attendees', $meeting)) {
    $meeting['attendees'] = array();
}

switch ($actionID) {
 case MOMENT_SEND:
     require_once HORDE_BASE . '/lib/MIME.php';
     require_once HORDE_BASE . '/lib/MIME/Message.php';

     // Get the Identity for the organizer.
     $identity = &new Identity(Auth::getAuth());
     $email = $identity->getValue('from_addr');
     $cn = $identity->getValue('fullname');
     if (empty($email)) {
         $notification->push(_("You don't have an email address configured in your preferences. You must set one before sending anything."), 'horde.error');
         break;
     }

     if ($mode == 'cancel') {
         $cancel = Horde::getFormData('cancel', array());

         if (count($cancel)) {
             // Send Cancelation Message
             $vCal = Moment::iCalCancel($meeting);

             // Create the email
             list($mailbox, $host) = explode('@', $email);
             $from = MIME::rfc822WriteAddress($mailbox, $host, $cn);

             // Add a Received header for the hop from browser to server.
             $remote = (!empty($_SERVER['REMOTE_HOST'])) ? $_SERVER['REMOTE_HOST'] : $_SERVER['REMOTE_ADDR'];
             $headers['Received'] = 'from ' . $remote . ' (';
             if (!empty($_SERVER['REMOTE_IDENT'])) {
                 $headers['Received'] .= $_SERVER['REMOTE_IDENT'] . '@' . $remote;
             }
             $headers['Received'] .= ' [' . $remote . '])';
             $headers['Received'] .= "\n\t by " . $conf['server']['name'] . ' with HTTP;';
             $headers['Received'] .= "\n\t" . date('r');

             $headers['Message-ID'] = MIME::generateMessageID();
             $headers['Date'] = date('r');
             $headers['To'] = implode(', ', array_keys($cancel));
             $headers['From'] = $from;
             $headers['Subject'] = sprintf(_("Meeting has been cancelled: %s"), $meeting['title']);
             $headers['User-Agent'] = 'Moment Meeting Planner';

             $message = sprintf(_("Meeting has been cancelled: \"%s\"."), $meeting['title']) . "\n\n";
             $message .= _("Attached is an iCalendar file containing the cancellation.");

             $mime = &new MIME_Message();
             $body = &new MIME_Part('text/plain', Text::wrap($message, 80, "\n"));

             $ics = &new MIME_Part('text/calendar', $vCal->exportvCalendar());
             $ics->setName('icalendar.ics');
             $ics->setContentTypeParameter('METHOD', 'CANCEL');

             $mime->addPart($body);
             $mime->addPart($ics);
             $headers = $mime->header($headers);

             $status = $mime->send(implode(', ', array_keys($cancel)), $headers);
             if (!is_a($status, 'PEAR_Error')) {
                 $notification->push(_("Your cancellations were successfully sent."), 'horde.success');
             } else {
                 $notification->push(sprintf(_("There was an error sending your cancellations: %s"), $status->getMessage()), 'horde.error');
             }
         }
         header('Location: ' . Horde::applicationUrl('list.php'));
         exit;
     } else {
         $update = Horde::getFormData('update', array());
         $invite = Horde::getFormData('invite', array());

         if (count($invite)) {
             // Send Invites
             $vCal = Moment::iCalRequest($meeting);

             // Create the email
             list($mailbox, $host) = explode('@', $email);
             $from = MIME::rfc822WriteAddress($mailbox, $host, $cn);

             // Add a Received header for the hop from browser to server.
             $remote = (!empty($_SERVER['REMOTE_HOST'])) ? $_SERVER['REMOTE_HOST'] : $_SERVER['REMOTE_ADDR'];
             $headers['Received'] = 'from ' . $remote . ' (';
             if (!empty($_SERVER['REMOTE_IDENT'])) {
                 $headers['Received'] .= $_SERVER['REMOTE_IDENT'] . '@' . $remote;
             }
             $headers['Received'] .= ' [' . $remote . '])';
             $headers['Received'] .= "\n\t by " . $conf['server']['name'] . ' with HTTP;';
             $headers['Received'] .= "\n\t" . date('r');

             $headers['Message-ID'] = MIME::generateMessageID();
             $headers['Date'] = date('r');
             $headers['To'] = implode(', ', array_keys($invite));
             $headers['From'] = $from;
             $headers['Subject'] = sprintf(_("You have been invited to %s"), $meeting['title']);
             $headers['User-Agent'] = 'Moment Meeting Planner';

             $message = sprintf(_("You have been invited to \"%s\"."), $meeting['title']) . "\n\n";
             $message .= _("Here is a more detailed description:") . "\n\n" . $meeting['title'] . "\n\n";
             $message .= _("Attached is an iCalendar file requesting a reply to this event. If your mail client does not prompt you to reply, please email the organizer to confirm your attendence.");

             $mime = &new MIME_Message();
             $body = &new MIME_Part('text/plain', Text::wrap($message, 80, "\n"));

             $ics = &new MIME_Part('text/calendar', $vCal->exportvCalendar());
             $ics->setName('icalendar.ics');
             $ics->setContentTypeParameter('METHOD', 'REQUEST');

             $mime->addPart($body);
             $mime->addPart($ics);
             $headers = $mime->header($headers);

             $status = $mime->send(implode(', ', array_keys($invite)), $headers);
             if (!is_a($status, 'PEAR_Error')) {
                 $notification->push(_("Your invitations were successfully sent."), 'horde.success');
             } else {
                 $notification->push(sprintf(_("There was an error sending your invitations: %s"), $status->getMessage()), 'horde.error');
             }
         }

         if (count($update)) {
             // Send Updates
             $vCal = Moment::iCalRequest($meeting);

             // Create the email
             list($mailbox, $host) = explode('@', $email);
             $from = MIME::rfc822WriteAddress($mailbox, $host, $cn);

             // Add a Received header for the hop from browser to server.
             $remote = (!empty($_SERVER['REMOTE_HOST'])) ? $_SERVER['REMOTE_HOST'] : $_SERVER['REMOTE_ADDR'];
             $headers['Received'] = 'from ' . $remote . ' (';
             if (!empty($_SERVER['REMOTE_IDENT'])) {
                 $headers['Received'] .= $_SERVER['REMOTE_IDENT'] . '@' . $remote;
             }
             $headers['Received'] .= ' [' . $remote . '])';
             $headers['Received'] .= "\n\t by " . $conf['server']['name'] . ' with HTTP;';
             $headers['Received'] .= "\n\t" . date('r');

             $headers['Message-ID'] = MIME::generateMessageID();
             $headers['Date'] = date('r');
             $headers['To'] = implode(', ', array_keys($update));
             $headers['From'] = $from;
             $headers['Subject'] = sprintf(_("Meeting has been update: %s"), $meeting['title']);
             $headers['User-Agent'] = 'Moment Meeting Planner';

             $message = sprintf(_("The meeting \"%s\" has been updates.\n\n"), $meeting['title']);
             $message .= _("Attached is an iCalendar file containing up to date details of the meeting.");

             $mime = &new MIME_Message();
             $body = &new MIME_Part('text/plain', Text::wrap($message, 80, "\n"));

             $ics = &new MIME_Part('text/calendar', $vCal->exportvCalendar());
             $ics->setName('icalendar.ics');
             $ics->setContentTypeParameter('METHOD', 'REQUEST');

             $mime->addPart($body);
             $mime->addPart($ics);
             $headers = $mime->header($headers);

             $status = $mime->send(implode(', ', array_keys($update)), $headers);
             if (!is_a($status, 'PEAR_Error')) {
                 $notification->push(_("Your updates were successfully sent."), 'horde.success');
             } else {
                 $notification->push(sprintf(_("There was an error sending your updates: %s"), $status->getMessage()), 'horde.error');
             }
         }

         header('Location: ' . Horde::applicationUrl(Horde::addParameter('viewMeeting.php', 'meetingID', $meetingID)));
         exit;
     }

     break;
}

switch ($mode) {
 case 'new':
     $title = _("Send Invitations");
     break;

 case 'update':
     $title = _("Send Invitations or Updates");
     break;

 case 'delete':
     $title = _("Send Cancellation Notices");
     break;
}

require MOMENT_TEMPLATES . '/common-header.inc';
Moment::menu();
require MOMENT_TEMPLATES . '/sendUpdates/updates.inc';
require MOMENT_TEMPLATES . '/common-footer.inc';
