<?php
/**
 * $Horde: kronolith/editevent.php,v 1.39 2003/05/22 21:48:28 chuck Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

if (Horde::getFormData('calendar') == '**remote') {
    $event = Kronolith::getRemoteEventObject(Horde::getFormData('remoteCal'), Horde::getFormData('eventID'));
} else {
    $calendar = &Kronolith_Driver::factory($conf['calendar']['driver'], $conf['calendar']['params']);
    $calendar->open(Horde::getFormData('calendar'));
    $event = &$calendar->getEventObject(Horde::getFormData('eventID'));
}

$calendar_id = $event->getCalendar();

if ($timestamp = Horde::getFormData('timestamp')) {
    $month = date('n', $timestamp);
    $year = date('Y', $timestamp);
} else {
    $month = Horde::getFormData('month', date('n'));
    $year = Horde::getFormData('year', date('Y'));
}

$url = Horde::getFormData('url');

$title = sprintf(_("Edit %s"), $event->getTitle());

require KRONOLITH_TEMPLATES . '/common-header.inc';
Kronolith::menu();
require KRONOLITH_TEMPLATES . '/edit/javascript.inc';

$buttons = array();
$share = &$GLOBALS['shares']->getShare(Horde::getFormData('calendar'));
if (Horde::getFormData('calendar') == '**remote' || !$share->hasPermission(Auth::getAuth(), _PERMS_EDIT, $event->getCreatorID())) {
    $buttons[] = '<input type="submit" class="button" name="saveAsNew" value="' . _("Save As New") . '" onclick="return checkCategory();" />';
} else {
    $buttons[] = '<input type="submit" class="button" name="save" value="' . _("Save Event") . '" onclick="return checkCategory();" />';
    if ($event->isInitialized()) {
        $buttons[] = '<input type="submit" class="button" name="saveAsNew" value="' . _("Save As New") . '" onclick="return checkCategory();" />';
        if ($share->hasPermission(Auth::getAuth(), _PERMS_DELETE, $event->getCreatorID())) {
            $delurl = Horde::addParameter('delevent.php', 'eventID=' . $event->getID());
            $delurl = Horde::addParameter($delurl, 'calendar=' . $event->getCalendar());
            $delurl = Horde::addParameter($delurl, 'month=' . $month);
            $delurl = Horde::addParameter($delurl, 'year=' . $year);
            if (isset($url)) {
                $delurl = Horde::addParameter($delurl, 'url', $url);
            }
            if (isset($timestamp)) {
                $delurl = Horde::addParameter($delurl, 'timestamp=' . $timestamp);
            }
            $delurl = Horde::applicationUrl($delurl);
            $buttons[] = '<input type="submit" class="button" name="delete" value="' . _("Delete Event") . '" onclick="self.location = \'' . $delurl . '\'; return false;" />';
        }
    }
}

if (isset($url)) {
    $cancelurl = $url;
} else {
    $cancelurl = Horde::addParameter('month.php', 'month=' . $month);
    $cancelurl = Horde::addParameter($cancelurl, 'year=' . $year);
    $cancelurl = Horde::applicationUrl($cancelurl);
}

require KRONOLITH_TEMPLATES . '/edit/edit.inc';
require KRONOLITH_TEMPLATES . '/common-footer.inc';
