#pragma once
#include "Options.h"
#include "Image.h"

namespace graphics {

	/**
	 * ICO options.
	 *
	 * Note: We don't support saving ICO files currently.
	 */
	class ICOOptions : public FormatOptions {
		STORM_CLASS;
	public:
		// Create, default options.
		STORM_CTOR ICOOptions();

		// Load only the best color-depth of each image? (default)
		Bool bestQualityOnly;

		// Load an image.
		virtual Image *STORM_FN load(IStream *from);
		virtual ImageSet *STORM_FN loadSet(IStream *from);
		using FormatOptions::load;

		// Save an image.
		virtual void STORM_FN save(Image *image, OStream *to);
		using FormatOptions::save;

		// Output.
		virtual void STORM_FN toS(StrBuf *to) const;
	};

	// Create ImageFormat. For internal use.
	ImageFormat *icoFormat(Engine &e);

}
