# Antimicrobial Abbreviations

In ResFinder results where antimicrobial abbreviations are used, it will use the [EUCAST System for Antimicrobial Abbreviations](https://www.eucast.org/fileadmin/src/media/PDFs/EUCAST_files/Disk_test_documents/Disk_abbreviations/EUCAST_system_for_antimicrobial_abbreviations.pdf).

Exception is the ResFinder results "unknown <class>". See bottom of list.

## Abbreviations

| Antimicrobial                                 | Abbreviation |
|-----------------------------------------------|--------------|
| Amikacin                                      | AMI          |
| Amoxicillin                                   | AMO          |
| Amoxicillin+clavulanic acid                   | AMC          |
| Ampicillin                                    | AMP          |
| Ampicillin+clavulanic acid                    | AML          |
| Ampicillin+sulbactam                          | AMS          |
| Apramycin                                     | APR          |
| Arbekacin                                     | ARB          |
| Astromicin                                    | AST          |
| Avibactam                                     | AVI          |
| Azithromycin                                  | AZI          |
| Aztreonam                                     | AZT          |
| Bedaquiline                                   | BED          |
| Benzylpenicillin                              | BEN          |
| Butiromycin                                   | BUT          |
| Butirosin                                     | BUI          |
| Capreomycin                                   | CAP          |
| Carbomycin                                    | CAR          |
| Cefaclor                                      | CCL          |
| Cefadroxil                                    | CDR          |
| Cefalexin                                     | CLE          |
| Cefazolin                                     | CZO          |
| Cefepime                                      | CEP          |
| Cefixime                                      | CIX          |
| Cefotaxime                                    | CTA          |
| Cefotaxime+clavulanic acid                    | CTC          |
| Cefoxitin                                     | CXI          |
| Cefpodoxime                                   | CPO          |
| Ceftaroline                                   | CTL          |
| Ceftazidime                                   | CTZ          |
| Ceftazidime+avibactam                         | CTV          |
| Ceftibuten                                    | CTI          |
| Ceftiofur                                     | CTF          |
| Ceftobiprole                                  | CTO          |
| Ceftolozane+tazobactam                        | CTT          |
| Ceftriaxone                                   | CTR          |
| Cefuroxime                                    | CUR          |
| Cephalothin                                   | CLT          |
| Cephalotin                                    | CLT          |
| Chloramphenicol                               | CHL          |
| Ciprofloxacin                                 | CIP          |
| Clarithromycin                                | CLA          |
| Clavulanic acid                               | CLV          |
| Clindamycin                                   | CLI          |
| Clofazimine                                   | CLF          |
| Cloxacillin                                   | CLO          |
| Colistin                                      | COL          |
| D-Cycloserine                                 | DCY          |
| Dalbavancin                                   | DAL          |
| Dalfopristin                                  | DAF          |
| Daptomycin                                    | DAP          |
| Dibekacin                                     | DIB          |
| Dicloxacillin                                 | DIC          |
| Difloxacin                                    | DIF          |
| Doripenem                                     | DOR          |
| Doxycycline                                   | DOX          |
| Enrofloxacin                                  | ENR          |
| Ertapenem                                     | ERT          |
| Erythromycin                                  | ERY          |
| Ethambutol                                    | ETH          |
| Ethionamide                                   | ETI          |
| Florfenicol                                   | FLO          |
| Flucloxacillin                                | FLU          |
| Fortimicin                                    | FOR          |
| Fosfomycin                                    | FOS          |
| Fusidic acid                                  | FUS          |
| G418                                          | G41          |
| Gamithromycin                                 | GAM          |
| Gentamicin                                    | GEN          |
| Gentamicin c                                  | GET          |
| Gepotidacin                                   | GEP          |
| Hygromycin                                    | HYG          |
| Imipenem                                      | IMI          |
| Isepamicin                                    | ISE          |
| Isoniazid                                     | ISO          |
| Kanamycin                                     | KAN          |
| Kanamycin a                                   | KAA          |
| Kasugamycin                                   | KAS          |
| Levofloxacin                                  | LEV          |
| Lincomycin                                    | LIC          |
| Linezolid                                     | LIN          |
| Lividomycin                                   | LIV          |
| Maduramicin                                   | MAD          |
| Marbofloxacin                                 | MAR          |
| Mecillinam                                    | MEC          |
| Meropenem                                     | MER          |
| Methicillin                                   | MEH          |
| Metronidazole                                 | MET          |
| Minocycline                                   | MIN          |
| Moxifloxacin                                  | MOX          |
| Mupirocin                                     | MUP          |
| Nalidixic acid                                | NAL          |
| Narasin                                       | NAR          |
| Neomycin                                      | NEO          |
| Netilmicin                                    | NET          |
| Nitrofurantoin                                | NIT          |
| Norfloxacin                                   | NOR          |
| Novobiocin                                    | NOV          |
| Ofloxacin                                     | OFL          |
| Oleandomycin                                  | OLE          |
| Orbifloxacin                                  | ORB          |
| Oritavancin                                   | ORI          |
| Oxacillin                                     | OXA          |
| Oxytetracycline                               | OXY          |
| Para-aminosalicyclic acid                     | PAR          |
| Paromomycin                                   | PAO          |
| Pefloxacin                                    | PEF          |
| Penicillin                                    | PEN          |
| Phenethicillin                                | PHN          |
| Phenoxymethypenicillin                        | PHE          |
| Pipemidic acid                                | PIE          |
| Piperacillin                                  | PIP          |
| Piperacillin+clavulanic acid                  | PIC          |
| Piperacillin+tazobactam                       | PIT          |
| Pirlimycin                                    | PIR          |
| Pradofloxacin                                 | PRA          |
| Pristinamycin IA                              | PRI          |
| Pristinamycin IIA                             | PRS          |
| Pyrazinamide                                  | PYR          |
| Quinupristin                                  | QUI          |
| Quinupristin+dalfopristin                     | QUD          |
| Relabactam                                    | REL          |
| Retapamulin                                   | RET          |
| Ribostamycin                                  | RIB          |
| Rifampicin                                    | RIF          |
| Roxithromycin                                 | ROX          |
| Salinomycin                                   | SAL          |
| Sisomicin                                     | SIS          |
| Spectinomycin                                 | SPE          |
| Spiramycin                                    | SPI          |
| Streptomycin                                  | STR          |
| Sulbactam                                     | SUL          |
| Sulfamethoxazole                              | SME          |
| Sulfathiazole                                 | STH          |
| Sulfisoxazole                                 | SIS          |
| Tazobactam                                    | TAZ          |
| Tedizolid                                     | TED          |
| Teicoplanin                                   | TEI          |
| Telavancin                                    | TEL          |
| Telithromycin                                 | TEH          |
| Temocillin                                    | TEM          |
| Tetracycline                                  | TET          |
| Tiamulin                                      | TIA          |
| Ticarcillin                                   | TIC          |
| Ticarcillin+clavulanic acid                   | TIL          |
| Tigecycline                                   | TIG          |
| Tildipirosin                                  | TID          |
| Tilmicosin                                    | TIM          |
| Tobramycin                                    | TOB          |
| Trimethoprim                                  | TRI          |
| Trimethoprim+sulfamethoxazole                 | TRS          |
| Tulathromycin                                 | TUL          |
| Tylosin                                       | TYL          |
| Vaborbactam                                   | VAB          |
| Valnemulin                                    | VAL          |
| Vancomycin                                    | VAN          |
| Virginiamycin M                               | VIR          |
| Virginiamycin S                               | VIG          |
| Unknown aminoglycoside                        | UAM          |
| Unknown aminocyclitol                         | UAC          |
| Unknown analog of d-alanine                   | UAN          |
| Unknown beta-lactam                           | UBE          |
| Unknown diarylquinoline                       | UDI          |
| Unknown fluoroquinolone                       | UFL          |
| Unknown folate pathway antagonist             | UFO          |
| Unknown fosfomycin                            | UFS          |
| Unknown glycopeptide                          | UGL          |
| Unknown iminophenazine                        | UIM          |
| Unknown isonicotinic acid hydrazide           | UIS          |
| Unknown lincosamide                           | ULI          |
| Unknown macrolide                             | UMA          |
| Unknown nitroimidazole                        | UNI          |
| Unknown oxazolidinone                         | UOX          |
| Unknown phenicol                              | UPH          |
| Unknown pleuromutilin                         | UPL          |
| Unknown polymyxin                             | UPO          |
| Unknown pseudomonic acid                      | UPS          |
| Unknown rifamycin                             | URI          |
| Unknown salicylic acid - anti-folate          | USA          |
| Unknown steroid antibacterial                 | USE          |
| Unknown streptogramin a                       | UST          |
| Unknown streptogramin b                       | USR          |
| Unknown synthetic derivative of nicotinamide  | USY          |
| Unknown tetracycline                          | UTE          |
| Unknown thioamide                             | UTH          |
| Unknown unspecified                           | UUN          |
