% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handout.R, R/html.R, R/utils.R
\name{tufte_handout}
\alias{tufte_handout}
\alias{tufte_book}
\alias{tufte_html}
\alias{newthought}
\alias{margin_note}
\alias{quote_footer}
\alias{sans_serif}
\title{Tufte handout formats (PDF and HTML)}
\usage{
tufte_handout(
  fig_width = 4,
  fig_height = 2.5,
  fig_crop = TRUE,
  dev = "pdf",
  highlight = "default",
  ...
)

tufte_book(
  fig_width = 4,
  fig_height = 2.5,
  fig_crop = TRUE,
  dev = "pdf",
  highlight = "default",
  ...
)

tufte_html(
  ...,
  tufte_features = c("fonts", "background", "italics"),
  tufte_variant = c("default", "envisioned"),
  margin_references = TRUE
)

newthought(text)

margin_note(text, icon = "&#8853;")

quote_footer(text)

sans_serif(text)
}
\arguments{
\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_crop}{Whether to crop PDF figures with the command
\command{pdfcrop}. This requires the tools \command{pdfcrop} and
\command{ghostscript} to be installed. By default, \code{fig_crop = TRUE}
if these two tools are available.}

\item{dev}{Graphics device to use for figure output (defaults to pdf)}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso",
"zenburn", and "haddock". Pass \code{NULL} to prevent syntax highlighting.}

\item{...}{Other arguments to be passed to \code{\link{pdf_document}} or
\code{\link{html_document}} (note you cannot use the \code{template}
argument in \code{tufte_handout} or the \code{theme} argument in
\code{tufte_html()}; these arguments have been set internally)}

\item{tufte_features}{A character vector of style features to enable:
\code{fonts} stands for the \code{et-book} fonts in the \code{tufte-css}
project, \code{background} means the lightyellow background color of the
page, and \code{italics} means whether to use italics for the headers. You
can enable a subset of these features, or just disable all of them by
\code{NULL}. When this argument is not used and the \code{tufte_variant}
argument is not \code{default}, no features are enabled.}

\item{tufte_variant}{A variant of the Tufte style. Currently supported styles
are \code{default} (from the \code{tufte-css} project), and
\code{envisioned} (inspired by the project \code{Envisioned CSS}
\url{https://github.com/nogginfuel/envisioned-css} but essentially just
sets the font family to \code{Roboto Condensed}, and changed the
background/foreground colors).}

\item{margin_references}{Whether to place citations in margin notes.}

\item{text}{A character string to be presented as a \dQuote{new thought}
(using small caps), or a margin note, or a footer of a quote}

\item{icon}{A character string to indicate there is a hidden margin note when
the page width is too narrow (by default it is a circled plus sign)}
}
\description{
Templates for creating handouts according to the style of Edward R. Tufte and
Richard Feynman.
}
\details{
\code{tufte_handout()} provides the PDF format based on the Tufte-LaTeX
class: \url{https://tufte-latex.github.io/tufte-latex/}.

\code{tufte_html()} provides the HTML format based on the Tufte CSS:
  \url{https://edwardtufte.github.io/tufte-css/}.

\code{newthought()} can be used in inline R expressions in R
  Markdown (e.g. \samp{`r newthought(Some text)`}), and it works for both
  HTML (\samp{<span class="newthought">text</span>}) and PDF
  (\samp{\\newthought{text}}) output.

\code{margin_note()} can be used in inline R expressions to write a
  margin note (like a sidenote but not numbered).

\code{quote_footer()} formats text as the footer of a quote. It puts
  \code{text} in \samp{<footer></footer>} for HTML output, and
  after \samp{\\hfill} for LaTeX output (to right-align text).

\code{sans_serif()} applies sans-serif fonts to \code{text}.
}
\examples{
library(tufte)
newthought('In this section')
}
\references{
See \url{https://rstudio.github.io/tufte/} for an example.
}
