% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_group_sequential.R
\name{getDesignCharacteristics}
\alias{getDesignCharacteristics}
\title{Get Design Characteristics}
\usage{
getDesignCharacteristics(design)
}
\arguments{
\item{design}{The trial design.}
}
\value{
Returns a \code{\link{TrialDesignCharacteristics}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
\item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.ParameterSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.ParameterSet]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.TrialDesignCharacteristics]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Calculates the characteristics of a design and returns it.
}
\details{
Calculates the inflation factor (IF),
the expected reduction in sample size under H1, under H0, and under a value in between H0 and H1.
Furthermore, absolute information values are calculated
under the prototype case testing H0: mu = 0 against H1: mu = 1.
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
# Calculate design characteristics for a three-stage O'Brien & Fleming 
# design at power 90\% and compare it with Pocock's design.  
getDesignCharacteristics(getDesignGroupSequential(beta = 0.1))
getDesignCharacteristics(getDesignGroupSequential(beta = 0.1, typeOfDesign = "P")) 

}
\seealso{
Other design functions: 
\code{\link{getDesignConditionalDunnett}()},
\code{\link{getDesignFisher}()},
\code{\link{getDesignGroupSequential}()},
\code{\link{getDesignInverseNormal}()},
\code{\link{getGroupSequentialProbabilities}()},
\code{\link{getPowerAndAverageSampleNumber}()}
}
\concept{design functions}
