% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctl_pillar_component.R
\name{new_pillar_component}
\alias{new_pillar_component}
\alias{pillar_component}
\title{Components of a pillar}
\usage{
new_pillar_component(x, ..., width, min_width = NULL)

pillar_component(x)
}
\arguments{
\item{x}{A bare list of length one (for \code{new_pillar_component()}),
or an object with \code{"width"} and \code{"min_width"} attributes
(for \code{pillar_component()}).}

\item{...}{These dots are for future extensions and must be empty.}

\item{width, min_width}{Width and minimum width for the new component.
If \code{min_width} is \code{NULL}, it is assumed to match \code{width}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{new_pillar_component()} constructs an object of class \code{"pillar_component"}.
It is used by custom \code{\link[=ctl_new_pillar]{ctl_new_pillar()}} methods to create pillars with
nonstandard components.

\code{pillar_component()} is a convenience helper that wraps the input in a list
and extracts width and minimum width.
}
\details{
Objects of class \code{"pillar"} are internally a named lists of their components.
The default components for pillars created by \code{\link[=pillar]{pillar()}} are:
\code{title} (may be missing), \code{type}, and \code{data}.
Each component is a \code{"pillar_component"} object.

This class captures contents that can be fitted in a simple column.
Compound columns are represented by multiple pillar objects, each with their
own components.
}
\examples{
new_pillar_component(list(letters[1:3]), width = 1)
pillar_component(new_pillar_title("letters"))
pillar_component(new_pillar_type(letters))
pillar_component(pillar_shaft(letters[1:3]))
}
