% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{raw_block}
\alias{raw_block}
\alias{raw_latex}
\alias{raw_html}
\title{Mark character strings as raw blocks in R Markdown}
\usage{
raw_block(x, type = "latex", ...)

raw_latex(x, ...)

raw_html(x, ...)
}
\arguments{
\item{x}{The character vector to be protected.}

\item{type}{The type of raw blocks (i.e., the Pandoc output format). If you
are not sure about the Pandoc output format of your document, insert a code
chunk \code{knitr:::pandoc_to()} and see what it returns after the document
is compiled.}

\item{...}{Arguments to be passed to \code{\link{asis_output}()}.}
}
\description{
Wraps content in a raw attribute block, which protects it from being escaped
by Pandoc. See \url{https://pandoc.org/MANUAL.html#generic-raw-attribute}.
Functions \code{raw_latex()} and \code{raw_html()} are shorthands of
\code{raw_block(x, 'latex')} and \code{raw_block(x, 'html')}, respectively.
}
\examples{
knitr::raw_latex("\\\\emph{some text}")
}
