% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gprofiler2.R
\name{gorth}
\alias{gorth}
\title{Orthology search.}
\usage{
gorth(
  query,
  source_organism = "hsapiens",
  target_organism = "mmusculus",
  numeric_ns = "",
  mthreshold = Inf,
  filter_na = TRUE
)
}
\arguments{
\item{query}{character vector of gene IDs to be translated.}

\item{source_organism}{name of the source organism. Organism names are constructed by concatenating
the first letter of the name and the family name. Example: human - 'hsapiens',
mouse - 'mmusculus'.}

\item{target_organism}{name of the target organism. Organism names are constructed by concatenating
the first letter of the name and the family name. Example: human - 'hsapiens',
mouse - 'mmusculus'.}

\item{numeric_ns}{namespace to use for fully numeric IDs (\href{https://biit.cs.ut.ee/gprofiler/page/namespaces-list}{list of available namespaces}).}

\item{mthreshold}{maximum number of ortholog names per gene to show.}

\item{filter_na}{logical indicating whether to filter out results without a
corresponding target name.}
}
\value{
The output is a data.frame which is a table closely corresponding to the
web interface output.

The result fields are further described in the \href{https://cran.r-project.org/package=gprofiler2/vignettes/gprofiler2.html}{vignette}.
}
\description{
Interface to the g:Profiler tool g:Orth (\url{https://biit.cs.ut.ee/gprofiler/orth}) that, given a target organism, retrieves the genes of the target organism that are similar in sequence to the source organism genes in the input.
}
\examples{
gorth(c("Klf4","Pax5","Sox2","Nanog"), source_organism="mmusculus", target_organism="hsapiens")
}
\author{
Liis Kolberg <liis.kolberg@ut.ee>, Uku Raudvere <uku.raudvere@ut.ee>
}
