% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dshw.r
\name{dshw}
\alias{dshw}
\title{Double-Seasonal Holt-Winters Forecasting}
\usage{
dshw(
  y,
  period1 = NULL,
  period2 = NULL,
  h = 2 * max(period1, period2),
  alpha = NULL,
  beta = NULL,
  gamma = NULL,
  omega = NULL,
  phi = NULL,
  lambda = NULL,
  biasadj = FALSE,
  armethod = TRUE,
  model = NULL
)
}
\arguments{
\item{y}{Either an \code{\link[=msts]{msts()}} object with two seasonal periods or a
numeric vector.}

\item{period1}{Period of the shorter seasonal period. Only used if \code{y}
is not an \code{\link[=msts]{msts()}} object.}

\item{period2}{Period of the longer seasonal period.  Only used if \code{y}
is not an \code{\link[=msts]{msts()}} object.}

\item{h}{Number of periods for forecasting.}

\item{alpha}{Smoothing parameter for the level. If \code{NULL}, the
parameter is estimated using least squares.}

\item{beta}{Smoothing parameter for the slope. If \code{NULL}, the parameter
is estimated using least squares.}

\item{gamma}{Smoothing parameter for the first seasonal period. If
\code{NULL}, the parameter is estimated using least squares.}

\item{omega}{Smoothing parameter for the second seasonal period. If
\code{NULL}, the parameter is estimated using least squares.}

\item{phi}{Autoregressive parameter. If \code{NULL}, the parameter is
estimated using least squares.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}

\item{armethod}{If \code{TRUE}, the forecasts are adjusted using an AR(1)
model for the errors.}

\item{model}{If it's specified, an existing model is applied to a new data set.}
}
\value{
An object of class \code{forecast}.
}
\description{
Returns forecasts using Taylor's (2003) Double-Seasonal Holt-Winters method.
}
\details{
Taylor's (2003) double-seasonal Holt-Winters method uses additive trend and
multiplicative seasonality, where there are two seasonal components which
are multiplied together. For example, with a series of half-hourly data, one
would set \code{period1 = 48} for the daily period and \code{period2 = 336} for
the weekly period. The smoothing parameter notation used here is different
from that in Taylor (2003); instead it matches that used in Hyndman et al
(2008) and that used for the \code{\link[=ets]{ets()}} function.
}
\examples{

\dontrun{
fcast <- dshw(taylor)
plot(fcast)

t <- seq(0, 5, by = 1 / 20)
x <- exp(sin(2 * pi * t) + cos(2 * pi * t * 4) + rnorm(length(t), 0, 0.1))
fit <- dshw(x, 20, 5)
plot(fit)
}

}
\references{
Taylor, J.W. (2003) Short-term electricity demand forecasting
using double seasonal exponential smoothing. \emph{Journal of the
Operational Research Society}, \bold{54}, 799-805.

Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
\emph{Forecasting with exponential smoothing: the state space approach},
Springer-Verlag. \url{https://robjhyndman.com/expsmooth/}.
}
\seealso{
\code{\link[stats:HoltWinters]{stats::HoltWinters()}}, \code{\link[=ets]{ets()}}.
}
\author{
Rob J Hyndman
}
\keyword{ts}
