% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queue.R
\docType{class}
\name{queue-class}
\alias{queue-class}
\alias{createQ}
\alias{initQ}
\alias{pop}
\alias{push}
\alias{isEmpty}
\alias{top}
\alias{show,queue-method}
\alias{push,queue-method}
\alias{isEmpty,queue-method}
\alias{top,queue-method}
\alias{pop,queue-method}
\title{A Queue Class}
\usage{
createQ(filename)

initQ(filename)

pop(db, ...)

push(db, val, ...)

isEmpty(db, ...)

top(db, ...)

\S4method{show}{queue}(object)

\S4method{push}{queue}(db, val, ...)

\S4method{isEmpty}{queue}(db)

\S4method{top}{queue}(db, ...)

\S4method{pop}{queue}(db, ...)
}
\arguments{
\item{filename}{name of queue file}

\item{db}{a queue object}

\item{...}{arguments passed to other methods}

\item{val}{an R object to be added to the tail queue}

\item{object}{a queue object}
}
\value{
\code{createQ} and \code{initQ} return a \code{queue} object
}
\description{
A queue implementation using a \code{filehash} database
}
\details{
Objects can be created by calls of the form \code{new("queue", ...)} or by calling \code{createQ}.  Existing queues can be initialized with \code{initQ}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{show(queue)}: Print a queue object

\item \code{push(queue)}: adds an element to the tail ("bottom") of the queue

\item \code{isEmpty(queue)}: returns \code{TRUE}/\code{FALSE} depending on whether there are elements in the queue.

\item \code{top(queue)}: returns the value of the "top" (i.e. head) of the queue; an error is signaled if the queue is empty

\item \code{pop(queue)}: returns the value of the "top" (i.e. head) of the queue and subsequently removes that element from the queue; an error is signaled if the queue is empty

}}
\section{Functions}{
\itemize{
\item \code{createQ()}: Create a file-based queue object

\item \code{initQ()}: Intialize an existing queue object

\item \code{pop()}: Return (and remove) the top element of a queue

\item \code{push()}: Push an R object on to the tail of a queue

\item \code{isEmpty()}: Check if a queue is empty or not

\item \code{top()}: Return the top of the queue

}}
\section{Slots}{

\describe{
\item{\code{queue}}{Object of class \code{"filehashDB1"}}

\item{\code{name}}{Object of class \code{"character"}: the name of the queue (default is the file name in which the queue data are stored)}
}}

