% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-weekday.R
\name{year-month-weekday-boundary}
\alias{year-month-weekday-boundary}
\alias{calendar_start.clock_year_month_weekday}
\alias{calendar_end.clock_year_month_weekday}
\title{Boundaries: year-month-weekday}
\usage{
\method{calendar_start}{clock_year_month_weekday}(x, precision)

\method{calendar_end}{clock_year_month_weekday}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_year_month_weekday]}

A year-month-weekday vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"month"}
}}
}
\value{
\code{x} at the same precision, but with some components altered to be
at the boundary value.
}
\description{
This is a year-month-weekday method for the \code{\link[=calendar_start]{calendar_start()}} and
\code{\link[=calendar_end]{calendar_end()}} generics. They adjust components of a calendar to the
start or end of a specified \code{precision}.

This method is restricted to only \code{"year"} and \code{"month"} \code{precision}s, and
\code{x} can't be more precise than month precision. Computing the "start" of
a day precision year-month-weekday object isn't defined because
a year-month-weekday with \verb{day = 1, index = 1} doesn't necessarily occur
earlier (chronologically) than \verb{day = 2, index = 1}. Because of these
restrictions, this method isn't particularly useful, but is included for
completeness.
}
\examples{
# Month precision
x <- year_month_weekday(2019, 1:5)
x

# Compute the last month of the year
calendar_end(x, "year")
}
