% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderClu.R
\encoding{UTF-8}
\name{orderClu}
\alias{orderClu}
\title{Orders the partition so that mean values of \code{fun} applied to columns (if \code{funWay=2}, default), rows (if \code{funWay=1}) or both (if \code{funWay=c(1,2)}) is decreasing by clusters.}
\usage{
orderClu(
  x,
  clu = NULL,
  fun = sum,
  funWay = 2,
  nn = NULL,
  returnList = TRUE,
  scale = TRUE
)
}
\arguments{
\item{x}{A result of \code{\link{critFunC}}, \code{\link{optRandomParC}} or similar (something containing M (matrix) and clu (partition)) or a matrix (or array for multirelational networks).}

\item{clu}{A partition - a vector or a list of vectors/partitions. It must be supplied only if \code{x} is a matrix or array.}

\item{fun}{A function used to summarize rows or columns. \code{sum} by default.}

\item{funWay}{In which "way" should \code{fun} be appluied - to columns (if \code{funWay=2}, default), rows (if \code{funWay=1}) or both (if \code{funWay=c(1,2)})}

\item{nn}{The numbers of untis by sets of units. In principle, the function should determin this automatically.}

\item{returnList}{Logical. Should the partition be returned in form of a list (for lined networks only). \code{TRUE} by default.}

\item{scale}{Only used in case of multirelational networks. Should relations be scaled (\code{TRUE} by default) before summation. It can also be a vector of weights by relations.}
}
\value{
An ordered partition. In an attribute ("reorder"). the information on how things were reordered.
}
\description{
Orders the partition so that mean values of \code{fun} applied to columns (if \code{funWay=2}, default), rows (if \code{funWay=1}) or both (if \code{funWay=c(1,2)}) is decreasing by clusters. The function can be used on the results of \code{\link{critFunC}}, \code{\link{optRandomParC}} or similar, or matrix and a partition can be supplied. It should also work on multirelational and lined networks.
}
\seealso{
\code{\link{clu}}
}
