% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_RccSet-class.R
\docType{class}
\name{RccSet-class}
\alias{RccSet-class}
\alias{.RccSet}
\title{RccSet class, derived from ExpressionSet}
\description{
The RccSet class is a trivial extension of
\code{\linkS4class{ExpressionSet}}, but with additional validation
criteria. \code{RccSet} is a class generator function.
}
\details{
A valid \code{RccSet} object must have the following columns in
\code{featureData}: \code{"CodeClass"}, \code{"GeneName"}, and
\code{"Accession"}. It must also have the following
\code{phenoData} columns: \code{"FileName"}, \code{"SampleID"},
\code{"LaneID"}, \code{"FovCount"}, \code{"FovCounted"},
\code{"StagePosition"}, \code{"BindingDensity"}, \code{"CartridgeID"}, and
\code{"SampleType"}. A final requirement is that the \code{"FovCount"}
column of \code{phenoData} have at most one distinct value.
}
\examples{

data("example_rccSet")
e <- example_rccSet

# "ExpressionSet" constructor makes a new assayData environment
r1 <- RccSet(e)
validObject(r1)
assayData(e)
assayData(r1)
head(pData(r1))
head(fData(r1))

# For other constructors, if not explicitly supplied, blank phenoData and
# featureData objects are populated with mandatory columns (and NA values).
r2 <- RccSet(assayData(e))
validObject(r2)
head(pData(r2))
head(fData(r2))

r3 <- RccSet(assayData(e), phenoData(e), featureData(e))
identical(pData(r1), pData(r3))
identical(fData(r1), fData(r3))
identical(annotation(r1), annotation(r3)) # We forgot it!
annotation(e)
r3 <- RccSet(assayData(e), phenoData(e), featureData(e), annotation = annotation(e))
identical(annotation(r1), annotation(r3)) # Better
identical(r1, r3) # False, due to assayData environments
assayData(r1)
assayData(r3)

# Matrix contructor is similar
r4 <- RccSet(exprs(e), phenoData(e), featureData(e), annotation = annotation(e))
identical(exprs(r1), exprs(r4))

# Blank object constructor
r0 <- RccSet()
dim(r0)
pData(r0)
fData(r0)
}
\seealso{
See \code{\link{checkRccSet}}, which provides additional checks and
generates warnings for unexpected or unusual conditions which, though
permitted by the class, may indicate data import errors.
}
