% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{differentialGeneTest}
\alias{differentialGeneTest}
\title{Test genes for differential expression}
\usage{
differentialGeneTest(cds, fullModelFormulaStr = "~sm.ns(Pseudotime, df=3)",
  reducedModelFormulaStr = "~1", relative_expr = TRUE, cores = 1,
  verbose = FALSE)
}
\arguments{
\item{cds}{a CellDataSet object upon which to perform this operation}

\item{fullModelFormulaStr}{a formula string specifying the full model in differential expression tests (i.e. likelihood ratio tests) for each gene/feature.}

\item{reducedModelFormulaStr}{a formula string specifying the reduced model in differential expression tests (i.e. likelihood ratio tests) for each gene/feature.}

\item{relative_expr}{Whether to transform expression into relative values.}

\item{cores}{the number of cores to be used while testing each gene for differential expression.}

\item{verbose}{Whether to show VGAM errors and warnings. Only valid for cores = 1.}
}
\value{
a data frame containing the p values and q-values from the likelihood ratio tests on the parallel arrays of models.
}
\description{
Tests each gene for differential expression as a function of pseudotime 
or according to other covariates as specified. \code{differentialGeneTest} is
Monocle's main differential analysis routine. 
It accepts a CellDataSet and two model formulae as input, which specify generalized
lineage models as implemented by the \code{VGAM} package.
}
\seealso{
\code{\link[VGAM]{vglm}}
}
