/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.EmbeddedDiagram;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.legacy.CreoleParser;
import net.sourceforge.plantuml.cucadiagram.BodyEnhancedAbstract;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;

public class BodyEnhanced1
extends BodyEnhancedAbstract
implements TextBlock,
WithPorts {
    private final Display rawBody2;
    private final FontParam fontParam;
    private final ISkinParam skinParam;
    private final boolean lineFirst;
    private final List<Url> urls = new ArrayList<Url>();
    private final Stereotype stereotype;
    private final ILeaf entity;
    private final boolean inEllipse;
    private final Style style;

    BodyEnhanced1(HorizontalAlignment align, List<CharSequence> rawBody, FontParam fontParam, ISkinParam skinParam, Stereotype stereotype, ILeaf entity, Style style) {
        super(align, new FontConfiguration(skinParam, fontParam, stereotype));
        this.style = style;
        this.rawBody2 = Display.create(rawBody);
        this.stereotype = stereotype;
        this.fontParam = fontParam;
        this.skinParam = skinParam;
        this.lineFirst = true;
        this.entity = entity;
        this.inEllipse = false;
    }

    BodyEnhanced1(HorizontalAlignment align, Display display, FontParam fontParam, ISkinParam skinParam, Stereotype stereotype, ILeaf entity, Style style) {
        super(align, style == null ? new FontConfiguration(skinParam, fontParam, stereotype) : style.getFontConfiguration(skinParam.getThemeStyle(), skinParam.getIHtmlColorSet()));
        this.style = style;
        this.entity = entity;
        this.stereotype = stereotype;
        this.fontParam = fontParam;
        this.skinParam = skinParam;
        this.lineFirst = false;
        boolean bl = this.inEllipse = fontParam == FontParam.USECASE;
        if (this.inEllipse && display.size() > 0 && BodyEnhanced1.isBlockSeparator(display.get(0).toString())) {
            display = display.add("");
        }
        this.rawBody2 = display;
    }

    @Override
    protected double getMarginX() {
        return 6.0;
    }

    private static boolean isTreeOrTable(String s) {
        return Parser.isTreeStart(s = StringUtils.trinNoTrace(s)) || CreoleParser.isTableLine(s);
    }

    @Override
    protected TextBlock getArea(StringBounder stringBounder) {
        if (this.area != null) {
            return this.area;
        }
        this.urls.clear();
        ArrayList<TextBlock> blocks = new ArrayList<TextBlock>();
        char separator = this.lineFirst ? (char)'_' : '\u0000';
        TextBlock title = null;
        Display display = Display.empty();
        Iterator it = this.rawBody2.iterator();
        while (it.hasNext()) {
            CharSequence cs = (CharSequence)it.next();
            if (cs instanceof EmbeddedDiagram) {
                if (display.size() > 0 || separator != '\u0000') {
                    blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(display, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.style), separator, title));
                    separator = '\u0000';
                    title = null;
                    display = Display.empty();
                }
                blocks.add(((EmbeddedDiagram)cs).asDraw(this.skinParam));
                continue;
            }
            String s = cs.toString();
            if (BodyEnhanced1.isBlockSeparator(s)) {
                blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(display, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.style), separator, title));
                separator = s.charAt(0);
                title = this.getTitle(s, this.skinParam);
                display = Display.empty();
                continue;
            }
            if (BodyEnhanced1.isTreeOrTable(s)) {
                boolean isTable = CreoleParser.isTableLine(s);
                if (display.size() > 0) {
                    blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(display, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.style), separator, title));
                }
                separator = '\u0000';
                title = null;
                display = Display.empty();
                List<CharSequence> allTree = BodyEnhanced1.buildTreeOrTable(s, (ListIterator<CharSequence>)it);
                TextBlock bloc = Display.create(allTree).create7(this.fontParam.getFontConfiguration(this.skinParam), this.align, this.skinParam, CreoleMode.FULL);
                if (isTable) {
                    bloc = TextBlockUtils.withMargin(bloc, 10.0, 10.0, 0.0, 5.0);
                }
                blocks.add(bloc);
                continue;
            }
            display = display.add(cs);
            if (!(cs instanceof Member) || ((Member)cs).getUrl() == null) continue;
            this.urls.add(((Member)cs).getUrl());
        }
        if (this.inEllipse && display.size() == 0) {
            display = display.add("");
        }
        blocks.add(this.decorate(stringBounder, new MethodsOrFieldsArea(display, this.fontParam, this.skinParam, this.align, this.stereotype, this.entity, this.style), separator, title));
        this.area = blocks.size() == 1 ? (TextBlock)blocks.get(0) : new TextBlockVertical2(blocks, this.align);
        if (this.skinParam.minClassWidth() > 0.0) {
            this.area = TextBlockUtils.withMinWidth(this.area, this.skinParam.minClassWidth(), this.align);
        }
        return this.area;
    }

    private static List<CharSequence> buildTreeOrTable(String init, ListIterator<CharSequence> it) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        Pattern p = Pattern.compile("^(\\s+)");
        Matcher m = p.matcher(init);
        String start = "";
        if (m.find()) {
            start = m.group(1);
        }
        result.add(BodyEnhanced1.purge(init, start));
        while (it.hasNext()) {
            String s = it.next().toString();
            if (BodyEnhanced1.isTreeOrTable(s)) {
                result.add(BodyEnhanced1.purge(s, start));
                continue;
            }
            it.previous();
            return result;
        }
        return result;
    }

    private static String purge(String s, String start) {
        if (s.startsWith(start)) {
            return s.substring(start.length());
        }
        return s;
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        TextBlock area = this.getArea(stringBounder);
        if (area instanceof WithPorts) {
            return ((WithPorts)((Object)area)).getPorts(stringBounder);
        }
        return new Ports();
    }

    public List<Url> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }

    @Override
    public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
        return this.getArea(stringBounder).getInnerPosition(member, stringBounder, strategy);
    }
}

