// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef PLOT_H
#define PLOT_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: Plot
//
// Purpose:
//    This class is a plot element in a plot list.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API Plot : public AttributeSubject
{
public:
    enum StateType
    {
        NewlyCreated,
        Pending,
        Completed,
        Error
    };

    // These constructors are for objects of this class
    Plot();
    Plot(const Plot &obj);
protected:
    // These constructors are for objects derived from this class
    Plot(private_tmfs_t tmfs);
    Plot(const Plot &obj, private_tmfs_t tmfs);
public:
    virtual ~Plot();

    virtual Plot& operator = (const Plot &obj);
    virtual bool operator == (const Plot &obj) const;
    virtual bool operator != (const Plot &obj) const;
private:
    void Init();
    void Copy(const Plot &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectPlotName();
    void SelectPlotVar();
    void SelectDatabaseName();
    void SelectOperators();
    void SelectOperatorNames();
    void SelectKeyframes();
    void SelectDatabaseKeyframes();
    void SelectDescription();
    void SelectSelection();

    // Property setting methods
    void SetStateType(StateType stateType_);
    void SetPlotType(int plotType_);
    void SetPlotName(const std::string &plotName_);
    void SetActiveFlag(bool activeFlag_);
    void SetHiddenFlag(bool hiddenFlag_);
    void SetExpandedFlag(bool expandedFlag_);
    void SetPlotVar(const std::string &plotVar_);
    void SetDatabaseName(const std::string &databaseName_);
    void SetOperators(const intVector &operators_);
    void SetOperatorNames(const stringVector &operatorNames_);
    void SetActiveOperator(int activeOperator_);
    void SetId(int id_);
    void SetEmbeddedPlotId(int embeddedPlotId_);
    void SetBeginFrame(int beginFrame_);
    void SetEndFrame(int endFrame_);
    void SetKeyframes(const intVector &keyframes_);
    void SetDatabaseKeyframes(const intVector &databaseKeyframes_);
    void SetIsFromSimulation(bool isFromSimulation_);
    void SetFollowsTime(bool followsTime_);
    void SetDescription(const std::string &description_);
    void SetSelection(const std::string &selection_);
    void SetAnimatingFlag(bool animatingFlag_);

    // Property getting methods
    StateType          GetStateType() const;
    int                GetPlotType() const;
    const std::string  &GetPlotName() const;
          std::string  &GetPlotName();
    bool               GetActiveFlag() const;
    bool               GetHiddenFlag() const;
    bool               GetExpandedFlag() const;
    const std::string  &GetPlotVar() const;
          std::string  &GetPlotVar();
    const std::string  &GetDatabaseName() const;
          std::string  &GetDatabaseName();
    const intVector    &GetOperators() const;
          intVector    &GetOperators();
    const stringVector &GetOperatorNames() const;
          stringVector &GetOperatorNames();
    int                GetActiveOperator() const;
    int                GetId() const;
    int                GetEmbeddedPlotId() const;
    int                GetBeginFrame() const;
    int                GetEndFrame() const;
    const intVector    &GetKeyframes() const;
          intVector    &GetKeyframes();
    const intVector    &GetDatabaseKeyframes() const;
          intVector    &GetDatabaseKeyframes();
    bool               GetIsFromSimulation() const;
    bool               GetFollowsTime() const;
    const std::string  &GetDescription() const;
          std::string  &GetDescription();
    const std::string  &GetSelection() const;
          std::string  &GetSelection();
    bool               GetAnimatingFlag() const;

    // Enum conversion functions
    static std::string StateType_ToString(StateType);
    static bool StateType_FromString(const std::string &, StateType &);
protected:
    static std::string StateType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void AddOperator(int op, const char *name);
    void ClearAllOperators();
    int  GetNumOperators() const;
    int  GetOperator(int i) const;
    const std::string  &GetOperatorName(int i) const;
    void RemoveLastOperator();

    // IDs that can be used to identify fields in case statements
    enum {
        ID_stateType = 0,
        ID_plotType,
        ID_plotName,
        ID_activeFlag,
        ID_hiddenFlag,
        ID_expandedFlag,
        ID_plotVar,
        ID_databaseName,
        ID_operators,
        ID_operatorNames,
        ID_activeOperator,
        ID_id,
        ID_embeddedPlotId,
        ID_beginFrame,
        ID_endFrame,
        ID_keyframes,
        ID_databaseKeyframes,
        ID_isFromSimulation,
        ID_followsTime,
        ID_description,
        ID_selection,
        ID_animatingFlag,
        ID__LAST
    };

private:
    int          stateType;
    int          plotType;
    std::string  plotName;
    bool         activeFlag;
    bool         hiddenFlag;
    bool         expandedFlag;
    std::string  plotVar;
    std::string  databaseName;
    intVector    operators;
    stringVector operatorNames;
    int          activeOperator;
    int          id;
    int          embeddedPlotId;
    int          beginFrame;
    int          endFrame;
    intVector    keyframes;
    intVector    databaseKeyframes;
    bool         isFromSimulation;
    bool         followsTime;
    std::string  description;
    std::string  selection;
    bool         animatingFlag;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define PLOT_TMFS "iisbbbssi*s*iiiiii*i*bbssb"

#endif
