% IDE support in the JDK

## Introduction

When you are familiar with building and testing the JDK, you may want to
configure an IDE to work with the source code. The instructions differ a bit
depending on whether you are interested in working with the native (C/C++) or
the Java code.

### IDE support for native code

There are a few ways to generate IDE configuration for the native sources,
depending on which IDE to use.

#### Visual Studio Code

The make system can generate a [Visual Studio Code](https://code.visualstudio.com)
workspace that has C/C++ source indexing configured correctly, as well as
launcher targets for tests and the Java launcher. After configuring, a workspace
for the configuration can be generated using:

```shell
make vscode-project
```

This creates a file called `jdk.code-workspace` in the build output folder. The
full location will be printed after the workspace has been generated. To use it,
choose `File -> Open Workspace...` in Visual Studio Code.

##### Alternative indexers

The main `vscode-project` target configures the default C++ support in Visual
Studio Code. There are also other source indexers that can be installed, that
may provide additional features. It's currently possible to generate
configuration for two such indexers, [clangd](https://clang.llvm.org/extra/clangd/)
and [rtags](https://github.com/Andersbakken/rtags). These can be configured by
appending the name of the indexer to the make target, such as:

```shell
make vscode-project-clangd
```

Additional instructions for configuring the given indexer will be displayed
after the workspace has been generated.

#### Visual Studio

The make system can generate a Visual Studio project for the Hotspot
native source. After configuring, the project is generated using:

```shell
make hotspot-ide-project
```

This creates a file named `jvm.vcxproj` in `ide\hotspot-visualstudio`
subfolder of the build output folder. The file can be opened in Visual Studio
via `File -> Open -> Project/Solution`.

#### Eclipse CDT

The make system can generate an Eclipse CDT Workspace that enables Eclipse
indexing for the C and C++ sources throughout the entire codebase, as well as
registering all common make targets to be runnable from the Eclipse explorer.
This can be done after configuring by running:

```
make eclipse-native-env
```

After this is run, simply open and import the workspace in Eclipse through
`File -> Import -> Projects from Folder or Archive` and at
`Import source` click on the directory `ide\eclipse`, which can be
found in the build output folder.

If this doesn't work, you can also try
`File -> Import -> Existing Projects into Workspace`
instead.

Setting up an Eclipse Workspace is relatively lightweight compared to other
supported IDEs, but requires that your CDT installation has Cross GCC support
enabled at the moment, even if you aren't cross compiling. The Visual C++
compiler is, at present, not supported as an indexer.

If desired, you can instead request make to only include indexing support for
just the Java Virtual Machine instead of the entire native codebase, by running:

```
make eclipse-hotspot-env
```

If you think your particular Eclipse installation can handle the strain, the
make system also supports generating a combined Java and C/C++ Workspace for
Eclipse which can then conveniently switch between Java and C/C++ natures
during development by running:

```
make eclipse-mixed-env
```

Do note that this generates all features that come with both Java and C/C++
natures.

By default, the Eclipse Workspace is located in the ide subdirectory in the
build output. To share the JDK's source directory with the Eclipse Workspace,
you can instead run:

```
make eclipse-shared-<ENV>-env
```

Eclipse support in the JDK is relatively new, so do keep in mind that not
everything may work at the moment. As such, the resulting Workspace also
has compilation database parsing support enabled, so you can pass Eclipse
the compile commands file (see below) if all else fails.

#### Compilation Database

The make system can generate generic native code indexing support in the form of
a [Compilation Database](https://clang.llvm.org/docs/JSONCompilationDatabase.html)
that can be used by many different IDEs and source code indexers.

```shell
make compile-commands
```

It's also possible to generate the Compilation Database for the HotSpot source
code only, which is a bit faster as it includes less information.

```shell
make compile-commands-hotspot
```

### IDE support for Java code

#### IntelliJ IDEA

The JDK project has a script that can be used for indexing the project
with IntelliJ. After configuring and building the JDK, an IntelliJ workspace
can be generated by running the following command in the top-level folder
of the cloned repository:

```shell
bash bin/idea.sh
```

To use it, choose `File -> Open...` in IntelliJ and select the folder where
you ran the above script.

Next, configure the project SDK in IntelliJ. Open
`File -> Project Structure -> Project` and select `build/<config>/images/jdk`
as the SDK to use.

In order to run the tests from the IDE, you can use the JTReg plugin.
Instructions for building and using the plugin can be found
[here](https://github.com/openjdk/jtreg/tree/master/plugins/idea).

#### Eclipse

Eclipse JDT is a widely used Java IDE and has been for a very long time, being
a popular choice alongside IntelliJ IDEA for Java development. Likewise, the
JDK now includes support for developing its Java sources with Eclipse, which
can be achieved by setting up a Java Workspace by running:

```
make eclipse-java-env
```

After the workspace has been generated you can import it in the same way as
you would with Eclipse CDT:

Follow `File -> Import -> Projects from Folder or Archive` and select the
`ide\eclipse` directory in the build output folder to import the newly created
Java Workspace.

If doing so results in an error, you can also import the JDK via
`File -> Import -> Existing Projects into Workspace`
as a last resort.

Alternatively, if you want a Java Workspace inside the JDK's source directory,
you can instead run:

```
make eclipse-shared-java-env
```

As mentioned above for Eclipse CDT, you can create a combined Java and C/C++
Workspace which can conveniently switch between Java and C/C++ natures during
development by running:

```
make eclipse-mixed-env
```
