/*
 * Shell folder identifier functions
 *
 * Copyright (C) 2010-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <memory.h>
#include <types.h>

#include "libfwsi_libcerror.h"
#include "libfwsi_shell_folder_identifier.h"

uint8_t libfwsi_shell_folder_identifier_3d_objects[ 16 ] = {
	0x3f, 0xe0, 0xb7, 0x0d, 0x29, 0xfc, 0xc6, 0x4d, 0x90, 0x20, 0xff, 0x41, 0xb5, 0x9e, 0x51, 0x3a };

uint8_t libfwsi_shell_folder_identifier_activex_cache_folder[ 16 ] = {
	0x81, 0xc3, 0xc6, 0x88, 0x85, 0x2e, 0xd0, 0x11, 0x94, 0xde, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 };

uint8_t libfwsi_shell_folder_identifier_add_network_place[ 16 ] = {
	0x50, 0x0a, 0x48, 0xd4, 0x28, 0xba, 0xd1, 0x11, 0x8e, 0x75, 0x00, 0xc0, 0x4f, 0xa3, 0x1a, 0x86 };

uint8_t libfwsi_shell_folder_identifier_administrative_tools[ 16 ] = {
	0xe1, 0xa4, 0x0e, 0xd2, 0x57, 0x39, 0xd2, 0x11, 0xa4, 0x0b, 0x0c, 0x50, 0x20, 0x52, 0x41, 0x53 };

uint8_t libfwsi_shell_folder_identifier_all_control_panel_items[ 16 ] = {
	0x20, 0x20, 0xec, 0x21, 0xea, 0x3a, 0x69, 0x10, 0xa2, 0xdd, 0x08, 0x00, 0x2b, 0x30, 0x30, 0x9d };

uint8_t libfwsi_shell_folder_identifier_all_tasks[ 16 ] = {
	0x70, 0xa4, 0x7b, 0xed, 0x54, 0x8e, 0x5e, 0x46, 0x82, 0x5c, 0x99, 0x71, 0x20, 0x43, 0xe0, 0x1c };

uint8_t libfwsi_shell_folder_identifier_all_tasks2[ 16 ] = {
	0x7b, 0x62, 0x0c, 0xf9, 0x80, 0x72, 0xdb, 0x45, 0xbc, 0x26, 0xcc, 0xe7, 0xbd, 0xd6, 0x20, 0xa4 };

uint8_t libfwsi_shell_folder_identifier_application_suggested_locations[ 16 ] = {
	0x66, 0x60, 0x7a, 0xc5, 0xa3, 0x66, 0x91, 0x4d, 0x9e, 0xb9, 0x41, 0x53, 0x21, 0x79, 0xf0, 0xa5 };

uint8_t libfwsi_shell_folder_identifier_applications[ 16 ] = {
	0x9b, 0xd4, 0x34, 0x42, 0x45, 0x02, 0xf3, 0x4d, 0xb7, 0x80, 0x38, 0x93, 0x94, 0x34, 0x56, 0xe1 };

uint8_t libfwsi_shell_folder_identifier_autoplay[ 16 ] = {
	0x1e, 0xde, 0x60, 0x9c, 0xfc, 0xe5, 0xf4, 0x40, 0xa4, 0x87, 0x46, 0x08, 0x51, 0xa8, 0xd9, 0x15 };

uint8_t libfwsi_shell_folder_identifier_backup_and_restore[ 16 ] = {
	0xea, 0x2b, 0x8a, 0xb9, 0x42, 0x7d, 0x58, 0x45, 0x8b, 0xd1, 0x83, 0x2f, 0x41, 0xba, 0xc6, 0xfd };

uint8_t libfwsi_shell_folder_identifier_backup_and_restore_center[ 16 ] = {
	0xdd, 0x31, 0x5a, 0x33, 0x4b, 0xf0, 0x76, 0x4d, 0xa9, 0x25, 0xd6, 0xb4, 0x7c, 0xf3, 0x60, 0xdf };

uint8_t libfwsi_shell_folder_identifier_biometrics[ 16 ] = {
	0xd0, 0xe4, 0x42, 0x01, 0x7a, 0xfb, 0xdc, 0x11, 0xba, 0x4a, 0x00, 0x0f, 0xfe, 0x7a, 0xb4, 0x28 };

uint8_t libfwsi_shell_folder_identifier_bluetooth_devices[ 16 ] = {
	0x59, 0x3f, 0x80, 0x28, 0x75, 0x3a, 0x58, 0x40, 0x99, 0x5f, 0x4e, 0xe5, 0x50, 0x3b, 0x02, 0x3c };

uint8_t libfwsi_shell_folder_identifier_briefcase[ 16 ] = {
	0x20, 0xd9, 0xbb, 0x85, 0xa0, 0x42, 0x69, 0x10, 0xa2, 0xe4, 0x08, 0x00, 0x2b, 0x30, 0x30, 0x9d };

uint8_t libfwsi_shell_folder_identifier_cabinet_file[ 16 ] = {
	0xc0, 0xa5, 0xd7, 0x0c, 0x37, 0x9f, 0xce, 0x11, 0xae, 0x65, 0x08, 0x00, 0x2b, 0x2e, 0x12, 0x62 };

uint8_t libfwsi_shell_folder_identifier_command_folder[ 16 ] = {
	0xc0, 0xf9, 0x7f, 0x43, 0x7f, 0xa0, 0xa0, 0x4f, 0xaf, 0x80, 0x84, 0xb6, 0xc6, 0x44, 0x0a, 0x16 };

uint8_t libfwsi_shell_folder_identifier_common_places_fs_folder[ 16 ] = {
	0xa6, 0x6c, 0x4a, 0xd3, 0xc2, 0x62, 0x34, 0x4c, 0x8a, 0x7c, 0x14, 0x70, 0x9c, 0x1a, 0xd9, 0x38 };

uint8_t libfwsi_shell_folder_identifier_compressed_folder[ 16 ] = {
	0xe0, 0xcc, 0x8d, 0xe8, 0xb3, 0xb7, 0xd1, 0x11, 0xa9, 0xf0, 0x00, 0xaa, 0x00, 0x60, 0xfa, 0x31 };

uint8_t libfwsi_shell_folder_identifier_computer_delegate_folder[ 16 ] = {
	0xf8, 0xbd, 0x55, 0xb1, 0xf0, 0x02, 0x1e, 0x45, 0x9a, 0x26, 0xae, 0x31, 0x7c, 0xfd, 0x77, 0x79 };

uint8_t libfwsi_shell_folder_identifier_computer_search_results_folder[ 16 ] = {
	0x70, 0xe3, 0x4d, 0x1f, 0x27, 0xd6, 0xd1, 0x11, 0xba, 0x4f, 0x00, 0xa0, 0xc9, 0x1e, 0xed, 0xba };

uint8_t libfwsi_shell_folder_identifier_computers_and_devices[ 16 ] = {
	0x0d, 0x1a, 0x2c, 0xf0, 0x21, 0xbe, 0x50, 0x43, 0x88, 0xb0, 0x73, 0x67, 0xfc, 0x96, 0xef, 0x3c };

uint8_t libfwsi_shell_folder_identifier_control_panel[ 16 ] = {
	0x68, 0x06, 0xee, 0x26, 0x0a, 0xa0, 0xd7, 0x44, 0x93, 0x71, 0xbe, 0xb0, 0x64, 0xc9, 0x86, 0x83 };

uint8_t libfwsi_shell_folder_identifier_control_panel_command_object_for_start_menu_and_desktop[ 16 ] = {
	0x94, 0xe6, 0x99, 0x53, 0xe5, 0x6c, 0x6c, 0x4d, 0x8f, 0xce, 0x1d, 0x88, 0x70, 0xfd, 0xcb, 0xa0 };

uint8_t libfwsi_shell_folder_identifier_credential_manager[ 16 ] = {
	0xf1, 0xf5, 0x06, 0x12, 0x69, 0x05, 0x2c, 0x41, 0x8f, 0xec, 0x32, 0x04, 0x63, 0x0d, 0xfb, 0x70 };

uint8_t libfwsi_shell_folder_identifier_db_folder[ 16 ] = {
	0x16, 0x2b, 0x95, 0xb2, 0x07, 0x0e, 0x5a, 0x4e, 0xb9, 0x93, 0x58, 0xc5, 0x2c, 0xb9, 0x4c, 0xae };

uint8_t libfwsi_shell_folder_identifier_default_location[ 16 ] = {
	0x5f, 0xd9, 0xc6, 0x00, 0x9c, 0x32, 0x9a, 0x40, 0x81, 0xd7, 0xc4, 0x6c, 0x66, 0xea, 0x7f, 0x33 };

uint8_t libfwsi_shell_folder_identifier_desktop[ 16 ] = {
	0x00, 0x14, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46 };

uint8_t libfwsi_shell_folder_identifier_device_center[ 16 ] = {
	0x66, 0x1a, 0xa9, 0xa8, 0x7d, 0x3a, 0x24, 0x44, 0x8d, 0x24, 0x04, 0xe1, 0x80, 0x69, 0x5c, 0x7a };

uint8_t libfwsi_shell_folder_identifier_device_center_initialization[ 16 ] = {
	0xe2, 0x36, 0xb1, 0xc2, 0x0e, 0xd5, 0x5c, 0x40, 0x87, 0x84, 0x36, 0x3c, 0x58, 0x2b, 0xf4, 0x3e };

uint8_t libfwsi_shell_folder_identifier_devicepairingfolder_initialization[ 16 ] = {
	0x0f, 0x42, 0xe2, 0xae, 0x0e, 0xd5, 0x5c, 0x40, 0x87, 0x84, 0x36, 0x3c, 0x58, 0x2b, 0xf4, 0x5a };

uint8_t libfwsi_shell_folder_identifier_directory[ 16 ] = {
	0xf0, 0x90, 0x12, 0xfe, 0xbd, 0xcf, 0xcf, 0x11, 0xa3, 0x30, 0x00, 0xaa, 0x00, 0xc1, 0x6e, 0x65 };

uint8_t libfwsi_shell_folder_identifier_display[ 16 ] = {
	0x8b, 0x43, 0x55, 0xc5, 0x23, 0x3c, 0x69, 0x47, 0xa7, 0x1f, 0xb6, 0xd3, 0xd9, 0xb6, 0x05, 0x3a };

uint8_t libfwsi_shell_folder_identifier_dlna_content_directory_data_source[ 16 ] = {
	0xdf, 0x5e, 0x03, 0xd2, 0xcb, 0x75, 0xf1, 0x4e, 0x95, 0xa7, 0x41, 0x0d, 0x9e, 0xe1, 0x71, 0x70 };

uint8_t libfwsi_shell_folder_identifier_dlna_media_servers_data_source[ 16 ] = {
	0x17, 0xf6, 0x9a, 0x28, 0xc3, 0x1c, 0xa6, 0x42, 0x92, 0x6c, 0xe6, 0xa8, 0x63, 0xf0, 0xe3, 0xba };

uint8_t libfwsi_shell_folder_identifier_dxp[ 16 ] = {
	0x8d, 0xb8, 0xd8, 0x8f, 0xe1, 0x30, 0x25, 0x4f, 0xac, 0x2b, 0x55, 0x3d, 0x3d, 0x65, 0xf0, 0xea };

uint8_t libfwsi_shell_folder_identifier_ease_of_access[ 16 ] = {
	0x5e, 0x64, 0x55, 0xd5, 0xf8, 0xd4, 0x29, 0x4c, 0xa8, 0x27, 0xd9, 0x3c, 0x85, 0x9c, 0x4f, 0x2a };

uint8_t libfwsi_shell_folder_identifier_ecs[ 16 ] = {
	0x24, 0x09, 0xdb, 0xec, 0x08, 0x42, 0x1e, 0x45, 0x8e, 0xe0, 0x37, 0x3c, 0x09, 0x56, 0xde, 0x16 };

uint8_t libfwsi_shell_folder_identifier_email[ 16 ] = {
	0xf5, 0xa1, 0x59, 0x25, 0xd7, 0x21, 0xd4, 0x11, 0xbd, 0xaf, 0x00, 0xc0, 0x4f, 0x60, 0xb9, 0xf0 };

uint8_t libfwsi_shell_folder_identifier_enhanced_storage_data_source[ 16 ] = {
	0x2d, 0xa0, 0x13, 0x91, 0xa3, 0x00, 0xb9, 0x46, 0xbc, 0x5f, 0x9c, 0x04, 0xda, 0xdd, 0xd5, 0xd7 };

uint8_t libfwsi_shell_folder_identifier_explorer_browser_results_folder[ 16 ] = {
	0x64, 0x8b, 0x8c, 0x41, 0x63, 0x54, 0x1d, 0x46, 0x88, 0xe0, 0x75, 0xe2, 0xaf, 0xa3, 0xc6, 0xfa };

uint8_t libfwsi_shell_folder_identifier_extensions_manager_folder[ 16 ] = {
	0x39, 0x03, 0x2f, 0x69, 0xaa, 0xcb, 0xe6, 0x47, 0xb5, 0xb5, 0x3b, 0x84, 0xdb, 0x60, 0x4e, 0x87 };

uint8_t libfwsi_shell_folder_identifier_favorites[ 16 ] = {
	0x80, 0xa6, 0x3c, 0x32, 0x4d, 0xc2, 0x99, 0x40, 0xb9, 0x4d, 0x44, 0x6d, 0xd2, 0xd7, 0x24, 0x9e };

uint8_t libfwsi_shell_folder_identifier_feedback_tool[ 16 ] = {
	0x7c, 0x45, 0x43, 0x83, 0x03, 0x87, 0x0f, 0x41, 0xba, 0x8b, 0x8b, 0x02, 0x6e, 0x43, 0x17, 0x43 };

uint8_t libfwsi_shell_folder_identifier_file_backup_index[ 16 ] = {
	0xac, 0xa5, 0x7c, 0x87, 0x41, 0xcb, 0x42, 0x48, 0x9c, 0x69, 0x91, 0x36, 0xe4, 0x2d, 0x47, 0xe2 };

uint8_t libfwsi_shell_folder_identifier_file_explorer[ 16 ] = {
	0xd8, 0x5f, 0x20, 0x52, 0xfb, 0x5d, 0x7d, 0x44, 0x80, 0x1a, 0xd0, 0xb5, 0x2f, 0x2e, 0x83, 0xe1 };

uint8_t libfwsi_shell_folder_identifier_file_history_data_source[ 16 ] = {
	0x5c, 0xe8, 0x6c, 0x2f, 0xee, 0xf9, 0xca, 0x43, 0x90, 0xc7, 0x8a, 0x9b, 0xd5, 0x3a, 0x24, 0x67 };

uint8_t libfwsi_shell_folder_identifier_folder_options[ 16 ] = {
	0x5c, 0x7c, 0xfd, 0x6d, 0x51, 0x24, 0xd3, 0x11, 0xa2, 0x99, 0x00, 0xc0, 0x4f, 0x8e, 0xf6, 0xaf };

uint8_t libfwsi_shell_folder_identifier_folder_shortcut[ 16 ] = {
	0xd1, 0xce, 0xfa, 0x0a, 0x28, 0xe8, 0xd1, 0x11, 0x91, 0x87, 0xb5, 0x32, 0xf1, 0xe9, 0x57, 0x5d };

uint8_t libfwsi_shell_folder_identifier_font_settings[ 16 ] = {
	0x89, 0x25, 0x41, 0x93, 0xd4, 0x74, 0x4e, 0x4e, 0xad, 0x0e, 0xe0, 0xcb, 0x62, 0x14, 0x40, 0xfd };

uint8_t libfwsi_shell_folder_identifier_fonts[ 16 ] = {
	0xe1, 0xa4, 0x0e, 0xd2, 0x57, 0x39, 0xd2, 0x11, 0xa4, 0x0b, 0x0c, 0x50, 0x20, 0x52, 0x41, 0x52 };

uint8_t libfwsi_shell_folder_identifier_frequent_places_folder[ 16 ] = {
	0xe4, 0xe9, 0x36, 0x39, 0x2c, 0xd9, 0xee, 0x4e, 0xa8, 0x5a, 0xbc, 0x16, 0xd5, 0xea, 0x08, 0x19 };

uint8_t libfwsi_shell_folder_identifier_fusion_cache[ 16 ] = {
	0xc9, 0x80, 0x26, 0x1d, 0x2a, 0x0e, 0x9d, 0x46, 0xb7, 0x87, 0x06, 0x55, 0x58, 0xbc, 0x7d, 0x43 };

uint8_t libfwsi_shell_folder_identifier_games_explorer[ 16 ] = {
	0xdf, 0x8f, 0x22, 0xed, 0xa8, 0x9e, 0x70, 0x48, 0x83, 0xb1, 0x96, 0xb0, 0x2c, 0xfe, 0x0d, 0x52 };

uint8_t libfwsi_shell_folder_identifier_help_and_support[ 16 ] = {
	0xf1, 0xa1, 0x59, 0x25, 0xd7, 0x21, 0xd4, 0x11, 0xbd, 0xaf, 0x00, 0xc0, 0x4f, 0x60, 0xb9, 0xf0 };

uint8_t libfwsi_shell_folder_identifier_history[ 16 ] = {
	0x00, 0x8b, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46 };

uint8_t libfwsi_shell_folder_identifier_history2[ 16 ] = {
	0x20, 0xa0, 0xc7, 0x3d, 0xcd, 0x0a, 0xcf, 0x11, 0xa9, 0xbb, 0x00, 0xaa, 0x00, 0x4a, 0xe8, 0x37 };

uint8_t libfwsi_shell_folder_identifier_history3[ 16 ] = {
	0x10, 0x7d, 0x66, 0x88, 0xf0, 0x10, 0xd0, 0x11, 0x81, 0x50, 0x00, 0xaa, 0x00, 0xbf, 0x84, 0x57 };

uint8_t libfwsi_shell_folder_identifier_history4[ 16 ] = {
	0x60, 0x35, 0x39, 0xff, 0xa7, 0xc2, 0xcf, 0x11, 0xbf, 0xf4, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 };

uint8_t libfwsi_shell_folder_identifier_history_vault[ 16 ] = {
	0x65, 0xe9, 0xb6, 0xf6, 0xb2, 0xe9, 0x4b, 0x44, 0x92, 0x86, 0x10, 0xc9, 0x15, 0x2e, 0xdb, 0xc5 };

uint8_t libfwsi_shell_folder_identifier_home_group_control_panel[ 16 ] = {
	0x50, 0x76, 0xca, 0x67, 0xe6, 0x96, 0xdd, 0x4f, 0xbb, 0x43, 0xa8, 0xe7, 0x74, 0xf7, 0x3a, 0x57 };

uint8_t libfwsi_shell_folder_identifier_inbox[ 16 ] = {
	0x75, 0x0d, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46 };

uint8_t libfwsi_shell_folder_identifier_inbox2[ 16 ] = {
	0x76, 0x0d, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46 };

uint8_t libfwsi_shell_folder_identifier_install_new_programs[ 16 ] = {
	0x2e, 0xe9, 0xea, 0x15, 0x7a, 0xf1, 0x31, 0x44, 0x9f, 0x28, 0x80, 0x5e, 0x48, 0x2d, 0xaf, 0xd4 };

uint8_t libfwsi_shell_folder_identifier_installed_updates[ 16 ] = {
	0xa1, 0xa8, 0x50, 0xd4, 0x68, 0x95, 0xc7, 0x45, 0x9c, 0x0e, 0xb4, 0xf9, 0xfb, 0x45, 0x37, 0xbd };

uint8_t libfwsi_shell_folder_identifier_internet[ 16 ] = {
	0xf4, 0xa1, 0x59, 0x25, 0xd7, 0x21, 0xd4, 0x11, 0xbd, 0xaf, 0x00, 0xc0, 0x4f, 0x60, 0xb9, 0xf0 };

uint8_t libfwsi_shell_folder_identifier_internet_explorer[ 16 ] = {
	0x42, 0x3b, 0xf2, 0xfb, 0xf0, 0xe3, 0x1b, 0x10, 0x84, 0x88, 0x00, 0xaa, 0x00, 0x3e, 0x56, 0xf8 };

uint8_t libfwsi_shell_folder_identifier_internet_explorer_history_and_feeds_shell_data_source_for_windows_search[ 16 ] = {
	0x01, 0x61, 0x01, 0x11, 0x66, 0xe3, 0x22, 0x4d, 0xbc, 0x06, 0x4a, 0xda, 0x33, 0x5c, 0x89, 0x2b };

uint8_t libfwsi_shell_folder_identifier_internet_explorer_rss_feeds_folder[ 16 ] = {
	0xb5, 0x6b, 0x09, 0x9a, 0xc3, 0x9d, 0x1c, 0x4d, 0x85, 0x26, 0xc3, 0xcb, 0xf9, 0x91, 0xea, 0x4e };

uint8_t libfwsi_shell_folder_identifier_internet_folder[ 16 ] = {
	0x80, 0x53, 0x1c, 0x87, 0xa0, 0x42, 0x69, 0x10, 0xa2, 0xea, 0x08, 0x00, 0x2b, 0x30, 0x30, 0x9d };

uint8_t libfwsi_shell_folder_identifier_language_settings[ 16 ] = {
	0xc9, 0x2c, 0x78, 0xbf, 0x52, 0x5a, 0x17, 0x4a, 0x80, 0x6c, 0x2a, 0x89, 0x4f, 0xfe, 0xea, 0xc5 };

uint8_t libfwsi_shell_folder_identifier_layout_folder[ 16 ] = {
	0x46, 0x03, 0x8b, 0x32, 0xaf, 0x7e, 0xbe, 0x4b, 0xa4, 0x79, 0x7c, 0xb8, 0x8a, 0x09, 0x5f, 0x5b };

uint8_t libfwsi_shell_folder_identifier_libraries_users_files_folder_delegate_folder[ 16 ] = {
	0xf7, 0x64, 0x66, 0x89, 0xe1, 0x12, 0x0f, 0x49, 0x87, 0x82, 0xc0, 0x83, 0x5a, 0xfd, 0x98, 0xfc };

uint8_t libfwsi_shell_folder_identifier_library_folder[ 16 ] = {
	0x3a, 0x56, 0xa3, 0xa5, 0x55, 0x57, 0x6f, 0x4a, 0x85, 0x4e, 0xaf, 0xa3, 0x23, 0x0b, 0x19, 0x9f };

uint8_t libfwsi_shell_folder_identifier_location_folder[ 16 ] = {
	0xa9, 0xf8, 0x7c, 0x26, 0xe3, 0xf4, 0xe6, 0x41, 0x95, 0xb1, 0xaf, 0x88, 0x1b, 0xe1, 0x30, 0xff };

uint8_t libfwsi_shell_folder_identifier_manage_wireless_networks[ 16 ] = {
	0x5f, 0x08, 0xa9, 0x1f, 0xa2, 0x25, 0x9b, 0x48, 0x85, 0xd4, 0x86, 0x32, 0x6e, 0xed, 0xcd, 0x87 };

uint8_t libfwsi_shell_folder_identifier_microsoft_browser_architecture[ 16 ] = {
	0x3a, 0x6e, 0xe4, 0xa5, 0x49, 0x88, 0xd1, 0x11, 0x9d, 0x8c, 0x00, 0xc0, 0x4f, 0xc9, 0x9d, 0x61 };

uint8_t libfwsi_shell_folder_identifier_microsoft_browser_architecture2[ 16 ] = {
	0x4c, 0x6f, 0x47, 0xbc, 0xd7, 0xd9, 0x00, 0x41, 0x8d, 0x4e, 0xe0, 0x43, 0xf6, 0xde, 0xc4, 0x09 };

uint8_t libfwsi_shell_folder_identifier_microsoft_ftp_folder[ 16 ] = {
	0xc0, 0x6e, 0xda, 0x63, 0x98, 0x2e, 0xcf, 0x11, 0x8d, 0x82, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 };

uint8_t libfwsi_shell_folder_identifier_microsoft_office_outlook[ 16 ] = {
	0x76, 0x35, 0xd8, 0x89, 0xd1, 0x6b, 0x86, 0x4c, 0x94, 0x54, 0xbe, 0xb0, 0x4e, 0x94, 0xc8, 0x19 };

uint8_t libfwsi_shell_folder_identifier_microsoft_onenote_namespace_extension_for_windows_desktop_search[ 16 ] = {
	0xb6, 0xdc, 0x75, 0x08, 0x86, 0xc6, 0x43, 0x42, 0x94, 0x32, 0xad, 0xcc, 0xf0, 0xb9, 0xf2, 0xd7 };

uint8_t libfwsi_shell_folder_identifier_microsoft_windows_font_folder[ 16 ] = {
	0x80, 0xb3, 0x84, 0xbd, 0xa2, 0x8c, 0x69, 0x10, 0xab, 0x1d, 0x08, 0x00, 0x09, 0x48, 0xf5, 0x34 };

uint8_t libfwsi_shell_folder_identifier_mobile_broadband_profile_settings_editor[ 16 ] = {
	0x19, 0x04, 0x63, 0x87, 0x16, 0x62, 0xf8, 0x4f, 0xa1, 0xf0, 0x14, 0x35, 0x62, 0xd1, 0x6d, 0x5c };

uint8_t libfwsi_shell_folder_identifier_mobility_center_control_panel[ 16 ] = {
	0x48, 0xf1, 0xa4, 0x5e, 0x8c, 0x30, 0xd7, 0x46, 0x98, 0xa9, 0x49, 0x04, 0x1b, 0x1d, 0xd4, 0x68 };

uint8_t libfwsi_shell_folder_identifier_ms_graph_recent_file_folder[ 16 ] = {
	0xe9, 0x4e, 0x25, 0x42, 0x25, 0xe6, 0x65, 0x40, 0x8f, 0x70, 0x77, 0x50, 0x90, 0x25, 0x6f, 0x72 };

uint8_t libfwsi_shell_folder_identifier_my_computer[ 16 ] = {
	0xe0, 0x4f, 0xd0, 0x20, 0xea, 0x3a, 0x69, 0x10, 0xa2, 0xd8, 0x08, 0x00, 0x2b, 0x30, 0x30, 0x9d };

uint8_t libfwsi_shell_folder_identifier_my_documents[ 16 ] = {
	0xba, 0x8f, 0x0d, 0x45, 0x25, 0xad, 0xd0, 0x11, 0x98, 0xa8, 0x08, 0x00, 0x36, 0x1b, 0x11, 0x03 };

uint8_t libfwsi_shell_folder_identifier_my_network_places[ 16 ] = {
	0x60, 0x2c, 0x8d, 0x20, 0xea, 0x3a, 0x69, 0x10, 0xa2, 0xd7, 0x08, 0x00, 0x2b, 0x30, 0x30, 0x9d };

uint8_t libfwsi_shell_folder_identifier_network_and_dialup_connections[ 16 ] = {
	0xc7, 0xac, 0x07, 0x70, 0x02, 0x32, 0xd1, 0x11, 0xaa, 0xd2, 0x00, 0x80, 0x5f, 0xc1, 0x27, 0x0e };

uint8_t libfwsi_shell_folder_identifier_network_and_dialup_connections2[ 16 ] = {
	0xa0, 0xff, 0x2c, 0x99, 0x57, 0xf5, 0x1a, 0x10, 0x88, 0xec, 0x00, 0xdd, 0x01, 0x0c, 0xcc, 0x48 };

uint8_t libfwsi_shell_folder_identifier_network_and_sharing_center[ 16 ] = {
	0xc9, 0x8f, 0x90, 0x8e, 0xcc, 0xbe, 0xf6, 0x40, 0x91, 0x5b, 0xf4, 0xca, 0x0e, 0x70, 0xd0, 0x3d };

uint8_t libfwsi_shell_folder_identifier_network_map[ 16 ] = {
	0x1a, 0x9b, 0xde, 0xe7, 0x33, 0x75, 0x56, 0x45, 0x94, 0x84, 0xb2, 0x6f, 0xb4, 0x86, 0x47, 0x5e };

uint8_t libfwsi_shell_folder_identifier_network_setup_wizard[ 16 ] = {
	0x0d, 0x52, 0x28, 0x27, 0xc8, 0x1e, 0x68, 0x4c, 0xa5, 0x51, 0x31, 0x6b, 0x68, 0x4c, 0x4e, 0xa7 };

uint8_t libfwsi_shell_folder_identifier_offline_files[ 16 ] = {
	0x7b, 0x2e, 0x7a, 0xbd, 0xcb, 0x21, 0xb2, 0x41, 0xa0, 0x86, 0xb3, 0x09, 0x68, 0x0c, 0x6b, 0x7e };

uint8_t libfwsi_shell_folder_identifier_offline_files_folder[ 16 ] = {
	0x70, 0x1f, 0xdb, 0xaf, 0x4c, 0x2a, 0xd2, 0x11, 0x90, 0x39, 0x00, 0xc0, 0x4f, 0x8e, 0xeb, 0x3e };

uint8_t libfwsi_shell_folder_identifier_other_users_folder[ 16 ] = {
	0xac, 0xbf, 0x85, 0x67, 0x2d, 0x9d, 0xe5, 0x4b, 0xb7, 0xe2, 0x59, 0x93, 0x7e, 0x8f, 0xb8, 0x0a };

uint8_t libfwsi_shell_folder_identifier_other_users_folder2[ 16 ] = {
	0x98, 0x3f, 0xfb, 0xb4, 0xea, 0xc1, 0x8d, 0x42, 0xa7, 0x8a, 0xd1, 0xf5, 0x65, 0x9c, 0xba, 0x93 };

uint8_t libfwsi_shell_folder_identifier_parental_controls[ 16 ] = {
	0x84, 0x8d, 0xae, 0x96, 0x50, 0xa2, 0x20, 0x45, 0x95, 0xa5, 0xa4, 0x7a, 0x7e, 0x3c, 0x54, 0x8b };

uint8_t libfwsi_shell_folder_identifier_pc_settings[ 16 ] = {
	0x8c, 0xf3, 0xd4, 0x5e, 0xff, 0xd3, 0x61, 0x4d, 0xb5, 0x06, 0x68, 0x20, 0x32, 0x0a, 0xeb, 0xfe };

uint8_t libfwsi_shell_folder_identifier_performance_information_and_tools[ 16 ] = {
	0x5e, 0x95, 0xf3, 0x78, 0x90, 0x3b, 0x84, 0x41, 0xbd, 0x14, 0x53, 0x97, 0xc1, 0x5f, 0x1e, 0xfc };

uint8_t libfwsi_shell_folder_identifier_personalization_control_panel[ 16 ] = {
	0xd6, 0x4e, 0x83, 0xed, 0x5a, 0x4b, 0xfe, 0x4b, 0x8f, 0x11, 0xa6, 0x26, 0xdc, 0xb6, 0xa9, 0x21 };

uint8_t libfwsi_shell_folder_identifier_portable_devices[ 16 ] = {
	0x3c, 0x6d, 0x78, 0x35, 0x75, 0xb0, 0xb9, 0x49, 0x88, 0xdd, 0x02, 0x98, 0x76, 0xe1, 0x1c, 0x01 };

uint8_t libfwsi_shell_folder_identifier_portable_media_devices[ 16 ] = {
	0xb4, 0x67, 0x01, 0x64, 0xb0, 0x59, 0xa6, 0x47, 0xb3, 0x35, 0xa6, 0xb3, 0xc0, 0x69, 0x5a, 0xea };

uint8_t libfwsi_shell_folder_identifier_power_options[ 16 ] = {
	0x37, 0x59, 0x5a, 0x02, 0xbe, 0xa6, 0x86, 0x46, 0xa8, 0x44, 0x36, 0xfe, 0x4b, 0xec, 0x8b, 0x6d };

uint8_t libfwsi_shell_folder_identifier_previous_versions[ 16 ] = {
	0x3c, 0xa1, 0xb7, 0x9d, 0x08, 0xf2, 0x81, 0x49, 0x83, 0x53, 0x73, 0xcc, 0x61, 0xae, 0x27, 0x83 };

uint8_t libfwsi_shell_folder_identifier_previous_versions_delegate_folder[ 16 ] = {
	0x6a, 0xd6, 0x23, 0x17, 0x12, 0x7a, 0x3e, 0x44, 0x88, 0xc7, 0x05, 0xe1, 0xbf, 0xe7, 0x99, 0x83 };

uint8_t libfwsi_shell_folder_identifier_previous_versions_results_delegate_folder[ 16 ] = {
	0x02, 0xd4, 0xc3, 0xa3, 0x6c, 0xe5, 0x33, 0x40, 0x95, 0xf7, 0x48, 0x85, 0xe8, 0x0b, 0x01, 0x11 };

uint8_t libfwsi_shell_folder_identifier_previous_versions_results_folder[ 16 ] = {
	0x3b, 0xab, 0xc2, 0xf8, 0xbc, 0x17, 0xda, 0x41, 0x97, 0x58, 0x33, 0x9d, 0x7d, 0xbf, 0x2d, 0x88 };

uint8_t libfwsi_shell_folder_identifier_printers_and_faxes[ 16 ] = {
	0x80, 0xa2, 0x27, 0x22, 0xea, 0x3a, 0x69, 0x10, 0xa2, 0xde, 0x08, 0x00, 0x2b, 0x30, 0x30, 0x9d };

uint8_t libfwsi_shell_folder_identifier_printhood_delegate_folder[ 16 ] = {
	0x29, 0xfc, 0x50, 0xed, 0x64, 0xb9, 0xa9, 0x48, 0xaf, 0xb3, 0x15, 0xeb, 0xb9, 0xb9, 0x7f, 0x36 };

uint8_t libfwsi_shell_folder_identifier_programs_and_features[ 16 ] = {
	0x6a, 0xbe, 0x81, 0x7b, 0x2b, 0xce, 0x76, 0x46, 0xa2, 0x9e, 0xeb, 0x90, 0x7a, 0x51, 0x26, 0xc5 };

uint8_t libfwsi_shell_folder_identifier_programs_folder[ 16 ] = {
	0x3c, 0xd8, 0xe9, 0x7b, 0x29, 0xa7, 0x97, 0x4d, 0xb5, 0xa7, 0x1b, 0x73, 0x13, 0xc3, 0x9e, 0x0a };

uint8_t libfwsi_shell_folder_identifier_programs_folder_and_fast_items[ 16 ] = {
	0x76, 0x5e, 0x5e, 0x86, 0x83, 0xad, 0xca, 0x4d, 0xa1, 0x09, 0x50, 0xdc, 0x21, 0x13, 0xce, 0x9a };

uint8_t libfwsi_shell_folder_identifier_proximity_cpl[ 16 ] = {
	0xe3, 0xb2, 0x60, 0x80, 0xd7, 0xc9, 0x5d, 0x4a, 0x8c, 0x6b, 0xce, 0x8e, 0xba, 0x11, 0x13, 0x28 };

uint8_t libfwsi_shell_folder_identifier_public_folder[ 16 ] = {
	0x4d, 0xa5, 0x36, 0x43, 0x8b, 0x03, 0x85, 0x46, 0xab, 0x02, 0x99, 0xbb, 0x52, 0xd3, 0xfb, 0x8b };

uint8_t libfwsi_shell_folder_identifier_quick_access[ 16 ] = {
	0xcb, 0x85, 0x9f, 0x67, 0x20, 0x02, 0x80, 0x40, 0xb2, 0x9b, 0x55, 0x40, 0xcc, 0x05, 0xaa, 0xb6 };

uint8_t libfwsi_shell_folder_identifier_recent_items_instance_folder[ 16 ] = {
	0x5e, 0xb2, 0x64, 0x45, 0xcd, 0x30, 0x87, 0x47, 0x82, 0xba, 0x39, 0xe7, 0x3a, 0x75, 0x0b, 0x14 };

uint8_t libfwsi_shell_folder_identifier_recent_places_folder[ 16 ] = {
	0x6d, 0x7a, 0x87, 0x22, 0xa1, 0x37, 0x1a, 0x46, 0x91, 0xb0, 0xdb, 0xda, 0x5a, 0xae, 0xbc, 0x99 };

uint8_t libfwsi_shell_folder_identifier_recycle_bin[ 16 ] = {
	0x40, 0xf0, 0x5f, 0x64, 0x81, 0x50, 0x1b, 0x10, 0x9f, 0x08, 0x00, 0xaa, 0x00, 0x2f, 0x95, 0x4e };

uint8_t libfwsi_shell_folder_identifier_remote_printers[ 16 ] = {
	0xfd, 0xa9, 0x3a, 0x86, 0xdf, 0x42, 0x7b, 0x45, 0x8e, 0x4d, 0x0d, 0xe1, 0xb8, 0x01, 0x5c, 0x60 };

uint8_t libfwsi_shell_folder_identifier_removable_drives[ 16 ] = {
	0x77, 0x2c, 0xfb, 0xf5, 0x2f, 0x0e, 0x16, 0x4a, 0xa3, 0x81, 0x3e, 0x56, 0x0c, 0x68, 0xbc, 0x83 };

uint8_t libfwsi_shell_folder_identifier_removable_storage_devices[ 16 ] = {
	0x30, 0x28, 0x48, 0xa6, 0xeb, 0x08, 0xe2, 0x41, 0x84, 0xc1, 0x73, 0x92, 0x0c, 0x2b, 0xad, 0xb9 };

uint8_t libfwsi_shell_folder_identifier_results_folder[ 16 ] = {
	0x15, 0xe7, 0x65, 0x29, 0x66, 0xeb, 0x19, 0x47, 0xb5, 0x3f, 0x16, 0x72, 0x67, 0x3b, 0xbe, 0xfa };

uint8_t libfwsi_shell_folder_identifier_run[ 16 ] = {
	0xf3, 0xa1, 0x59, 0x25, 0xd7, 0x21, 0xd4, 0x11, 0xbd, 0xaf, 0x00, 0xc0, 0x4f, 0x60, 0xb9, 0xf0 };

uint8_t libfwsi_shell_folder_identifier_scanners_and_cameras[ 16 ] = {
	0x36, 0xb7, 0x11, 0xe2, 0xfd, 0x43, 0xd1, 0x11, 0x9e, 0xfb, 0x00, 0x00, 0xf8, 0x75, 0x7f, 0xcd };

uint8_t libfwsi_shell_folder_identifier_scanners_and_cameras2[ 16 ] = {
	0x8a, 0x9c, 0x0c, 0xfb, 0x50, 0x6c, 0xd1, 0x11, 0x9f, 0x1d, 0x00, 0x00, 0xf8, 0x75, 0x7f, 0xcd };

uint8_t libfwsi_shell_folder_identifier_scheduled_tasks[ 16 ] = {
	0x90, 0x79, 0x27, 0xd6, 0x6a, 0x4c, 0xcf, 0x11, 0x8d, 0x87, 0x00, 0xaa, 0x00, 0x60, 0xf5, 0xbf };

uint8_t libfwsi_shell_folder_identifier_search[ 16 ] = {
	0xf0, 0xa1, 0x59, 0x25, 0xd7, 0x21, 0xd4, 0x11, 0xbd, 0xaf, 0x00, 0xc0, 0x4f, 0x60, 0xb9, 0xf0 };

uint8_t libfwsi_shell_folder_identifier_search_connector_folder[ 16 ] = {
	0x70, 0x6e, 0xb3, 0x72, 0x00, 0x87, 0xd6, 0x42, 0xa7, 0xf7, 0xc9, 0xab, 0x33, 0x23, 0xee, 0x51 };

uint8_t libfwsi_shell_folder_identifier_search_folder[ 16 ] = {
	0x67, 0x1b, 0x73, 0x04, 0x33, 0xd9, 0x0a, 0x45, 0x90, 0xe6, 0x4a, 0xcd, 0x2e, 0x94, 0x08, 0xfe };

uint8_t libfwsi_shell_folder_identifier_search_home[ 16 ] = {
	0x2e, 0x81, 0x43, 0x93, 0x37, 0x1c, 0x49, 0x4a, 0xa1, 0x2e, 0x4b, 0x2d, 0x81, 0x0d, 0x95, 0x6b };

uint8_t libfwsi_shell_folder_identifier_search_results[ 16 ] = {
	0xc0, 0x4f, 0x7d, 0xe1, 0x64, 0x55, 0xd1, 0x11, 0x83, 0xf2, 0x00, 0xa0, 0xc9, 0x0d, 0xc8, 0x49 };

uint8_t libfwsi_shell_folder_identifier_secure_startup[ 16 ] = {
	0x27, 0x87, 0xef, 0xd9, 0xc2, 0xca, 0x60, 0x4e, 0x80, 0x9e, 0x86, 0xf8, 0x0a, 0x66, 0x6c, 0x91 };

uint8_t libfwsi_shell_folder_identifier_security_and_maintenance_cpl[ 16 ] = {
	0xa7, 0xf8, 0x64, 0xbb, 0xe7, 0xbe, 0x1a, 0x4e, 0xab, 0x8d, 0x7d, 0x82, 0x73, 0xf7, 0xfd, 0xb6 };

uint8_t libfwsi_shell_folder_identifier_security_center[ 16 ] = {
	0x7c, 0x3b, 0x43, 0x9f, 0x96, 0x5f, 0xe1, 0x4c, 0xac, 0x28, 0xae, 0xaa, 0x1c, 0xc0, 0x4d, 0x7c };

uint8_t libfwsi_shell_folder_identifier_sensors[ 16 ] = {
	0x54, 0x01, 0x95, 0xe9, 0x18, 0xc4, 0x9e, 0x41, 0xa9, 0x0a, 0x20, 0xc5, 0x28, 0x7a, 0xe2, 0x4b };

uint8_t libfwsi_shell_folder_identifier_server_manager[ 16 ] = {
	0x31, 0x74, 0x43, 0x96, 0x90, 0x5a, 0x58, 0x46, 0xa7, 0x7c, 0x25, 0x47, 0x87, 0x34, 0xf0, 0x3e };

uint8_t libfwsi_shell_folder_identifier_set_program_access_and_defaults[ 16 ] = {
	0xf7, 0xa1, 0x59, 0x25, 0xd7, 0x21, 0xd4, 0x11, 0xbd, 0xaf, 0x00, 0xc0, 0x4f, 0x60, 0xb9, 0xf0 };

uint8_t libfwsi_shell_folder_identifier_set_user_defaults[ 16 ] = {
	0x88, 0x94, 0xcd, 0x17, 0x28, 0x12, 0x2f, 0x4b, 0x88, 0xce, 0x42, 0x98, 0xe9, 0x3e, 0x09, 0x66 };

uint8_t libfwsi_shell_folder_identifier_shared_documents_folder[ 16 ] = {
	0x47, 0x1a, 0x03, 0x59, 0x72, 0x3f, 0xa7, 0x44, 0x89, 0xc5, 0x55, 0x95, 0xfe, 0x6b, 0x30, 0xee };

uint8_t libfwsi_shell_folder_identifier_shell_docobject_viewer[ 16 ] = {
	0x40, 0xbc, 0xe4, 0xe7, 0x6a, 0xe7, 0xce, 0x11, 0xa9, 0xbb, 0x00, 0xaa, 0x00, 0x4a, 0xe8, 0x37 };

uint8_t libfwsi_shell_folder_identifier_shell_favorite_folder[ 16 ] = {
	0xa0, 0xa3, 0x9b, 0x1a, 0x3a, 0x14, 0xcf, 0x11, 0x83, 0x50, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 };

uint8_t libfwsi_shell_folder_identifier_shell_file_system_folder[ 16 ] = {
	0x11, 0xae, 0x5a, 0x0e, 0x75, 0xa4, 0x5b, 0x4c, 0xab, 0x00, 0xc6, 0x6d, 0xe4, 0x00, 0x27, 0x4e };

uint8_t libfwsi_shell_folder_identifier_shell_file_system_folder2[ 16 ] = {
	0xa0, 0x4b, 0x36, 0xf3, 0xb9, 0x65, 0xce, 0x11, 0xa9, 0xba, 0x00, 0xaa, 0x00, 0x4a, 0xe8, 0x37 };

uint8_t libfwsi_shell_folder_identifier_shell_file_system_netfolder[ 16 ] = {
	0xfd, 0x4b, 0xe0, 0x4f, 0xb9, 0x85, 0xdd, 0x49, 0xb9, 0x14, 0xf4, 0xc9, 0x55, 0x6b, 0x9d, 0xa6 };

uint8_t libfwsi_shell_folder_identifier_shell_storage_folder_viewer[ 16 ] = {
	0xaf, 0xf1, 0x73, 0xe7, 0x65, 0x3a, 0x66, 0x48, 0x85, 0x7d, 0x84, 0x6f, 0xc9, 0xc4, 0x59, 0x8a };

uint8_t libfwsi_shell_folder_identifier_show_desktop[ 16 ] = {
	0x0d, 0xf9, 0x80, 0x30, 0xad, 0xd7, 0xd9, 0x11, 0xbd, 0x98, 0x00, 0x00, 0x94, 0x7b, 0x02, 0x57 };

uint8_t libfwsi_shell_folder_identifier_skydrive[ 16 ] = {
	0x36, 0xd2, 0x74, 0x8e, 0x35, 0x7f, 0x20, 0x47, 0xb1, 0x38, 0x1f, 0xed, 0x0b, 0x85, 0xea, 0x75 };

uint8_t libfwsi_shell_folder_identifier_softex_omnipass_encrypted_folder[ 16 ] = {
	0x4e, 0x94, 0xb1, 0xd5, 0x4e, 0xdb, 0x2e, 0x48, 0xb3, 0xf1, 0xdb, 0x05, 0x82, 0x7f, 0x09, 0x78 };

uint8_t libfwsi_shell_folder_identifier_solidworks_enterprise_pdm[ 16 ] = {
	0x93, 0xe7, 0xd8, 0x0b, 0x71, 0xd3, 0xd1, 0x11, 0xb0, 0xb5, 0x00, 0x60, 0x97, 0x29, 0x19, 0xd7 };

uint8_t libfwsi_shell_folder_identifier_speech_recognition[ 16 ] = {
	0x45, 0xc7, 0xe3, 0x58, 0x71, 0xd9, 0x81, 0x40, 0x90, 0x34, 0x86, 0xe3, 0x4b, 0x30, 0x83, 0x6a };

uint8_t libfwsi_shell_folder_identifier_start_menu_all_programs[ 16 ] = {
	0xe7, 0x80, 0xfa, 0xad, 0x69, 0x97, 0xd9, 0x4a, 0x99, 0x2c, 0x55, 0xdc, 0x57, 0xe1, 0x00, 0x8c };

uint8_t libfwsi_shell_folder_identifier_start_menu_folder[ 16 ] = {
	0xab, 0xca, 0xe7, 0x48, 0x18, 0xb9, 0x58, 0x4e, 0xa9, 0x4d, 0x50, 0x55, 0x19, 0xc7, 0x95, 0xdc };

uint8_t libfwsi_shell_folder_identifier_sticky_notes_namespace_extension_for_windows_desktop_search[ 16 ] = {
	0x4c, 0x82, 0xf5, 0xf3, 0x58, 0xad, 0x28, 0x47, 0xaf, 0x59, 0xa1, 0xeb, 0xe3, 0x39, 0x27, 0x99 };

uint8_t libfwsi_shell_folder_identifier_storage_spaces[ 16 ] = {
	0x06, 0xc6, 0x42, 0xf9, 0x14, 0x09, 0xab, 0x47, 0xbe, 0x56, 0x13, 0x21, 0xb8, 0x03, 0x50, 0x96 };

uint8_t libfwsi_shell_folder_identifier_stream_backed_folder[ 16 ] = {
	0xd6, 0x78, 0xc9, 0xed, 0x53, 0x4d, 0x2f, 0x4b, 0xa2, 0x65, 0x58, 0x05, 0x67, 0x4b, 0xe5, 0x68 };

uint8_t libfwsi_shell_folder_identifier_subscription_folder[ 16 ] = {
	0x61, 0x58, 0x17, 0xf5, 0x88, 0x26, 0xd0, 0x11, 0x9c, 0x5e, 0x00, 0xaa, 0x00, 0xa4, 0x59, 0x57 };

uint8_t libfwsi_shell_folder_identifier_sync_center_conflict_delegate_folder[ 16 ] = {
	0x40, 0xd0, 0x13, 0xe4, 0x88, 0x67, 0x22, 0x4c, 0x95, 0x7e, 0x17, 0x5d, 0x1c, 0x51, 0x3a, 0x34 };

uint8_t libfwsi_shell_folder_identifier_sync_center_conflict_folder[ 16 ] = {
	0xac, 0x78, 0x99, 0x28, 0x01, 0xa1, 0x41, 0x43, 0xa8, 0x17, 0x21, 0xeb, 0xa7, 0xfd, 0x04, 0x6d };

uint8_t libfwsi_shell_folder_identifier_sync_center_folder[ 16 ] = {
	0xe5, 0xf5, 0x73, 0x9c, 0xe7, 0x7a, 0x32, 0x4e, 0xa8, 0xe8, 0x8d, 0x23, 0xb8, 0x52, 0x55, 0xbf };

uint8_t libfwsi_shell_folder_identifier_sync_results_delegate_folder[ 16 ] = {
	0x2f, 0xb3, 0x48, 0xbc, 0x10, 0x59, 0xf5, 0x47, 0x85, 0x70, 0x50, 0x74, 0xa8, 0xa5, 0x63, 0x6a };

uint8_t libfwsi_shell_folder_identifier_sync_results_folder[ 16 ] = {
	0x64, 0x94, 0xd9, 0x71, 0x6b, 0x3b, 0x5c, 0x47, 0xb2, 0x41, 0xe1, 0x58, 0x83, 0x20, 0x75, 0x29 };

uint8_t libfwsi_shell_folder_identifier_sync_setup_delegate_folder[ 16 ] = {
	0x9a, 0x0a, 0x39, 0xf1, 0xf4, 0xa3, 0x5d, 0x4e, 0x9c, 0x5f, 0x98, 0xf3, 0xbd, 0x8d, 0x93, 0x5c };

uint8_t libfwsi_shell_folder_identifier_sync_setup_folder[ 16 ] = {
	0xc0, 0x59, 0x9e, 0x2e, 0x37, 0xb4, 0x81, 0x49, 0xa6, 0x47, 0x9c, 0x34, 0xb9, 0xb9, 0x08, 0x91 };

uint8_t libfwsi_shell_folder_identifier_system[ 16 ] = {
	0xe4, 0xc0, 0x06, 0xbb, 0x93, 0xd2, 0x75, 0x4f, 0x8a, 0x90, 0xcb, 0x05, 0xb6, 0x47, 0x7e, 0xee };

uint8_t libfwsi_shell_folder_identifier_system_recovery[ 16 ] = {
	0xfd, 0x3a, 0xe6, 0x9f, 0xcf, 0x59, 0x19, 0x44, 0x97, 0x75, 0xab, 0xcc, 0x38, 0x49, 0xf8, 0x61 };

uint8_t libfwsi_shell_folder_identifier_system_restore[ 16 ] = {
	0x34, 0xc5, 0x6b, 0x3f, 0xa1, 0xdf, 0xb4, 0x4a, 0xae, 0x54, 0xef, 0x25, 0xa7, 0x4e, 0x01, 0x07 };

uint8_t libfwsi_shell_folder_identifier_taskbar[ 16 ] = {
	0xf4, 0xb0, 0xd7, 0x05, 0x21, 0x21, 0xff, 0x4e, 0xbf, 0x6b, 0xed, 0x3f, 0x69, 0xb8, 0x94, 0xd9 };

uint8_t libfwsi_shell_folder_identifier_taskbar_and_start_menu[ 16 ] = {
	0xaa, 0x4e, 0xf4, 0x0d, 0x21, 0xff, 0x12, 0x44, 0x82, 0x8e, 0x26, 0x0a, 0x87, 0x28, 0xe7, 0xf1 };

uint8_t libfwsi_shell_folder_identifier_temporary_internet_files[ 16 ] = {
	0x00, 0x9e, 0xd2, 0x7b, 0xc1, 0x76, 0xcf, 0x11, 0x9d, 0xd0, 0x00, 0xa0, 0xc9, 0x03, 0x49, 0x33 };

uint8_t libfwsi_shell_folder_identifier_temporary_internet_files2[ 16 ] = {
	0x01, 0x9e, 0xd2, 0x7b, 0xc1, 0x76, 0xcf, 0x11, 0x9d, 0xd0, 0x00, 0xa0, 0xc9, 0x03, 0x49, 0x33 };

uint8_t libfwsi_shell_folder_identifier_this_device[ 16 ] = {
	0x42, 0x4b, 0x93, 0x5b, 0x2b, 0x52, 0x34, 0x4c, 0xbb, 0xfe, 0x37, 0xa3, 0xef, 0x7b, 0x9c, 0x90 };

uint8_t libfwsi_shell_folder_identifier_this_device2[ 16 ] = {
	0x54, 0x8c, 0x27, 0xf8, 0x12, 0xa7, 0x5b, 0x41, 0xb5, 0x93, 0xb7, 0x7a, 0x2b, 0xe0, 0xdd, 0xa9 };

uint8_t libfwsi_shell_folder_identifier_this_pc[ 16 ] = {
	0xce, 0x29, 0x5f, 0x5e, 0xa8, 0xe0, 0xd3, 0x49, 0xaf, 0x32, 0x7a, 0x7b, 0xdc, 0x17, 0x34, 0x78 };

uint8_t libfwsi_shell_folder_identifier_tree_property_value_folder[ 16 ] = {
	0x62, 0x16, 0x8e, 0x70, 0x32, 0xb8, 0xa8, 0x42, 0xbb, 0xe1, 0x0a, 0x77, 0x12, 0x1e, 0x39, 0x08 };

uint8_t libfwsi_shell_folder_identifier_troubleshooting[ 16 ] = {
	0x93, 0x48, 0x8c, 0xc5, 0xe0, 0x3b, 0x45, 0x4b, 0xab, 0xb5, 0xa6, 0x3e, 0x4b, 0x8c, 0x86, 0x51 };

uint8_t libfwsi_shell_folder_identifier_uncfatshellfolder_class[ 16 ] = {
	0x80, 0xa0, 0x91, 0xc2, 0x00, 0xb4, 0x34, 0x4e, 0xae, 0x3f, 0x3d, 0x2b, 0x96, 0x37, 0xd5, 0x6c };

uint8_t libfwsi_shell_folder_identifier_user_accounts[ 16 ] = {
	0x54, 0x27, 0x63, 0x60, 0x23, 0xc5, 0x62, 0x4b, 0xb4, 0x5c, 0x41, 0x72, 0xda, 0x01, 0x26, 0x19 };

uint8_t libfwsi_shell_folder_identifier_user_pinned[ 16 ] = {
	0xc8, 0x27, 0x34, 0x1f, 0x10, 0x5c, 0x10, 0x42, 0xaa, 0x03, 0x2e, 0xe4, 0x52, 0x87, 0xd6, 0x68 };

uint8_t libfwsi_shell_folder_identifier_users_and_passwords[ 16 ] = {
	0xbd, 0x77, 0x9d, 0x7a, 0x03, 0x54, 0xd2, 0x11, 0x87, 0x85, 0x2e, 0x04, 0x20, 0x52, 0x41, 0x53 };

uint8_t libfwsi_shell_folder_identifier_users_files_folder_delegate_folder[ 16 ] = {
	0xc5, 0xcd, 0xfa, 0xdf, 0x9f, 0x67, 0x56, 0x41, 0x89, 0x47, 0xc5, 0xc7, 0x6b, 0xc0, 0xb6, 0x7f };

uint8_t libfwsi_shell_folder_identifier_users_libraries[ 16 ] = {
	0x25, 0x48, 0x1e, 0x03, 0x94, 0x7b, 0xc3, 0x4d, 0xb1, 0x31, 0xe9, 0x46, 0xb4, 0x4c, 0x8d, 0xd5 };

uint8_t libfwsi_shell_folder_identifier_web_folders[ 16 ] = {
	0x00, 0xdf, 0xea, 0xbd, 0x65, 0xc2, 0xd0, 0x11, 0xbc, 0xed, 0x00, 0xa0, 0xc9, 0x0a, 0xb5, 0x0f };

uint8_t libfwsi_shell_folder_identifier_welcome_center[ 16 ] = {
	0x8c, 0x7f, 0x1b, 0xcb, 0x0a, 0xc5, 0x76, 0x41, 0xb6, 0x04, 0x9e, 0x24, 0xde, 0xe8, 0xd4, 0xd1 };

uint8_t libfwsi_shell_folder_identifier_window_switcher[ 16 ] = {
	0x0e, 0xf9, 0x80, 0x30, 0xad, 0xd7, 0xd9, 0x11, 0xbd, 0x98, 0x00, 0x00, 0x94, 0x7b, 0x02, 0x57 };

uint8_t libfwsi_shell_folder_identifier_windows_anytime_upgrade[ 16 ] = {
	0x0e, 0x2a, 0x12, 0xbe, 0x03, 0x45, 0xda, 0x11, 0x8b, 0xde, 0xf6, 0x6b, 0xad, 0x1e, 0x3f, 0x3a };

uint8_t libfwsi_shell_folder_identifier_windows_defender[ 16 ] = {
	0xb9, 0x9e, 0x55, 0xd8, 0xc0, 0x20, 0x0e, 0x41, 0xbe, 0xda, 0x7e, 0xd4, 0x16, 0xae, 0xcc, 0x2a };

uint8_t libfwsi_shell_folder_identifier_windows_desktop_search[ 16 ] = {
	0x12, 0xf6, 0xe7, 0x13, 0x61, 0xf2, 0x91, 0x43, 0xbe, 0xa2, 0x39, 0xdf, 0x4f, 0x3f, 0xa3, 0x11 };

uint8_t libfwsi_shell_folder_identifier_windows_desktop_search_mapi_namespace_extension_class[ 16 ] = {
	0x8c, 0xa5, 0x43, 0x1f, 0x28, 0xea, 0xe6, 0x43, 0x9e, 0xc4, 0x34, 0x57, 0x4a, 0x16, 0xeb, 0xb7 };

uint8_t libfwsi_shell_folder_identifier_windows_features[ 16 ] = {
	0x15, 0x84, 0x71, 0x67, 0x50, 0xc4, 0x3c, 0x4f, 0xbf, 0x8a, 0xb4, 0x87, 0x64, 0x2d, 0xc3, 0x9b };

uint8_t libfwsi_shell_folder_identifier_windows_firewall[ 16 ] = {
	0x2f, 0x49, 0x26, 0x40, 0x69, 0x2f, 0xb8, 0x46, 0xb9, 0xbf, 0x56, 0x54, 0xfc, 0x07, 0xe4, 0x23 };

uint8_t libfwsi_shell_folder_identifier_windows_search_service_media_center_namespace_extension_handler[ 16 ] = {
	0x50, 0x97, 0xd9, 0x98, 0x8a, 0x0b, 0x59, 0x4c, 0x91, 0x51, 0x58, 0x90, 0x53, 0x68, 0x3d, 0x73 };

uint8_t libfwsi_shell_folder_identifier_windows_search_service_outlook_express_protocol_handler[ 16 ] = {
	0xd0, 0xcf, 0x26, 0xd4, 0xfc, 0x87, 0x06, 0x49, 0x98, 0xd9, 0xa2, 0x3f, 0x5d, 0x51, 0x5d, 0x61 };

uint8_t libfwsi_shell_folder_identifier_windows_security[ 16 ] = {
	0xf2, 0xa1, 0x59, 0x25, 0xd7, 0x21, 0xd4, 0x11, 0xbd, 0xaf, 0x00, 0xc0, 0x4f, 0x60, 0xb9, 0xf0 };

uint8_t libfwsi_shell_folder_identifier_windows_sideshow[ 16 ] = {
	0x61, 0x48, 0x5a, 0xe9, 0x7a, 0xd5, 0xe1, 0x4b, 0xad, 0x0f, 0x35, 0x26, 0x7e, 0x26, 0x17, 0x39 };

uint8_t libfwsi_shell_folder_identifier_windows_update[ 16 ] = {
	0xdb, 0xf7, 0xee, 0x36, 0xad, 0x88, 0x81, 0x4e, 0xad, 0x49, 0x0e, 0x31, 0x3f, 0x0c, 0x35, 0xf8 };

uint8_t libfwsi_shell_folder_identifier_workspaces_center[ 16 ] = {
	0x96, 0x7c, 0x1d, 0x24, 0xbf, 0xf8, 0x85, 0x4f, 0xb0, 0x1f, 0xe2, 0xb0, 0x43, 0x34, 0x1a, 0x4b };


uint8_t libfwsi_shell_folder_identifier_empty[ 16 ] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

uint8_t libfwsi_shell_folder_identifier_unknown[ 16 ] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };

/* The shell folder identifiers
 */
libfwsi_shell_folder_identifier_definition_t libfwsi_shell_folder_identifier_definitions[ ] = {

	{ libfwsi_shell_folder_identifier_3d_objects,
	  "3D Objects" },
	{ libfwsi_shell_folder_identifier_activex_cache_folder,
	  "ActiveX Cache Folder" },
	{ libfwsi_shell_folder_identifier_add_network_place,
	  "Add Network Place" },
	{ libfwsi_shell_folder_identifier_administrative_tools,
	  "Administrative Tools" },
	{ libfwsi_shell_folder_identifier_all_control_panel_items,
	  "All Control Panel Items" },
	{ libfwsi_shell_folder_identifier_all_tasks,
	  "All Tasks" },
	{ libfwsi_shell_folder_identifier_all_tasks2,
	  "All Tasks" },
	{ libfwsi_shell_folder_identifier_application_suggested_locations,
	  "Application Suggested Locations" },
	{ libfwsi_shell_folder_identifier_applications,
	  "Applications" },
	{ libfwsi_shell_folder_identifier_autoplay,
	  "AutoPlay" },
	{ libfwsi_shell_folder_identifier_backup_and_restore,
	  "Backup And Restore" },
	{ libfwsi_shell_folder_identifier_backup_and_restore_center,
	  "Backup and Restore Center" },
	{ libfwsi_shell_folder_identifier_biometrics,
	  "Biometrics" },
	{ libfwsi_shell_folder_identifier_bluetooth_devices,
	  "Bluetooth Devices" },
	{ libfwsi_shell_folder_identifier_briefcase,
	  "Briefcase" },
	{ libfwsi_shell_folder_identifier_cabinet_file,
	  "Cabinet File" },
	{ libfwsi_shell_folder_identifier_command_folder,
	  "Command Folder" },
	{ libfwsi_shell_folder_identifier_common_places_fs_folder,
	  "Common Places FS Folder" },
	{ libfwsi_shell_folder_identifier_compressed_folder,
	  "Compressed Folder" },
	{ libfwsi_shell_folder_identifier_computer_delegate_folder,
	  "Computer (delegate folder)" },
	{ libfwsi_shell_folder_identifier_computer_search_results_folder,
	  "Computer Search Results Folder" },
	{ libfwsi_shell_folder_identifier_computers_and_devices,
	  "Computers and Devices" },
	{ libfwsi_shell_folder_identifier_control_panel,
	  "Control Panel" },
	{ libfwsi_shell_folder_identifier_control_panel_command_object_for_start_menu_and_desktop,
	  "Control Panel command object for Start menu and desktop" },
	{ libfwsi_shell_folder_identifier_credential_manager,
	  "Credential Manager" },
	{ libfwsi_shell_folder_identifier_db_folder,
	  "DB Folder" },
	{ libfwsi_shell_folder_identifier_default_location,
	  "Default Location" },
	{ libfwsi_shell_folder_identifier_desktop,
	  "Desktop" },
	{ libfwsi_shell_folder_identifier_device_center,
	  "Device Center" },
	{ libfwsi_shell_folder_identifier_device_center_initialization,
	  "Device Center Initialization" },
	{ libfwsi_shell_folder_identifier_devicepairingfolder_initialization,
	  "DevicePairingFolder Initialization" },
	{ libfwsi_shell_folder_identifier_directory,
	  "Directory" },
	{ libfwsi_shell_folder_identifier_display,
	  "Display" },
	{ libfwsi_shell_folder_identifier_dlna_content_directory_data_source,
	  "DLNA Content Directory Data Source" },
	{ libfwsi_shell_folder_identifier_dlna_media_servers_data_source,
	  "DLNA Media Servers Data Source" },
	{ libfwsi_shell_folder_identifier_dxp,
	  "DXP" },
	{ libfwsi_shell_folder_identifier_ease_of_access,
	  "Ease of Access" },
	{ libfwsi_shell_folder_identifier_ecs,
	  "ECS" },
	{ libfwsi_shell_folder_identifier_email,
	  "E-mail" },
	{ libfwsi_shell_folder_identifier_enhanced_storage_data_source,
	  "Enhanced Storage Data Source" },
	{ libfwsi_shell_folder_identifier_explorer_browser_results_folder,
	  "Explorer Browser Results Folder" },
	{ libfwsi_shell_folder_identifier_extensions_manager_folder,
	  "Extensions Manager Folder" },
	{ libfwsi_shell_folder_identifier_favorites,
	  "Favorites" },
	{ libfwsi_shell_folder_identifier_feedback_tool,
	  "Feedback Tool" },
	{ libfwsi_shell_folder_identifier_file_backup_index,
	  "File Backup Index" },
	{ libfwsi_shell_folder_identifier_file_explorer,
	  "File Explorer" },
	{ libfwsi_shell_folder_identifier_file_history_data_source,
	  "File History Data Source" },
	{ libfwsi_shell_folder_identifier_folder_options,
	  "Folder Options" },
	{ libfwsi_shell_folder_identifier_folder_shortcut,
	  "Folder Shortcut" },
	{ libfwsi_shell_folder_identifier_font_settings,
	  "Font Settings" },
	{ libfwsi_shell_folder_identifier_fonts,
	  "Fonts" },
	{ libfwsi_shell_folder_identifier_frequent_places_folder,
	  "Frequent Places Folder" },
	{ libfwsi_shell_folder_identifier_fusion_cache,
	  "Fusion Cache" },
	{ libfwsi_shell_folder_identifier_games_explorer,
	  "Games Explorer" },
	{ libfwsi_shell_folder_identifier_help_and_support,
	  "Help and Support" },
	{ libfwsi_shell_folder_identifier_history,
	  "History" },
	{ libfwsi_shell_folder_identifier_history2,
	  "History" },
	{ libfwsi_shell_folder_identifier_history3,
	  "History" },
	{ libfwsi_shell_folder_identifier_history4,
	  "History" },
	{ libfwsi_shell_folder_identifier_history_vault,
	  "History Vault" },
	{ libfwsi_shell_folder_identifier_home_group_control_panel,
	  "Home Group Control Panel" },
	{ libfwsi_shell_folder_identifier_inbox,
	  "Inbox" },
	{ libfwsi_shell_folder_identifier_inbox2,
	  "Inbox" },
	{ libfwsi_shell_folder_identifier_install_new_programs,
	  "Install New Programs" },
	{ libfwsi_shell_folder_identifier_installed_updates,
	  "Installed Updates" },
	{ libfwsi_shell_folder_identifier_internet,
	  "Internet" },
	{ libfwsi_shell_folder_identifier_internet_explorer,
	  "Internet Explorer" },
	{ libfwsi_shell_folder_identifier_internet_explorer_history_and_feeds_shell_data_source_for_windows_search,
	  "Internet Explorer History and Feeds Shell Data Source for Windows Search" },
	{ libfwsi_shell_folder_identifier_internet_explorer_rss_feeds_folder,
	  "Internet Explorer RSS Feeds Folder" },
	{ libfwsi_shell_folder_identifier_internet_folder,
	  "Internet Folder" },
	{ libfwsi_shell_folder_identifier_language_settings,
	  "Language Settings" },
	{ libfwsi_shell_folder_identifier_layout_folder,
	  "Layout Folder" },
	{ libfwsi_shell_folder_identifier_libraries_users_files_folder_delegate_folder,
	  "Libraries Users Files Folder (delegate folder)" },
	{ libfwsi_shell_folder_identifier_library_folder,
	  "Library Folder" },
	{ libfwsi_shell_folder_identifier_location_folder,
	  "Location Folder" },
	{ libfwsi_shell_folder_identifier_manage_wireless_networks,
	  "Manage Wireless Networks" },
	{ libfwsi_shell_folder_identifier_microsoft_browser_architecture,
	  "Microsoft Browser Architecture" },
	{ libfwsi_shell_folder_identifier_microsoft_browser_architecture2,
	  "Microsoft Browser Architecture" },
	{ libfwsi_shell_folder_identifier_microsoft_ftp_folder,
	  "Microsoft FTP Folder" },
	{ libfwsi_shell_folder_identifier_microsoft_office_outlook,
	  "Microsoft Office Outlook" },
	{ libfwsi_shell_folder_identifier_microsoft_onenote_namespace_extension_for_windows_desktop_search,
	  "Microsoft OneNote Namespace Extension for Windows Desktop Search" },
	{ libfwsi_shell_folder_identifier_microsoft_windows_font_folder,
	  "Microsoft Windows Font Folder" },
	{ libfwsi_shell_folder_identifier_mobile_broadband_profile_settings_editor,
	  "Mobile Broadband Profile Settings Editor" },
	{ libfwsi_shell_folder_identifier_mobility_center_control_panel,
	  "Mobility Center Control Panel" },
	{ libfwsi_shell_folder_identifier_ms_graph_recent_file_folder,
	  "MS Graph Recent File Folder" },
	{ libfwsi_shell_folder_identifier_my_computer,
	  "My Computer" },
	{ libfwsi_shell_folder_identifier_my_documents,
	  "My Documents" },
	{ libfwsi_shell_folder_identifier_my_network_places,
	  "My Network Places" },
	{ libfwsi_shell_folder_identifier_network_and_dialup_connections,
	  "Network and Dial-up Connections" },
	{ libfwsi_shell_folder_identifier_network_and_dialup_connections2,
	  "Network and Dial-up Connections" },
	{ libfwsi_shell_folder_identifier_network_and_sharing_center,
	  "Network and Sharing Center" },
	{ libfwsi_shell_folder_identifier_network_map,
	  "Network Map" },
	{ libfwsi_shell_folder_identifier_network_setup_wizard,
	  "Network Setup Wizard" },
	{ libfwsi_shell_folder_identifier_offline_files,
	  "Offline Files" },
	{ libfwsi_shell_folder_identifier_offline_files_folder,
	  "Offline Files Folder" },
	{ libfwsi_shell_folder_identifier_other_users_folder,
	  "Other Users Folder" },
	{ libfwsi_shell_folder_identifier_other_users_folder2,
	  "Other Users Folder" },
	{ libfwsi_shell_folder_identifier_parental_controls,
	  "Parental Controls" },
	{ libfwsi_shell_folder_identifier_pc_settings,
	  "PC Settings" },
	{ libfwsi_shell_folder_identifier_performance_information_and_tools,
	  "Performance Information and Tools" },
	{ libfwsi_shell_folder_identifier_personalization_control_panel,
	  "Personalization Control Panel" },
	{ libfwsi_shell_folder_identifier_portable_devices,
	  "Portable Devices" },
	{ libfwsi_shell_folder_identifier_portable_media_devices,
	  "Portable Media Devices" },
	{ libfwsi_shell_folder_identifier_power_options,
	  "Power Options" },
	{ libfwsi_shell_folder_identifier_previous_versions,
	  "Previous Versions" },
	{ libfwsi_shell_folder_identifier_previous_versions_delegate_folder,
	  "Previous Versions Delegate Folder" },
	{ libfwsi_shell_folder_identifier_previous_versions_results_delegate_folder,
	  "Previous Versions Results Delegate Folder" },
	{ libfwsi_shell_folder_identifier_previous_versions_results_folder,
	  "Previous Versions Results Folder" },
	{ libfwsi_shell_folder_identifier_printers_and_faxes,
	  "Printers and Faxes" },
	{ libfwsi_shell_folder_identifier_printhood_delegate_folder,
	  "Printhood delegate folder" },
	{ libfwsi_shell_folder_identifier_programs_and_features,
	  "Programs and Features" },
	{ libfwsi_shell_folder_identifier_programs_folder,
	  "Programs Folder" },
	{ libfwsi_shell_folder_identifier_programs_folder_and_fast_items,
	  "Programs Folder and Fast Items" },
	{ libfwsi_shell_folder_identifier_proximity_cpl,
	  "Proximity CPL" },
	{ libfwsi_shell_folder_identifier_public_folder,
	  "Public Folder" },
	{ libfwsi_shell_folder_identifier_quick_access,
	  "Quick Access" },
	{ libfwsi_shell_folder_identifier_recent_items_instance_folder,
	  "Recent Items Instance Folder" },
	{ libfwsi_shell_folder_identifier_recent_places_folder,
	  "Recent Places Folder" },
	{ libfwsi_shell_folder_identifier_recycle_bin,
	  "Recycle Bin" },
	{ libfwsi_shell_folder_identifier_remote_printers,
	  "Remote Printers" },
	{ libfwsi_shell_folder_identifier_removable_drives,
	  "Removable Drives" },
	{ libfwsi_shell_folder_identifier_removable_storage_devices,
	  "Removable Storage Devices" },
	{ libfwsi_shell_folder_identifier_results_folder,
	  "Results Folder" },
	{ libfwsi_shell_folder_identifier_run,
	  "Run..." },
	{ libfwsi_shell_folder_identifier_scanners_and_cameras,
	  "Scanners & Cameras" },
	{ libfwsi_shell_folder_identifier_scanners_and_cameras2,
	  "Scanners & Cameras" },
	{ libfwsi_shell_folder_identifier_scheduled_tasks,
	  "Scheduled Tasks" },
	{ libfwsi_shell_folder_identifier_search,
	  "Search" },
	{ libfwsi_shell_folder_identifier_search_connector_folder,
	  "Search Connector Folder" },
	{ libfwsi_shell_folder_identifier_search_folder,
	  "Search Folder" },
	{ libfwsi_shell_folder_identifier_search_home,
	  "Search Home" },
	{ libfwsi_shell_folder_identifier_search_results,
	  "Search Results" },
	{ libfwsi_shell_folder_identifier_secure_startup,
	  "Secure Startup" },
	{ libfwsi_shell_folder_identifier_security_and_maintenance_cpl,
	  "Security and Maintenance CPL" },
	{ libfwsi_shell_folder_identifier_security_center,
	  "Security Center" },
	{ libfwsi_shell_folder_identifier_sensors,
	  "Sensors" },
	{ libfwsi_shell_folder_identifier_server_manager,
	  "Server Manager" },
	{ libfwsi_shell_folder_identifier_set_program_access_and_defaults,
	  "Set Program Access and Defaults" },
	{ libfwsi_shell_folder_identifier_set_user_defaults,
	  "Set User Defaults" },
	{ libfwsi_shell_folder_identifier_shared_documents_folder,
	  "Shared Documents Folder" },
	{ libfwsi_shell_folder_identifier_shell_docobject_viewer,
	  "Shell DocObject Viewer" },
	{ libfwsi_shell_folder_identifier_shell_favorite_folder,
	  "Shell Favorite Folder" },
	{ libfwsi_shell_folder_identifier_shell_file_system_folder,
	  "Shell File System Folder" },
	{ libfwsi_shell_folder_identifier_shell_file_system_folder2,
	  "Shell File System Folder" },
	{ libfwsi_shell_folder_identifier_shell_file_system_netfolder,
	  "Shell File System NetFolder" },
	{ libfwsi_shell_folder_identifier_shell_storage_folder_viewer,
	  "Shell Storage Folder Viewer" },
	{ libfwsi_shell_folder_identifier_show_desktop,
	  "Show Desktop" },
	{ libfwsi_shell_folder_identifier_skydrive,
	  "SkyDrive" },
	{ libfwsi_shell_folder_identifier_softex_omnipass_encrypted_folder,
	  "Softex OmniPass Encrypted Folder" },
	{ libfwsi_shell_folder_identifier_solidworks_enterprise_pdm,
	  "SolidWorks Enterprise PDM" },
	{ libfwsi_shell_folder_identifier_speech_recognition,
	  "Speech Recognition" },
	{ libfwsi_shell_folder_identifier_start_menu_all_programs,
	  "Start Menu All Programs" },
	{ libfwsi_shell_folder_identifier_start_menu_folder,
	  "Start Menu Folder" },
	{ libfwsi_shell_folder_identifier_sticky_notes_namespace_extension_for_windows_desktop_search,
	  "Sticky Notes Namespace Extension for Windows Desktop Search" },
	{ libfwsi_shell_folder_identifier_storage_spaces,
	  "Storage Spaces" },
	{ libfwsi_shell_folder_identifier_stream_backed_folder,
	  "Stream Backed Folder" },
	{ libfwsi_shell_folder_identifier_subscription_folder,
	  "Subscription Folder" },
	{ libfwsi_shell_folder_identifier_sync_center_conflict_delegate_folder,
	  "Sync Center Conflict Delegate Folder" },
	{ libfwsi_shell_folder_identifier_sync_center_conflict_folder,
	  "Sync Center Conflict Folder" },
	{ libfwsi_shell_folder_identifier_sync_center_folder,
	  "Sync Center Folder" },
	{ libfwsi_shell_folder_identifier_sync_results_delegate_folder,
	  "Sync Results Delegate Folder" },
	{ libfwsi_shell_folder_identifier_sync_results_folder,
	  "Sync Results Folder" },
	{ libfwsi_shell_folder_identifier_sync_setup_delegate_folder,
	  "Sync Setup Delegate Folder" },
	{ libfwsi_shell_folder_identifier_sync_setup_folder,
	  "Sync Setup Folder" },
	{ libfwsi_shell_folder_identifier_system,
	  "System" },
	{ libfwsi_shell_folder_identifier_system_recovery,
	  "System Recovery" },
	{ libfwsi_shell_folder_identifier_system_restore,
	  "System Restore" },
	{ libfwsi_shell_folder_identifier_taskbar,
	  "Taskbar" },
	{ libfwsi_shell_folder_identifier_taskbar_and_start_menu,
	  "Taskbar and Start Menu" },
	{ libfwsi_shell_folder_identifier_temporary_internet_files,
	  "Temporary Internet Files" },
	{ libfwsi_shell_folder_identifier_temporary_internet_files2,
	  "Temporary Internet Files" },
	{ libfwsi_shell_folder_identifier_this_device,
	  "This Device" },
	{ libfwsi_shell_folder_identifier_this_device2,
	  "This Device" },
	{ libfwsi_shell_folder_identifier_this_pc,
	  "This PC" },
	{ libfwsi_shell_folder_identifier_tree_property_value_folder,
	  "Tree property value folder" },
	{ libfwsi_shell_folder_identifier_troubleshooting,
	  "Troubleshooting" },
	{ libfwsi_shell_folder_identifier_uncfatshellfolder_class,
	  "UNCFATShellFolder Class" },
	{ libfwsi_shell_folder_identifier_user_accounts,
	  "User Accounts" },
	{ libfwsi_shell_folder_identifier_user_pinned,
	  "User Pinned" },
	{ libfwsi_shell_folder_identifier_users_and_passwords,
	  "Users and Passwords" },
	{ libfwsi_shell_folder_identifier_users_files_folder_delegate_folder,
	  "Users Files Folder (delegate folder)" },
	{ libfwsi_shell_folder_identifier_users_libraries,
	  "Users Libraries" },
	{ libfwsi_shell_folder_identifier_web_folders,
	  "Web Folders" },
	{ libfwsi_shell_folder_identifier_welcome_center,
	  "Welcome Center" },
	{ libfwsi_shell_folder_identifier_window_switcher,
	  "Window Switcher" },
	{ libfwsi_shell_folder_identifier_windows_anytime_upgrade,
	  "Windows Anytime Upgrade" },
	{ libfwsi_shell_folder_identifier_windows_defender,
	  "Windows Defender" },
	{ libfwsi_shell_folder_identifier_windows_desktop_search,
	  "Windows Desktop Search" },
	{ libfwsi_shell_folder_identifier_windows_desktop_search_mapi_namespace_extension_class,
	  "Windows Desktop Search MAPI Namespace Extension Class" },
	{ libfwsi_shell_folder_identifier_windows_features,
	  "Windows Features" },
	{ libfwsi_shell_folder_identifier_windows_firewall,
	  "Windows Firewall" },
	{ libfwsi_shell_folder_identifier_windows_search_service_media_center_namespace_extension_handler,
	  "Windows Search Service Media Center Namespace Extension Handler" },
	{ libfwsi_shell_folder_identifier_windows_search_service_outlook_express_protocol_handler,
	  "Windows Search Service Outlook Express Protocol Handler" },
	{ libfwsi_shell_folder_identifier_windows_security,
	  "Windows Security" },
	{ libfwsi_shell_folder_identifier_windows_sideshow,
	  "Windows SideShow" },
	{ libfwsi_shell_folder_identifier_windows_update,
	  "Windows Update" },
	{ libfwsi_shell_folder_identifier_workspaces_center,
	  "Workspaces Center" },

	{ libfwsi_shell_folder_identifier_unknown,
	  "Unknown" } };

/* Retrieves a string containing the name of the folder identifier
 */
const char *libfwsi_shell_folder_identifier_get_name(
             const uint8_t *shell_folder_identifier )
{
	int iterator = 0;

	if( shell_folder_identifier == NULL )
	{
		return( "Invalid shell folder identifier" );
	}
	while( memory_compare(
	        ( libfwsi_shell_folder_identifier_definitions[ iterator ] ).identifier,
	        libfwsi_shell_folder_identifier_unknown,
	        16 ) != 0 )
	{
		if( memory_compare(
		     ( libfwsi_shell_folder_identifier_definitions[ iterator ] ).identifier,
		     shell_folder_identifier,
		     16 ) == 0 )
		{
			break;
		}
		iterator++;
	}
	return(
	 ( libfwsi_shell_folder_identifier_definitions[ iterator ] ).name );
}

