LoadFunctionLibrary ("libv3/all-terms.bf");
LoadFunctionLibrary ("libv3/convenience/regexp.bf");
LoadFunctionLibrary ("libv3/convenience/math.bf");
LoadFunctionLibrary ("libv3/IOFunctions.bf");
LoadFunctionLibrary ("libv3/UtilityFunctions.bf");
LoadFunctionLibrary ("libv3/tasks/trees.bf");
LoadFunctionLibrary ("libv3/tasks/alignments.bf");
LoadFunctionLibrary ("libv3/tasks/estimators.bf");
LoadFunctionLibrary ("SelectionAnalyses/modules/io_functions.ibf");
LoadFunctionLibrary ("libv3/tasks/mpi.bf");
LoadFunctionLibrary ("libv3/convenience/random.bf");
LoadFunctionLibrary("libv3/models/rate_variation.bf");

global kappa = 1;
Q_HKY85 = {
            {*, t, kappa*t, a}
            {t,*,t,kappa*t}
            {kappa*t,t,*,t*c}
            {t,kappa*t,t,*}
        };
        
equal = {4,1}["0.25"];
        
Model HKY85 = (Q_HKY85,equal);

tree_string = "(BMS619_consensus_553_n_14_1:0.002179,BMS619_consensus_70_n_22_1:0.000001,((((((BMS619_consensus_335_n_109_1:0.000001,((((BMS619_consensus_272_n_24_1:0.001342,BMS619_consensus_130_n_20_1:0.000435)33:0.000433,BMS619_consensus_51_n_115_1:0.000001)7:0.000001,(((BMS619_consensus_69_n_15_1:0.001761,BMS619_consensus_120_n_13_1:0.001740)7:0.000001,(BMS619_consensus_116_n_6_1:0.000001,(BMS619_consensus_76_n_12_1:0.001302,(PBP619_consensus_437_n_104_1:0.000434,((PBP619_consensus_145_n_460_1:0.000001,PBP619_consensus_1048_n_20_1:0.000001)19:0.000001,PBP619_consensus_409_n_1_1:0.000434)19:0.000001)45:0.000433)2:0.000001)10:0.000433)0:0.000001,(((((((PBP619_consensus_903_n_4_1:0.000433,((((PBP619_consensus_463_n_2_1:0.003075,PBP619_consensus_116_n_33_1:0.000433)18:0.000001,PBP619_consensus_445_n_2_1:0.000001)5:0.000001,PBP619_consensus_1094_n_372_1:0.000001)2:0.000001,((PBP619_consensus_191_n_96_1:0.000001,PBP619_consensus_656_n_4_1:0.000867)60:0.000433,PBP619_consensus_206_n_18_1:0.000436)1:0.000001)0:0.000001)19:0.000433,((((PBP619_consensus_475_n_84_1:0.000433,PBP619_consensus_190_n_385_1:0.000001)27:0.000001,PBP619_consensus_1384_n_203_1:0.000433)58:0.000434,PBP619_consensus_1376_n_8_1:0.000001)69:0.000437,BMS619_consensus_185_n_11_1:0.001748)27:0.000431)1:0.000001,(PBP619_consensus_935_n_20_2:0.000001,((((PBP619_consensus_428_n_29_1:0.000433,PBP619_consensus_627_n_12_1:0.000435)15:0.000001,PBP619_consensus_212_n_559_1:0.000001)31:0.000001,PBP619_consensus_621_n_2_1:0.001302)67:0.000868,(PBP619_consensus_211_n_9_1:0.000001,PBP619_consensus_1103_n_79_1:0.000433)53:0.000433)3:0.000001)0:0.000001)2:0.000001,BMS619_consensus_271_n_17_1:0.001740)1:0.000433,(BMS619_consensus_77_n_11_1:0.002176,BMS619_consensus_264_n_9_1:0.000867)13:0.000001)0:0.000001,((BMS619_consensus_309_n_7_1:0.003519,((PBP619_consensus_151_n_11_1:0.000001,PBP619_consensus_794_n_81_1:0.000001)73:0.000434,PBP619_consensus_180_n_378_1:0.000001)82:0.000878)20:0.000425,(BMS619_consensus_598_n_25_1:0.000471,BMS619_consensus_123_n_41_1:0.000001)33:0.000433)0:0.000001)0:0.000001,(((BMS619_consensus_362_n_19_1:0.001306,BMS619_consensus_401_n_7_1:0.003494)19:0.000001,PBP619_consensus_1359_n_158_1:0.000001)28:0.000001,(PBP619_consensus_1787_n_6_1:0.000001,PBP619_consensus_1129_n_510_1:0.000001)97:0.000863)21:0.000430)0:0.000430)0:0.000430)0:0.000431,(((BMS619_consensus_206_n_14_1:0.003509,BMS619_consensus_261_n_16_1:0.000424)63:0.001320,(BMS619_consensus_448_n_9_1:0.002178,((BMS619_consensus_56_n_40_1:0.001304,(BMS619_consensus_305_n_14_1:0.001289,BMS619_consensus_396_n_55_1:0.000433)38:0.000001)9:0.000645,(PBP619_consensus_142_n_228_1:0.000001,PBP619_consensus_153_n_90_1:0.000434)91:0.001308)1:0.000640)0:0.000001)0:0.000001,(BMS619_consensus_256_n_7_1:0.001740,(((BMS619_consensus_58_n_17_1:0.003054,(((((PBP619_consensus_1475_n_283_1:0.001743,(((BMS619_consensus_444_n_7_1:0.001738,(BMS619_consensus_132_n_10_1:0.000867,BMS619_consensus_449_n_31_1:0.000001)22:0.000433)4:0.000001,(((BMS619_consensus_321_n_3_1:0.000433,BMS619_consensus_314_n_12_1:0.000001)97:0.002623,BMS619_consensus_209_n_42_1:0.000437)25:0.000431,BMS619_consensus_498_n_10_1:0.000433)4:0.000001)12:0.000434,(((((((PBP619_consensus_1116_n_2_1:0.002175,PBP619_consensus_209_n_131_1:0.000001)97:0.002179,(BMS619_consensus_73_n_24_1:0.001742,(((BMS619_consensus_57_n_9_1:0.002178,((((((PBP619_consensus_1136_n_290_1:0.000001,(PBP619_consensus_441_n_1_1:0.000868,PBP619_consensus_112_n_8_1:0.001305)28:0.000001)22:0.000001,PBP619_consensus_2032_n_43_1:0.000433)89:0.000870,(BMS619_consensus_399_n_4_1:0.001741,BMS619_consensus_501_n_12_1:0.000001)32:0.000434)28:0.000870,((BMS619_consensus_117_n_9_1:0.000432,BMS619_consensus_257_n_4_1:0.000435)89:0.001308,(((PBP619_consensus_1130_n_14_1:0.000433,PBP619_consensus_361_n_192_1:0.000001)62:0.000433,((PBP619_consensus_141_n_3_1:0.000433,PBP619_consensus_697_n_76_1:0.000001)67:0.000433,(PBP619_consensus_892_n_8_1:0.000001,PBP619_consensus_1004_n_178_1:0.000001)28:0.000001)25:0.000001)87:0.001734,((PBP619_consensus_1105_n_343_1:0.000001,PBP619_consensus_1093_n_5_1:0.000870)89:0.000869,PBP619_consensus_917_n_9_1:0.000433)48:0.000452)42:0.000868)12:0.000433)4:0.000001,(BMS619_consensus_274_n_13_1:0.001304,BMS619_consensus_166_n_39_1:0.000433)13:0.000001)6:0.000434,((BMS619_consensus_80_n_29_1:0.002179,((((BMS619_consensus_148_n_1_1:0.000001,(BMS619_consensus_275_n_18_1:0.002190,BMS619_consensus_322_n_20_1:0.001748)24:0.000427)0:0.000001,(BMS619_consensus_18_n_167_1:0.000001,(((BMS619_consensus_500_n_6_1:0.001742,(BMS619_consensus_133_n_9_1:0.001304,(BMS619_consensus_192_n_8_1:0.000434,(((BMS619_consensus_452_n_7_1:0.000434,BMS619_consensus_292_n_15_1:0.000001)37:0.000001,(BMS619_consensus_138_n_36_1:0.000001,BMS619_consensus_497_n_2_1:0.000433)55:0.000433)48:0.000434,((BMS619_consensus_50_n_24_1:0.000434,BMS619_consensus_72_n_21_1:0.000001)74:0.000434,BMS619_consensus_71_n_22_1:0.002241)27:0.000435)13:0.000435)2:0.000434)0:0.000001)1:0.000434,BMS619_consensus_35_n_6_1:0.001303)2:0.000001,(BMS619_consensus_121_n_9_1:0.002180,BMS619_consensus_268_n_14_1:0.000868)6:0.000001)0:0.000001)4:0.000434)0:0.000434,(BMS619_consensus_244_n_11_1:0.002193,BMS619_consensus_189_n_8_1:0.002630)18:0.000424)0:0.000434,(BMS619_consensus_216_n_6_1:0.000433,BMS619_consensus_68_n_54_1:0.000001)21:0.000001)0:0.000001)0:0.000500,(BMS619_consensus_54_n_11_1:0.003626,BMS619_consensus_392_n_11_1:0.000433)23:0.000435)0:0.000001)0:0.000001)0:0.000001,BMS619_consensus_140_n_10_1:0.004828)0:0.000001,PBP619_consensus_728_n_19_2:0.000001)0:0.000001)0:0.000001)0:0.000500,BMS619_consensus_655_n_15_1:0.001740)0:0.000001,((((PBP619_consensus_1095_n_12_2:0.000001,(((PBP619_consensus_1090_n_406_1:0.000001,PBP619_consensus_440_n_4_1:0.000433)70:0.000433,PBP619_consensus_236_n_66_1:0.000001)59:0.000433,BMS619_consensus_213_n_5_1:0.001741)11:0.000001)4:0.000001,PBP619_consensus_1079_n_558_1:0.000433)15:0.000001,BMS619_consensus_329_n_22_1:0.001305)14:0.000434,PBP619_consensus_1140_n_548_1:0.001302)11:0.000434)0:0.000001,BMS619_consensus_558_n_10_1:0.001760)0:0.000500,(BMS619_consensus_308_n_17_1:0.000434,(((BMS619_consensus_21_n_17_1:0.000434,BMS619_consensus_537_n_12_1:0.000434)9:0.000001,(BMS619_consensus_7_n_13_1:0.000869,(PBP619_consensus_1121_n_1_1:0.000434,((PBP619_consensus_287_n_206_1:0.000434,PBP619_consensus_864_n_3_1:0.000434)10:0.000001,(PBP619_consensus_129_n_14_1:0.000001,PBP619_consensus_1142_n_483_1:0.000001)14:0.000001)14:0.000001)58:0.000434)12:0.000001)3:0.000001,BMS619_consensus_168_n_35_1:0.000001)10:0.000001)82:0.000872)0:0.000500,BMS619_consensus_388_n_16_1:0.002179)0:0.000001)0:0.000001)0:0.000001,(BMS619_consensus_64_n_12_1:0.000436,BMS619_consensus_564_n_9_1:0.001740)6:0.000432)0:0.000500,((BMS619_consensus_201_n_11_1:0.000001,BMS619_consensus_109_n_8_1:0.000867)36:0.000433,(((BMS619_consensus_559_n_7_1:0.001301,BMS619_consensus_601_n_16_1:0.001739)3:0.000001,BMS619_consensus_395_n_35_1:0.000001)0:0.000001,((((BMS619_consensus_402_n_18_1:0.002636,(BMS619_consensus_393_n_12_1:0.002609,BMS619_consensus_247_n_15_1:0.000445)28:0.000425)30:0.000444,(BMS619_consensus_333_n_11_1:0.002622,BMS619_consensus_259_n_11_1:0.000862)28:0.000437)11:0.000438,BMS619_consensus_53_n_16_1:0.000001)10:0.000868,(BMS619_consensus_129_n_14_1:0.003107,BMS619_consensus_44_n_20_1:0.000878)31:0.000862)0:0.000001)0:0.000001)0:0.000433)0:0.000001,(((BMS619_consensus_66_n_74_1:0.000001,(BMS619_consensus_545_n_15_1:0.001740,(((BMS619_consensus_266_n_18_1:0.001303,(PBP619_consensus_711_n_5_1:0.000434,PBP619_consensus_2042_n_265_1:0.000001)94:0.001304)7:0.000001,((((BMS619_consensus_440_n_9_1:0.001741,PBP619_consensus_185_n_462_1:0.000001)45:0.000434,BMS619_consensus_313_n_23_1:0.000434)43:0.000435,BMS619_consensus_101_n_18_1:0.001748)23:0.000434,BMS619_consensus_74_n_13_1:0.000001)1:0.000001)1:0.000001,BMS619_consensus_135_n_21_1:0.002178)5:0.000433)4:0.000001)7:0.000001,BMS619_consensus_595_n_8_1:0.001738)21:0.000434,BMS619_consensus_389_n_13_1:0.002618)7:0.000434)0:0.000001,(BMS619_consensus_215_n_9_1:0.001745,BMS619_consensus_260_n_21_1:0.001310)49:0.000430)0:0.000001)0:0.000001,PBP619_consensus_1407_n_60_2:0.000001)0:0.000001,(((BMS619_consensus_387_n_22_1:0.001303,(PBP619_consensus_172_n_1_1:0.000868,PBP619_consensus_1141_n_229_1:0.000001)96:0.001303)8:0.000001,(((BMS619_consensus_304_n_24_1:0.000867,BMS619_consensus_561_n_9_1:0.000001)87:0.000870,BMS619_consensus_647_n_11_1:0.000869)47:0.000433,BMS619_consensus_198_n_114_1:0.001303)9:0.000001)3:0.000001,BMS619_consensus_316_n_17_1:0.000868)40:0.000434)0:0.000001)0:0.000500)0:0.000431)0:0.000001)0:0.000001,(((PBP619_consensus_1406_n_6_1:0.001305,(PBP619_consensus_1072_n_4_1:0.000872,(PBP619_consensus_1086_n_530_1:0.000001,PBP619_consensus_634_n_3_1:0.000001)50:0.000001)56:0.000001)93:0.001742,(((BMS619_consensus_385_n_11_1:0.000870,PBP619_consensus_484_n_14_1:0.000870)36:0.000434,(((BMS619_consensus_61_n_12_1:0.002617,BMS619_consensus_262_n_11_1:0.002177)2:0.000001,BMS619_consensus_400_n_12_1:0.000001)2:0.000001,BMS619_consensus_562_n_11_1:0.003054)1:0.000434)0:0.000001,((PBP619_consensus_720_n_68_1:0.000434,PBP619_consensus_154_n_213_1:0.000001)98:0.001305,((BMS619_consensus_46_n_9_1:0.002181,PBP619_consensus_1340_n_324_1:0.000001)35:0.000868,(((BMS619_consensus_315_n_17_1:0.001738,BMS619_consensus_36_n_27_1:0.001302)12:0.000001,(BMS619_consensus_144_n_12_1:0.000434,BMS619_consensus_67_n_8_1:0.001307)96:0.001743)1:0.000433,BMS619_consensus_131_n_11_1:0.002176)0:0.000001)0:0.000433)0:0.000001)0:0.000434)0:0.000001,(BMS619_consensus_544_n_10_1:0.001739,BMS619_consensus_550_n_13_1:0.002617)5:0.000001)0:0.000001)1:0.000434,(BMS619_consensus_127_n_189_1:0.000001,(((((((PBP619_consensus_446_n_5_1:0.000001,PBP619_consensus_144_n_366_1:0.000001)66:0.000433,(PBP619_consensus_242_n_79_1:0.000433,PBP619_consensus_176_n_117_1:0.000001)51:0.000001)85:0.000868,BMS619_consensus_490_n_9_1:0.002176)6:0.000001,(BMS619_consensus_211_n_9_1:0.001921,(((((PBP619_consensus_1139_n_9_1:0.000433,(PBP619_consensus_1045_n_209_1:0.000001,PBP619_consensus_699_n_2_1:0.002174)59:0.000433)11:0.000001,PBP619_consensus_119_n_436_1:0.000001)9:0.000001,PBP619_consensus_1337_n_2_1:0.000433)51:0.000433,(PBP619_consensus_1631_n_130_1:0.000433,BMS619_consensus_128_n_13_1:0.001307)43:0.000435)4:0.000001,PBP619_consensus_234_n_13_1:0.000001)9:0.000214)8:0.000219)6:0.000433,(BMS619_consensus_203_n_23_1:0.000434,(BMS619_consensus_187_n_2_1:0.000868,BMS619_consensus_81_n_9_1:0.002629)8:0.000001)0:0.000001)0:0.000434,(PBP619_consensus_147_n_183_1:0.001304,BMS619_consensus_273_n_45_1:0.000001)3:0.000434)0:0.000001,(BMS619_consensus_108_n_20_1:0.001304,BMS619_consensus_596_n_4_1:0.000872)9:0.000001)0:0.000001)0:0.000001)0:0.000001,BMS619_consensus_124_n_16_1:0.000868)0:0.000434,((BMS619_consensus_538_n_12_1:0.000434,BMS619_consensus_258_n_70_1:0.000001)39:0.000001,BMS619_consensus_145_n_11_1:0.003534)26:0.000435)12:0.000435,PBP619_consensus_1211_n_259_1:0.000872)10:0.000001):0.0";

#profile START;

N = 1000;

for (k = 0; k < N; k+=1) {
    Tree T = tree_string;
}

fprintf (stdout, Format (T,1,1), "\n");

#profile _hyphy_profile_dump;
stats  			= _hyphy_profile_dump["STATS"];
_profile_summer = ({1,Rows(stats)}["1"]) * stats;
_instructions   = _hyphy_profile_dump["INSTRUCTION"];
_indices	    = _hyphy_profile_dump["INSTRUCTION INDEX"];

fprintf (stdout, "\nTotal run time (seconds)      : ", Format(_profile_summer[1],15,6),
                 "\nTotal number of steps         : ", Format(_profile_summer[0],15,0), "\n\n");

to_sort        =  stats["-_MATRIX_ELEMENT_VALUE_*_MATRIX_ELEMENT_COLUMN_+(_MATRIX_ELEMENT_COLUMN_==0)*_MATRIX_ELEMENT_ROW_"] % 1;

for (k=0; k<Columns(_instructions); k=k+1)
{
    k2 = to_sort[k][0];
    fprintf (stdout, Format (_indices[k2],6,0), " : ", _instructions[k2], "\n\tCall count: ", stats[k2][0],
                                                   "\n\tTime (seconds): ", stats[k2][1], "\n");
}

