#pragma once
/*
 *  $Id: layer-axis.h 28233 2025-07-16 10:46:57Z yeti-dn $
 *  Copyright (C) 2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_LAYER_AXIS_H__
#define __GWYUI_LAYER_AXIS_H__

#include <libgwyddion/enums.h>
#include <libgwyui/gwyvectorlayer.h>

G_BEGIN_DECLS

#define GWY_TYPE_LAYER_AXIS            (gwy_layer_axis_get_type())
#define GWY_LAYER_AXIS(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_LAYER_AXIS, GwyLayerAxis))
#define GWY_LAYER_AXIS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_LAYER_AXIS, GwyLayerAxisClass))
#define GWY_IS_LAYER_AXIS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_LAYER_AXIS))
#define GWY_IS_LAYER_AXIS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_LAYER_AXIS))
#define GWY_LAYER_AXIS_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_LAYER_AXIS, GwyLayerAxisClass))

typedef struct _GwyLayerAxis             GwyLayerAxis;
typedef struct _GwyLayerAxisClass        GwyLayerAxisClass;
typedef struct _GwyLayerAxisPrivate      GwyLayerAxisPrivate;

struct _GwyLayerAxis {
    GwyVectorLayer parent_instance;
    GwyLayerAxisPrivate *priv;
};

struct _GwyLayerAxisClass {
    GwyVectorLayerClass parent_class;
};

GType           gwy_layer_axis_get_type     (void)                 G_GNUC_CONST;
GwyVectorLayer* gwy_layer_axis_new          (void);
gdouble         gwy_layer_axis_get_thickness(GwyLayerAxis *layer);
void            gwy_layer_axis_set_thickness(GwyLayerAxis *layer,
                                             gdouble thickness);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
