// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/domains/v1beta1/domains.proto

package domainspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	money "google.golang.org/genproto/googleapis/type/money"
	postaladdress "google.golang.org/genproto/googleapis/type/postaladdress"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines a set of possible contact privacy settings for a `Registration`.
//
// [ICANN](https://icann.org/) maintains the WHOIS database, a publicly
// accessible mapping from domain name to contact information, and requires that
// each domain name have an entry. Choose from these options to control how much
// information in your `ContactSettings` is published.
type ContactPrivacy int32

const (
	// The contact privacy settings are undefined.
	ContactPrivacy_CONTACT_PRIVACY_UNSPECIFIED ContactPrivacy = 0
	// All the data from `ContactSettings` is publicly available. When setting
	// this option, you must also provide a
	// `PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT` in the `contact_notices` field of the
	// request.
	ContactPrivacy_PUBLIC_CONTACT_DATA ContactPrivacy = 1
	// None of the data from `ContactSettings` is publicly available. Instead,
	// proxy contact data is published for your domain. Email sent to the proxy
	// email address is forwarded to the registrant's email address. Cloud Domains
	// provides this privacy proxy service at no additional cost.
	ContactPrivacy_PRIVATE_CONTACT_DATA ContactPrivacy = 2
	// Some data from `ContactSettings` is publicly available. The actual
	// information redacted depends on the domain. For details, see [the
	// registration privacy
	// article](https://support.google.com/domains/answer/3251242).
	ContactPrivacy_REDACTED_CONTACT_DATA ContactPrivacy = 3
)

// Enum value maps for ContactPrivacy.
var (
	ContactPrivacy_name = map[int32]string{
		0: "CONTACT_PRIVACY_UNSPECIFIED",
		1: "PUBLIC_CONTACT_DATA",
		2: "PRIVATE_CONTACT_DATA",
		3: "REDACTED_CONTACT_DATA",
	}
	ContactPrivacy_value = map[string]int32{
		"CONTACT_PRIVACY_UNSPECIFIED": 0,
		"PUBLIC_CONTACT_DATA":         1,
		"PRIVATE_CONTACT_DATA":        2,
		"REDACTED_CONTACT_DATA":       3,
	}
)

func (x ContactPrivacy) Enum() *ContactPrivacy {
	p := new(ContactPrivacy)
	*p = x
	return p
}

func (x ContactPrivacy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContactPrivacy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[0].Descriptor()
}

func (ContactPrivacy) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[0]
}

func (x ContactPrivacy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContactPrivacy.Descriptor instead.
func (ContactPrivacy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{0}
}

// Notices about special properties of certain domains.
type DomainNotice int32

const (
	// The notice is undefined.
	DomainNotice_DOMAIN_NOTICE_UNSPECIFIED DomainNotice = 0
	// Indicates that the domain is preloaded on the HTTP Strict Transport
	// Security list in browsers. Serving a website on such domain requires
	// an SSL certificate. For details, see
	// [how to get an SSL
	// certificate](https://support.google.com/domains/answer/7638036).
	DomainNotice_HSTS_PRELOADED DomainNotice = 1
)

// Enum value maps for DomainNotice.
var (
	DomainNotice_name = map[int32]string{
		0: "DOMAIN_NOTICE_UNSPECIFIED",
		1: "HSTS_PRELOADED",
	}
	DomainNotice_value = map[string]int32{
		"DOMAIN_NOTICE_UNSPECIFIED": 0,
		"HSTS_PRELOADED":            1,
	}
)

func (x DomainNotice) Enum() *DomainNotice {
	p := new(DomainNotice)
	*p = x
	return p
}

func (x DomainNotice) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DomainNotice) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[1].Descriptor()
}

func (DomainNotice) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[1]
}

func (x DomainNotice) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DomainNotice.Descriptor instead.
func (DomainNotice) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{1}
}

// Notices related to contact information.
type ContactNotice int32

const (
	// The notice is undefined.
	ContactNotice_CONTACT_NOTICE_UNSPECIFIED ContactNotice = 0
	// Required when setting the `privacy` field of `ContactSettings` to
	// `PUBLIC_CONTACT_DATA`, which exposes contact data publicly.
	ContactNotice_PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT ContactNotice = 1
)

// Enum value maps for ContactNotice.
var (
	ContactNotice_name = map[int32]string{
		0: "CONTACT_NOTICE_UNSPECIFIED",
		1: "PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT",
	}
	ContactNotice_value = map[string]int32{
		"CONTACT_NOTICE_UNSPECIFIED":          0,
		"PUBLIC_CONTACT_DATA_ACKNOWLEDGEMENT": 1,
	}
)

func (x ContactNotice) Enum() *ContactNotice {
	p := new(ContactNotice)
	*p = x
	return p
}

func (x ContactNotice) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContactNotice) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[2].Descriptor()
}

func (ContactNotice) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[2]
}

func (x ContactNotice) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContactNotice.Descriptor instead.
func (ContactNotice) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{2}
}

// Possible states of a `Registration`'s transfer lock.
type TransferLockState int32

const (
	// The state is unspecified.
	TransferLockState_TRANSFER_LOCK_STATE_UNSPECIFIED TransferLockState = 0
	// The domain is unlocked and can be transferred to another registrar.
	TransferLockState_UNLOCKED TransferLockState = 1
	// The domain is locked and cannot be transferred to another registrar.
	TransferLockState_LOCKED TransferLockState = 2
)

// Enum value maps for TransferLockState.
var (
	TransferLockState_name = map[int32]string{
		0: "TRANSFER_LOCK_STATE_UNSPECIFIED",
		1: "UNLOCKED",
		2: "LOCKED",
	}
	TransferLockState_value = map[string]int32{
		"TRANSFER_LOCK_STATE_UNSPECIFIED": 0,
		"UNLOCKED":                        1,
		"LOCKED":                          2,
	}
)

func (x TransferLockState) Enum() *TransferLockState {
	p := new(TransferLockState)
	*p = x
	return p
}

func (x TransferLockState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferLockState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[3].Descriptor()
}

func (TransferLockState) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[3]
}

func (x TransferLockState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferLockState.Descriptor instead.
func (TransferLockState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{3}
}

// Possible states of a `Registration`.
type Registration_State int32

const (
	// The state is undefined.
	Registration_STATE_UNSPECIFIED Registration_State = 0
	// The domain is being registered.
	Registration_REGISTRATION_PENDING Registration_State = 1
	// The domain registration failed. You can delete resources in this state
	// to allow registration to be retried.
	Registration_REGISTRATION_FAILED Registration_State = 2
	// The domain is being transferred from another registrar to Cloud Domains.
	Registration_TRANSFER_PENDING Registration_State = 3
	// The attempt to transfer the domain from another registrar to
	// Cloud Domains failed. You can delete resources in this state and retry
	// the transfer.
	Registration_TRANSFER_FAILED Registration_State = 4
	// The domain is registered and operational. The domain renews automatically
	// as long as it remains in this state.
	Registration_ACTIVE Registration_State = 6
	// The domain is suspended and inoperative. For more details, see the
	// `issues` field.
	Registration_SUSPENDED Registration_State = 7
	// The domain is no longer managed with Cloud Domains. It may have been
	// transferred to another registrar or exported for management in
	// [Google Domains](https://domains.google/). You can no longer update it
	// with this API, and information shown about it may be stale. Domains in
	// this state are not automatically renewed by Cloud Domains.
	Registration_EXPORTED Registration_State = 8
)

// Enum value maps for Registration_State.
var (
	Registration_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "REGISTRATION_PENDING",
		2: "REGISTRATION_FAILED",
		3: "TRANSFER_PENDING",
		4: "TRANSFER_FAILED",
		6: "ACTIVE",
		7: "SUSPENDED",
		8: "EXPORTED",
	}
	Registration_State_value = map[string]int32{
		"STATE_UNSPECIFIED":    0,
		"REGISTRATION_PENDING": 1,
		"REGISTRATION_FAILED":  2,
		"TRANSFER_PENDING":     3,
		"TRANSFER_FAILED":      4,
		"ACTIVE":               6,
		"SUSPENDED":            7,
		"EXPORTED":             8,
	}
)

func (x Registration_State) Enum() *Registration_State {
	p := new(Registration_State)
	*p = x
	return p
}

func (x Registration_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Registration_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[4].Descriptor()
}

func (Registration_State) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[4]
}

func (x Registration_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Registration_State.Descriptor instead.
func (Registration_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{0, 0}
}

// Possible issues with a `Registration` that require attention.
type Registration_Issue int32

const (
	// The issue is undefined.
	Registration_ISSUE_UNSPECIFIED Registration_Issue = 0
	// Contact the Cloud Support team to resolve a problem with this domain.
	Registration_CONTACT_SUPPORT Registration_Issue = 1
	// [ICANN](https://icann.org/) requires verification of the email address
	// in the `Registration`'s `contact_settings.registrant_contact` field. To
	// verify the email address, follow the
	// instructions in the email the `registrant_contact` receives following
	// registration. If you do not complete email verification within
	// 15 days of registration, the domain is suspended. To resend the
	// verification email, call ConfigureContactSettings and provide the current
	// `registrant_contact.email`.
	Registration_UNVERIFIED_EMAIL Registration_Issue = 2
)

// Enum value maps for Registration_Issue.
var (
	Registration_Issue_name = map[int32]string{
		0: "ISSUE_UNSPECIFIED",
		1: "CONTACT_SUPPORT",
		2: "UNVERIFIED_EMAIL",
	}
	Registration_Issue_value = map[string]int32{
		"ISSUE_UNSPECIFIED": 0,
		"CONTACT_SUPPORT":   1,
		"UNVERIFIED_EMAIL":  2,
	}
)

func (x Registration_Issue) Enum() *Registration_Issue {
	p := new(Registration_Issue)
	*p = x
	return p
}

func (x Registration_Issue) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Registration_Issue) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[5].Descriptor()
}

func (Registration_Issue) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[5]
}

func (x Registration_Issue) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Registration_Issue.Descriptor instead.
func (Registration_Issue) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{0, 1}
}

// Defines how the `Registration` is renewed.
type ManagementSettings_RenewalMethod int32

const (
	// The renewal method is undefined.
	ManagementSettings_RENEWAL_METHOD_UNSPECIFIED ManagementSettings_RenewalMethod = 0
	// The domain is automatically renewed each year .
	//
	// To disable automatic renewals, delete the resource by calling
	// `DeleteRegistration` or export it by calling `ExportRegistration`.
	ManagementSettings_AUTOMATIC_RENEWAL ManagementSettings_RenewalMethod = 1
	// The domain must be explicitly renewed each year before its
	// `expire_time`. This option is only available when the `Registration`
	// is in state `EXPORTED`.
	//
	// To manage the domain's current billing and
	// renewal settings, go to [Google Domains](https://domains.google/).
	ManagementSettings_MANUAL_RENEWAL ManagementSettings_RenewalMethod = 2
)

// Enum value maps for ManagementSettings_RenewalMethod.
var (
	ManagementSettings_RenewalMethod_name = map[int32]string{
		0: "RENEWAL_METHOD_UNSPECIFIED",
		1: "AUTOMATIC_RENEWAL",
		2: "MANUAL_RENEWAL",
	}
	ManagementSettings_RenewalMethod_value = map[string]int32{
		"RENEWAL_METHOD_UNSPECIFIED": 0,
		"AUTOMATIC_RENEWAL":          1,
		"MANUAL_RENEWAL":             2,
	}
)

func (x ManagementSettings_RenewalMethod) Enum() *ManagementSettings_RenewalMethod {
	p := new(ManagementSettings_RenewalMethod)
	*p = x
	return p
}

func (x ManagementSettings_RenewalMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManagementSettings_RenewalMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[6].Descriptor()
}

func (ManagementSettings_RenewalMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[6]
}

func (x ManagementSettings_RenewalMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManagementSettings_RenewalMethod.Descriptor instead.
func (ManagementSettings_RenewalMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{1, 0}
}

// The publication state of DS records for a `Registration`.
type DnsSettings_DsState int32

const (
	// DS state is unspecified.
	DnsSettings_DS_STATE_UNSPECIFIED DnsSettings_DsState = 0
	// DNSSEC is disabled for this domain. No DS records for this domain are
	// published in the parent DNS zone.
	DnsSettings_DS_RECORDS_UNPUBLISHED DnsSettings_DsState = 1
	// DNSSEC is enabled for this domain. Appropriate DS records for this domain
	// are published in the parent DNS zone. This option is valid only if the
	// DNS zone referenced in the `Registration`'s `dns_provider` field is
	// already DNSSEC-signed.
	DnsSettings_DS_RECORDS_PUBLISHED DnsSettings_DsState = 2
)

// Enum value maps for DnsSettings_DsState.
var (
	DnsSettings_DsState_name = map[int32]string{
		0: "DS_STATE_UNSPECIFIED",
		1: "DS_RECORDS_UNPUBLISHED",
		2: "DS_RECORDS_PUBLISHED",
	}
	DnsSettings_DsState_value = map[string]int32{
		"DS_STATE_UNSPECIFIED":   0,
		"DS_RECORDS_UNPUBLISHED": 1,
		"DS_RECORDS_PUBLISHED":   2,
	}
)

func (x DnsSettings_DsState) Enum() *DnsSettings_DsState {
	p := new(DnsSettings_DsState)
	*p = x
	return p
}

func (x DnsSettings_DsState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DnsSettings_DsState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[7].Descriptor()
}

func (DnsSettings_DsState) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[7]
}

func (x DnsSettings_DsState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DnsSettings_DsState.Descriptor instead.
func (DnsSettings_DsState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{2, 0}
}

// List of algorithms used to create a DNSKEY. Certain
// algorithms are not supported for particular domains.
type DnsSettings_DsRecord_Algorithm int32

const (
	// The algorithm is unspecified.
	DnsSettings_DsRecord_ALGORITHM_UNSPECIFIED DnsSettings_DsRecord_Algorithm = 0
	// RSA/MD5. Cannot be used for new deployments.
	DnsSettings_DsRecord_RSAMD5 DnsSettings_DsRecord_Algorithm = 1
	// Diffie-Hellman. Cannot be used for new deployments.
	DnsSettings_DsRecord_DH DnsSettings_DsRecord_Algorithm = 2
	// DSA/SHA1. Not recommended for new deployments.
	DnsSettings_DsRecord_DSA DnsSettings_DsRecord_Algorithm = 3
	// ECC. Not recommended for new deployments.
	DnsSettings_DsRecord_ECC DnsSettings_DsRecord_Algorithm = 4
	// RSA/SHA-1. Not recommended for new deployments.
	DnsSettings_DsRecord_RSASHA1 DnsSettings_DsRecord_Algorithm = 5
	// DSA-NSEC3-SHA1. Not recommended for new deployments.
	DnsSettings_DsRecord_DSANSEC3SHA1 DnsSettings_DsRecord_Algorithm = 6
	// RSA/SHA1-NSEC3-SHA1. Not recommended for new deployments.
	DnsSettings_DsRecord_RSASHA1NSEC3SHA1 DnsSettings_DsRecord_Algorithm = 7
	// RSA/SHA-256.
	DnsSettings_DsRecord_RSASHA256 DnsSettings_DsRecord_Algorithm = 8
	// RSA/SHA-512.
	DnsSettings_DsRecord_RSASHA512 DnsSettings_DsRecord_Algorithm = 10
	// GOST R 34.10-2001.
	DnsSettings_DsRecord_ECCGOST DnsSettings_DsRecord_Algorithm = 12
	// ECDSA Curve P-256 with SHA-256.
	DnsSettings_DsRecord_ECDSAP256SHA256 DnsSettings_DsRecord_Algorithm = 13
	// ECDSA Curve P-384 with SHA-384.
	DnsSettings_DsRecord_ECDSAP384SHA384 DnsSettings_DsRecord_Algorithm = 14
	// Ed25519.
	DnsSettings_DsRecord_ED25519 DnsSettings_DsRecord_Algorithm = 15
	// Ed448.
	DnsSettings_DsRecord_ED448 DnsSettings_DsRecord_Algorithm = 16
	// Reserved for Indirect Keys. Cannot be used for new deployments.
	DnsSettings_DsRecord_INDIRECT DnsSettings_DsRecord_Algorithm = 252
	// Private algorithm. Cannot be used for new deployments.
	DnsSettings_DsRecord_PRIVATEDNS DnsSettings_DsRecord_Algorithm = 253
	// Private algorithm OID. Cannot be used for new deployments.
	DnsSettings_DsRecord_PRIVATEOID DnsSettings_DsRecord_Algorithm = 254
)

// Enum value maps for DnsSettings_DsRecord_Algorithm.
var (
	DnsSettings_DsRecord_Algorithm_name = map[int32]string{
		0:   "ALGORITHM_UNSPECIFIED",
		1:   "RSAMD5",
		2:   "DH",
		3:   "DSA",
		4:   "ECC",
		5:   "RSASHA1",
		6:   "DSANSEC3SHA1",
		7:   "RSASHA1NSEC3SHA1",
		8:   "RSASHA256",
		10:  "RSASHA512",
		12:  "ECCGOST",
		13:  "ECDSAP256SHA256",
		14:  "ECDSAP384SHA384",
		15:  "ED25519",
		16:  "ED448",
		252: "INDIRECT",
		253: "PRIVATEDNS",
		254: "PRIVATEOID",
	}
	DnsSettings_DsRecord_Algorithm_value = map[string]int32{
		"ALGORITHM_UNSPECIFIED": 0,
		"RSAMD5":                1,
		"DH":                    2,
		"DSA":                   3,
		"ECC":                   4,
		"RSASHA1":               5,
		"DSANSEC3SHA1":          6,
		"RSASHA1NSEC3SHA1":      7,
		"RSASHA256":             8,
		"RSASHA512":             10,
		"ECCGOST":               12,
		"ECDSAP256SHA256":       13,
		"ECDSAP384SHA384":       14,
		"ED25519":               15,
		"ED448":                 16,
		"INDIRECT":              252,
		"PRIVATEDNS":            253,
		"PRIVATEOID":            254,
	}
)

func (x DnsSettings_DsRecord_Algorithm) Enum() *DnsSettings_DsRecord_Algorithm {
	p := new(DnsSettings_DsRecord_Algorithm)
	*p = x
	return p
}

func (x DnsSettings_DsRecord_Algorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DnsSettings_DsRecord_Algorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[8].Descriptor()
}

func (DnsSettings_DsRecord_Algorithm) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[8]
}

func (x DnsSettings_DsRecord_Algorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DnsSettings_DsRecord_Algorithm.Descriptor instead.
func (DnsSettings_DsRecord_Algorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{2, 2, 0}
}

// List of hash functions that may have been used to generate a digest of a
// DNSKEY.
type DnsSettings_DsRecord_DigestType int32

const (
	// The DigestType is unspecified.
	DnsSettings_DsRecord_DIGEST_TYPE_UNSPECIFIED DnsSettings_DsRecord_DigestType = 0
	// SHA-1. Not recommended for new deployments.
	DnsSettings_DsRecord_SHA1 DnsSettings_DsRecord_DigestType = 1
	// SHA-256.
	DnsSettings_DsRecord_SHA256 DnsSettings_DsRecord_DigestType = 2
	// GOST R 34.11-94.
	DnsSettings_DsRecord_GOST3411 DnsSettings_DsRecord_DigestType = 3
	// SHA-384.
	DnsSettings_DsRecord_SHA384 DnsSettings_DsRecord_DigestType = 4
)

// Enum value maps for DnsSettings_DsRecord_DigestType.
var (
	DnsSettings_DsRecord_DigestType_name = map[int32]string{
		0: "DIGEST_TYPE_UNSPECIFIED",
		1: "SHA1",
		2: "SHA256",
		3: "GOST3411",
		4: "SHA384",
	}
	DnsSettings_DsRecord_DigestType_value = map[string]int32{
		"DIGEST_TYPE_UNSPECIFIED": 0,
		"SHA1":                    1,
		"SHA256":                  2,
		"GOST3411":                3,
		"SHA384":                  4,
	}
)

func (x DnsSettings_DsRecord_DigestType) Enum() *DnsSettings_DsRecord_DigestType {
	p := new(DnsSettings_DsRecord_DigestType)
	*p = x
	return p
}

func (x DnsSettings_DsRecord_DigestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DnsSettings_DsRecord_DigestType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[9].Descriptor()
}

func (DnsSettings_DsRecord_DigestType) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[9]
}

func (x DnsSettings_DsRecord_DigestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DnsSettings_DsRecord_DigestType.Descriptor instead.
func (DnsSettings_DsRecord_DigestType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{2, 2, 1}
}

// Possible availability states of a domain name.
type RegisterParameters_Availability int32

const (
	// The availability is unspecified.
	RegisterParameters_AVAILABILITY_UNSPECIFIED RegisterParameters_Availability = 0
	// The domain is available for registration.
	RegisterParameters_AVAILABLE RegisterParameters_Availability = 1
	// The domain is not available for registration. Generally this means it is
	// already registered to another party.
	RegisterParameters_UNAVAILABLE RegisterParameters_Availability = 2
	// The domain is not currently supported by Cloud Domains, but may
	// be available elsewhere.
	RegisterParameters_UNSUPPORTED RegisterParameters_Availability = 3
	// Cloud Domains is unable to determine domain availability, generally
	// due to system maintenance at the domain name registry.
	RegisterParameters_UNKNOWN RegisterParameters_Availability = 4
)

// Enum value maps for RegisterParameters_Availability.
var (
	RegisterParameters_Availability_name = map[int32]string{
		0: "AVAILABILITY_UNSPECIFIED",
		1: "AVAILABLE",
		2: "UNAVAILABLE",
		3: "UNSUPPORTED",
		4: "UNKNOWN",
	}
	RegisterParameters_Availability_value = map[string]int32{
		"AVAILABILITY_UNSPECIFIED": 0,
		"AVAILABLE":                1,
		"UNAVAILABLE":              2,
		"UNSUPPORTED":              3,
		"UNKNOWN":                  4,
	}
)

func (x RegisterParameters_Availability) Enum() *RegisterParameters_Availability {
	p := new(RegisterParameters_Availability)
	*p = x
	return p
}

func (x RegisterParameters_Availability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RegisterParameters_Availability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_domains_v1beta1_domains_proto_enumTypes[10].Descriptor()
}

func (RegisterParameters_Availability) Type() protoreflect.EnumType {
	return &file_google_cloud_domains_v1beta1_domains_proto_enumTypes[10]
}

func (x RegisterParameters_Availability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RegisterParameters_Availability.Descriptor instead.
func (RegisterParameters_Availability) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{23, 0}
}

// The `Registration` resource facilitates managing and configuring domain name
// registrations.
//
// There are several ways to create a new `Registration` resource:
//
// To create a new `Registration` resource, find a suitable domain name by
// calling the `SearchDomains` method with a query to see available domain name
// options. After choosing a name, call `RetrieveRegisterParameters` to
// ensure availability and obtain information like pricing, which is needed to
// build a call to `RegisterDomain`.
//
// Another way to create a new `Registration` is to transfer an existing
// domain from another registrar. First, go to the current registrar to unlock
// the domain for transfer and retrieve the domain's transfer authorization
// code. Then call `RetrieveTransferParameters` to confirm that the domain is
// unlocked and to get values needed to build a call to `TransferDomain`.
type Registration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Name of the `Registration` resource, in the format
	// `projects/*/locations/*/registrations/<domain_name>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The domain name. Unicode domain names must be expressed in Punycode format.
	DomainName string `protobuf:"bytes,2,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// Output only. The creation timestamp of the `Registration` resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The expiration timestamp of the `Registration`.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. The state of the `Registration`
	State Registration_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.domains.v1beta1.Registration_State" json:"state,omitempty"`
	// Output only. The set of issues with the `Registration` that require attention.
	Issues []Registration_Issue `protobuf:"varint,8,rep,packed,name=issues,proto3,enum=google.cloud.domains.v1beta1.Registration_Issue" json:"issues,omitempty"`
	// Set of labels associated with the `Registration`.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Settings for management of the `Registration`, including renewal, billing,
	// and transfer. You cannot update these with the `UpdateRegistration`
	// method. To update these settings, use the `ConfigureManagementSettings`
	// method.
	ManagementSettings *ManagementSettings `protobuf:"bytes,10,opt,name=management_settings,json=managementSettings,proto3" json:"management_settings,omitempty"`
	// Settings controlling the DNS configuration of the `Registration`. You
	// cannot update these with the `UpdateRegistration` method. To update these
	// settings, use the `ConfigureDnsSettings` method.
	DnsSettings *DnsSettings `protobuf:"bytes,11,opt,name=dns_settings,json=dnsSettings,proto3" json:"dns_settings,omitempty"`
	// Required. Settings for contact information linked to the `Registration`. You cannot
	// update these with the `UpdateRegistration` method. To update these
	// settings, use the `ConfigureContactSettings` method.
	ContactSettings *ContactSettings `protobuf:"bytes,12,opt,name=contact_settings,json=contactSettings,proto3" json:"contact_settings,omitempty"`
	// Output only. Pending contact settings for the `Registration`. Updates to the
	// `contact_settings` field that change its `registrant_contact` or `privacy`
	// fields require email confirmation by the `registrant_contact`
	// before taking effect. This field is set only if there are pending updates
	// to the `contact_settings` that have not been confirmed. To confirm the
	// changes, the `registrant_contact` must follow the instructions in the
	// email they receive.
	PendingContactSettings *ContactSettings `protobuf:"bytes,13,opt,name=pending_contact_settings,json=pendingContactSettings,proto3" json:"pending_contact_settings,omitempty"`
	// Output only. Set of options for the `contact_settings.privacy` field that this
	// `Registration` supports.
	SupportedPrivacy []ContactPrivacy `protobuf:"varint,14,rep,packed,name=supported_privacy,json=supportedPrivacy,proto3,enum=google.cloud.domains.v1beta1.ContactPrivacy" json:"supported_privacy,omitempty"`
}

func (x *Registration) Reset() {
	*x = Registration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Registration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Registration) ProtoMessage() {}

func (x *Registration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Registration.ProtoReflect.Descriptor instead.
func (*Registration) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{0}
}

func (x *Registration) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Registration) GetDomainName() string {
	if x != nil {
		return x.DomainName
	}
	return ""
}

func (x *Registration) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Registration) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Registration) GetState() Registration_State {
	if x != nil {
		return x.State
	}
	return Registration_STATE_UNSPECIFIED
}

func (x *Registration) GetIssues() []Registration_Issue {
	if x != nil {
		return x.Issues
	}
	return nil
}

func (x *Registration) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Registration) GetManagementSettings() *ManagementSettings {
	if x != nil {
		return x.ManagementSettings
	}
	return nil
}

func (x *Registration) GetDnsSettings() *DnsSettings {
	if x != nil {
		return x.DnsSettings
	}
	return nil
}

func (x *Registration) GetContactSettings() *ContactSettings {
	if x != nil {
		return x.ContactSettings
	}
	return nil
}

func (x *Registration) GetPendingContactSettings() *ContactSettings {
	if x != nil {
		return x.PendingContactSettings
	}
	return nil
}

func (x *Registration) GetSupportedPrivacy() []ContactPrivacy {
	if x != nil {
		return x.SupportedPrivacy
	}
	return nil
}

// Defines renewal, billing, and transfer settings for a `Registration`.
type ManagementSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The renewal method for this `Registration`.
	RenewalMethod ManagementSettings_RenewalMethod `protobuf:"varint,3,opt,name=renewal_method,json=renewalMethod,proto3,enum=google.cloud.domains.v1beta1.ManagementSettings_RenewalMethod" json:"renewal_method,omitempty"`
	// Controls whether the domain can be transferred to another registrar.
	TransferLockState TransferLockState `protobuf:"varint,4,opt,name=transfer_lock_state,json=transferLockState,proto3,enum=google.cloud.domains.v1beta1.TransferLockState" json:"transfer_lock_state,omitempty"`
}

func (x *ManagementSettings) Reset() {
	*x = ManagementSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagementSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagementSettings) ProtoMessage() {}

func (x *ManagementSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagementSettings.ProtoReflect.Descriptor instead.
func (*ManagementSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{1}
}

func (x *ManagementSettings) GetRenewalMethod() ManagementSettings_RenewalMethod {
	if x != nil {
		return x.RenewalMethod
	}
	return ManagementSettings_RENEWAL_METHOD_UNSPECIFIED
}

func (x *ManagementSettings) GetTransferLockState() TransferLockState {
	if x != nil {
		return x.TransferLockState
	}
	return TransferLockState_TRANSFER_LOCK_STATE_UNSPECIFIED
}

// Defines the DNS configuration of a `Registration`, including name servers,
// DNSSEC, and glue records.
type DnsSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DNS provider of the registration.
	//
	// Types that are assignable to DnsProvider:
	//
	//	*DnsSettings_CustomDns_
	//	*DnsSettings_GoogleDomainsDns_
	DnsProvider isDnsSettings_DnsProvider `protobuf_oneof:"dns_provider"`
	// The list of glue records for this `Registration`. Commonly empty.
	GlueRecords []*DnsSettings_GlueRecord `protobuf:"bytes,4,rep,name=glue_records,json=glueRecords,proto3" json:"glue_records,omitempty"`
}

func (x *DnsSettings) Reset() {
	*x = DnsSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DnsSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsSettings) ProtoMessage() {}

func (x *DnsSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsSettings.ProtoReflect.Descriptor instead.
func (*DnsSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{2}
}

func (m *DnsSettings) GetDnsProvider() isDnsSettings_DnsProvider {
	if m != nil {
		return m.DnsProvider
	}
	return nil
}

func (x *DnsSettings) GetCustomDns() *DnsSettings_CustomDns {
	if x, ok := x.GetDnsProvider().(*DnsSettings_CustomDns_); ok {
		return x.CustomDns
	}
	return nil
}

func (x *DnsSettings) GetGoogleDomainsDns() *DnsSettings_GoogleDomainsDns {
	if x, ok := x.GetDnsProvider().(*DnsSettings_GoogleDomainsDns_); ok {
		return x.GoogleDomainsDns
	}
	return nil
}

func (x *DnsSettings) GetGlueRecords() []*DnsSettings_GlueRecord {
	if x != nil {
		return x.GlueRecords
	}
	return nil
}

type isDnsSettings_DnsProvider interface {
	isDnsSettings_DnsProvider()
}

type DnsSettings_CustomDns_ struct {
	// An arbitrary DNS provider identified by its name servers.
	CustomDns *DnsSettings_CustomDns `protobuf:"bytes,1,opt,name=custom_dns,json=customDns,proto3,oneof"`
}

type DnsSettings_GoogleDomainsDns_ struct {
	// The free DNS zone provided by
	// [Google Domains](https://domains.google/).
	GoogleDomainsDns *DnsSettings_GoogleDomainsDns `protobuf:"bytes,2,opt,name=google_domains_dns,json=googleDomainsDns,proto3,oneof"`
}

func (*DnsSettings_CustomDns_) isDnsSettings_DnsProvider() {}

func (*DnsSettings_GoogleDomainsDns_) isDnsSettings_DnsProvider() {}

// Defines the contact information associated with a `Registration`.
//
// [ICANN](https://icann.org/) requires all domain names to have associated
// contact information. The `registrant_contact` is considered the
// domain's legal owner, and often the other contacts are identical.
type ContactSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Privacy setting for the contacts associated with the `Registration`.
	Privacy ContactPrivacy `protobuf:"varint,1,opt,name=privacy,proto3,enum=google.cloud.domains.v1beta1.ContactPrivacy" json:"privacy,omitempty"`
	// Required. The registrant contact for the `Registration`.
	//
	// *Caution: Anyone with access to this email address, phone number,
	// and/or postal address can take control of the domain.*
	//
	// *Warning: For new `Registration`s, the registrant receives an email
	// confirmation that they must complete within 15 days to avoid domain
	// suspension.*
	RegistrantContact *ContactSettings_Contact `protobuf:"bytes,2,opt,name=registrant_contact,json=registrantContact,proto3" json:"registrant_contact,omitempty"`
	// Required. The administrative contact for the `Registration`.
	AdminContact *ContactSettings_Contact `protobuf:"bytes,3,opt,name=admin_contact,json=adminContact,proto3" json:"admin_contact,omitempty"`
	// Required. The technical contact for the `Registration`.
	TechnicalContact *ContactSettings_Contact `protobuf:"bytes,4,opt,name=technical_contact,json=technicalContact,proto3" json:"technical_contact,omitempty"`
}

func (x *ContactSettings) Reset() {
	*x = ContactSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContactSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContactSettings) ProtoMessage() {}

func (x *ContactSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContactSettings.ProtoReflect.Descriptor instead.
func (*ContactSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{3}
}

func (x *ContactSettings) GetPrivacy() ContactPrivacy {
	if x != nil {
		return x.Privacy
	}
	return ContactPrivacy_CONTACT_PRIVACY_UNSPECIFIED
}

func (x *ContactSettings) GetRegistrantContact() *ContactSettings_Contact {
	if x != nil {
		return x.RegistrantContact
	}
	return nil
}

func (x *ContactSettings) GetAdminContact() *ContactSettings_Contact {
	if x != nil {
		return x.AdminContact
	}
	return nil
}

func (x *ContactSettings) GetTechnicalContact() *ContactSettings_Contact {
	if x != nil {
		return x.TechnicalContact
	}
	return nil
}

// Request for the `SearchDomains` method.
type SearchDomainsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. String used to search for available domain names.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Required. The location. Must be in the format `projects/*/locations/*`.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *SearchDomainsRequest) Reset() {
	*x = SearchDomainsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchDomainsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDomainsRequest) ProtoMessage() {}

func (x *SearchDomainsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchDomainsRequest.ProtoReflect.Descriptor instead.
func (*SearchDomainsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{4}
}

func (x *SearchDomainsRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchDomainsRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Response for the `SearchDomains` method.
type SearchDomainsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results of the domain name search.
	RegisterParameters []*RegisterParameters `protobuf:"bytes,1,rep,name=register_parameters,json=registerParameters,proto3" json:"register_parameters,omitempty"`
}

func (x *SearchDomainsResponse) Reset() {
	*x = SearchDomainsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchDomainsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchDomainsResponse) ProtoMessage() {}

func (x *SearchDomainsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchDomainsResponse.ProtoReflect.Descriptor instead.
func (*SearchDomainsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{5}
}

func (x *SearchDomainsResponse) GetRegisterParameters() []*RegisterParameters {
	if x != nil {
		return x.RegisterParameters
	}
	return nil
}

// Request for the `RetrieveRegisterParameters` method.
type RetrieveRegisterParametersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The domain name. Unicode domain names must be expressed in Punycode format.
	DomainName string `protobuf:"bytes,1,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// Required. The location. Must be in the format `projects/*/locations/*`.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *RetrieveRegisterParametersRequest) Reset() {
	*x = RetrieveRegisterParametersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveRegisterParametersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveRegisterParametersRequest) ProtoMessage() {}

func (x *RetrieveRegisterParametersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveRegisterParametersRequest.ProtoReflect.Descriptor instead.
func (*RetrieveRegisterParametersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{6}
}

func (x *RetrieveRegisterParametersRequest) GetDomainName() string {
	if x != nil {
		return x.DomainName
	}
	return ""
}

func (x *RetrieveRegisterParametersRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Response for the `RetrieveRegisterParameters` method.
type RetrieveRegisterParametersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parameters to use when calling the `RegisterDomain` method.
	RegisterParameters *RegisterParameters `protobuf:"bytes,1,opt,name=register_parameters,json=registerParameters,proto3" json:"register_parameters,omitempty"`
}

func (x *RetrieveRegisterParametersResponse) Reset() {
	*x = RetrieveRegisterParametersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveRegisterParametersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveRegisterParametersResponse) ProtoMessage() {}

func (x *RetrieveRegisterParametersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveRegisterParametersResponse.ProtoReflect.Descriptor instead.
func (*RetrieveRegisterParametersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{7}
}

func (x *RetrieveRegisterParametersResponse) GetRegisterParameters() *RegisterParameters {
	if x != nil {
		return x.RegisterParameters
	}
	return nil
}

// Request for the `RegisterDomain` method.
type RegisterDomainRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the `Registration`. Must be in the
	// format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The complete `Registration` resource to be created.
	Registration *Registration `protobuf:"bytes,2,opt,name=registration,proto3" json:"registration,omitempty"`
	// The list of domain notices that you acknowledge. Call
	// `RetrieveRegisterParameters` to see the notices that need acknowledgement.
	DomainNotices []DomainNotice `protobuf:"varint,3,rep,packed,name=domain_notices,json=domainNotices,proto3,enum=google.cloud.domains.v1beta1.DomainNotice" json:"domain_notices,omitempty"`
	// The list of contact notices that the caller acknowledges. The notices
	// needed here depend on the values specified in
	// `registration.contact_settings`.
	ContactNotices []ContactNotice `protobuf:"varint,4,rep,packed,name=contact_notices,json=contactNotices,proto3,enum=google.cloud.domains.v1beta1.ContactNotice" json:"contact_notices,omitempty"`
	// Required. Yearly price to register or renew the domain.
	// The value that should be put here can be obtained from
	// RetrieveRegisterParameters or SearchDomains calls.
	YearlyPrice *money.Money `protobuf:"bytes,5,opt,name=yearly_price,json=yearlyPrice,proto3" json:"yearly_price,omitempty"`
	// When true, only validation is performed, without actually registering
	// the domain. Follows:
	// https://cloud.google.com/apis/design/design_patterns#request_validation
	ValidateOnly bool `protobuf:"varint,6,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *RegisterDomainRequest) Reset() {
	*x = RegisterDomainRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterDomainRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterDomainRequest) ProtoMessage() {}

func (x *RegisterDomainRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterDomainRequest.ProtoReflect.Descriptor instead.
func (*RegisterDomainRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{8}
}

func (x *RegisterDomainRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *RegisterDomainRequest) GetRegistration() *Registration {
	if x != nil {
		return x.Registration
	}
	return nil
}

func (x *RegisterDomainRequest) GetDomainNotices() []DomainNotice {
	if x != nil {
		return x.DomainNotices
	}
	return nil
}

func (x *RegisterDomainRequest) GetContactNotices() []ContactNotice {
	if x != nil {
		return x.ContactNotices
	}
	return nil
}

func (x *RegisterDomainRequest) GetYearlyPrice() *money.Money {
	if x != nil {
		return x.YearlyPrice
	}
	return nil
}

func (x *RegisterDomainRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request for the `RetrieveTransferParameters` method.
type RetrieveTransferParametersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The domain name. Unicode domain names must be expressed in Punycode format.
	DomainName string `protobuf:"bytes,1,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// Required. The location. Must be in the format `projects/*/locations/*`.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *RetrieveTransferParametersRequest) Reset() {
	*x = RetrieveTransferParametersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveTransferParametersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveTransferParametersRequest) ProtoMessage() {}

func (x *RetrieveTransferParametersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveTransferParametersRequest.ProtoReflect.Descriptor instead.
func (*RetrieveTransferParametersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{9}
}

func (x *RetrieveTransferParametersRequest) GetDomainName() string {
	if x != nil {
		return x.DomainName
	}
	return ""
}

func (x *RetrieveTransferParametersRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Response for the `RetrieveTransferParameters` method.
type RetrieveTransferParametersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parameters to use when calling the `TransferDomain` method.
	TransferParameters *TransferParameters `protobuf:"bytes,1,opt,name=transfer_parameters,json=transferParameters,proto3" json:"transfer_parameters,omitempty"`
}

func (x *RetrieveTransferParametersResponse) Reset() {
	*x = RetrieveTransferParametersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveTransferParametersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveTransferParametersResponse) ProtoMessage() {}

func (x *RetrieveTransferParametersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveTransferParametersResponse.ProtoReflect.Descriptor instead.
func (*RetrieveTransferParametersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{10}
}

func (x *RetrieveTransferParametersResponse) GetTransferParameters() *TransferParameters {
	if x != nil {
		return x.TransferParameters
	}
	return nil
}

// Request for the `TransferDomain` method.
type TransferDomainRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the `Registration`. Must be in the
	// format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The complete `Registration` resource to be created.
	//
	// You can leave `registration.dns_settings` unset to import the
	// domain's current DNS configuration from its current registrar. Use this
	// option only if you are sure that the domain's current DNS service
	// does not cease upon transfer, as is often the case for DNS services
	// provided for free by the registrar.
	Registration *Registration `protobuf:"bytes,2,opt,name=registration,proto3" json:"registration,omitempty"`
	// The list of contact notices that you acknowledge. The notices
	// needed here depend on the values specified in
	// `registration.contact_settings`.
	ContactNotices []ContactNotice `protobuf:"varint,3,rep,packed,name=contact_notices,json=contactNotices,proto3,enum=google.cloud.domains.v1beta1.ContactNotice" json:"contact_notices,omitempty"`
	// Required. Acknowledgement of the price to transfer or renew the domain for one year.
	// Call `RetrieveTransferParameters` to obtain the price, which you must
	// acknowledge.
	YearlyPrice *money.Money `protobuf:"bytes,4,opt,name=yearly_price,json=yearlyPrice,proto3" json:"yearly_price,omitempty"`
	// The domain's transfer authorization code. You can obtain this from the
	// domain's current registrar.
	AuthorizationCode *AuthorizationCode `protobuf:"bytes,5,opt,name=authorization_code,json=authorizationCode,proto3" json:"authorization_code,omitempty"`
	// Validate the request without actually transferring the domain.
	ValidateOnly bool `protobuf:"varint,6,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *TransferDomainRequest) Reset() {
	*x = TransferDomainRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferDomainRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferDomainRequest) ProtoMessage() {}

func (x *TransferDomainRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferDomainRequest.ProtoReflect.Descriptor instead.
func (*TransferDomainRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{11}
}

func (x *TransferDomainRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *TransferDomainRequest) GetRegistration() *Registration {
	if x != nil {
		return x.Registration
	}
	return nil
}

func (x *TransferDomainRequest) GetContactNotices() []ContactNotice {
	if x != nil {
		return x.ContactNotices
	}
	return nil
}

func (x *TransferDomainRequest) GetYearlyPrice() *money.Money {
	if x != nil {
		return x.YearlyPrice
	}
	return nil
}

func (x *TransferDomainRequest) GetAuthorizationCode() *AuthorizationCode {
	if x != nil {
		return x.AuthorizationCode
	}
	return nil
}

func (x *TransferDomainRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request for the `ListRegistrations` method.
type ListRegistrationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which to list `Registration`s, specified in
	// the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of results to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// When set to the `next_page_token` from a prior response, provides the next
	// page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter expression to restrict the `Registration`s returned.
	//
	// The expression must specify the field name, a comparison operator, and the
	// value that you want to use for filtering. The value must be a string, a
	// number, a boolean, or an enum value. The comparison operator should be one
	// of =, !=, >, <, >=, <=, or : for prefix or wildcard matches.
	//
	// For example, to filter to a specific domain name, use an expression like
	// `domainName="example.com"`. You can also check for the existence of a
	// field; for example, to find domains using custom DNS settings, use an
	// expression like `dnsSettings.customDns:*`.
	//
	// You can also create compound filters by combining expressions with the
	// `AND` and `OR` operators. For example, to find domains that are suspended
	// or have specific issues flagged, use an expression like
	// `(state=SUSPENDED) OR (issue:*)`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListRegistrationsRequest) Reset() {
	*x = ListRegistrationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRegistrationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRegistrationsRequest) ProtoMessage() {}

func (x *ListRegistrationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRegistrationsRequest.ProtoReflect.Descriptor instead.
func (*ListRegistrationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{12}
}

func (x *ListRegistrationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRegistrationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRegistrationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRegistrationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response for the `ListRegistrations` method.
type ListRegistrationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of `Registration`s.
	Registrations []*Registration `protobuf:"bytes,1,rep,name=registrations,proto3" json:"registrations,omitempty"`
	// When present, there are more results to retrieve. Set `page_token` to this
	// value on a subsequent call to get the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRegistrationsResponse) Reset() {
	*x = ListRegistrationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRegistrationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRegistrationsResponse) ProtoMessage() {}

func (x *ListRegistrationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRegistrationsResponse.ProtoReflect.Descriptor instead.
func (*ListRegistrationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{13}
}

func (x *ListRegistrationsResponse) GetRegistrations() []*Registration {
	if x != nil {
		return x.Registrations
	}
	return nil
}

func (x *ListRegistrationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the `GetRegistration` method.
type GetRegistrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Registration` to get, in the format
	// `projects/*/locations/*/registrations/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRegistrationRequest) Reset() {
	*x = GetRegistrationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRegistrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRegistrationRequest) ProtoMessage() {}

func (x *GetRegistrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRegistrationRequest.ProtoReflect.Descriptor instead.
func (*GetRegistrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{14}
}

func (x *GetRegistrationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `UpdateRegistration` method.
type UpdateRegistrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Fields of the `Registration` to update.
	Registration *Registration `protobuf:"bytes,1,opt,name=registration,proto3" json:"registration,omitempty"`
	// Required. The field mask describing which fields to update as a comma-separated list.
	// For example, if only the labels are being updated, the `update_mask` is
	// `"labels"`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateRegistrationRequest) Reset() {
	*x = UpdateRegistrationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateRegistrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateRegistrationRequest) ProtoMessage() {}

func (x *UpdateRegistrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateRegistrationRequest.ProtoReflect.Descriptor instead.
func (*UpdateRegistrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateRegistrationRequest) GetRegistration() *Registration {
	if x != nil {
		return x.Registration
	}
	return nil
}

func (x *UpdateRegistrationRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the `ConfigureManagementSettings` method.
type ConfigureManagementSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Registration` whose management settings are being updated,
	// in the format `projects/*/locations/*/registrations/*`.
	Registration string `protobuf:"bytes,1,opt,name=registration,proto3" json:"registration,omitempty"`
	// Fields of the `ManagementSettings` to update.
	ManagementSettings *ManagementSettings `protobuf:"bytes,2,opt,name=management_settings,json=managementSettings,proto3" json:"management_settings,omitempty"`
	// Required. The field mask describing which fields to update as a comma-separated list.
	// For example, if only the transfer lock is being updated, the `update_mask`
	// is `"transfer_lock_state"`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *ConfigureManagementSettingsRequest) Reset() {
	*x = ConfigureManagementSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigureManagementSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureManagementSettingsRequest) ProtoMessage() {}

func (x *ConfigureManagementSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureManagementSettingsRequest.ProtoReflect.Descriptor instead.
func (*ConfigureManagementSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{16}
}

func (x *ConfigureManagementSettingsRequest) GetRegistration() string {
	if x != nil {
		return x.Registration
	}
	return ""
}

func (x *ConfigureManagementSettingsRequest) GetManagementSettings() *ManagementSettings {
	if x != nil {
		return x.ManagementSettings
	}
	return nil
}

func (x *ConfigureManagementSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the `ConfigureDnsSettings` method.
type ConfigureDnsSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Registration` whose DNS settings are being updated,
	// in the format `projects/*/locations/*/registrations/*`.
	Registration string `protobuf:"bytes,1,opt,name=registration,proto3" json:"registration,omitempty"`
	// Fields of the `DnsSettings` to update.
	DnsSettings *DnsSettings `protobuf:"bytes,2,opt,name=dns_settings,json=dnsSettings,proto3" json:"dns_settings,omitempty"`
	// Required. The field mask describing which fields to update as a comma-separated list.
	// For example, if only the name servers are being updated for an existing
	// Custom DNS configuration, the `update_mask` is
	// `"custom_dns.name_servers"`.
	//
	// When changing the DNS provider from one type to another, pass the new
	// provider's field name as part of the field mask. For example, when changing
	// from a Google Domains DNS configuration to a Custom DNS configuration, the
	// `update_mask` is `"custom_dns"`. //
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Validate the request without actually updating the DNS settings.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *ConfigureDnsSettingsRequest) Reset() {
	*x = ConfigureDnsSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigureDnsSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureDnsSettingsRequest) ProtoMessage() {}

func (x *ConfigureDnsSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureDnsSettingsRequest.ProtoReflect.Descriptor instead.
func (*ConfigureDnsSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{17}
}

func (x *ConfigureDnsSettingsRequest) GetRegistration() string {
	if x != nil {
		return x.Registration
	}
	return ""
}

func (x *ConfigureDnsSettingsRequest) GetDnsSettings() *DnsSettings {
	if x != nil {
		return x.DnsSettings
	}
	return nil
}

func (x *ConfigureDnsSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *ConfigureDnsSettingsRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request for the `ConfigureContactSettings` method.
type ConfigureContactSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Registration` whose contact settings are being updated,
	// in the format `projects/*/locations/*/registrations/*`.
	Registration string `protobuf:"bytes,1,opt,name=registration,proto3" json:"registration,omitempty"`
	// Fields of the `ContactSettings` to update.
	ContactSettings *ContactSettings `protobuf:"bytes,2,opt,name=contact_settings,json=contactSettings,proto3" json:"contact_settings,omitempty"`
	// Required. The field mask describing which fields to update as a comma-separated list.
	// For example, if only the registrant contact is being updated, the
	// `update_mask` is `"registrant_contact"`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The list of contact notices that the caller acknowledges. The notices
	// needed here depend on the values specified in `contact_settings`.
	ContactNotices []ContactNotice `protobuf:"varint,4,rep,packed,name=contact_notices,json=contactNotices,proto3,enum=google.cloud.domains.v1beta1.ContactNotice" json:"contact_notices,omitempty"`
	// Validate the request without actually updating the contact settings.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *ConfigureContactSettingsRequest) Reset() {
	*x = ConfigureContactSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigureContactSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigureContactSettingsRequest) ProtoMessage() {}

func (x *ConfigureContactSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigureContactSettingsRequest.ProtoReflect.Descriptor instead.
func (*ConfigureContactSettingsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{18}
}

func (x *ConfigureContactSettingsRequest) GetRegistration() string {
	if x != nil {
		return x.Registration
	}
	return ""
}

func (x *ConfigureContactSettingsRequest) GetContactSettings() *ContactSettings {
	if x != nil {
		return x.ContactSettings
	}
	return nil
}

func (x *ConfigureContactSettingsRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *ConfigureContactSettingsRequest) GetContactNotices() []ContactNotice {
	if x != nil {
		return x.ContactNotices
	}
	return nil
}

func (x *ConfigureContactSettingsRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request for the `ExportRegistration` method.
type ExportRegistrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Registration` to export,
	// in the format `projects/*/locations/*/registrations/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ExportRegistrationRequest) Reset() {
	*x = ExportRegistrationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportRegistrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportRegistrationRequest) ProtoMessage() {}

func (x *ExportRegistrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportRegistrationRequest.ProtoReflect.Descriptor instead.
func (*ExportRegistrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{19}
}

func (x *ExportRegistrationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `DeleteRegistration` method.
type DeleteRegistrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Registration` to delete,
	// in the format `projects/*/locations/*/registrations/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteRegistrationRequest) Reset() {
	*x = DeleteRegistrationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRegistrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRegistrationRequest) ProtoMessage() {}

func (x *DeleteRegistrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRegistrationRequest.ProtoReflect.Descriptor instead.
func (*DeleteRegistrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{20}
}

func (x *DeleteRegistrationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `RetrieveAuthorizationCode` method.
type RetrieveAuthorizationCodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Registration` whose authorization code is being retrieved,
	// in the format `projects/*/locations/*/registrations/*`.
	Registration string `protobuf:"bytes,1,opt,name=registration,proto3" json:"registration,omitempty"`
}

func (x *RetrieveAuthorizationCodeRequest) Reset() {
	*x = RetrieveAuthorizationCodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetrieveAuthorizationCodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrieveAuthorizationCodeRequest) ProtoMessage() {}

func (x *RetrieveAuthorizationCodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrieveAuthorizationCodeRequest.ProtoReflect.Descriptor instead.
func (*RetrieveAuthorizationCodeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{21}
}

func (x *RetrieveAuthorizationCodeRequest) GetRegistration() string {
	if x != nil {
		return x.Registration
	}
	return ""
}

// Request for the `ResetAuthorizationCode` method.
type ResetAuthorizationCodeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the `Registration` whose authorization code is being reset,
	// in the format `projects/*/locations/*/registrations/*`.
	Registration string `protobuf:"bytes,1,opt,name=registration,proto3" json:"registration,omitempty"`
}

func (x *ResetAuthorizationCodeRequest) Reset() {
	*x = ResetAuthorizationCodeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetAuthorizationCodeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetAuthorizationCodeRequest) ProtoMessage() {}

func (x *ResetAuthorizationCodeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetAuthorizationCodeRequest.ProtoReflect.Descriptor instead.
func (*ResetAuthorizationCodeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{22}
}

func (x *ResetAuthorizationCodeRequest) GetRegistration() string {
	if x != nil {
		return x.Registration
	}
	return ""
}

// Parameters required to register a new domain.
type RegisterParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The domain name. Unicode domain names are expressed in Punycode format.
	DomainName string `protobuf:"bytes,1,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// Indicates whether the domain is available for registration. This value is
	// accurate when obtained by calling `RetrieveRegisterParameters`, but is
	// approximate when obtained by calling `SearchDomains`.
	Availability RegisterParameters_Availability `protobuf:"varint,2,opt,name=availability,proto3,enum=google.cloud.domains.v1beta1.RegisterParameters_Availability" json:"availability,omitempty"`
	// Contact privacy options that the domain supports.
	SupportedPrivacy []ContactPrivacy `protobuf:"varint,3,rep,packed,name=supported_privacy,json=supportedPrivacy,proto3,enum=google.cloud.domains.v1beta1.ContactPrivacy" json:"supported_privacy,omitempty"`
	// Notices about special properties of the domain.
	DomainNotices []DomainNotice `protobuf:"varint,4,rep,packed,name=domain_notices,json=domainNotices,proto3,enum=google.cloud.domains.v1beta1.DomainNotice" json:"domain_notices,omitempty"`
	// Price to register or renew the domain for one year.
	YearlyPrice *money.Money `protobuf:"bytes,5,opt,name=yearly_price,json=yearlyPrice,proto3" json:"yearly_price,omitempty"`
}

func (x *RegisterParameters) Reset() {
	*x = RegisterParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterParameters) ProtoMessage() {}

func (x *RegisterParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterParameters.ProtoReflect.Descriptor instead.
func (*RegisterParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{23}
}

func (x *RegisterParameters) GetDomainName() string {
	if x != nil {
		return x.DomainName
	}
	return ""
}

func (x *RegisterParameters) GetAvailability() RegisterParameters_Availability {
	if x != nil {
		return x.Availability
	}
	return RegisterParameters_AVAILABILITY_UNSPECIFIED
}

func (x *RegisterParameters) GetSupportedPrivacy() []ContactPrivacy {
	if x != nil {
		return x.SupportedPrivacy
	}
	return nil
}

func (x *RegisterParameters) GetDomainNotices() []DomainNotice {
	if x != nil {
		return x.DomainNotices
	}
	return nil
}

func (x *RegisterParameters) GetYearlyPrice() *money.Money {
	if x != nil {
		return x.YearlyPrice
	}
	return nil
}

// Parameters required to transfer a domain from another registrar.
type TransferParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The domain name. Unicode domain names are expressed in Punycode format.
	DomainName string `protobuf:"bytes,1,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// The registrar that currently manages the domain.
	CurrentRegistrar string `protobuf:"bytes,2,opt,name=current_registrar,json=currentRegistrar,proto3" json:"current_registrar,omitempty"`
	// The name servers that currently store the configuration of the domain.
	NameServers []string `protobuf:"bytes,3,rep,name=name_servers,json=nameServers,proto3" json:"name_servers,omitempty"`
	// Indicates whether the domain is protected by a transfer lock. For a
	// transfer to succeed, this must show `UNLOCKED`. To unlock a domain,
	// go to its current registrar.
	TransferLockState TransferLockState `protobuf:"varint,4,opt,name=transfer_lock_state,json=transferLockState,proto3,enum=google.cloud.domains.v1beta1.TransferLockState" json:"transfer_lock_state,omitempty"`
	// Contact privacy options that the domain supports.
	SupportedPrivacy []ContactPrivacy `protobuf:"varint,5,rep,packed,name=supported_privacy,json=supportedPrivacy,proto3,enum=google.cloud.domains.v1beta1.ContactPrivacy" json:"supported_privacy,omitempty"`
	// Price to transfer or renew the domain for one year.
	YearlyPrice *money.Money `protobuf:"bytes,6,opt,name=yearly_price,json=yearlyPrice,proto3" json:"yearly_price,omitempty"`
}

func (x *TransferParameters) Reset() {
	*x = TransferParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferParameters) ProtoMessage() {}

func (x *TransferParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferParameters.ProtoReflect.Descriptor instead.
func (*TransferParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{24}
}

func (x *TransferParameters) GetDomainName() string {
	if x != nil {
		return x.DomainName
	}
	return ""
}

func (x *TransferParameters) GetCurrentRegistrar() string {
	if x != nil {
		return x.CurrentRegistrar
	}
	return ""
}

func (x *TransferParameters) GetNameServers() []string {
	if x != nil {
		return x.NameServers
	}
	return nil
}

func (x *TransferParameters) GetTransferLockState() TransferLockState {
	if x != nil {
		return x.TransferLockState
	}
	return TransferLockState_TRANSFER_LOCK_STATE_UNSPECIFIED
}

func (x *TransferParameters) GetSupportedPrivacy() []ContactPrivacy {
	if x != nil {
		return x.SupportedPrivacy
	}
	return nil
}

func (x *TransferParameters) GetYearlyPrice() *money.Money {
	if x != nil {
		return x.YearlyPrice
	}
	return nil
}

// Defines an authorization code.
type AuthorizationCode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Authorization Code in ASCII. It can be used to transfer the domain
	// to or from another registrar.
	Code string `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
}

func (x *AuthorizationCode) Reset() {
	*x = AuthorizationCode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizationCode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationCode) ProtoMessage() {}

func (x *AuthorizationCode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationCode.ProtoReflect.Descriptor instead.
func (*AuthorizationCode) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{25}
}

func (x *AuthorizationCode) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

// Represents the metadata of the long-running operation. Output only.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Human-readable status of the operation, if any.
	StatusDetail string `protobuf:"bytes,5,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// API version used to start the operation.
	ApiVersion string `protobuf:"bytes,6,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{26}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusDetail() string {
	if x != nil {
		return x.StatusDetail
	}
	return ""
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Configuration for an arbitrary DNS provider.
type DnsSettings_CustomDns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of name servers that store the DNS zone for this domain. Each name
	// server is a domain name, with Unicode domain names expressed in
	// Punycode format.
	NameServers []string `protobuf:"bytes,1,rep,name=name_servers,json=nameServers,proto3" json:"name_servers,omitempty"`
	// The list of DS records for this domain, which are used to enable DNSSEC.
	// The domain's DNS provider can provide the values to set here. If this
	// field is empty, DNSSEC is disabled.
	DsRecords []*DnsSettings_DsRecord `protobuf:"bytes,2,rep,name=ds_records,json=dsRecords,proto3" json:"ds_records,omitempty"`
}

func (x *DnsSettings_CustomDns) Reset() {
	*x = DnsSettings_CustomDns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DnsSettings_CustomDns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsSettings_CustomDns) ProtoMessage() {}

func (x *DnsSettings_CustomDns) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsSettings_CustomDns.ProtoReflect.Descriptor instead.
func (*DnsSettings_CustomDns) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{2, 0}
}

func (x *DnsSettings_CustomDns) GetNameServers() []string {
	if x != nil {
		return x.NameServers
	}
	return nil
}

func (x *DnsSettings_CustomDns) GetDsRecords() []*DnsSettings_DsRecord {
	if x != nil {
		return x.DsRecords
	}
	return nil
}

// Configuration for using the free DNS zone provided by Google Domains as a
// `Registration`'s `dns_provider`. You cannot configure the DNS zone itself
// using the API. To configure the DNS zone, go to
// [Google Domains](https://domains.google/).
type DnsSettings_GoogleDomainsDns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. A list of name servers that store the DNS zone for this domain. Each name
	// server is a domain name, with Unicode domain names expressed in
	// Punycode format. This field is automatically populated with the name
	// servers assigned to the Google Domains DNS zone.
	NameServers []string `protobuf:"bytes,1,rep,name=name_servers,json=nameServers,proto3" json:"name_servers,omitempty"`
	// Required. The state of DS records for this domain. Used to enable or disable
	// automatic DNSSEC.
	DsState DnsSettings_DsState `protobuf:"varint,2,opt,name=ds_state,json=dsState,proto3,enum=google.cloud.domains.v1beta1.DnsSettings_DsState" json:"ds_state,omitempty"`
	// Output only. The list of DS records published for this domain. The list is
	// automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`,
	// otherwise it remains empty.
	DsRecords []*DnsSettings_DsRecord `protobuf:"bytes,3,rep,name=ds_records,json=dsRecords,proto3" json:"ds_records,omitempty"`
}

func (x *DnsSettings_GoogleDomainsDns) Reset() {
	*x = DnsSettings_GoogleDomainsDns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DnsSettings_GoogleDomainsDns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsSettings_GoogleDomainsDns) ProtoMessage() {}

func (x *DnsSettings_GoogleDomainsDns) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsSettings_GoogleDomainsDns.ProtoReflect.Descriptor instead.
func (*DnsSettings_GoogleDomainsDns) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{2, 1}
}

func (x *DnsSettings_GoogleDomainsDns) GetNameServers() []string {
	if x != nil {
		return x.NameServers
	}
	return nil
}

func (x *DnsSettings_GoogleDomainsDns) GetDsState() DnsSettings_DsState {
	if x != nil {
		return x.DsState
	}
	return DnsSettings_DS_STATE_UNSPECIFIED
}

func (x *DnsSettings_GoogleDomainsDns) GetDsRecords() []*DnsSettings_DsRecord {
	if x != nil {
		return x.DsRecords
	}
	return nil
}

// Defines a Delegation Signer (DS) record, which is needed to enable DNSSEC
// for a domain. It contains a digest (hash) of a DNSKEY record that must be
// present in the domain's DNS zone.
type DnsSettings_DsRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key tag of the record. Must be set in range 0 -- 65535.
	KeyTag int32 `protobuf:"varint,1,opt,name=key_tag,json=keyTag,proto3" json:"key_tag,omitempty"`
	// The algorithm used to generate the referenced DNSKEY.
	Algorithm DnsSettings_DsRecord_Algorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.cloud.domains.v1beta1.DnsSettings_DsRecord_Algorithm" json:"algorithm,omitempty"`
	// The hash function used to generate the digest of the referenced DNSKEY.
	DigestType DnsSettings_DsRecord_DigestType `protobuf:"varint,3,opt,name=digest_type,json=digestType,proto3,enum=google.cloud.domains.v1beta1.DnsSettings_DsRecord_DigestType" json:"digest_type,omitempty"`
	// The digest generated from the referenced DNSKEY.
	Digest string `protobuf:"bytes,4,opt,name=digest,proto3" json:"digest,omitempty"`
}

func (x *DnsSettings_DsRecord) Reset() {
	*x = DnsSettings_DsRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DnsSettings_DsRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsSettings_DsRecord) ProtoMessage() {}

func (x *DnsSettings_DsRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsSettings_DsRecord.ProtoReflect.Descriptor instead.
func (*DnsSettings_DsRecord) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{2, 2}
}

func (x *DnsSettings_DsRecord) GetKeyTag() int32 {
	if x != nil {
		return x.KeyTag
	}
	return 0
}

func (x *DnsSettings_DsRecord) GetAlgorithm() DnsSettings_DsRecord_Algorithm {
	if x != nil {
		return x.Algorithm
	}
	return DnsSettings_DsRecord_ALGORITHM_UNSPECIFIED
}

func (x *DnsSettings_DsRecord) GetDigestType() DnsSettings_DsRecord_DigestType {
	if x != nil {
		return x.DigestType
	}
	return DnsSettings_DsRecord_DIGEST_TYPE_UNSPECIFIED
}

func (x *DnsSettings_DsRecord) GetDigest() string {
	if x != nil {
		return x.Digest
	}
	return ""
}

// Defines a host on your domain that is a DNS name server for your domain
// and/or other domains. Glue records are a way of making the IP address of a
// name server known, even when it serves DNS queries for its parent domain.
// For example, when `ns.example.com` is a name server for `example.com`, the
// host `ns.example.com` must have a glue record to break the circular DNS
// reference.
type DnsSettings_GlueRecord struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Domain name of the host in Punycode format.
	HostName string `protobuf:"bytes,1,opt,name=host_name,json=hostName,proto3" json:"host_name,omitempty"`
	// List of IPv4 addresses corresponding to this host in the standard decimal
	// format (e.g. `198.51.100.1`). At least one of `ipv4_address` and
	// `ipv6_address` must be set.
	Ipv4Addresses []string `protobuf:"bytes,2,rep,name=ipv4_addresses,json=ipv4Addresses,proto3" json:"ipv4_addresses,omitempty"`
	// List of IPv6 addresses corresponding to this host in the standard
	// hexadecimal format (e.g. `2001:db8::`). At least one of
	// `ipv4_address` and `ipv6_address` must be set.
	Ipv6Addresses []string `protobuf:"bytes,3,rep,name=ipv6_addresses,json=ipv6Addresses,proto3" json:"ipv6_addresses,omitempty"`
}

func (x *DnsSettings_GlueRecord) Reset() {
	*x = DnsSettings_GlueRecord{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DnsSettings_GlueRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnsSettings_GlueRecord) ProtoMessage() {}

func (x *DnsSettings_GlueRecord) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnsSettings_GlueRecord.ProtoReflect.Descriptor instead.
func (*DnsSettings_GlueRecord) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{2, 3}
}

func (x *DnsSettings_GlueRecord) GetHostName() string {
	if x != nil {
		return x.HostName
	}
	return ""
}

func (x *DnsSettings_GlueRecord) GetIpv4Addresses() []string {
	if x != nil {
		return x.Ipv4Addresses
	}
	return nil
}

func (x *DnsSettings_GlueRecord) GetIpv6Addresses() []string {
	if x != nil {
		return x.Ipv6Addresses
	}
	return nil
}

// Details required for a contact associated with a `Registration`.
type ContactSettings_Contact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Postal address of the contact.
	PostalAddress *postaladdress.PostalAddress `protobuf:"bytes,1,opt,name=postal_address,json=postalAddress,proto3" json:"postal_address,omitempty"`
	// Required. Email address of the contact.
	Email string `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
	// Required. Phone number of the contact in international format. For example,
	// `"+1-800-555-0123"`.
	PhoneNumber string `protobuf:"bytes,3,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	// Fax number of the contact in international format. For example,
	// `"+1-800-555-0123"`.
	FaxNumber string `protobuf:"bytes,4,opt,name=fax_number,json=faxNumber,proto3" json:"fax_number,omitempty"`
}

func (x *ContactSettings_Contact) Reset() {
	*x = ContactSettings_Contact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ContactSettings_Contact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ContactSettings_Contact) ProtoMessage() {}

func (x *ContactSettings_Contact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_domains_v1beta1_domains_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ContactSettings_Contact.ProtoReflect.Descriptor instead.
func (*ContactSettings_Contact) Descriptor() ([]byte, []int) {
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ContactSettings_Contact) GetPostalAddress() *postaladdress.PostalAddress {
	if x != nil {
		return x.PostalAddress
	}
	return nil
}

func (x *ContactSettings_Contact) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ContactSettings_Contact) GetPhoneNumber() string {
	if x != nil {
		return x.PhoneNumber
	}
	return ""
}

func (x *ContactSettings_Contact) GetFaxNumber() string {
	if x != nil {
		return x.FaxNumber
	}
	return ""
}

var File_google_cloud_domains_v1beta1_domains_proto protoreflect.FileDescriptor

var file_google_cloud_domains_v1beta1_domains_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x70, 0x6f, 0x73, 0x74,
	0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xbc, 0x0a, 0x0a, 0x0c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0b, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70,
	0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x69, 0x73, 0x73,
	0x75, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x09, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x61, 0x0a, 0x13, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x12, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x4c, 0x0a, 0x0c, 0x64, 0x6e, 0x73, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0b, 0x64, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x12, 0x5d, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x6c, 0x0a, 0x18, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x70, 0x65, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x5e, 0x0a, 0x11, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x63, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63,
	0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa5, 0x01, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a,
	0x14, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x45, 0x47, 0x49, 0x53,
	0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46,
	0x45, 0x52, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45,
	0x4e, 0x44, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x58, 0x50, 0x4f, 0x52, 0x54,
	0x45, 0x44, 0x10, 0x08, 0x22, 0x49, 0x0a, 0x05, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x49, 0x53, 0x53, 0x55, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x43, 0x54, 0x5f,
	0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x55, 0x4e, 0x56,
	0x45, 0x52, 0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x45, 0x4d, 0x41, 0x49, 0x4c, 0x10, 0x02, 0x3a,
	0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x23, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22,
	0xbd, 0x02, 0x0a, 0x12, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x6a, 0x0a, 0x0e, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61,
	0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0d, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x12, 0x5f, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6c,
	0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x6b, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x22, 0x5a, 0x0a, 0x0d, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x4e, 0x45, 0x57, 0x41, 0x4c, 0x5f,
	0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49,
	0x43, 0x5f, 0x52, 0x45, 0x4e, 0x45, 0x57, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x4d,
	0x41, 0x4e, 0x55, 0x41, 0x4c, 0x5f, 0x52, 0x45, 0x4e, 0x45, 0x57, 0x41, 0x4c, 0x10, 0x02, 0x22,
	0xf9, 0x0b, 0x0a, 0x0b, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x54, 0x0a, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x64, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x44, 0x6e, 0x73, 0x12, 0x6a, 0x0a, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x5f, 0x64, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x44, 0x6e, 0x73, 0x48, 0x00, 0x52,
	0x10, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x44, 0x6e,
	0x73, 0x12, 0x57, 0x0a, 0x0c, 0x67, 0x6c, 0x75, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x47, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x0b, 0x67,
	0x6c, 0x75, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x1a, 0x86, 0x01, 0x0a, 0x09, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x44, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73,
	0x12, 0x51, 0x0a, 0x0a, 0x64, 0x73, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x44, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x09, 0x64, 0x73, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x73, 0x1a, 0xe5, 0x01, 0x0a, 0x10, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x73, 0x44, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6e, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73,
	0x12, 0x51, 0x0a, 0x08, 0x64, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x73,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x73, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x0a, 0x64, 0x73, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x44, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x64, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x1a, 0xf4, 0x04, 0x0a, 0x08,
	0x44, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x5f,
	0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6b, 0x65, 0x79, 0x54, 0x61,
	0x67, 0x12, 0x5a, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x44, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x5e, 0x0a,
	0x0b, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x73,
	0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0a, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a,
	0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x22, 0x9f, 0x02, 0x0a, 0x09, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x4c, 0x47, 0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x52, 0x53, 0x41, 0x4d, 0x44, 0x35, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x44, 0x48,
	0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x53, 0x41, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x45,
	0x43, 0x43, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x53, 0x41, 0x53, 0x48, 0x41, 0x31, 0x10,
	0x05, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x53, 0x41, 0x4e, 0x53, 0x45, 0x43, 0x33, 0x53, 0x48, 0x41,
	0x31, 0x10, 0x06, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x53, 0x41, 0x53, 0x48, 0x41, 0x31, 0x4e, 0x53,
	0x45, 0x43, 0x33, 0x53, 0x48, 0x41, 0x31, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x53, 0x41,
	0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x53, 0x41, 0x53,
	0x48, 0x41, 0x35, 0x31, 0x32, 0x10, 0x0a, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x43, 0x43, 0x47, 0x4f,
	0x53, 0x54, 0x10, 0x0c, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x43, 0x44, 0x53, 0x41, 0x50, 0x32, 0x35,
	0x36, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x0d, 0x12, 0x13, 0x0a, 0x0f, 0x45, 0x43, 0x44,
	0x53, 0x41, 0x50, 0x33, 0x38, 0x34, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34, 0x10, 0x0e, 0x12, 0x0b,
	0x0a, 0x07, 0x45, 0x44, 0x32, 0x35, 0x35, 0x31, 0x39, 0x10, 0x0f, 0x12, 0x09, 0x0a, 0x05, 0x45,
	0x44, 0x34, 0x34, 0x38, 0x10, 0x10, 0x12, 0x0d, 0x0a, 0x08, 0x49, 0x4e, 0x44, 0x49, 0x52, 0x45,
	0x43, 0x54, 0x10, 0xfc, 0x01, 0x12, 0x0f, 0x0a, 0x0a, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45,
	0x44, 0x4e, 0x53, 0x10, 0xfd, 0x01, 0x12, 0x0f, 0x0a, 0x0a, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54,
	0x45, 0x4f, 0x49, 0x44, 0x10, 0xfe, 0x01, 0x22, 0x59, 0x0a, 0x0a, 0x44, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x49, 0x47, 0x45, 0x53, 0x54, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x48, 0x41, 0x31, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x47, 0x4f, 0x53, 0x54,
	0x33, 0x34, 0x31, 0x31, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41, 0x33, 0x38, 0x34,
	0x10, 0x04, 0x1a, 0x7c, 0x0a, 0x0a, 0x47, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x12, 0x20, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x70, 0x76, 0x34, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x70, 0x76, 0x34,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x70, 0x76,
	0x36, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0d, 0x69, 0x70, 0x76, 0x36, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x22, 0x59, 0x0a, 0x07, 0x44, 0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x44,
	0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x53, 0x5f, 0x52, 0x45, 0x43, 0x4f,
	0x52, 0x44, 0x53, 0x5f, 0x55, 0x4e, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x18, 0x0a, 0x14, 0x44, 0x53, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x52, 0x44, 0x53, 0x5f,
	0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x44, 0x10, 0x02, 0x42, 0x0e, 0x0a, 0x0c, 0x64,
	0x6e, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x22, 0xc9, 0x04, 0x0a, 0x0f,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x4b, 0x0a, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x12, 0x69, 0x0a, 0x12,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x6e, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x5f, 0x0a, 0x0d, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x67, 0x0a, 0x11, 0x74, 0x65, 0x63, 0x68,
	0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x10, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63,
	0x74, 0x1a, 0xb3, 0x01, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x12, 0x46, 0x0a,
	0x0e, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c,
	0x12, 0x26, 0x0a, 0x0c, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70, 0x68, 0x6f,
	0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x61, 0x78, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x61,
	0x78, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x78, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x7a, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a, 0x13, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x12, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x90, 0x01,
	0x0a, 0x21, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x87, 0x01, 0x0a, 0x22, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a, 0x13, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x12, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xb9, 0x03, 0x0a, 0x15, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0e,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65,
	0x52, 0x0d, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x73, 0x12,
	0x54, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x63,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x4e,
	0x6f, 0x74, 0x69, 0x63, 0x65, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x4e, 0x6f,
	0x74, 0x69, 0x63, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x0c, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f,
	0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x90, 0x01, 0x0a, 0x21, 0x52, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x22, 0x52, 0x65,
	0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x61, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52,
	0x12, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x22, 0xc6, 0x03, 0x0a, 0x15, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x53, 0x0a, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x63, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x52, 0x0e, 0x63, 0x6f, 0x6e,
	0x74, 0x61, 0x63, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x0c, 0x79,
	0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x79, 0x65, 0x61, 0x72,
	0x6c, 0x79, 0x50, 0x72, 0x69, 0x63, 0x65, 0x12, 0x5e, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x64, 0x65, 0x52, 0x11, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xb1, 0x01, 0x0a,
	0x18, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x22, 0x95, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50,
	0x0a, 0x0d, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x59, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xad, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4e, 0x0a, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x9a, 0x02, 0x0a, 0x22, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0c, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x13, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x12, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x22, 0xa3, 0x02, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x44, 0x6e,
	0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x4c, 0x0a, 0x0c, 0x64, 0x6e, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x0b, 0x64, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x89, 0x03, 0x0a, 0x1f, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0c, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x10, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x54, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x52, 0x0e, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0x5c, 0x0a, 0x19, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x5c, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x73,
	0x0a, 0x20, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x70, 0x0a, 0x1d, 0x52, 0x65, 0x73, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x25, 0x0a, 0x23, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe9, 0x03, 0x0a, 0x12, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x61, 0x0a,
	0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x52, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x59, 0x0a, 0x11, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
	0x63, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x52, 0x10, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x12, 0x51, 0x0a, 0x0e, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x52,
	0x0d, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x73, 0x12, 0x35,
	0x0a, 0x0c, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x0b, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79,
	0x50, 0x72, 0x69, 0x63, 0x65, 0x22, 0x6a, 0x0a, 0x0c, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42,
	0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c,
	0x45, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10,
	0x04, 0x22, 0xf8, 0x02, 0x0a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x61, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x61,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x12, 0x5f, 0x0a, 0x13, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c, 0x6f,
	0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x11, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x4c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x59, 0x0a, 0x11, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x52, 0x10, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x63, 0x79, 0x12, 0x35, 0x0a, 0x0c, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f,
	0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52,
	0x0b, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x50, 0x72, 0x69, 0x63, 0x65, 0x22, 0x27, 0x0a, 0x11,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0xf9, 0x01, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3b, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x23, 0x0a, 0x0d, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x2a, 0x7f, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x63, 0x79, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x43, 0x54, 0x5f, 0x50,
	0x52, 0x49, 0x56, 0x41, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x43,
	0x4f, 0x4e, 0x54, 0x41, 0x43, 0x54, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10, 0x01, 0x12, 0x18, 0x0a,
	0x14, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x43, 0x54,
	0x5f, 0x44, 0x41, 0x54, 0x41, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x44, 0x41, 0x43,
	0x54, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x43, 0x54, 0x5f, 0x44, 0x41, 0x54, 0x41,
	0x10, 0x03, 0x2a, 0x41, 0x0a, 0x0c, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x6f, 0x74, 0x69,
	0x63, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x4f, 0x4d, 0x41, 0x49, 0x4e, 0x5f, 0x4e, 0x4f, 0x54,
	0x49, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x53, 0x54, 0x53, 0x5f, 0x50, 0x52, 0x45, 0x4c, 0x4f, 0x41,
	0x44, 0x45, 0x44, 0x10, 0x01, 0x2a, 0x58, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x4e, 0x6f, 0x74, 0x69, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x43,
	0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x49, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x27, 0x0a, 0x23, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43,
	0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x43, 0x54, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x41, 0x43,
	0x4b, 0x4e, 0x4f, 0x57, 0x4c, 0x45, 0x44, 0x47, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x2a,
	0x52, 0x0a, 0x11, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x6b, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52,
	0x5f, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x4e, 0x4c,
	0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x4f, 0x43, 0x4b, 0x45,
	0x44, 0x10, 0x02, 0x32, 0xca, 0x1e, 0x0a, 0x07, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x12,
	0xd9, 0x01, 0x0a, 0x0d, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0xda, 0x41, 0x0e, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x93, 0x02, 0x0a, 0x1a,
	0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x76, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x72, 0xda,
	0x41, 0x14, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x64, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x12, 0x53, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x52,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x12, 0xf8, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x44, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0xca, 0x41, 0x21, 0x0a, 0x0c,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x20, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x70, 0x72, 0x69,
	0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x12, 0x93, 0x02, 0x0a,
	0x1a, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x72,
	0xda, 0x41, 0x14, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x12, 0x53, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x8b, 0x02, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x44,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x44, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0xca, 0x41, 0x21, 0x0a,
	0x0c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0xda, 0x41, 0x33, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x79, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x70, 0x72,
	0x69, 0x63, 0x65, 0x2c, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22,
	0x3f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x12, 0xcd, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0xba, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x87, 0x02,
	0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98, 0x01, 0xca,
	0x41, 0x21, 0x0a, 0x0c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x18, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x53, 0x3a, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x32, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb9, 0x02, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb8, 0x01, 0xca, 0x41, 0x21, 0x0a, 0x0c,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x2c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x5f, 0x3a, 0x01, 0x2a, 0x22, 0x5a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x9d, 0x02, 0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61,
	0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x65, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaa, 0x01, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x52, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x25,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x64, 0x6e, 0x73,
	0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58, 0x3a, 0x01, 0x2a, 0x22, 0x53,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x44, 0x6e, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0xad, 0x02, 0x0a, 0x18, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb2,
	0x01, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x29, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x3a, 0x01, 0x2a, 0x22, 0x57, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0xe1, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xe0, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x72, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x38, 0x2a, 0x36, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfd, 0x01, 0x0a, 0x19, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x6f, 0xda, 0x41, 0x0c, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a,
	0x12, 0x58, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0xf7, 0x01, 0x0a, 0x16, 0x52,
	0x65, 0x73, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x64, 0x65, 0x22, 0x6f, 0xda, 0x41, 0x0c, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x01, 0x2a, 0x22, 0x55, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65,
	0x73, 0x65, 0x74, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x64, 0x65, 0x1a, 0x4a, 0xca, 0x41, 0x16, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0x6e, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x42, 0x0c, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x73, 0x70, 0x62, 0x3b, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x70, 0x62,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_domains_v1beta1_domains_proto_rawDescOnce sync.Once
	file_google_cloud_domains_v1beta1_domains_proto_rawDescData = file_google_cloud_domains_v1beta1_domains_proto_rawDesc
)

func file_google_cloud_domains_v1beta1_domains_proto_rawDescGZIP() []byte {
	file_google_cloud_domains_v1beta1_domains_proto_rawDescOnce.Do(func() {
		file_google_cloud_domains_v1beta1_domains_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_domains_v1beta1_domains_proto_rawDescData)
	})
	return file_google_cloud_domains_v1beta1_domains_proto_rawDescData
}

var file_google_cloud_domains_v1beta1_domains_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_cloud_domains_v1beta1_domains_proto_msgTypes = make([]protoimpl.MessageInfo, 33)
var file_google_cloud_domains_v1beta1_domains_proto_goTypes = []interface{}{
	(ContactPrivacy)(0),                        // 0: google.cloud.domains.v1beta1.ContactPrivacy
	(DomainNotice)(0),                          // 1: google.cloud.domains.v1beta1.DomainNotice
	(ContactNotice)(0),                         // 2: google.cloud.domains.v1beta1.ContactNotice
	(TransferLockState)(0),                     // 3: google.cloud.domains.v1beta1.TransferLockState
	(Registration_State)(0),                    // 4: google.cloud.domains.v1beta1.Registration.State
	(Registration_Issue)(0),                    // 5: google.cloud.domains.v1beta1.Registration.Issue
	(ManagementSettings_RenewalMethod)(0),      // 6: google.cloud.domains.v1beta1.ManagementSettings.RenewalMethod
	(DnsSettings_DsState)(0),                   // 7: google.cloud.domains.v1beta1.DnsSettings.DsState
	(DnsSettings_DsRecord_Algorithm)(0),        // 8: google.cloud.domains.v1beta1.DnsSettings.DsRecord.Algorithm
	(DnsSettings_DsRecord_DigestType)(0),       // 9: google.cloud.domains.v1beta1.DnsSettings.DsRecord.DigestType
	(RegisterParameters_Availability)(0),       // 10: google.cloud.domains.v1beta1.RegisterParameters.Availability
	(*Registration)(nil),                       // 11: google.cloud.domains.v1beta1.Registration
	(*ManagementSettings)(nil),                 // 12: google.cloud.domains.v1beta1.ManagementSettings
	(*DnsSettings)(nil),                        // 13: google.cloud.domains.v1beta1.DnsSettings
	(*ContactSettings)(nil),                    // 14: google.cloud.domains.v1beta1.ContactSettings
	(*SearchDomainsRequest)(nil),               // 15: google.cloud.domains.v1beta1.SearchDomainsRequest
	(*SearchDomainsResponse)(nil),              // 16: google.cloud.domains.v1beta1.SearchDomainsResponse
	(*RetrieveRegisterParametersRequest)(nil),  // 17: google.cloud.domains.v1beta1.RetrieveRegisterParametersRequest
	(*RetrieveRegisterParametersResponse)(nil), // 18: google.cloud.domains.v1beta1.RetrieveRegisterParametersResponse
	(*RegisterDomainRequest)(nil),              // 19: google.cloud.domains.v1beta1.RegisterDomainRequest
	(*RetrieveTransferParametersRequest)(nil),  // 20: google.cloud.domains.v1beta1.RetrieveTransferParametersRequest
	(*RetrieveTransferParametersResponse)(nil), // 21: google.cloud.domains.v1beta1.RetrieveTransferParametersResponse
	(*TransferDomainRequest)(nil),              // 22: google.cloud.domains.v1beta1.TransferDomainRequest
	(*ListRegistrationsRequest)(nil),           // 23: google.cloud.domains.v1beta1.ListRegistrationsRequest
	(*ListRegistrationsResponse)(nil),          // 24: google.cloud.domains.v1beta1.ListRegistrationsResponse
	(*GetRegistrationRequest)(nil),             // 25: google.cloud.domains.v1beta1.GetRegistrationRequest
	(*UpdateRegistrationRequest)(nil),          // 26: google.cloud.domains.v1beta1.UpdateRegistrationRequest
	(*ConfigureManagementSettingsRequest)(nil), // 27: google.cloud.domains.v1beta1.ConfigureManagementSettingsRequest
	(*ConfigureDnsSettingsRequest)(nil),        // 28: google.cloud.domains.v1beta1.ConfigureDnsSettingsRequest
	(*ConfigureContactSettingsRequest)(nil),    // 29: google.cloud.domains.v1beta1.ConfigureContactSettingsRequest
	(*ExportRegistrationRequest)(nil),          // 30: google.cloud.domains.v1beta1.ExportRegistrationRequest
	(*DeleteRegistrationRequest)(nil),          // 31: google.cloud.domains.v1beta1.DeleteRegistrationRequest
	(*RetrieveAuthorizationCodeRequest)(nil),   // 32: google.cloud.domains.v1beta1.RetrieveAuthorizationCodeRequest
	(*ResetAuthorizationCodeRequest)(nil),      // 33: google.cloud.domains.v1beta1.ResetAuthorizationCodeRequest
	(*RegisterParameters)(nil),                 // 34: google.cloud.domains.v1beta1.RegisterParameters
	(*TransferParameters)(nil),                 // 35: google.cloud.domains.v1beta1.TransferParameters
	(*AuthorizationCode)(nil),                  // 36: google.cloud.domains.v1beta1.AuthorizationCode
	(*OperationMetadata)(nil),                  // 37: google.cloud.domains.v1beta1.OperationMetadata
	nil,                                        // 38: google.cloud.domains.v1beta1.Registration.LabelsEntry
	(*DnsSettings_CustomDns)(nil),              // 39: google.cloud.domains.v1beta1.DnsSettings.CustomDns
	(*DnsSettings_GoogleDomainsDns)(nil),       // 40: google.cloud.domains.v1beta1.DnsSettings.GoogleDomainsDns
	(*DnsSettings_DsRecord)(nil),               // 41: google.cloud.domains.v1beta1.DnsSettings.DsRecord
	(*DnsSettings_GlueRecord)(nil),             // 42: google.cloud.domains.v1beta1.DnsSettings.GlueRecord
	(*ContactSettings_Contact)(nil),            // 43: google.cloud.domains.v1beta1.ContactSettings.Contact
	(*timestamppb.Timestamp)(nil),              // 44: google.protobuf.Timestamp
	(*money.Money)(nil),                        // 45: google.type.Money
	(*fieldmaskpb.FieldMask)(nil),              // 46: google.protobuf.FieldMask
	(*postaladdress.PostalAddress)(nil),        // 47: google.type.PostalAddress
	(*longrunningpb.Operation)(nil),            // 48: google.longrunning.Operation
}
var file_google_cloud_domains_v1beta1_domains_proto_depIdxs = []int32{
	44, // 0: google.cloud.domains.v1beta1.Registration.create_time:type_name -> google.protobuf.Timestamp
	44, // 1: google.cloud.domains.v1beta1.Registration.expire_time:type_name -> google.protobuf.Timestamp
	4,  // 2: google.cloud.domains.v1beta1.Registration.state:type_name -> google.cloud.domains.v1beta1.Registration.State
	5,  // 3: google.cloud.domains.v1beta1.Registration.issues:type_name -> google.cloud.domains.v1beta1.Registration.Issue
	38, // 4: google.cloud.domains.v1beta1.Registration.labels:type_name -> google.cloud.domains.v1beta1.Registration.LabelsEntry
	12, // 5: google.cloud.domains.v1beta1.Registration.management_settings:type_name -> google.cloud.domains.v1beta1.ManagementSettings
	13, // 6: google.cloud.domains.v1beta1.Registration.dns_settings:type_name -> google.cloud.domains.v1beta1.DnsSettings
	14, // 7: google.cloud.domains.v1beta1.Registration.contact_settings:type_name -> google.cloud.domains.v1beta1.ContactSettings
	14, // 8: google.cloud.domains.v1beta1.Registration.pending_contact_settings:type_name -> google.cloud.domains.v1beta1.ContactSettings
	0,  // 9: google.cloud.domains.v1beta1.Registration.supported_privacy:type_name -> google.cloud.domains.v1beta1.ContactPrivacy
	6,  // 10: google.cloud.domains.v1beta1.ManagementSettings.renewal_method:type_name -> google.cloud.domains.v1beta1.ManagementSettings.RenewalMethod
	3,  // 11: google.cloud.domains.v1beta1.ManagementSettings.transfer_lock_state:type_name -> google.cloud.domains.v1beta1.TransferLockState
	39, // 12: google.cloud.domains.v1beta1.DnsSettings.custom_dns:type_name -> google.cloud.domains.v1beta1.DnsSettings.CustomDns
	40, // 13: google.cloud.domains.v1beta1.DnsSettings.google_domains_dns:type_name -> google.cloud.domains.v1beta1.DnsSettings.GoogleDomainsDns
	42, // 14: google.cloud.domains.v1beta1.DnsSettings.glue_records:type_name -> google.cloud.domains.v1beta1.DnsSettings.GlueRecord
	0,  // 15: google.cloud.domains.v1beta1.ContactSettings.privacy:type_name -> google.cloud.domains.v1beta1.ContactPrivacy
	43, // 16: google.cloud.domains.v1beta1.ContactSettings.registrant_contact:type_name -> google.cloud.domains.v1beta1.ContactSettings.Contact
	43, // 17: google.cloud.domains.v1beta1.ContactSettings.admin_contact:type_name -> google.cloud.domains.v1beta1.ContactSettings.Contact
	43, // 18: google.cloud.domains.v1beta1.ContactSettings.technical_contact:type_name -> google.cloud.domains.v1beta1.ContactSettings.Contact
	34, // 19: google.cloud.domains.v1beta1.SearchDomainsResponse.register_parameters:type_name -> google.cloud.domains.v1beta1.RegisterParameters
	34, // 20: google.cloud.domains.v1beta1.RetrieveRegisterParametersResponse.register_parameters:type_name -> google.cloud.domains.v1beta1.RegisterParameters
	11, // 21: google.cloud.domains.v1beta1.RegisterDomainRequest.registration:type_name -> google.cloud.domains.v1beta1.Registration
	1,  // 22: google.cloud.domains.v1beta1.RegisterDomainRequest.domain_notices:type_name -> google.cloud.domains.v1beta1.DomainNotice
	2,  // 23: google.cloud.domains.v1beta1.RegisterDomainRequest.contact_notices:type_name -> google.cloud.domains.v1beta1.ContactNotice
	45, // 24: google.cloud.domains.v1beta1.RegisterDomainRequest.yearly_price:type_name -> google.type.Money
	35, // 25: google.cloud.domains.v1beta1.RetrieveTransferParametersResponse.transfer_parameters:type_name -> google.cloud.domains.v1beta1.TransferParameters
	11, // 26: google.cloud.domains.v1beta1.TransferDomainRequest.registration:type_name -> google.cloud.domains.v1beta1.Registration
	2,  // 27: google.cloud.domains.v1beta1.TransferDomainRequest.contact_notices:type_name -> google.cloud.domains.v1beta1.ContactNotice
	45, // 28: google.cloud.domains.v1beta1.TransferDomainRequest.yearly_price:type_name -> google.type.Money
	36, // 29: google.cloud.domains.v1beta1.TransferDomainRequest.authorization_code:type_name -> google.cloud.domains.v1beta1.AuthorizationCode
	11, // 30: google.cloud.domains.v1beta1.ListRegistrationsResponse.registrations:type_name -> google.cloud.domains.v1beta1.Registration
	11, // 31: google.cloud.domains.v1beta1.UpdateRegistrationRequest.registration:type_name -> google.cloud.domains.v1beta1.Registration
	46, // 32: google.cloud.domains.v1beta1.UpdateRegistrationRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 33: google.cloud.domains.v1beta1.ConfigureManagementSettingsRequest.management_settings:type_name -> google.cloud.domains.v1beta1.ManagementSettings
	46, // 34: google.cloud.domains.v1beta1.ConfigureManagementSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	13, // 35: google.cloud.domains.v1beta1.ConfigureDnsSettingsRequest.dns_settings:type_name -> google.cloud.domains.v1beta1.DnsSettings
	46, // 36: google.cloud.domains.v1beta1.ConfigureDnsSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	14, // 37: google.cloud.domains.v1beta1.ConfigureContactSettingsRequest.contact_settings:type_name -> google.cloud.domains.v1beta1.ContactSettings
	46, // 38: google.cloud.domains.v1beta1.ConfigureContactSettingsRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 39: google.cloud.domains.v1beta1.ConfigureContactSettingsRequest.contact_notices:type_name -> google.cloud.domains.v1beta1.ContactNotice
	10, // 40: google.cloud.domains.v1beta1.RegisterParameters.availability:type_name -> google.cloud.domains.v1beta1.RegisterParameters.Availability
	0,  // 41: google.cloud.domains.v1beta1.RegisterParameters.supported_privacy:type_name -> google.cloud.domains.v1beta1.ContactPrivacy
	1,  // 42: google.cloud.domains.v1beta1.RegisterParameters.domain_notices:type_name -> google.cloud.domains.v1beta1.DomainNotice
	45, // 43: google.cloud.domains.v1beta1.RegisterParameters.yearly_price:type_name -> google.type.Money
	3,  // 44: google.cloud.domains.v1beta1.TransferParameters.transfer_lock_state:type_name -> google.cloud.domains.v1beta1.TransferLockState
	0,  // 45: google.cloud.domains.v1beta1.TransferParameters.supported_privacy:type_name -> google.cloud.domains.v1beta1.ContactPrivacy
	45, // 46: google.cloud.domains.v1beta1.TransferParameters.yearly_price:type_name -> google.type.Money
	44, // 47: google.cloud.domains.v1beta1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	44, // 48: google.cloud.domains.v1beta1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	41, // 49: google.cloud.domains.v1beta1.DnsSettings.CustomDns.ds_records:type_name -> google.cloud.domains.v1beta1.DnsSettings.DsRecord
	7,  // 50: google.cloud.domains.v1beta1.DnsSettings.GoogleDomainsDns.ds_state:type_name -> google.cloud.domains.v1beta1.DnsSettings.DsState
	41, // 51: google.cloud.domains.v1beta1.DnsSettings.GoogleDomainsDns.ds_records:type_name -> google.cloud.domains.v1beta1.DnsSettings.DsRecord
	8,  // 52: google.cloud.domains.v1beta1.DnsSettings.DsRecord.algorithm:type_name -> google.cloud.domains.v1beta1.DnsSettings.DsRecord.Algorithm
	9,  // 53: google.cloud.domains.v1beta1.DnsSettings.DsRecord.digest_type:type_name -> google.cloud.domains.v1beta1.DnsSettings.DsRecord.DigestType
	47, // 54: google.cloud.domains.v1beta1.ContactSettings.Contact.postal_address:type_name -> google.type.PostalAddress
	15, // 55: google.cloud.domains.v1beta1.Domains.SearchDomains:input_type -> google.cloud.domains.v1beta1.SearchDomainsRequest
	17, // 56: google.cloud.domains.v1beta1.Domains.RetrieveRegisterParameters:input_type -> google.cloud.domains.v1beta1.RetrieveRegisterParametersRequest
	19, // 57: google.cloud.domains.v1beta1.Domains.RegisterDomain:input_type -> google.cloud.domains.v1beta1.RegisterDomainRequest
	20, // 58: google.cloud.domains.v1beta1.Domains.RetrieveTransferParameters:input_type -> google.cloud.domains.v1beta1.RetrieveTransferParametersRequest
	22, // 59: google.cloud.domains.v1beta1.Domains.TransferDomain:input_type -> google.cloud.domains.v1beta1.TransferDomainRequest
	23, // 60: google.cloud.domains.v1beta1.Domains.ListRegistrations:input_type -> google.cloud.domains.v1beta1.ListRegistrationsRequest
	25, // 61: google.cloud.domains.v1beta1.Domains.GetRegistration:input_type -> google.cloud.domains.v1beta1.GetRegistrationRequest
	26, // 62: google.cloud.domains.v1beta1.Domains.UpdateRegistration:input_type -> google.cloud.domains.v1beta1.UpdateRegistrationRequest
	27, // 63: google.cloud.domains.v1beta1.Domains.ConfigureManagementSettings:input_type -> google.cloud.domains.v1beta1.ConfigureManagementSettingsRequest
	28, // 64: google.cloud.domains.v1beta1.Domains.ConfigureDnsSettings:input_type -> google.cloud.domains.v1beta1.ConfigureDnsSettingsRequest
	29, // 65: google.cloud.domains.v1beta1.Domains.ConfigureContactSettings:input_type -> google.cloud.domains.v1beta1.ConfigureContactSettingsRequest
	30, // 66: google.cloud.domains.v1beta1.Domains.ExportRegistration:input_type -> google.cloud.domains.v1beta1.ExportRegistrationRequest
	31, // 67: google.cloud.domains.v1beta1.Domains.DeleteRegistration:input_type -> google.cloud.domains.v1beta1.DeleteRegistrationRequest
	32, // 68: google.cloud.domains.v1beta1.Domains.RetrieveAuthorizationCode:input_type -> google.cloud.domains.v1beta1.RetrieveAuthorizationCodeRequest
	33, // 69: google.cloud.domains.v1beta1.Domains.ResetAuthorizationCode:input_type -> google.cloud.domains.v1beta1.ResetAuthorizationCodeRequest
	16, // 70: google.cloud.domains.v1beta1.Domains.SearchDomains:output_type -> google.cloud.domains.v1beta1.SearchDomainsResponse
	18, // 71: google.cloud.domains.v1beta1.Domains.RetrieveRegisterParameters:output_type -> google.cloud.domains.v1beta1.RetrieveRegisterParametersResponse
	48, // 72: google.cloud.domains.v1beta1.Domains.RegisterDomain:output_type -> google.longrunning.Operation
	21, // 73: google.cloud.domains.v1beta1.Domains.RetrieveTransferParameters:output_type -> google.cloud.domains.v1beta1.RetrieveTransferParametersResponse
	48, // 74: google.cloud.domains.v1beta1.Domains.TransferDomain:output_type -> google.longrunning.Operation
	24, // 75: google.cloud.domains.v1beta1.Domains.ListRegistrations:output_type -> google.cloud.domains.v1beta1.ListRegistrationsResponse
	11, // 76: google.cloud.domains.v1beta1.Domains.GetRegistration:output_type -> google.cloud.domains.v1beta1.Registration
	48, // 77: google.cloud.domains.v1beta1.Domains.UpdateRegistration:output_type -> google.longrunning.Operation
	48, // 78: google.cloud.domains.v1beta1.Domains.ConfigureManagementSettings:output_type -> google.longrunning.Operation
	48, // 79: google.cloud.domains.v1beta1.Domains.ConfigureDnsSettings:output_type -> google.longrunning.Operation
	48, // 80: google.cloud.domains.v1beta1.Domains.ConfigureContactSettings:output_type -> google.longrunning.Operation
	48, // 81: google.cloud.domains.v1beta1.Domains.ExportRegistration:output_type -> google.longrunning.Operation
	48, // 82: google.cloud.domains.v1beta1.Domains.DeleteRegistration:output_type -> google.longrunning.Operation
	36, // 83: google.cloud.domains.v1beta1.Domains.RetrieveAuthorizationCode:output_type -> google.cloud.domains.v1beta1.AuthorizationCode
	36, // 84: google.cloud.domains.v1beta1.Domains.ResetAuthorizationCode:output_type -> google.cloud.domains.v1beta1.AuthorizationCode
	70, // [70:85] is the sub-list for method output_type
	55, // [55:70] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_google_cloud_domains_v1beta1_domains_proto_init() }
func file_google_cloud_domains_v1beta1_domains_proto_init() {
	if File_google_cloud_domains_v1beta1_domains_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Registration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagementSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DnsSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContactSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchDomainsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchDomainsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveRegisterParametersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveRegisterParametersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterDomainRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveTransferParametersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveTransferParametersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferDomainRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRegistrationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRegistrationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRegistrationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateRegistrationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigureManagementSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigureDnsSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigureContactSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportRegistrationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRegistrationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetrieveAuthorizationCodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetAuthorizationCodeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizationCode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DnsSettings_CustomDns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DnsSettings_GoogleDomainsDns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DnsSettings_DsRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DnsSettings_GlueRecord); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_domains_v1beta1_domains_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ContactSettings_Contact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_domains_v1beta1_domains_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*DnsSettings_CustomDns_)(nil),
		(*DnsSettings_GoogleDomainsDns_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_domains_v1beta1_domains_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   33,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_domains_v1beta1_domains_proto_goTypes,
		DependencyIndexes: file_google_cloud_domains_v1beta1_domains_proto_depIdxs,
		EnumInfos:         file_google_cloud_domains_v1beta1_domains_proto_enumTypes,
		MessageInfos:      file_google_cloud_domains_v1beta1_domains_proto_msgTypes,
	}.Build()
	File_google_cloud_domains_v1beta1_domains_proto = out.File
	file_google_cloud_domains_v1beta1_domains_proto_rawDesc = nil
	file_google_cloud_domains_v1beta1_domains_proto_goTypes = nil
	file_google_cloud_domains_v1beta1_domains_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DomainsClient is the client API for Domains service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DomainsClient interface {
	// Searches for available domain names similar to the provided query.
	//
	// Availability results from this method are approximate; call
	// `RetrieveRegisterParameters` on a domain before registering to confirm
	// availability.
	SearchDomains(ctx context.Context, in *SearchDomainsRequest, opts ...grpc.CallOption) (*SearchDomainsResponse, error)
	// Gets parameters needed to register a new domain name, including price and
	// up-to-date availability. Use the returned values to call `RegisterDomain`.
	RetrieveRegisterParameters(ctx context.Context, in *RetrieveRegisterParametersRequest, opts ...grpc.CallOption) (*RetrieveRegisterParametersResponse, error)
	// Registers a new domain name and creates a corresponding `Registration`
	// resource.
	//
	// Call `RetrieveRegisterParameters` first to check availability of the domain
	// name and determine parameters like price that are needed to build a call to
	// this method.
	//
	// A successful call creates a `Registration` resource in state
	// `REGISTRATION_PENDING`, which resolves to `ACTIVE` within 1-2
	// minutes, indicating that the domain was successfully registered. If the
	// resource ends up in state `REGISTRATION_FAILED`, it indicates that the
	// domain was not registered successfully, and you can safely delete the
	// resource and retry registration.
	RegisterDomain(ctx context.Context, in *RegisterDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets parameters needed to transfer a domain name from another registrar to
	// Cloud Domains. For domains managed by Google Domains, transferring to Cloud
	// Domains is not supported.
	//
	// Use the returned values to call `TransferDomain`.
	RetrieveTransferParameters(ctx context.Context, in *RetrieveTransferParametersRequest, opts ...grpc.CallOption) (*RetrieveTransferParametersResponse, error)
	// Transfers a domain name from another registrar to Cloud Domains.  For
	// domains managed by Google Domains, transferring to Cloud Domains is not
	// supported.
	//
	// Before calling this method, go to the domain's current registrar to unlock
	// the domain for transfer and retrieve the domain's transfer authorization
	// code. Then call `RetrieveTransferParameters` to confirm that the domain is
	// unlocked and to get values needed to build a call to this method.
	//
	// A successful call creates a `Registration` resource in state
	// `TRANSFER_PENDING`. It can take several days to complete the transfer
	// process. The registrant can often speed up this process by approving the
	// transfer through the current registrar, either by clicking a link in an
	// email from the registrar or by visiting the registrar's website.
	//
	// A few minutes after transfer approval, the resource transitions to state
	// `ACTIVE`, indicating that the transfer was successful. If the transfer is
	// rejected or the request expires without being approved, the resource can
	// end up in state `TRANSFER_FAILED`. If transfer fails, you can safely delete
	// the resource and retry the transfer.
	TransferDomain(ctx context.Context, in *TransferDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the `Registration` resources in a project.
	ListRegistrations(ctx context.Context, in *ListRegistrationsRequest, opts ...grpc.CallOption) (*ListRegistrationsResponse, error)
	// Gets the details of a `Registration` resource.
	GetRegistration(ctx context.Context, in *GetRegistrationRequest, opts ...grpc.CallOption) (*Registration, error)
	// Updates select fields of a `Registration` resource, notably `labels`. To
	// update other fields, use the appropriate custom update method:
	//
	// * To update management settings, see `ConfigureManagementSettings`
	// * To update DNS configuration, see `ConfigureDnsSettings`
	// * To update contact information, see `ConfigureContactSettings`
	UpdateRegistration(ctx context.Context, in *UpdateRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s management settings.
	ConfigureManagementSettings(ctx context.Context, in *ConfigureManagementSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s DNS settings.
	ConfigureDnsSettings(ctx context.Context, in *ConfigureDnsSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s contact settings. Some changes require
	// confirmation by the domain's registrant contact .
	ConfigureContactSettings(ctx context.Context, in *ConfigureContactSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports a `Registration` resource, such that it is no longer managed by
	// Cloud Domains.
	//
	// When an active domain is successfully exported, you can continue to use the
	// domain in [Google Domains](https://domains.google/) until it expires. The
	// calling user becomes the domain's sole owner in Google Domains, and
	// permissions for the domain are subsequently managed there. The domain does
	// not renew automatically unless the new owner sets up billing in Google
	// Domains.
	ExportRegistration(ctx context.Context, in *ExportRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a `Registration` resource.
	//
	// This method works on any `Registration` resource using [Subscription or
	// Commitment billing](/domains/pricing#billing-models), provided that the
	// resource was created at least 1 day in the past.
	//
	// For `Registration` resources using
	// [Monthly billing](/domains/pricing#billing-models), this method works if:
	//
	// * `state` is `EXPORTED` with `expire_time` in the past
	// * `state` is `REGISTRATION_FAILED`
	// * `state` is `TRANSFER_FAILED`
	//
	// When an active registration is successfully deleted, you can continue to
	// use the domain in [Google Domains](https://domains.google/) until it
	// expires. The calling user becomes the domain's sole owner in Google
	// Domains, and permissions for the domain are subsequently managed there. The
	// domain does not renew automatically unless the new owner sets up billing in
	// Google Domains.
	DeleteRegistration(ctx context.Context, in *DeleteRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets the authorization code of the `Registration` for the purpose of
	// transferring the domain to another registrar.
	//
	// You can call this method only after 60 days have elapsed since the initial
	// domain registration.
	RetrieveAuthorizationCode(ctx context.Context, in *RetrieveAuthorizationCodeRequest, opts ...grpc.CallOption) (*AuthorizationCode, error)
	// Resets the authorization code of the `Registration` to a new random string.
	//
	// You can call this method only after 60 days have elapsed since the initial
	// domain registration.
	ResetAuthorizationCode(ctx context.Context, in *ResetAuthorizationCodeRequest, opts ...grpc.CallOption) (*AuthorizationCode, error)
}

type domainsClient struct {
	cc grpc.ClientConnInterface
}

func NewDomainsClient(cc grpc.ClientConnInterface) DomainsClient {
	return &domainsClient{cc}
}

func (c *domainsClient) SearchDomains(ctx context.Context, in *SearchDomainsRequest, opts ...grpc.CallOption) (*SearchDomainsResponse, error) {
	out := new(SearchDomainsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/SearchDomains", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) RetrieveRegisterParameters(ctx context.Context, in *RetrieveRegisterParametersRequest, opts ...grpc.CallOption) (*RetrieveRegisterParametersResponse, error) {
	out := new(RetrieveRegisterParametersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/RetrieveRegisterParameters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) RegisterDomain(ctx context.Context, in *RegisterDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/RegisterDomain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) RetrieveTransferParameters(ctx context.Context, in *RetrieveTransferParametersRequest, opts ...grpc.CallOption) (*RetrieveTransferParametersResponse, error) {
	out := new(RetrieveTransferParametersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/RetrieveTransferParameters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) TransferDomain(ctx context.Context, in *TransferDomainRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/TransferDomain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ListRegistrations(ctx context.Context, in *ListRegistrationsRequest, opts ...grpc.CallOption) (*ListRegistrationsResponse, error) {
	out := new(ListRegistrationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/ListRegistrations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) GetRegistration(ctx context.Context, in *GetRegistrationRequest, opts ...grpc.CallOption) (*Registration, error) {
	out := new(Registration)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/GetRegistration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) UpdateRegistration(ctx context.Context, in *UpdateRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/UpdateRegistration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ConfigureManagementSettings(ctx context.Context, in *ConfigureManagementSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/ConfigureManagementSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ConfigureDnsSettings(ctx context.Context, in *ConfigureDnsSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/ConfigureDnsSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ConfigureContactSettings(ctx context.Context, in *ConfigureContactSettingsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/ConfigureContactSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ExportRegistration(ctx context.Context, in *ExportRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/ExportRegistration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) DeleteRegistration(ctx context.Context, in *DeleteRegistrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/DeleteRegistration", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) RetrieveAuthorizationCode(ctx context.Context, in *RetrieveAuthorizationCodeRequest, opts ...grpc.CallOption) (*AuthorizationCode, error) {
	out := new(AuthorizationCode)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/RetrieveAuthorizationCode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *domainsClient) ResetAuthorizationCode(ctx context.Context, in *ResetAuthorizationCodeRequest, opts ...grpc.CallOption) (*AuthorizationCode, error) {
	out := new(AuthorizationCode)
	err := c.cc.Invoke(ctx, "/google.cloud.domains.v1beta1.Domains/ResetAuthorizationCode", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DomainsServer is the server API for Domains service.
type DomainsServer interface {
	// Searches for available domain names similar to the provided query.
	//
	// Availability results from this method are approximate; call
	// `RetrieveRegisterParameters` on a domain before registering to confirm
	// availability.
	SearchDomains(context.Context, *SearchDomainsRequest) (*SearchDomainsResponse, error)
	// Gets parameters needed to register a new domain name, including price and
	// up-to-date availability. Use the returned values to call `RegisterDomain`.
	RetrieveRegisterParameters(context.Context, *RetrieveRegisterParametersRequest) (*RetrieveRegisterParametersResponse, error)
	// Registers a new domain name and creates a corresponding `Registration`
	// resource.
	//
	// Call `RetrieveRegisterParameters` first to check availability of the domain
	// name and determine parameters like price that are needed to build a call to
	// this method.
	//
	// A successful call creates a `Registration` resource in state
	// `REGISTRATION_PENDING`, which resolves to `ACTIVE` within 1-2
	// minutes, indicating that the domain was successfully registered. If the
	// resource ends up in state `REGISTRATION_FAILED`, it indicates that the
	// domain was not registered successfully, and you can safely delete the
	// resource and retry registration.
	RegisterDomain(context.Context, *RegisterDomainRequest) (*longrunningpb.Operation, error)
	// Gets parameters needed to transfer a domain name from another registrar to
	// Cloud Domains. For domains managed by Google Domains, transferring to Cloud
	// Domains is not supported.
	//
	// Use the returned values to call `TransferDomain`.
	RetrieveTransferParameters(context.Context, *RetrieveTransferParametersRequest) (*RetrieveTransferParametersResponse, error)
	// Transfers a domain name from another registrar to Cloud Domains.  For
	// domains managed by Google Domains, transferring to Cloud Domains is not
	// supported.
	//
	// Before calling this method, go to the domain's current registrar to unlock
	// the domain for transfer and retrieve the domain's transfer authorization
	// code. Then call `RetrieveTransferParameters` to confirm that the domain is
	// unlocked and to get values needed to build a call to this method.
	//
	// A successful call creates a `Registration` resource in state
	// `TRANSFER_PENDING`. It can take several days to complete the transfer
	// process. The registrant can often speed up this process by approving the
	// transfer through the current registrar, either by clicking a link in an
	// email from the registrar or by visiting the registrar's website.
	//
	// A few minutes after transfer approval, the resource transitions to state
	// `ACTIVE`, indicating that the transfer was successful. If the transfer is
	// rejected or the request expires without being approved, the resource can
	// end up in state `TRANSFER_FAILED`. If transfer fails, you can safely delete
	// the resource and retry the transfer.
	TransferDomain(context.Context, *TransferDomainRequest) (*longrunningpb.Operation, error)
	// Lists the `Registration` resources in a project.
	ListRegistrations(context.Context, *ListRegistrationsRequest) (*ListRegistrationsResponse, error)
	// Gets the details of a `Registration` resource.
	GetRegistration(context.Context, *GetRegistrationRequest) (*Registration, error)
	// Updates select fields of a `Registration` resource, notably `labels`. To
	// update other fields, use the appropriate custom update method:
	//
	// * To update management settings, see `ConfigureManagementSettings`
	// * To update DNS configuration, see `ConfigureDnsSettings`
	// * To update contact information, see `ConfigureContactSettings`
	UpdateRegistration(context.Context, *UpdateRegistrationRequest) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s management settings.
	ConfigureManagementSettings(context.Context, *ConfigureManagementSettingsRequest) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s DNS settings.
	ConfigureDnsSettings(context.Context, *ConfigureDnsSettingsRequest) (*longrunningpb.Operation, error)
	// Updates a `Registration`'s contact settings. Some changes require
	// confirmation by the domain's registrant contact .
	ConfigureContactSettings(context.Context, *ConfigureContactSettingsRequest) (*longrunningpb.Operation, error)
	// Exports a `Registration` resource, such that it is no longer managed by
	// Cloud Domains.
	//
	// When an active domain is successfully exported, you can continue to use the
	// domain in [Google Domains](https://domains.google/) until it expires. The
	// calling user becomes the domain's sole owner in Google Domains, and
	// permissions for the domain are subsequently managed there. The domain does
	// not renew automatically unless the new owner sets up billing in Google
	// Domains.
	ExportRegistration(context.Context, *ExportRegistrationRequest) (*longrunningpb.Operation, error)
	// Deletes a `Registration` resource.
	//
	// This method works on any `Registration` resource using [Subscription or
	// Commitment billing](/domains/pricing#billing-models), provided that the
	// resource was created at least 1 day in the past.
	//
	// For `Registration` resources using
	// [Monthly billing](/domains/pricing#billing-models), this method works if:
	//
	// * `state` is `EXPORTED` with `expire_time` in the past
	// * `state` is `REGISTRATION_FAILED`
	// * `state` is `TRANSFER_FAILED`
	//
	// When an active registration is successfully deleted, you can continue to
	// use the domain in [Google Domains](https://domains.google/) until it
	// expires. The calling user becomes the domain's sole owner in Google
	// Domains, and permissions for the domain are subsequently managed there. The
	// domain does not renew automatically unless the new owner sets up billing in
	// Google Domains.
	DeleteRegistration(context.Context, *DeleteRegistrationRequest) (*longrunningpb.Operation, error)
	// Gets the authorization code of the `Registration` for the purpose of
	// transferring the domain to another registrar.
	//
	// You can call this method only after 60 days have elapsed since the initial
	// domain registration.
	RetrieveAuthorizationCode(context.Context, *RetrieveAuthorizationCodeRequest) (*AuthorizationCode, error)
	// Resets the authorization code of the `Registration` to a new random string.
	//
	// You can call this method only after 60 days have elapsed since the initial
	// domain registration.
	ResetAuthorizationCode(context.Context, *ResetAuthorizationCodeRequest) (*AuthorizationCode, error)
}

// UnimplementedDomainsServer can be embedded to have forward compatible implementations.
type UnimplementedDomainsServer struct {
}

func (*UnimplementedDomainsServer) SearchDomains(context.Context, *SearchDomainsRequest) (*SearchDomainsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchDomains not implemented")
}
func (*UnimplementedDomainsServer) RetrieveRegisterParameters(context.Context, *RetrieveRegisterParametersRequest) (*RetrieveRegisterParametersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveRegisterParameters not implemented")
}
func (*UnimplementedDomainsServer) RegisterDomain(context.Context, *RegisterDomainRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterDomain not implemented")
}
func (*UnimplementedDomainsServer) RetrieveTransferParameters(context.Context, *RetrieveTransferParametersRequest) (*RetrieveTransferParametersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveTransferParameters not implemented")
}
func (*UnimplementedDomainsServer) TransferDomain(context.Context, *TransferDomainRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TransferDomain not implemented")
}
func (*UnimplementedDomainsServer) ListRegistrations(context.Context, *ListRegistrationsRequest) (*ListRegistrationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRegistrations not implemented")
}
func (*UnimplementedDomainsServer) GetRegistration(context.Context, *GetRegistrationRequest) (*Registration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRegistration not implemented")
}
func (*UnimplementedDomainsServer) UpdateRegistration(context.Context, *UpdateRegistrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRegistration not implemented")
}
func (*UnimplementedDomainsServer) ConfigureManagementSettings(context.Context, *ConfigureManagementSettingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureManagementSettings not implemented")
}
func (*UnimplementedDomainsServer) ConfigureDnsSettings(context.Context, *ConfigureDnsSettingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureDnsSettings not implemented")
}
func (*UnimplementedDomainsServer) ConfigureContactSettings(context.Context, *ConfigureContactSettingsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConfigureContactSettings not implemented")
}
func (*UnimplementedDomainsServer) ExportRegistration(context.Context, *ExportRegistrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportRegistration not implemented")
}
func (*UnimplementedDomainsServer) DeleteRegistration(context.Context, *DeleteRegistrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRegistration not implemented")
}
func (*UnimplementedDomainsServer) RetrieveAuthorizationCode(context.Context, *RetrieveAuthorizationCodeRequest) (*AuthorizationCode, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetrieveAuthorizationCode not implemented")
}
func (*UnimplementedDomainsServer) ResetAuthorizationCode(context.Context, *ResetAuthorizationCodeRequest) (*AuthorizationCode, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetAuthorizationCode not implemented")
}

func RegisterDomainsServer(s *grpc.Server, srv DomainsServer) {
	s.RegisterService(&_Domains_serviceDesc, srv)
}

func _Domains_SearchDomains_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchDomainsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).SearchDomains(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/SearchDomains",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).SearchDomains(ctx, req.(*SearchDomainsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_RetrieveRegisterParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveRegisterParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).RetrieveRegisterParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/RetrieveRegisterParameters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).RetrieveRegisterParameters(ctx, req.(*RetrieveRegisterParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_RegisterDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).RegisterDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/RegisterDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).RegisterDomain(ctx, req.(*RegisterDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_RetrieveTransferParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveTransferParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).RetrieveTransferParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/RetrieveTransferParameters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).RetrieveTransferParameters(ctx, req.(*RetrieveTransferParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_TransferDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TransferDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).TransferDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/TransferDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).TransferDomain(ctx, req.(*TransferDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ListRegistrations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRegistrationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ListRegistrations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/ListRegistrations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ListRegistrations(ctx, req.(*ListRegistrationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_GetRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRegistrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).GetRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/GetRegistration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).GetRegistration(ctx, req.(*GetRegistrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_UpdateRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRegistrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).UpdateRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/UpdateRegistration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).UpdateRegistration(ctx, req.(*UpdateRegistrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ConfigureManagementSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureManagementSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ConfigureManagementSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/ConfigureManagementSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ConfigureManagementSettings(ctx, req.(*ConfigureManagementSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ConfigureDnsSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureDnsSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ConfigureDnsSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/ConfigureDnsSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ConfigureDnsSettings(ctx, req.(*ConfigureDnsSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ConfigureContactSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigureContactSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ConfigureContactSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/ConfigureContactSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ConfigureContactSettings(ctx, req.(*ConfigureContactSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ExportRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportRegistrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ExportRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/ExportRegistration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ExportRegistration(ctx, req.(*ExportRegistrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_DeleteRegistration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRegistrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).DeleteRegistration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/DeleteRegistration",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).DeleteRegistration(ctx, req.(*DeleteRegistrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_RetrieveAuthorizationCode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetrieveAuthorizationCodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).RetrieveAuthorizationCode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/RetrieveAuthorizationCode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).RetrieveAuthorizationCode(ctx, req.(*RetrieveAuthorizationCodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Domains_ResetAuthorizationCode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetAuthorizationCodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DomainsServer).ResetAuthorizationCode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.domains.v1beta1.Domains/ResetAuthorizationCode",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DomainsServer).ResetAuthorizationCode(ctx, req.(*ResetAuthorizationCodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Domains_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.domains.v1beta1.Domains",
	HandlerType: (*DomainsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchDomains",
			Handler:    _Domains_SearchDomains_Handler,
		},
		{
			MethodName: "RetrieveRegisterParameters",
			Handler:    _Domains_RetrieveRegisterParameters_Handler,
		},
		{
			MethodName: "RegisterDomain",
			Handler:    _Domains_RegisterDomain_Handler,
		},
		{
			MethodName: "RetrieveTransferParameters",
			Handler:    _Domains_RetrieveTransferParameters_Handler,
		},
		{
			MethodName: "TransferDomain",
			Handler:    _Domains_TransferDomain_Handler,
		},
		{
			MethodName: "ListRegistrations",
			Handler:    _Domains_ListRegistrations_Handler,
		},
		{
			MethodName: "GetRegistration",
			Handler:    _Domains_GetRegistration_Handler,
		},
		{
			MethodName: "UpdateRegistration",
			Handler:    _Domains_UpdateRegistration_Handler,
		},
		{
			MethodName: "ConfigureManagementSettings",
			Handler:    _Domains_ConfigureManagementSettings_Handler,
		},
		{
			MethodName: "ConfigureDnsSettings",
			Handler:    _Domains_ConfigureDnsSettings_Handler,
		},
		{
			MethodName: "ConfigureContactSettings",
			Handler:    _Domains_ConfigureContactSettings_Handler,
		},
		{
			MethodName: "ExportRegistration",
			Handler:    _Domains_ExportRegistration_Handler,
		},
		{
			MethodName: "DeleteRegistration",
			Handler:    _Domains_DeleteRegistration_Handler,
		},
		{
			MethodName: "RetrieveAuthorizationCode",
			Handler:    _Domains_RetrieveAuthorizationCode_Handler,
		},
		{
			MethodName: "ResetAuthorizationCode",
			Handler:    _Domains_ResetAuthorizationCode_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/domains/v1beta1/domains.proto",
}
