//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/LocationCapabilityListByLocation.json
func ExampleCapabilitiesClient_ListByLocation() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCapabilitiesClient().ListByLocation(ctx, "eastus", &armsql.CapabilitiesClientListByLocationOptions{Include: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LocationCapabilities = armsql.LocationCapabilities{
	// 	Name: to.Ptr("East US"),
	// 	Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 	SupportedManagedInstanceVersions: []*armsql.ManagedInstanceVersionCapability{
	// 		{
	// 			Name: to.Ptr("12.0"),
	// 			Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 			SupportedEditions: []*armsql.ManagedInstanceEditionCapability{
	// 				{
	// 					Name: to.Ptr("GeneralPurpose"),
	// 					Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 					SupportedFamilies: []*armsql.ManagedInstanceFamilyCapability{
	// 						{
	// 							Name: to.Ptr("Gen4"),
	// 							SKU: to.Ptr("GP_Gen4"),
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedVcoresValues: []*armsql.ManagedInstanceVcoresCapability{
	// 								{
	// 									Name: to.Ptr("8"),
	// 									IncludedMaxSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](262144),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_1"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_2"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									SupportedStorageSizes: []*armsql.MaxSizeRangeCapability{
	// 										{
	// 											MaxValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](8),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitTerabytes),
	// 											},
	// 											MinValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											ScaleSize: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									Value: to.Ptr[int32](8),
	// 								},
	// 								{
	// 									Name: to.Ptr("16"),
	// 									IncludedMaxSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](262144),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_1"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_2"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									SupportedStorageSizes: []*armsql.MaxSizeRangeCapability{
	// 										{
	// 											MaxValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](8),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitTerabytes),
	// 											},
	// 											MinValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											ScaleSize: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									Value: to.Ptr[int32](16),
	// 								},
	// 								{
	// 									Name: to.Ptr("24"),
	// 									IncludedMaxSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](262144),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_1"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_2"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									SupportedStorageSizes: []*armsql.MaxSizeRangeCapability{
	// 										{
	// 											MaxValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](8),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitTerabytes),
	// 											},
	// 											MinValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											ScaleSize: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									Value: to.Ptr[int32](24),
	// 							}},
	// 						},
	// 						{
	// 							Name: to.Ptr("Gen5"),
	// 							SKU: to.Ptr("GP_Gen5"),
	// 							Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedVcoresValues: []*armsql.ManagedInstanceVcoresCapability{
	// 								{
	// 									Name: to.Ptr("8"),
	// 									IncludedMaxSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](262144),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_1"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_2"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									SupportedStorageSizes: []*armsql.MaxSizeRangeCapability{
	// 										{
	// 											MaxValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](8),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitTerabytes),
	// 											},
	// 											MinValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											ScaleSize: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									Value: to.Ptr[int32](8),
	// 								},
	// 								{
	// 									Name: to.Ptr("16"),
	// 									IncludedMaxSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](262144),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_1"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_2"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									SupportedStorageSizes: []*armsql.MaxSizeRangeCapability{
	// 										{
	// 											MaxValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](8),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitTerabytes),
	// 											},
	// 											MinValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											ScaleSize: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									Value: to.Ptr[int32](16),
	// 								},
	// 								{
	// 									Name: to.Ptr("24"),
	// 									IncludedMaxSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](262144),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_1"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 										},
	// 										{
	// 											Name: to.Ptr("SQL_EastUS_MI_2"),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									SupportedStorageSizes: []*armsql.MaxSizeRangeCapability{
	// 										{
	// 											MaxValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](8),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitTerabytes),
	// 											},
	// 											MinValue: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											ScaleSize: &armsql.MaxSizeCapability{
	// 												Limit: to.Ptr[int32](32),
	// 												Unit: to.Ptr(armsql.MaxSizeUnitGigabytes),
	// 											},
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									}},
	// 									Value: to.Ptr[int32](24),
	// 							}},
	// 					}},
	// 					SupportedStorageCapabilities: []*armsql.StorageCapability{
	// 						{
	// 							Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 							StorageAccountType: to.Ptr(armsql.StorageCapabilityStorageAccountTypeGRS),
	// 						},
	// 						{
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							StorageAccountType: to.Ptr(armsql.StorageCapabilityStorageAccountTypeLRS),
	// 						},
	// 						{
	// 							Reason: to.Ptr("ZRS is available in multi-az regions"),
	// 							Status: to.Ptr(armsql.CapabilityStatusVisible),
	// 							StorageAccountType: to.Ptr(armsql.StorageCapabilityStorageAccountTypeZRS),
	// 					}},
	// 				},
	// 				{
	// 					Name: to.Ptr("Hyperscale"),
	// 					Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 					SupportedFamilies: []*armsql.ManagedInstanceFamilyCapability{
	// 						{
	// 							Name: to.Ptr("Gen4"),
	// 							SKU: to.Ptr("HS_Gen4"),
	// 							Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedVcoresValues: []*armsql.ManagedInstanceVcoresCapability{
	// 								{
	// 									Name: to.Ptr("4"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](4),
	// 								},
	// 								{
	// 									Name: to.Ptr("8"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](8),
	// 								},
	// 								{
	// 									Name: to.Ptr("16"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](16),
	// 								},
	// 								{
	// 									Name: to.Ptr("24"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](24),
	// 							}},
	// 						},
	// 						{
	// 							Name: to.Ptr("Gen5"),
	// 							SKU: to.Ptr("HS_Gen5"),
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedVcoresValues: []*armsql.ManagedInstanceVcoresCapability{
	// 								{
	// 									Name: to.Ptr("4"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](4),
	// 								},
	// 								{
	// 									Name: to.Ptr("8"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](8),
	// 								},
	// 								{
	// 									Name: to.Ptr("16"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](16),
	// 								},
	// 								{
	// 									Name: to.Ptr("24"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](24),
	// 								},
	// 								{
	// 									Name: to.Ptr("32"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](32),
	// 								},
	// 								{
	// 									Name: to.Ptr("40"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](40),
	// 								},
	// 								{
	// 									Name: to.Ptr("48"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](48),
	// 								},
	// 								{
	// 									Name: to.Ptr("64"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](64),
	// 								},
	// 								{
	// 									Name: to.Ptr("80"),
	// 									InstancePoolSupported: to.Ptr(true),
	// 									StandaloneSupported: to.Ptr(true),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedMaintenanceConfigurations: []*armsql.ManagedInstanceMaintenanceConfigurationCapability{
	// 										{
	// 											Name: to.Ptr("SQL_Default"),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									}},
	// 									Value: to.Ptr[int32](80),
	// 							}},
	// 					}},
	// 					SupportedStorageCapabilities: []*armsql.StorageCapability{
	// 						{
	// 							Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 							StorageAccountType: to.Ptr(armsql.StorageCapabilityStorageAccountTypeGRS),
	// 						},
	// 						{
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							StorageAccountType: to.Ptr(armsql.StorageCapabilityStorageAccountTypeLRS),
	// 						},
	// 						{
	// 							Reason: to.Ptr("ZRS is available in multi-az regions"),
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							StorageAccountType: to.Ptr(armsql.StorageCapabilityStorageAccountTypeZRS),
	// 					}},
	// 			}},
	// 			SupportedInstancePoolEditions: []*armsql.InstancePoolEditionCapability{
	// 				{
	// 					Name: to.Ptr("GeneralPurpose"),
	// 					Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 					SupportedFamilies: []*armsql.InstancePoolFamilyCapability{
	// 						{
	// 							Name: to.Ptr("Gen5"),
	// 							Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedVcoresValues: []*armsql.InstancePoolVcoresCapability{
	// 								{
	// 									Name: to.Ptr("GP_Gen5_8"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									StorageLimit: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](8388608),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Value: to.Ptr[int32](8),
	// 								},
	// 								{
	// 									Name: to.Ptr("GP_Gen5_16"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									StorageLimit: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](8388608),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Value: to.Ptr[int32](16),
	// 								},
	// 								{
	// 									Name: to.Ptr("GP_Gen5_24"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									StorageLimit: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](8388608),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Value: to.Ptr[int32](24),
	// 								},
	// 								{
	// 									Name: to.Ptr("GP_Gen5_32"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									StorageLimit: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](8388608),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Value: to.Ptr[int32](32),
	// 								},
	// 								{
	// 									Name: to.Ptr("GP_Gen5_40"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									StorageLimit: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](8388608),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Value: to.Ptr[int32](40),
	// 								},
	// 								{
	// 									Name: to.Ptr("GP_Gen5_64"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									StorageLimit: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](8388608),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Value: to.Ptr[int32](64),
	// 								},
	// 								{
	// 									Name: to.Ptr("GP_Gen5_80"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									StorageLimit: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](8388608),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Value: to.Ptr[int32](80),
	// 							}},
	// 					}},
	// 			}},
	// 	}},
	// 	SupportedServerVersions: []*armsql.ServerVersionCapability{
	// 		{
	// 			Name: to.Ptr("12.0"),
	// 			Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 			SupportedEditions: []*armsql.EditionCapability{
	// 				{
	// 					Name: to.Ptr("Hyperscale"),
	// 					ReadScale: &armsql.ReadScaleCapability{
	// 						MaxNumberOfReplicas: to.Ptr[int32](4),
	// 					},
	// 					Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 					SupportedServiceLevelObjectives: []*armsql.ServiceObjectiveCapability{
	// 						{
	// 							Name: to.Ptr("HS_Gen4_1"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("9380cd0e-b025-4e9d-829c-c1918c1614bb"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](1),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](1),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_2"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("34497c3f-24b9-4cee-968d-6e5e854670fe"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](2),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](2),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_2"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("a420d2b2-ca32-4152-b1c6-dd8d4d9fd734"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](2),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](2),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_3"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("5de845d2-2055-428c-b507-94131358cdd7"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](3),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](3),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_4"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("d060b874-21f3-47b0-a9bd-a1a737cfcc6e"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](4),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](4),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_4"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("60dba88b-2dfa-4123-be57-bd0dbfd92a72"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](4),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](4),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_5"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("925a0916-15fb-4764-aa76-533d97f2d782"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](5),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](5),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_6"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("d7aa11c2-e4c7-442a-962e-308b371f5ec1"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](6),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](6),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_6"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("b9c594ec-a3fe-4bfe-808d-a595410d0a07"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](6),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](6),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_7"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("d77eef57-6c00-4003-b140-822509b8736a"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](7),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](7),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_8"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("694bf389-7cb2-4461-8fa2-0b06d8438315"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](8),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](8),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_8"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("efdfac5f-3f8e-4500-95b1-684c07349860"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](8),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](8),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_9"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("554ea52a-9ecc-4d87-bbc7-1e257705da3f"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](9),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](9),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_10"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("576f3f38-b950-4eaa-b74e-33d831193441"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](10),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](10),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_10"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("69697c3a-1946-4eb8-a5a4-a269168dde27"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](10),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](10),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_12"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("1bee9dc8-68b4-44df-b870-8ab0e4d71e94"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](12),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](12),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_14"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("07a8341d-c0b2-4000-bc7a-5b4dae2ad210"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](14),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](14),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_16"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("7fc1f700-a45d-499e-901f-2a00645c54db"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](16),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](16),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_16"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("6b56f70b-52e5-44ba-8cd5-4f63d224b206"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](16),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](16),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_18"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("ba0029f2-3ff4-4ef6-9e65-e8f77b5dd1e2"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](18),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](18),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_20"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("f1b2a082-f622-4fb8-bbef-e74deac3ec89"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](20),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](20),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen4_24"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("f016d419-a031-4b93-ab62-7f3d2a789376"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](24),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen4"),
	// 								Capacity: to.Ptr[int32](24),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_24"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("222bc0ee-e195-4bbc-be05-3b849c3a8195"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](24),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](24),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_32"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("05366cca-cc70-486e-a697-bb3fab877f75"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](32),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](32),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_40"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("32542ef7-124d-4e66-8b41-9c6c0ab963c2"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](40),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](40),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							Name: to.Ptr("HS_Gen5_80"),
	// 							ComputeModel: to.Ptr("Provisioned"),
	// 							ID: to.Ptr("6509db45-febe-44dd-a079-35f11d477984"),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](80),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("HS_Gen5"),
	// 								Capacity: to.Ptr[int32](80),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("Hyperscale"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 					}},
	// 					SupportedStorageCapabilities: []*armsql.StorageCapability{
	// 						{
	// 							Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 							StorageAccountType: to.Ptr(armsql.StorageCapabilityStorageAccountTypeGRS),
	// 						},
	// 						{
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							StorageAccountType: to.Ptr(armsql.StorageCapabilityStorageAccountTypeLRS),
	// 						},
	// 						{
	// 							Reason: to.Ptr("ZRS is available in multi-az regions"),
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							StorageAccountType: to.Ptr(armsql.StorageCapabilityStorageAccountTypeZRS),
	// 					}},
	// 					ZoneRedundant: to.Ptr(false),
	// 			}},
	// 			SupportedElasticPoolEditions: []*armsql.ElasticPoolEditionCapability{
	// 				{
	// 					Name: to.Ptr("BusinessCritical"),
	// 					Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 					SupportedElasticPoolPerformanceLevels: []*armsql.ElasticPoolPerformanceLevelCapability{
	// 						{
	// 							MaxDatabaseCount: to.Ptr[int32](100),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](3),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("BC_Gen4"),
	// 								Capacity: to.Ptr[int32](3),
	// 								Family: to.Ptr("Gen4"),
	// 								Tier: to.Ptr("BusinessCritical"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 								},
	// 								{
	// 									Name: to.Ptr("SQL_EastUS_DB_1"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									ZoneRedundant: to.Ptr(false),
	// 								},
	// 								{
	// 									Name: to.Ptr("SQL_EastUS_DB_2"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							SupportedMaxSizes: []*armsql.MaxSizeRangeCapability{
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](30),
	// 										Unit: to.Ptr(armsql.LogSizeUnitPercent),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](31744),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 								},
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](30),
	// 										Unit: to.Ptr(armsql.LogSizeUnitPercent),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](0),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](30),
	// 										Unit: to.Ptr(armsql.LogSizeUnitPercent),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1048576),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](33792),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedPerDatabaseMaxPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMaxPerformanceLevelCapability{
	// 								{
	// 									Limit: to.Ptr[float64](0.25),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](0.5),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](1),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](1),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](2),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](1),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](2),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](3),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](1),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](2),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](3),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 							}},
	// 							SupportedPerDatabaseMaxSizes: []*armsql.MaxSizeRangeCapability{
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](31744),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 								},
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](0),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1048576),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](33792),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 						},
	// 						{
	// 							MaxDatabaseCount: to.Ptr[int32](100),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](12),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("BC_Gen5"),
	// 								Capacity: to.Ptr[int32](12),
	// 								Family: to.Ptr("Gen5"),
	// 								Tier: to.Ptr("BusinessCritical"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 								},
	// 								{
	// 									Name: to.Ptr("SQL_EastUS_DB_1"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									ZoneRedundant: to.Ptr(false),
	// 								},
	// 								{
	// 									Name: to.Ptr("SQL_EastUS_DB_2"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							SupportedMaxSizes: []*armsql.MaxSizeRangeCapability{
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](30),
	// 										Unit: to.Ptr(armsql.LogSizeUnitPercent),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](31744),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 								},
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](30),
	// 										Unit: to.Ptr(armsql.LogSizeUnitPercent),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](0),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](30),
	// 										Unit: to.Ptr(armsql.LogSizeUnitPercent),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](3144704),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](33792),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 								},
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](1048576),
	// 										Unit: to.Ptr(armsql.LogSizeUnitMegabytes),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](3145728),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](3145728),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](0),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedPerDatabaseMaxPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMaxPerformanceLevelCapability{
	// 								{
	// 									Limit: to.Ptr[float64](0.25),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](0.5),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](1),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](1),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](2),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](1),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](2),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](4),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](1),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](2),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](4),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](6),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](1),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](2),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](4),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](6),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](8),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](1),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](2),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](4),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](6),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](10),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](1),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](2),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](4),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](6),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](12),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.25),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](0.5),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](1),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](2),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](4),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](6),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 							}},
	// 							SupportedPerDatabaseMaxSizes: []*armsql.MaxSizeRangeCapability{
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](31744),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 								},
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](0),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](3144704),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](33792),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 								},
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](3145728),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](3145728),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](0),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							ZoneRedundant: to.Ptr(true),
	// 						},
	// 						{
	// 							MaxDatabaseCount: to.Ptr[int32](100),
	// 							PerformanceLevel: &armsql.PerformanceLevelCapability{
	// 								Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								Value: to.Ptr[float64](128),
	// 							},
	// 							SKU: &armsql.SKU{
	// 								Name: to.Ptr("BC_M"),
	// 								Capacity: to.Ptr[int32](128),
	// 								Family: to.Ptr("M"),
	// 								Tier: to.Ptr("BusinessCritical"),
	// 							},
	// 							Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							SupportedLicenseTypes: []*armsql.LicenseTypeCapability{
	// 								{
	// 									Name: to.Ptr("LicenseIncluded"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									Name: to.Ptr("BasePrice"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedMaintenanceConfigurations: []*armsql.MaintenanceConfigurationCapability{
	// 								{
	// 									Name: to.Ptr("SQL_Default"),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									ZoneRedundant: to.Ptr(false),
	// 								},
	// 								{
	// 									Name: to.Ptr("SQL_EastUS_DB_1"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									ZoneRedundant: to.Ptr(false),
	// 								},
	// 								{
	// 									Name: to.Ptr("SQL_EastUS_DB_2"),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									ZoneRedundant: to.Ptr(false),
	// 							}},
	// 							SupportedMaxSizes: []*armsql.MaxSizeRangeCapability{
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](30),
	// 										Unit: to.Ptr(armsql.LogSizeUnitPercent),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](31744),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 								},
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](30),
	// 										Unit: to.Ptr(armsql.LogSizeUnitPercent),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](0),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](30),
	// 										Unit: to.Ptr(armsql.LogSizeUnitPercent),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](3144704),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](33792),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 								},
	// 								{
	// 									LogSize: &armsql.LogSizeCapability{
	// 										Limit: to.Ptr[int32](1048576),
	// 										Unit: to.Ptr(armsql.LogSizeUnitMegabytes),
	// 									},
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](4194304),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](3145728),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							SupportedPerDatabaseMaxPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMaxPerformanceLevelCapability{
	// 								{
	// 									Limit: to.Ptr[float64](8),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](10),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](12),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](14),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](14),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](16),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](14),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](16),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](18),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](14),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](16),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](18),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](20),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](14),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](16),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](18),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](20),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](24),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](14),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](16),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](18),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](20),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](24),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](32),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](14),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](16),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](18),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](20),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](24),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](32),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](40),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](14),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](16),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](18),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](20),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](24),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](32),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](40),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](64),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](14),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](16),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](18),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](20),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](24),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](32),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](40),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](64),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](80),
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](14),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](16),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](18),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](20),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](24),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](32),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](40),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](64),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](80),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 								},
	// 								{
	// 									Limit: to.Ptr[float64](128),
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 									SupportedPerDatabaseMinPerformanceLevels: []*armsql.ElasticPoolPerDatabaseMinPerformanceLevelCapability{
	// 										{
	// 											Limit: to.Ptr[float64](0),
	// 											Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](8),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](10),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](12),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](14),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](16),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](18),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](20),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](24),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](32),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](40),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](64),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](80),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 										},
	// 										{
	// 											Limit: to.Ptr[float64](128),
	// 											Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 											Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 									}},
	// 									Unit: to.Ptr(armsql.PerformanceLevelUnitVCores),
	// 							}},
	// 							SupportedPerDatabaseMaxSizes: []*armsql.MaxSizeRangeCapability{
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](31744),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 								},
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](32768),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](0),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusDefault),
	// 								},
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](3144704),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](33792),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 								},
	// 								{
	// 									MaxValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](4194304),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									MinValue: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](3145728),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									ScaleSize: &armsql.MaxSizeCapability{
	// 										Limit: to.Ptr[int32](1024),
	// 										Unit: to.Ptr(armsql.MaxSizeUnitMegabytes),
	// 									},
	// 									Status: to.Ptr(armsql.CapabilityStatusAvailable),
	// 							}},
	// 							ZoneRedundant: to.Ptr(false),
	// 					}},
	// 					ZoneRedundant: to.Ptr(false),
	// 			}},
	// 	}},
	// }
}
