//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsaas

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// OperationClient contains the methods for the SaaSOperation group.
// Don't use this type directly, use NewOperationClient() instead.
type OperationClient struct {
	internal *arm.Client
}

// NewOperationClient creates a new instance of OperationClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewOperationClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*OperationClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &OperationClient{
		internal: cl,
	}
	return client, nil
}

// BeginGet - Gets information about the specified operation progress.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-01-beta
//   - operationID - the operation Id parameter.
//   - options - OperationClientBeginGetOptions contains the optional parameters for the OperationClient.BeginGet method.
func (client *OperationClient) BeginGet(ctx context.Context, operationID string, options *OperationClientBeginGetOptions) (*runtime.Poller[OperationClientGetResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.get(ctx, operationID, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[OperationClientGetResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[OperationClientGetResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Get - Gets information about the specified operation progress.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2018-03-01-beta
func (client *OperationClient) get(ctx context.Context, operationID string, options *OperationClientBeginGetOptions) (*http.Response, error) {
	var err error
	const operationName = "OperationClient.BeginGet"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, operationID, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// getCreateRequest creates the Get request.
func (client *OperationClient) getCreateRequest(ctx context.Context, operationID string, options *OperationClientBeginGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.SaaS/operationResults/{operationId}"
	if operationID == "" {
		return nil, errors.New("parameter operationID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{operationId}", url.PathEscape(operationID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2018-03-01-beta")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
