//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdynatrace_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dynatrace/armdynatrace/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListMonitoredResources_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListMonitoredResourcesPager_monitorsListMonitoredResourcesMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListMonitoredResourcesPager("myResourceGroup", "myMonitor", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MonitoredResourceListResponse = armdynatrace.MonitoredResourceListResponse{
		// 	Value: []*armdynatrace.MonitoredResource{
		// 		{
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/monitors/myMonitor/listMonitoredResources"),
		// 			ReasonForLogsStatus: to.Ptr("CapturedByRules"),
		// 			ReasonForMetricsStatus: to.Ptr("CapturedByRules"),
		// 			SendingLogs: to.Ptr(armdynatrace.SendingLogsStatusEnabled),
		// 			SendingMetrics: to.Ptr(armdynatrace.SendingMetricsStatusEnabled),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListMonitoredResources_MinimumSet_Gen.json
func ExampleMonitorsClient_NewListMonitoredResourcesPager_monitorsListMonitoredResourcesMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListMonitoredResourcesPager("myResourceGroup", "myMonitor", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MonitoredResourceListResponse = armdynatrace.MonitoredResourceListResponse{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_GetVMHostPayload_MaximumSet_Gen.json
func ExampleMonitorsClient_GetVMHostPayload_monitorsGetVmHostPayloadMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetVMHostPayload(ctx, "myResourceGroup", "myMonitor", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VMExtensionPayload = armdynatrace.VMExtensionPayload{
	// 	EnvironmentID: to.Ptr("abc123lsjlsfjlfjgd"),
	// 	IngestionKey: to.Ptr("abcd.efg"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_GetVMHostPayload_MinimumSet_Gen.json
func ExampleMonitorsClient_GetVMHostPayload_monitorsGetVmHostPayloadMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetVMHostPayload(ctx, "myResourceGroup", "myMonitor", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VMExtensionPayload = armdynatrace.VMExtensionPayload{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_Get_MaximumSet_Gen.json
func ExampleMonitorsClient_Get_monitorsGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().Get(ctx, "myResourceGroup", "myMonitor", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MonitorResource = armdynatrace.MonitorResource{
	// 	Name: to.Ptr("myMonitor"),
	// 	Type: to.Ptr("Dynatrace.Observability/monitors"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/monitors/myMonitor"),
	// 	Location: to.Ptr("West US 2"),
	// 	Tags: map[string]*string{
	// 		"Environment": to.Ptr("Dev"),
	// 	},
	// 	Identity: &armdynatrace.IdentityProperties{
	// 		Type: to.Ptr(armdynatrace.ManagedIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("4534676867978"),
	// 		TenantID: to.Ptr("23456789001"),
	// 	},
	// 	Properties: &armdynatrace.MonitorProperties{
	// 		DynatraceEnvironmentProperties: &armdynatrace.EnvironmentProperties{
	// 			AccountInfo: &armdynatrace.AccountInfo{
	// 				AccountID: to.Ptr("1234567890"),
	// 				RegionID: to.Ptr("wus2"),
	// 			},
	// 			EnvironmentInfo: &armdynatrace.EnvironmentInfo{
	// 				EnvironmentID: to.Ptr("a23xcv456"),
	// 				IngestionKey: to.Ptr("1234567890"),
	// 				LandingURL: to.Ptr("https://a23xcv456.dynatrace.com"),
	// 				LogsIngestionEndpoint: to.Ptr("https://dynatrace.com"),
	// 			},
	// 			SingleSignOnProperties: &armdynatrace.SingleSignOnProperties{
	// 				AADDomains: []*string{
	// 					to.Ptr("mpliftrdt20210811outlook.onmicrosoft.com")},
	// 					EnterpriseAppID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					SingleSignOnState: to.Ptr(armdynatrace.SingleSignOnStatesEnable),
	// 					SingleSignOnURL: to.Ptr("https://www.dynatrace.io/IAmSomeHash"),
	// 				},
	// 				UserID: to.Ptr("alice123"),
	// 			},
	// 			LiftrResourceCategory: to.Ptr(armdynatrace.LiftrResourceCategoriesUnknown),
	// 			LiftrResourcePreference: to.Ptr[int32](28),
	// 			MarketplaceSubscriptionStatus: to.Ptr(armdynatrace.MarketplaceSubscriptionStatusActive),
	// 			MonitoringStatus: to.Ptr(armdynatrace.MonitoringStatusEnabled),
	// 			PlanData: &armdynatrace.PlanData{
	// 				BillingCycle: to.Ptr("Monthly"),
	// 				EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-30T13:14:33.000Z"); return t}()),
	// 				PlanDetails: to.Ptr("dynatraceapitestplan"),
	// 				UsageType: to.Ptr("Committed"),
	// 			},
	// 			ProvisioningState: to.Ptr(armdynatrace.ProvisioningStateSucceeded),
	// 			UserInfo: &armdynatrace.UserInfo{
	// 				Country: to.Ptr("westus2"),
	// 				EmailAddress: to.Ptr("alice@microsoft.com"),
	// 				FirstName: to.Ptr("Alice"),
	// 				LastName: to.Ptr("Bobab"),
	// 				PhoneNumber: to.Ptr("123456"),
	// 			},
	// 		},
	// 		SystemData: &armdynatrace.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-16T04:25:21.040Z"); return t}()),
	// 			CreatedBy: to.Ptr("alice@microsoft.com"),
	// 			CreatedByType: to.Ptr(armdynatrace.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-16T04:25:21.040Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("alice@microsoft.com"),
	// 			LastModifiedByType: to.Ptr(armdynatrace.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_Get_MinimumSet_Gen.json
func ExampleMonitorsClient_Get_monitorsGetMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().Get(ctx, "myResourceGroup", "myMonitor", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MonitorResource = armdynatrace.MonitorResource{
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/monitors/myMonitor"),
	// 	Location: to.Ptr("West US 2"),
	// 	Properties: &armdynatrace.MonitorProperties{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_CreateOrUpdate_MaximumSet_Gen.json
func ExampleMonitorsClient_BeginCreateOrUpdate_monitorsCreateOrUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMonitorsClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myMonitor", armdynatrace.MonitorResource{
		Location: to.Ptr("West US 2"),
		Tags: map[string]*string{
			"Environment": to.Ptr("Dev"),
		},
		Identity: &armdynatrace.IdentityProperties{
			Type: to.Ptr(armdynatrace.ManagedIdentityTypeSystemAssigned),
		},
		Properties: &armdynatrace.MonitorProperties{
			DynatraceEnvironmentProperties: &armdynatrace.EnvironmentProperties{
				AccountInfo:            &armdynatrace.AccountInfo{},
				EnvironmentInfo:        &armdynatrace.EnvironmentInfo{},
				SingleSignOnProperties: &armdynatrace.SingleSignOnProperties{},
			},
			LiftrResourceCategory:         to.Ptr(armdynatrace.LiftrResourceCategoriesUnknown),
			MarketplaceSubscriptionStatus: to.Ptr(armdynatrace.MarketplaceSubscriptionStatusActive),
			MonitoringStatus:              to.Ptr(armdynatrace.MonitoringStatusEnabled),
			PlanData: &armdynatrace.PlanData{
				BillingCycle:  to.Ptr("Monthly"),
				EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-30T13:14:33.000Z"); return t }()),
				PlanDetails:   to.Ptr("dynatraceapitestplan"),
				UsageType:     to.Ptr("Committed"),
			},
			ProvisioningState: to.Ptr(armdynatrace.ProvisioningStateAccepted),
			UserInfo: &armdynatrace.UserInfo{
				Country:      to.Ptr("westus2"),
				EmailAddress: to.Ptr("alice@microsoft.com"),
				FirstName:    to.Ptr("Alice"),
				LastName:     to.Ptr("Bobab"),
				PhoneNumber:  to.Ptr("123456"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MonitorResource = armdynatrace.MonitorResource{
	// 	Name: to.Ptr("myMonitor"),
	// 	Type: to.Ptr("Dynatrace.Observability/monitors"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/monitors/myMonitor"),
	// 	Location: to.Ptr("West US 2"),
	// 	Tags: map[string]*string{
	// 		"Environment": to.Ptr("Dev"),
	// 	},
	// 	Identity: &armdynatrace.IdentityProperties{
	// 		Type: to.Ptr(armdynatrace.ManagedIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("4534676867978"),
	// 		TenantID: to.Ptr("23456789001"),
	// 	},
	// 	Properties: &armdynatrace.MonitorProperties{
	// 		DynatraceEnvironmentProperties: &armdynatrace.EnvironmentProperties{
	// 			AccountInfo: &armdynatrace.AccountInfo{
	// 				AccountID: to.Ptr("1234567890"),
	// 				RegionID: to.Ptr("wus2"),
	// 			},
	// 			EnvironmentInfo: &armdynatrace.EnvironmentInfo{
	// 				EnvironmentID: to.Ptr("a23xcv456"),
	// 				IngestionKey: to.Ptr("1234567890"),
	// 				LogsIngestionEndpoint: to.Ptr("https://dynatrace.com"),
	// 			},
	// 			SingleSignOnProperties: &armdynatrace.SingleSignOnProperties{
	// 				AADDomains: []*string{
	// 					to.Ptr("mpliftrdt20210811outlook.onmicrosoft.com")},
	// 					EnterpriseAppID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					SingleSignOnState: to.Ptr(armdynatrace.SingleSignOnStatesEnable),
	// 					SingleSignOnURL: to.Ptr("https://www.dynatrace.io/IAmSomeHash"),
	// 				},
	// 				UserID: to.Ptr("alice123"),
	// 			},
	// 			LiftrResourceCategory: to.Ptr(armdynatrace.LiftrResourceCategoriesUnknown),
	// 			LiftrResourcePreference: to.Ptr[int32](28),
	// 			MarketplaceSubscriptionStatus: to.Ptr(armdynatrace.MarketplaceSubscriptionStatusActive),
	// 			MonitoringStatus: to.Ptr(armdynatrace.MonitoringStatusEnabled),
	// 			PlanData: &armdynatrace.PlanData{
	// 				BillingCycle: to.Ptr("Monthly"),
	// 				EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-30T13:14:33.000Z"); return t}()),
	// 				PlanDetails: to.Ptr("dynatraceapitestplan"),
	// 				UsageType: to.Ptr("Committed"),
	// 			},
	// 			ProvisioningState: to.Ptr(armdynatrace.ProvisioningStateSucceeded),
	// 			UserInfo: &armdynatrace.UserInfo{
	// 				Country: to.Ptr("westus2"),
	// 				EmailAddress: to.Ptr("alice@microsoft.com"),
	// 				FirstName: to.Ptr("Alice"),
	// 				LastName: to.Ptr("Bobab"),
	// 				PhoneNumber: to.Ptr("123456"),
	// 			},
	// 		},
	// 		SystemData: &armdynatrace.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-16T04:25:21.040Z"); return t}()),
	// 			CreatedBy: to.Ptr("alice@microsoft.com"),
	// 			CreatedByType: to.Ptr(armdynatrace.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-16T04:25:21.040Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("alice@microsoft.com"),
	// 			LastModifiedByType: to.Ptr(armdynatrace.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_CreateOrUpdate_MinimumSet_Gen.json
func ExampleMonitorsClient_BeginCreateOrUpdate_monitorsCreateOrUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMonitorsClient().BeginCreateOrUpdate(ctx, "myResourceGroup", "myMonitor", armdynatrace.MonitorResource{
		Location:   to.Ptr("West US 2"),
		Properties: &armdynatrace.MonitorProperties{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MonitorResource = armdynatrace.MonitorResource{
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/monitors/myMonitor"),
	// 	Location: to.Ptr("West US 2"),
	// 	Properties: &armdynatrace.MonitorProperties{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_Update_MaximumSet_Gen.json
func ExampleMonitorsClient_Update_monitorsUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().Update(ctx, "myResourceGroup", "myMonitor", armdynatrace.MonitorResourceUpdate{
		Tags: map[string]*string{
			"Environment": to.Ptr("Dev"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MonitorResource = armdynatrace.MonitorResource{
	// 	Name: to.Ptr("myMonitor"),
	// 	Type: to.Ptr("Dynatrace.Observability/monitors"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/monitors/myMonitor"),
	// 	Location: to.Ptr("West US 2"),
	// 	Tags: map[string]*string{
	// 		"Environment": to.Ptr("Dev"),
	// 	},
	// 	Identity: &armdynatrace.IdentityProperties{
	// 		Type: to.Ptr(armdynatrace.ManagedIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("4534676867978"),
	// 		TenantID: to.Ptr("23456789001"),
	// 	},
	// 	Properties: &armdynatrace.MonitorProperties{
	// 		DynatraceEnvironmentProperties: &armdynatrace.EnvironmentProperties{
	// 			AccountInfo: &armdynatrace.AccountInfo{
	// 				AccountID: to.Ptr("1234567890"),
	// 				RegionID: to.Ptr("wus2"),
	// 			},
	// 			EnvironmentInfo: &armdynatrace.EnvironmentInfo{
	// 				EnvironmentID: to.Ptr("a23xcv456"),
	// 				IngestionKey: to.Ptr("1234567890"),
	// 				LandingURL: to.Ptr("https://a23xcv456.dynatrace.com"),
	// 				LogsIngestionEndpoint: to.Ptr("https://dynatrace.com"),
	// 			},
	// 			SingleSignOnProperties: &armdynatrace.SingleSignOnProperties{
	// 				AADDomains: []*string{
	// 					to.Ptr("mpliftrdt20210811outlook.onmicrosoft.com")},
	// 					EnterpriseAppID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 					SingleSignOnState: to.Ptr(armdynatrace.SingleSignOnStatesEnable),
	// 					SingleSignOnURL: to.Ptr("https://www.dynatrace.io/IAmSomeHash"),
	// 				},
	// 				UserID: to.Ptr("alice123"),
	// 			},
	// 			LiftrResourceCategory: to.Ptr(armdynatrace.LiftrResourceCategoriesUnknown),
	// 			LiftrResourcePreference: to.Ptr[int32](28),
	// 			MarketplaceSubscriptionStatus: to.Ptr(armdynatrace.MarketplaceSubscriptionStatusActive),
	// 			MonitoringStatus: to.Ptr(armdynatrace.MonitoringStatusEnabled),
	// 			PlanData: &armdynatrace.PlanData{
	// 				BillingCycle: to.Ptr("Monthly"),
	// 				EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-30T13:14:33.000Z"); return t}()),
	// 				PlanDetails: to.Ptr("dynatraceapitestplan"),
	// 				UsageType: to.Ptr("Committed"),
	// 			},
	// 			ProvisioningState: to.Ptr(armdynatrace.ProvisioningStateSucceeded),
	// 			UserInfo: &armdynatrace.UserInfo{
	// 				Country: to.Ptr("westus2"),
	// 				EmailAddress: to.Ptr("alice@microsoft.com"),
	// 				FirstName: to.Ptr("Alice"),
	// 				LastName: to.Ptr("Bobab"),
	// 				PhoneNumber: to.Ptr("123456"),
	// 			},
	// 		},
	// 		SystemData: &armdynatrace.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-16T04:25:21.040Z"); return t}()),
	// 			CreatedBy: to.Ptr("alice@microsoft.com"),
	// 			CreatedByType: to.Ptr(armdynatrace.CreatedByTypeUser),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-16T04:25:21.040Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("alice@microsoft.com"),
	// 			LastModifiedByType: to.Ptr(armdynatrace.CreatedByTypeUser),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_Update_MinimumSet_Gen.json
func ExampleMonitorsClient_Update_monitorsUpdateMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().Update(ctx, "myResourceGroup", "myMonitor", armdynatrace.MonitorResourceUpdate{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MonitorResource = armdynatrace.MonitorResource{
	// 	Location: to.Ptr("West US 2"),
	// 	Properties: &armdynatrace.MonitorProperties{
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_Delete_MaximumSet_Gen.json
func ExampleMonitorsClient_BeginDelete_monitorsDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMonitorsClient().BeginDelete(ctx, "myResourceGroup", "myMonitor", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_Delete_MinimumSet_Gen.json
func ExampleMonitorsClient_BeginDelete_monitorsDeleteMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewMonitorsClient().BeginDelete(ctx, "myResourceGroup", "myMonitor", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListBySubscriptionId_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListBySubscriptionIDPager_monitorsListBySubscriptionIdMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListBySubscriptionIDPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MonitorResourceListResult = armdynatrace.MonitorResourceListResult{
		// 	Value: []*armdynatrace.MonitorResource{
		// 		{
		// 			Name: to.Ptr("myMonitor"),
		// 			Type: to.Ptr("Dynatrace.Observability/monitors"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/monitors/myMonitor"),
		// 			Location: to.Ptr("West US 2"),
		// 			Tags: map[string]*string{
		// 				"Environment": to.Ptr("Dev"),
		// 			},
		// 			Identity: &armdynatrace.IdentityProperties{
		// 				Type: to.Ptr(armdynatrace.ManagedIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("4534676867978"),
		// 				TenantID: to.Ptr("23456789001"),
		// 			},
		// 			Properties: &armdynatrace.MonitorProperties{
		// 				DynatraceEnvironmentProperties: &armdynatrace.EnvironmentProperties{
		// 					AccountInfo: &armdynatrace.AccountInfo{
		// 						AccountID: to.Ptr("1234567890"),
		// 						RegionID: to.Ptr("wus2"),
		// 					},
		// 					EnvironmentInfo: &armdynatrace.EnvironmentInfo{
		// 						EnvironmentID: to.Ptr("a23xcv456"),
		// 						IngestionKey: to.Ptr("1234567890"),
		// 						LandingURL: to.Ptr("https://a23xcv456.dynatrace.com"),
		// 						LogsIngestionEndpoint: to.Ptr("https://dynatrace.com"),
		// 					},
		// 					SingleSignOnProperties: &armdynatrace.SingleSignOnProperties{
		// 						AADDomains: []*string{
		// 							to.Ptr("mpliftrdt20210811outlook.onmicrosoft.com")},
		// 							EnterpriseAppID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 							SingleSignOnState: to.Ptr(armdynatrace.SingleSignOnStatesEnable),
		// 							SingleSignOnURL: to.Ptr("https://www.dynatrace.io/IAmSomeHash"),
		// 						},
		// 						UserID: to.Ptr("alice123"),
		// 					},
		// 					LiftrResourceCategory: to.Ptr(armdynatrace.LiftrResourceCategoriesUnknown),
		// 					LiftrResourcePreference: to.Ptr[int32](28),
		// 					MarketplaceSubscriptionStatus: to.Ptr(armdynatrace.MarketplaceSubscriptionStatusActive),
		// 					MonitoringStatus: to.Ptr(armdynatrace.MonitoringStatusEnabled),
		// 					PlanData: &armdynatrace.PlanData{
		// 						BillingCycle: to.Ptr("Monthly"),
		// 						EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-30T13:14:33.000Z"); return t}()),
		// 						PlanDetails: to.Ptr("dynatraceapitestplan"),
		// 						UsageType: to.Ptr("Committed"),
		// 					},
		// 					ProvisioningState: to.Ptr(armdynatrace.ProvisioningStateSucceeded),
		// 					UserInfo: &armdynatrace.UserInfo{
		// 						Country: to.Ptr("westus2"),
		// 						EmailAddress: to.Ptr("alice@microsoft.com"),
		// 						FirstName: to.Ptr("Alice"),
		// 						LastName: to.Ptr("Bobab"),
		// 						PhoneNumber: to.Ptr("123456"),
		// 					},
		// 				},
		// 				SystemData: &armdynatrace.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-16T04:25:21.040Z"); return t}()),
		// 					CreatedBy: to.Ptr("alice@microsoft.com"),
		// 					CreatedByType: to.Ptr(armdynatrace.CreatedByTypeUser),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-16T04:25:21.040Z"); return t}()),
		// 					LastModifiedBy: to.Ptr("alice@microsoft.com"),
		// 					LastModifiedByType: to.Ptr(armdynatrace.CreatedByTypeUser),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListBySubscriptionId_MinimumSet_Gen.json
func ExampleMonitorsClient_NewListBySubscriptionIDPager_monitorsListBySubscriptionIdMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListBySubscriptionIDPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MonitorResourceListResult = armdynatrace.MonitorResourceListResult{
		// 	Value: []*armdynatrace.MonitorResource{
		// 		{
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Dynatrace.Observability/monitors/myMonitor/tagRules/default"),
		// 			Location: to.Ptr("West US 2"),
		// 			Properties: &armdynatrace.MonitorProperties{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListByResourceGroup_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListByResourceGroupPager_monitorsListByResourceGroupMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListByResourceGroupPager("myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MonitorResourceListResult = armdynatrace.MonitorResourceListResult{
		// 	Value: []*armdynatrace.MonitorResource{
		// 		{
		// 			Name: to.Ptr("myMonitor"),
		// 			Type: to.Ptr("Dynatrace.Observability/monitors"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/monitors/myMonitor"),
		// 			Location: to.Ptr("West US 2"),
		// 			Tags: map[string]*string{
		// 				"Environment": to.Ptr("Dev"),
		// 			},
		// 			Identity: &armdynatrace.IdentityProperties{
		// 				Type: to.Ptr(armdynatrace.ManagedIdentityTypeSystemAssigned),
		// 				PrincipalID: to.Ptr("4534676867978"),
		// 				TenantID: to.Ptr("23456789001"),
		// 			},
		// 			Properties: &armdynatrace.MonitorProperties{
		// 				DynatraceEnvironmentProperties: &armdynatrace.EnvironmentProperties{
		// 					AccountInfo: &armdynatrace.AccountInfo{
		// 						AccountID: to.Ptr("1234567890"),
		// 						RegionID: to.Ptr("wus2"),
		// 					},
		// 					EnvironmentInfo: &armdynatrace.EnvironmentInfo{
		// 						EnvironmentID: to.Ptr("a23xcv456"),
		// 						IngestionKey: to.Ptr("1234567890"),
		// 						LandingURL: to.Ptr("https://a23xcv456.dynatrace.com"),
		// 						LogsIngestionEndpoint: to.Ptr("https://dynatrace.com"),
		// 					},
		// 					SingleSignOnProperties: &armdynatrace.SingleSignOnProperties{
		// 						AADDomains: []*string{
		// 							to.Ptr("mpliftrdt20210811outlook.onmicrosoft.com")},
		// 							EnterpriseAppID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 							SingleSignOnState: to.Ptr(armdynatrace.SingleSignOnStatesEnable),
		// 							SingleSignOnURL: to.Ptr("https://www.dynatrace.io/IAmSomeHash"),
		// 						},
		// 						UserID: to.Ptr("alice123"),
		// 					},
		// 					LiftrResourceCategory: to.Ptr(armdynatrace.LiftrResourceCategoriesUnknown),
		// 					LiftrResourcePreference: to.Ptr[int32](28),
		// 					MarketplaceSubscriptionStatus: to.Ptr(armdynatrace.MarketplaceSubscriptionStatusActive),
		// 					MonitoringStatus: to.Ptr(armdynatrace.MonitoringStatusEnabled),
		// 					PlanData: &armdynatrace.PlanData{
		// 						BillingCycle: to.Ptr("Monthly"),
		// 						EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-30T13:14:33.000Z"); return t}()),
		// 						PlanDetails: to.Ptr("dynatraceapitestplan"),
		// 						UsageType: to.Ptr("Committed"),
		// 					},
		// 					ProvisioningState: to.Ptr(armdynatrace.ProvisioningStateSucceeded),
		// 					UserInfo: &armdynatrace.UserInfo{
		// 						Country: to.Ptr("westus2"),
		// 						EmailAddress: to.Ptr("alice@microsoft.com"),
		// 						FirstName: to.Ptr("Alice"),
		// 						LastName: to.Ptr("Bobab"),
		// 						PhoneNumber: to.Ptr("123456"),
		// 					},
		// 				},
		// 				SystemData: &armdynatrace.SystemData{
		// 					CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-16T04:25:21.040Z"); return t}()),
		// 					CreatedBy: to.Ptr("alice@microsoft.com"),
		// 					CreatedByType: to.Ptr(armdynatrace.CreatedByTypeUser),
		// 					LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-16T04:25:21.040Z"); return t}()),
		// 					LastModifiedBy: to.Ptr("alice@microsoft.com"),
		// 					LastModifiedByType: to.Ptr(armdynatrace.CreatedByTypeUser),
		// 				},
		// 		}},
		// 	}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListByResourceGroup_MinimumSet_Gen.json
func ExampleMonitorsClient_NewListByResourceGroupPager_monitorsListByResourceGroupMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListByResourceGroupPager("myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.MonitorResourceListResult = armdynatrace.MonitorResourceListResult{
		// 	Value: []*armdynatrace.MonitorResource{
		// 		{
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Dynatrace.Observability/monitors/myMonitor/tagRules/default"),
		// 			Location: to.Ptr("West US 2"),
		// 			Properties: &armdynatrace.MonitorProperties{
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_GetMarketplaceSaaSResourceDetails_MaximumSet_Gen.json
func ExampleMonitorsClient_GetMarketplaceSaaSResourceDetails_monitorsGetMarketplaceSaaSResourceDetailsMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetMarketplaceSaaSResourceDetails(ctx, armdynatrace.MarketplaceSaaSResourceDetailsRequest{
		TenantID: to.Ptr("urnmattojzhktcfw"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MarketplaceSaaSResourceDetailsResponse = armdynatrace.MarketplaceSaaSResourceDetailsResponse{
	// 	MarketplaceSaaSResourceID: to.Ptr("owpmulwohq"),
	// 	MarketplaceSubscriptionStatus: to.Ptr(armdynatrace.MarketplaceSubscriptionStatusActive),
	// 	PlanID: to.Ptr("dsfefsaf"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_GetMarketplaceSaaSResourceDetails_MinimumSet_Gen.json
func ExampleMonitorsClient_GetMarketplaceSaaSResourceDetails_monitorsGetMarketplaceSaaSResourceDetailsMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetMarketplaceSaaSResourceDetails(ctx, armdynatrace.MarketplaceSaaSResourceDetailsRequest{
		TenantID: to.Ptr("urnmattojzhktcfw"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MarketplaceSaaSResourceDetailsResponse = armdynatrace.MarketplaceSaaSResourceDetailsResponse{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListHosts_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListHostsPager_monitorsListHostsMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListHostsPager("myResourceGroup", "myMonitor", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VMHostsListResponse = armdynatrace.VMHostsListResponse{
		// 	Value: []*armdynatrace.VMInfo{
		// 		{
		// 			AutoUpdateSetting: to.Ptr(armdynatrace.AutoUpdateSettingENABLED),
		// 			AvailabilityState: to.Ptr(armdynatrace.AvailabilityStateCRASHED),
		// 			HostGroup: to.Ptr("myGroup"),
		// 			HostName: to.Ptr("myName"),
		// 			LogModule: to.Ptr(armdynatrace.LogModuleENABLED),
		// 			MonitoringType: to.Ptr(armdynatrace.MonitoringTypeCLOUDINFRASTRUCTURE),
		// 			ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/virtual1"),
		// 			UpdateStatus: to.Ptr(armdynatrace.UpdateStatusINCOMPATIBLE),
		// 			Version: to.Ptr("1.2.0"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListHosts_MinimumSet_Gen.json
func ExampleMonitorsClient_NewListHostsPager_monitorsListHostsMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListHostsPager("myResourceGroup", "myMonitor", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VMHostsListResponse = armdynatrace.VMHostsListResponse{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_GetMetricStatus_MaximumSet_Gen.json
func ExampleMonitorsClient_GetMetricStatus_monitorsGetMetricStatusMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetMetricStatus(ctx, "rgDynatrace", "fhcjxnxumkdlgpwanewtkdnyuz", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricsStatusResponse = armdynatrace.MetricsStatusResponse{
	// 	AzureResourceIDs: []*string{
	// 		to.Ptr("/subscriptions/69b51384-146c-4685-9dab-5ae01877d78/resourceGroups/szytr-liftr/providers/Dynatrace.Observability/monitors/szytrz-prod-23-05-23")},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_GetMetricStatus_MinimumSet_Gen.json
func ExampleMonitorsClient_GetMetricStatus_monitorsGetMetricStatusMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetMetricStatus(ctx, "rgDynatrace", "fhcjxnxumkdlgpwanewtkdnyuz", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.MetricsStatusResponse = armdynatrace.MetricsStatusResponse{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListAppServices_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListAppServicesPager_monitorsListAppServicesMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListAppServicesPager("myResourceGroup", "myMonitor", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AppServiceListResponse = armdynatrace.AppServiceListResponse{
		// 	Value: []*armdynatrace.AppServiceInfo{
		// 		{
		// 			AutoUpdateSetting: to.Ptr(armdynatrace.AutoUpdateSettingENABLED),
		// 			AvailabilityState: to.Ptr(armdynatrace.AvailabilityStateCRASHED),
		// 			HostGroup: to.Ptr("myGroup"),
		// 			HostName: to.Ptr("myName"),
		// 			LogModule: to.Ptr(armdynatrace.LogModuleENABLED),
		// 			MonitoringType: to.Ptr(armdynatrace.MonitoringTypeCLOUDINFRASTRUCTURE),
		// 			ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Compute/virtualMachines/virtual1"),
		// 			UpdateStatus: to.Ptr(armdynatrace.UpdateStatusINCOMPATIBLE),
		// 			Version: to.Ptr("1.2.0"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListAppServices_MinimumSet_Gen.json
func ExampleMonitorsClient_NewListAppServicesPager_monitorsListAppServicesMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListAppServicesPager("myResourceGroup", "myMonitor", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AppServiceListResponse = armdynatrace.AppServiceListResponse{
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_GetSSODetails_MaximumSet_Gen.json
func ExampleMonitorsClient_GetSSODetails_monitorsGetSsoDetailsMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetSSODetails(ctx, "myResourceGroup", "myMonitor", &armdynatrace.MonitorsClientGetSSODetailsOptions{Request: &armdynatrace.SSODetailsRequest{
		UserPrincipal: to.Ptr("alice@microsoft.com"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SSODetailsResponse = armdynatrace.SSODetailsResponse{
	// 	AADDomains: []*string{
	// 		to.Ptr("mpliftrdt20210811outlook.onmicrosoft.com")},
	// 		AdminUsers: []*string{
	// 			to.Ptr("alice@microsoft.com")},
	// 			IsSsoEnabled: to.Ptr(armdynatrace.SSOStatusEnabled),
	// 			MetadataURL: to.Ptr("https://someuri"),
	// 			SingleSignOnURL: to.Ptr("https://www.dynatrace.io/IAmSomeHash"),
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_GetSSODetails_MinimumSet_Gen.json
func ExampleMonitorsClient_GetSSODetails_monitorsGetSsoDetailsMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewMonitorsClient().GetSSODetails(ctx, "myResourceGroup", "myMonitor", &armdynatrace.MonitorsClientGetSSODetailsOptions{Request: &armdynatrace.SSODetailsRequest{
		UserPrincipal: to.Ptr("alice@microsoft.com"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SSODetailsResponse = armdynatrace.SSODetailsResponse{
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListLinkableEnvironments_MaximumSet_Gen.json
func ExampleMonitorsClient_NewListLinkableEnvironmentsPager_monitorsListLinkableEnvironmentsMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListLinkableEnvironmentsPager("myResourceGroup", "myMonitor", armdynatrace.LinkableEnvironmentRequest{
		Region:        to.Ptr("East US"),
		TenantID:      to.Ptr("00000000-0000-0000-0000-000000000000"),
		UserPrincipal: to.Ptr("alice@microsoft.com"),
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LinkableEnvironmentListResponse = armdynatrace.LinkableEnvironmentListResponse{
		// 	Value: []*armdynatrace.LinkableEnvironmentResponse{
		// 		{
		// 			EnvironmentID: to.Ptr("abc.123"),
		// 			EnvironmentName: to.Ptr("myEnv"),
		// 			PlanData: &armdynatrace.PlanData{
		// 				BillingCycle: to.Ptr("Monthly"),
		// 				EffectiveDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-30T13:14:33.000Z"); return t}()),
		// 				PlanDetails: to.Ptr("dynatraceapitestplan"),
		// 				UsageType: to.Ptr("Committed"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/baac183ffa684d94f697f0fc6f480e02cfb00f3d/specification/dynatrace/resource-manager/Dynatrace.Observability/stable/2023-04-27/examples/Monitors_ListLinkableEnvironments_MinimumSet_Gen.json
func ExampleMonitorsClient_NewListLinkableEnvironmentsPager_monitorsListLinkableEnvironmentsMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdynatrace.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewMonitorsClient().NewListLinkableEnvironmentsPager("myResourceGroup", "myMonitor", armdynatrace.LinkableEnvironmentRequest{
		Region:        to.Ptr("East US"),
		TenantID:      to.Ptr("00000000-0000-0000-0000-000000000000"),
		UserPrincipal: to.Ptr("alice@microsoft.com"),
	}, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LinkableEnvironmentListResponse = armdynatrace.LinkableEnvironmentListResponse{
		// }
	}
}
