//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementListNotifications.json
func ExampleNotificationClient_NewListByServicePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewNotificationClient().NewListByServicePager("rg1", "apimService1", &armapimanagement.NotificationClientListByServiceOptions{Top: nil,
		Skip: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.NotificationCollection = armapimanagement.NotificationCollection{
		// 	Count: to.Ptr[int64](7),
		// 	Value: []*armapimanagement.NotificationContract{
		// 		{
		// 			Name: to.Ptr("RequestPublisherNotificationMessage"),
		// 			Type: to.Ptr("Microsoft.ApiManagement/service/notifications"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage"),
		// 			Properties: &armapimanagement.NotificationContractProperties{
		// 				Description: to.Ptr("The following email recipients and users will receive email notifications about subscription requests for API products requiring approval."),
		// 				Recipients: &armapimanagement.RecipientsContractProperties{
		// 					Emails: []*string{
		// 						to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage/recipientEmails/contoso@live.com"),
		// 						to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage/recipientEmails/foobar!live"),
		// 						to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage/recipientEmails/foobar@live.com")},
		// 						Users: []*string{
		// 							to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/576823d0a40f7e74ec07d642")},
		// 						},
		// 						Title: to.Ptr("Subscription requests (requiring approval)"),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("PurchasePublisherNotificationMessage"),
		// 					Type: to.Ptr("Microsoft.ApiManagement/service/notifications"),
		// 					ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/PurchasePublisherNotificationMessage"),
		// 					Properties: &armapimanagement.NotificationContractProperties{
		// 						Description: to.Ptr("The following email recipients and users will receive email notifications about new API product subscriptions."),
		// 						Recipients: &armapimanagement.RecipientsContractProperties{
		// 							Emails: []*string{
		// 								to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage/recipientEmails/contoso@live.com")},
		// 								Users: []*string{
		// 									to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1")},
		// 								},
		// 								Title: to.Ptr("New subscriptions"),
		// 							},
		// 						},
		// 						{
		// 							Name: to.Ptr("NewApplicationNotificationMessage"),
		// 							Type: to.Ptr("Microsoft.ApiManagement/service/notifications"),
		// 							ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/NewApplicationNotificationMessage"),
		// 							Properties: &armapimanagement.NotificationContractProperties{
		// 								Description: to.Ptr("The following email recipients and users will receive email notifications when new applications are submitted to the application gallery."),
		// 								Recipients: &armapimanagement.RecipientsContractProperties{
		// 									Emails: []*string{
		// 										to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage/recipientEmails/contoso@live.com")},
		// 										Users: []*string{
		// 										},
		// 									},
		// 									Title: to.Ptr("Application gallery requests"),
		// 								},
		// 							},
		// 							{
		// 								Name: to.Ptr("BCC"),
		// 								Type: to.Ptr("Microsoft.ApiManagement/service/notifications"),
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/BCC"),
		// 								Properties: &armapimanagement.NotificationContractProperties{
		// 									Description: to.Ptr("The following recipients will receive blind carbon copies of all emails sent to developers."),
		// 									Recipients: &armapimanagement.RecipientsContractProperties{
		// 										Emails: []*string{
		// 										},
		// 										Users: []*string{
		// 										},
		// 									},
		// 									Title: to.Ptr("BCC"),
		// 								},
		// 							},
		// 							{
		// 								Name: to.Ptr("NewIssuePublisherNotificationMessage"),
		// 								Type: to.Ptr("Microsoft.ApiManagement/service/notifications"),
		// 								ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/NewIssuePublisherNotificationMessage"),
		// 								Properties: &armapimanagement.NotificationContractProperties{
		// 									Description: to.Ptr("The following email recipients and users will receive email notifications when a new issue or comment is submitted on the developer portal."),
		// 									Recipients: &armapimanagement.RecipientsContractProperties{
		// 										Emails: []*string{
		// 										},
		// 										Users: []*string{
		// 											to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1")},
		// 										},
		// 										Title: to.Ptr("New issue or comment"),
		// 									},
		// 								},
		// 								{
		// 									Name: to.Ptr("AccountClosedPublisher"),
		// 									Type: to.Ptr("Microsoft.ApiManagement/service/notifications"),
		// 									ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/AccountClosedPublisher"),
		// 									Properties: &armapimanagement.NotificationContractProperties{
		// 										Description: to.Ptr("The following email recipients and users will receive email notifications when developer closes his account"),
		// 										Recipients: &armapimanagement.RecipientsContractProperties{
		// 											Emails: []*string{
		// 												to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage/recipientEmails/contoso@live.com")},
		// 												Users: []*string{
		// 												},
		// 											},
		// 											Title: to.Ptr("Close account message"),
		// 										},
		// 									},
		// 									{
		// 										Name: to.Ptr("QuotaLimitApproachingPublisherNotificationMessage"),
		// 										Type: to.Ptr("Microsoft.ApiManagement/service/notifications"),
		// 										ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/QuotaLimitApproachingPublisherNotificationMessage"),
		// 										Properties: &armapimanagement.NotificationContractProperties{
		// 											Description: to.Ptr("The following email recipients and users will receive email notifications when subscription usage gets close to usage quota."),
		// 											Recipients: &armapimanagement.RecipientsContractProperties{
		// 												Emails: []*string{
		// 												},
		// 												Users: []*string{
		// 													to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/1")},
		// 												},
		// 												Title: to.Ptr("Approaching subscription quota limit"),
		// 											},
		// 									}},
		// 								}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementGetNotification.json
func ExampleNotificationClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNotificationClient().Get(ctx, "rg1", "apimService1", armapimanagement.NotificationNameRequestPublisherNotificationMessage, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NotificationContract = armapimanagement.NotificationContract{
	// 	Name: to.Ptr("RequestPublisherNotificationMessage"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/notifications"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage"),
	// 	Properties: &armapimanagement.NotificationContractProperties{
	// 		Description: to.Ptr("The following email recipients and users will receive email notifications about subscription requests for API products requiring approval."),
	// 		Recipients: &armapimanagement.RecipientsContractProperties{
	// 			Emails: []*string{
	// 				to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/recipientEmails/contoso@live.com"),
	// 				to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/recipientEmails/foobar!live"),
	// 				to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/recipientEmails/foobar@live.com")},
	// 				Users: []*string{
	// 					to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/576823d0a40f7e74ec07d642")},
	// 				},
	// 				Title: to.Ptr("Subscription requests (requiring approval)"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateNotification.json
func ExampleNotificationClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewNotificationClient().CreateOrUpdate(ctx, "rg1", "apimService1", armapimanagement.NotificationNameRequestPublisherNotificationMessage, &armapimanagement.NotificationClientCreateOrUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.NotificationContract = armapimanagement.NotificationContract{
	// 	Name: to.Ptr("RequestPublisherNotificationMessage"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/notifications"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/notifications/RequestPublisherNotificationMessage"),
	// 	Properties: &armapimanagement.NotificationContractProperties{
	// 		Description: to.Ptr("The following email recipients and users will receive email notifications about subscription requests for API products requiring approval."),
	// 		Recipients: &armapimanagement.RecipientsContractProperties{
	// 			Emails: []*string{
	// 				to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/recipientEmails/contoso@live.com"),
	// 				to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/recipientEmails/foobar!live"),
	// 				to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/recipientEmails/foobar@live.com")},
	// 				Users: []*string{
	// 					to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/users/576823d0a40f7e74ec07d642")},
	// 				},
	// 				Title: to.Ptr("Subscription requests (requiring approval)"),
	// 			},
	// 		}
}
