package storage

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// AccessTier enumerates the values for access tier.
type AccessTier string

const (
	// Cool specifies the cool state for access tier.
	Cool AccessTier = "Cool"
	// Hot specifies the hot state for access tier.
	Hot AccessTier = "Hot"
)

// AccountStatus enumerates the values for account status.
type AccountStatus string

const (
	// Available specifies the available state for account status.
	Available AccountStatus = "available"
	// Unavailable specifies the unavailable state for account status.
	Unavailable AccountStatus = "unavailable"
)

// HTTPProtocol enumerates the values for http protocol.
type HTTPProtocol string

const (
	// HTTPS specifies the https state for http protocol.
	HTTPS HTTPProtocol = "https"
	// Httpshttp specifies the httpshttp state for http protocol.
	Httpshttp HTTPProtocol = "https,http"
)

// KeyPermission enumerates the values for key permission.
type KeyPermission string

const (
	// Full specifies the full state for key permission.
	Full KeyPermission = "Full"
	// Read specifies the read state for key permission.
	Read KeyPermission = "Read"
)

// Kind enumerates the values for kind.
type Kind string

const (
	// BlobStorage specifies the blob storage state for kind.
	BlobStorage Kind = "BlobStorage"
	// Storage specifies the storage state for kind.
	Storage Kind = "Storage"
)

// Permissions enumerates the values for permissions.
type Permissions string

const (
	// A specifies the a state for permissions.
	A Permissions = "a"
	// C specifies the c state for permissions.
	C Permissions = "c"
	// D specifies the d state for permissions.
	D Permissions = "d"
	// L specifies the l state for permissions.
	L Permissions = "l"
	// P specifies the p state for permissions.
	P Permissions = "p"
	// R specifies the r state for permissions.
	R Permissions = "r"
	// U specifies the u state for permissions.
	U Permissions = "u"
	// W specifies the w state for permissions.
	W Permissions = "w"
)

// Permissions1 enumerates the values for permissions 1.
type Permissions1 string

const (
	// Permissions1A specifies the permissions 1a state for permissions 1.
	Permissions1A Permissions1 = "a"
	// Permissions1C specifies the permissions 1c state for permissions 1.
	Permissions1C Permissions1 = "c"
	// Permissions1D specifies the permissions 1d state for permissions 1.
	Permissions1D Permissions1 = "d"
	// Permissions1L specifies the permissions 1l state for permissions 1.
	Permissions1L Permissions1 = "l"
	// Permissions1P specifies the permissions 1p state for permissions 1.
	Permissions1P Permissions1 = "p"
	// Permissions1R specifies the permissions 1r state for permissions 1.
	Permissions1R Permissions1 = "r"
	// Permissions1U specifies the permissions 1u state for permissions 1.
	Permissions1U Permissions1 = "u"
	// Permissions1W specifies the permissions 1w state for permissions 1.
	Permissions1W Permissions1 = "w"
)

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating specifies the creating state for provisioning state.
	Creating ProvisioningState = "Creating"
	// ResolvingDNS specifies the resolving dns state for provisioning state.
	ResolvingDNS ProvisioningState = "ResolvingDNS"
	// Succeeded specifies the succeeded state for provisioning state.
	Succeeded ProvisioningState = "Succeeded"
)

// Reason enumerates the values for reason.
type Reason string

const (
	// AccountNameInvalid specifies the account name invalid state for reason.
	AccountNameInvalid Reason = "AccountNameInvalid"
	// AlreadyExists specifies the already exists state for reason.
	AlreadyExists Reason = "AlreadyExists"
)

// ResourceEnum enumerates the values for resource enum.
type ResourceEnum string

const (
	// ResourceEnumB specifies the resource enum b state for resource enum.
	ResourceEnumB ResourceEnum = "b"
	// ResourceEnumC specifies the resource enum c state for resource enum.
	ResourceEnumC ResourceEnum = "c"
	// ResourceEnumF specifies the resource enum f state for resource enum.
	ResourceEnumF ResourceEnum = "f"
	// ResourceEnumS specifies the resource enum s state for resource enum.
	ResourceEnumS ResourceEnum = "s"
)

// ResourceTypes enumerates the values for resource types.
type ResourceTypes string

const (
	// ResourceTypesC specifies the resource types c state for resource types.
	ResourceTypesC ResourceTypes = "c"
	// ResourceTypesO specifies the resource types o state for resource types.
	ResourceTypesO ResourceTypes = "o"
	// ResourceTypesS specifies the resource types s state for resource types.
	ResourceTypesS ResourceTypes = "s"
)

// Services enumerates the values for services.
type Services string

const (
	// B specifies the b state for services.
	B Services = "b"
	// F specifies the f state for services.
	F Services = "f"
	// Q specifies the q state for services.
	Q Services = "q"
	// T specifies the t state for services.
	T Services = "t"
)

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// PremiumLRS specifies the premium lrs state for sku name.
	PremiumLRS SkuName = "Premium_LRS"
	// StandardGRS specifies the standard grs state for sku name.
	StandardGRS SkuName = "Standard_GRS"
	// StandardLRS specifies the standard lrs state for sku name.
	StandardLRS SkuName = "Standard_LRS"
	// StandardRAGRS specifies the standard ragrs state for sku name.
	StandardRAGRS SkuName = "Standard_RAGRS"
	// StandardZRS specifies the standard zrs state for sku name.
	StandardZRS SkuName = "Standard_ZRS"
)

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Premium specifies the premium state for sku tier.
	Premium SkuTier = "Premium"
	// Standard specifies the standard state for sku tier.
	Standard SkuTier = "Standard"
)

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// Bytes specifies the bytes state for usage unit.
	Bytes UsageUnit = "Bytes"
	// BytesPerSecond specifies the bytes per second state for usage unit.
	BytesPerSecond UsageUnit = "BytesPerSecond"
	// Count specifies the count state for usage unit.
	Count UsageUnit = "Count"
	// CountsPerSecond specifies the counts per second state for usage unit.
	CountsPerSecond UsageUnit = "CountsPerSecond"
	// Percent specifies the percent state for usage unit.
	Percent UsageUnit = "Percent"
	// Seconds specifies the seconds state for usage unit.
	Seconds UsageUnit = "Seconds"
)

// Account is the storage account.
type Account struct {
	autorest.Response  `json:"-"`
	ID                 *string             `json:"id,omitempty"`
	Name               *string             `json:"name,omitempty"`
	Type               *string             `json:"type,omitempty"`
	Location           *string             `json:"location,omitempty"`
	Tags               *map[string]*string `json:"tags,omitempty"`
	Sku                *Sku                `json:"sku,omitempty"`
	Kind               Kind                `json:"kind,omitempty"`
	*AccountProperties `json:"properties,omitempty"`
}

// AccountCheckNameAvailabilityParameters is the parameters used to check the
// availabity of the storage account name.
type AccountCheckNameAvailabilityParameters struct {
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// AccountCreateParameters is the parameters used when creating a storage
// account.
type AccountCreateParameters struct {
	Sku                                *Sku                `json:"sku,omitempty"`
	Kind                               Kind                `json:"kind,omitempty"`
	Location                           *string             `json:"location,omitempty"`
	Tags                               *map[string]*string `json:"tags,omitempty"`
	*AccountPropertiesCreateParameters `json:"properties,omitempty"`
}

// AccountKey is an access key for the storage account.
type AccountKey struct {
	KeyName     *string       `json:"keyName,omitempty"`
	Value       *string       `json:"value,omitempty"`
	Permissions KeyPermission `json:"permissions,omitempty"`
}

// AccountListKeysResult is the response from the ListKeys operation.
type AccountListKeysResult struct {
	autorest.Response `json:"-"`
	Keys              *[]AccountKey `json:"keys,omitempty"`
}

// AccountListResult is the response from the List Storage Accounts operation.
type AccountListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Account `json:"value,omitempty"`
}

// AccountProperties is properties of the storage account.
type AccountProperties struct {
	ProvisioningState      ProvisioningState `json:"provisioningState,omitempty"`
	PrimaryEndpoints       *Endpoints        `json:"primaryEndpoints,omitempty"`
	PrimaryLocation        *string           `json:"primaryLocation,omitempty"`
	StatusOfPrimary        AccountStatus     `json:"statusOfPrimary,omitempty"`
	LastGeoFailoverTime    *date.Time        `json:"lastGeoFailoverTime,omitempty"`
	SecondaryLocation      *string           `json:"secondaryLocation,omitempty"`
	StatusOfSecondary      AccountStatus     `json:"statusOfSecondary,omitempty"`
	CreationTime           *date.Time        `json:"creationTime,omitempty"`
	CustomDomain           *CustomDomain     `json:"customDomain,omitempty"`
	SecondaryEndpoints     *Endpoints        `json:"secondaryEndpoints,omitempty"`
	Encryption             *Encryption       `json:"encryption,omitempty"`
	AccessTier             AccessTier        `json:"accessTier,omitempty"`
	EnableHTTPSTrafficOnly *bool             `json:"supportsHttpsTrafficOnly,omitempty"`
}

// AccountPropertiesCreateParameters is the parameters used to create the
// storage account.
type AccountPropertiesCreateParameters struct {
	CustomDomain           *CustomDomain `json:"customDomain,omitempty"`
	Encryption             *Encryption   `json:"encryption,omitempty"`
	AccessTier             AccessTier    `json:"accessTier,omitempty"`
	EnableHTTPSTrafficOnly *bool         `json:"supportsHttpsTrafficOnly,omitempty"`
}

// AccountPropertiesUpdateParameters is the parameters used when updating a
// storage account.
type AccountPropertiesUpdateParameters struct {
	CustomDomain           *CustomDomain `json:"customDomain,omitempty"`
	Encryption             *Encryption   `json:"encryption,omitempty"`
	AccessTier             AccessTier    `json:"accessTier,omitempty"`
	EnableHTTPSTrafficOnly *bool         `json:"supportsHttpsTrafficOnly,omitempty"`
}

// AccountRegenerateKeyParameters is the parameters used to regenerate the
// storage account key.
type AccountRegenerateKeyParameters struct {
	KeyName *string `json:"keyName,omitempty"`
}

// AccountSasParameters is the parameters to list SAS credentials of a storage
// account.
type AccountSasParameters struct {
	Services               Services      `json:"signedServices,omitempty"`
	ResourceTypes          ResourceTypes `json:"signedResourceTypes,omitempty"`
	Permissions            Permissions   `json:"signedPermission,omitempty"`
	IPAddressOrRange       *string       `json:"signedIp,omitempty"`
	Protocols              HTTPProtocol  `json:"signedProtocol,omitempty"`
	SharedAccessStartTime  *date.Time    `json:"signedStart,omitempty"`
	SharedAccessExpiryTime *date.Time    `json:"signedExpiry,omitempty"`
	KeyToSign              *string       `json:"keyToSign,omitempty"`
}

// AccountUpdateParameters is the parameters that can be provided when updating
// the storage account properties.
type AccountUpdateParameters struct {
	Sku                                *Sku                `json:"sku,omitempty"`
	Tags                               *map[string]*string `json:"tags,omitempty"`
	*AccountPropertiesUpdateParameters `json:"properties,omitempty"`
}

// CheckNameAvailabilityResult is the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	NameAvailable     *bool   `json:"nameAvailable,omitempty"`
	Reason            Reason  `json:"reason,omitempty"`
	Message           *string `json:"message,omitempty"`
}

// CustomDomain is the custom domain assigned to this storage account. This can
// be set via Update.
type CustomDomain struct {
	Name         *string `json:"name,omitempty"`
	UseSubDomain *bool   `json:"useSubDomain,omitempty"`
}

// Encryption is the encryption settings on the storage account.
type Encryption struct {
	Services  *EncryptionServices `json:"services,omitempty"`
	KeySource *string             `json:"keySource,omitempty"`
}

// EncryptionService is a service that allows server-side encryption to be
// used.
type EncryptionService struct {
	Enabled         *bool      `json:"enabled,omitempty"`
	LastEnabledTime *date.Time `json:"lastEnabledTime,omitempty"`
}

// EncryptionServices is a list of services that support encryption.
type EncryptionServices struct {
	Blob  *EncryptionService `json:"blob,omitempty"`
	File  *EncryptionService `json:"file,omitempty"`
	Table *EncryptionService `json:"table,omitempty"`
	Queue *EncryptionService `json:"queue,omitempty"`
}

// Endpoints is the URIs that are used to perform a retrieval of a public blob,
// queue, or table object.
type Endpoints struct {
	Blob  *string `json:"blob,omitempty"`
	Queue *string `json:"queue,omitempty"`
	Table *string `json:"table,omitempty"`
	File  *string `json:"file,omitempty"`
}

// ListAccountSasResponse is the List SAS credentials operation response.
type ListAccountSasResponse struct {
	autorest.Response `json:"-"`
	AccountSasToken   *string `json:"accountSasToken,omitempty"`
}

// ListServiceSasResponse is the List service SAS credentials operation
// response.
type ListServiceSasResponse struct {
	autorest.Response `json:"-"`
	ServiceSasToken   *string `json:"serviceSasToken,omitempty"`
}

// Resource is describes a storage resource.
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ServiceSasParameters is the parameters to list service SAS credentials of a
// speicific resource.
type ServiceSasParameters struct {
	CanonicalizedResource  *string      `json:"canonicalizedResource,omitempty"`
	Resource               Resource     `json:"signedResource,omitempty"`
	Permissions            Permissions  `json:"signedPermission,omitempty"`
	IPAddressOrRange       *string      `json:"signedIp,omitempty"`
	Protocols              HTTPProtocol `json:"signedProtocol,omitempty"`
	SharedAccessStartTime  *date.Time   `json:"signedStart,omitempty"`
	SharedAccessExpiryTime *date.Time   `json:"signedExpiry,omitempty"`
	Identifier             *string      `json:"signedIdentifier,omitempty"`
	PartitionKeyStart      *string      `json:"startPk,omitempty"`
	PartitionKeyEnd        *string      `json:"endPk,omitempty"`
	RowKeyStart            *string      `json:"startRk,omitempty"`
	RowKeyEnd              *string      `json:"endRk,omitempty"`
	KeyToSign              *string      `json:"keyToSign,omitempty"`
	CacheControl           *string      `json:"rscc,omitempty"`
	ContentDisposition     *string      `json:"rscd,omitempty"`
	ContentEncoding        *string      `json:"rsce,omitempty"`
	ContentLanguage        *string      `json:"rscl,omitempty"`
	ContentType            *string      `json:"rsct,omitempty"`
}

// Sku is the SKU of the storage account.
type Sku struct {
	Name SkuName `json:"name,omitempty"`
	Tier SkuTier `json:"tier,omitempty"`
}

// Usage is describes Storage Resource Usage.
type Usage struct {
	Unit         UsageUnit  `json:"unit,omitempty"`
	CurrentValue *int32     `json:"currentValue,omitempty"`
	Limit        *int32     `json:"limit,omitempty"`
	Name         *UsageName `json:"name,omitempty"`
}

// UsageListResult is the response from the List Usages operation.
type UsageListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Usage `json:"value,omitempty"`
}

// UsageName is the usage names that can be used; currently limited to
// StorageAccount.
type UsageName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}
