// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The summary of a migration workflow.
type MigrationWorkflowSummary struct {

	// The name of the application configured in Application Discovery Service.
	AdsApplicationConfigurationName *string

	// The steps completed in the migration workflow.
	CompletedSteps *int32

	// The time at which the migration workflow was created.
	CreationTime *time.Time

	// The time at which the migration workflow ended.
	EndTime *time.Time

	// The ID of the migration workflow.
	Id *string

	// The name of the migration workflow.
	Name *string

	// The status of the migration workflow.
	Status MigrationWorkflowStatusEnum

	// The status message of the migration workflow.
	StatusMessage *string

	// The ID of the template.
	TemplateId *string

	// All the steps in a migration workflow.
	TotalSteps *int32

	noSmithyDocumentSerde
}

// Command to be run on a particular operating system.
type PlatformCommand struct {

	// Command for Linux.
	Linux *string

	// Command for Windows.
	Windows *string

	noSmithyDocumentSerde
}

// The script location for a particular operating system.
type PlatformScriptKey struct {

	// The script location for Linux.
	Linux *string

	// The script location for Windows.
	Windows *string

	noSmithyDocumentSerde
}

// The summary of the Migration Hub Orchestrator plugin.
type PluginSummary struct {

	// The name of the host.
	Hostname *string

	// The IP address at which the plugin is located.
	IpAddress *string

	// The ID of the plugin.
	PluginId *string

	// The time at which the plugin was registered.
	RegisteredTime *string

	// The status of the plugin.
	Status PluginHealth

	// The version of the plugin.
	Version *string

	noSmithyDocumentSerde
}

// The custom script to run tests on source or target environments.
type StepAutomationConfiguration struct {

	// The command to run the script.
	Command *PlatformCommand

	// The source or target environment.
	RunEnvironment RunEnvironment

	// The Amazon S3 bucket where the script is located.
	ScriptLocationS3Bucket *string

	// The Amazon S3 key for the script location.
	ScriptLocationS3Key *PlatformScriptKey

	// The servers on which to run the script.
	TargetType TargetType

	noSmithyDocumentSerde
}

// A map of key value pairs that is generated when you create a migration workflow.
// The key value pairs will differ based on your selection of the template.
//
// The following types satisfy this interface:
//
//	StepInputMemberIntegerValue
//	StepInputMemberListOfStringsValue
//	StepInputMemberMapOfStringValue
//	StepInputMemberStringValue
type StepInput interface {
	isStepInput()
}

// The value of the integer.
type StepInputMemberIntegerValue struct {
	Value int32

	noSmithyDocumentSerde
}

func (*StepInputMemberIntegerValue) isStepInput() {}

// List of string values.
type StepInputMemberListOfStringsValue struct {
	Value []string

	noSmithyDocumentSerde
}

func (*StepInputMemberListOfStringsValue) isStepInput() {}

// Map of string values.
type StepInputMemberMapOfStringValue struct {
	Value map[string]string

	noSmithyDocumentSerde
}

func (*StepInputMemberMapOfStringValue) isStepInput() {}

// String value.
type StepInputMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*StepInputMemberStringValue) isStepInput() {}

// The output of the step.
type StepOutput struct {

	// The data type of the step output.
	DataType DataType

	// The name of the step.
	Name *string

	// Determine if an output is required from a step.
	Required *bool

	noSmithyDocumentSerde
}

// The input parameters of a template.
type TemplateInput struct {

	// The data type of the template input.
	DataType DataType

	// The name of the template.
	InputName *string

	// Determine if an input is required from the template.
	Required *bool

	noSmithyDocumentSerde
}

// The summary of the step group in the template.
type TemplateStepGroupSummary struct {

	// The ID of the step group.
	Id *string

	// The name of the step group.
	Name *string

	// The next step group.
	Next []string

	// The previous step group.
	Previous []string

	noSmithyDocumentSerde
}

// The summary of the step.
type TemplateStepSummary struct {

	// The ID of the step.
	Id *string

	// The name of the step.
	Name *string

	// The next step.
	Next []string

	// The owner of the step.
	Owner Owner

	// The previous step.
	Previous []string

	// The action type of the step. You must run and update the status of a manual step
	// for the workflow to continue after the completion of the step.
	StepActionType StepActionType

	// The ID of the step group.
	StepGroupId *string

	// The servers on which to run the script.
	TargetType TargetType

	// The ID of the template.
	TemplateId *string

	noSmithyDocumentSerde
}

// The summary of the template.
type TemplateSummary struct {

	// The Amazon Resource Name (ARN) of the template.
	Arn *string

	// The description of the template.
	Description *string

	// The ID of the template.
	Id *string

	// The name of the template.
	Name *string

	noSmithyDocumentSerde
}

// List of AWS services utilized in a migration workflow.
type Tool struct {

	// The name of an AWS service.
	Name *string

	// The URL of an AWS service.
	Url *string

	noSmithyDocumentSerde
}

// The custom script to run tests on source or target environments.
type WorkflowStepAutomationConfiguration struct {

	// The command required to run the script.
	Command *PlatformCommand

	// The source or target environment.
	RunEnvironment RunEnvironment

	// The Amazon S3 bucket where the script is located.
	ScriptLocationS3Bucket *string

	// The Amazon S3 key for the script location.
	ScriptLocationS3Key *PlatformScriptKey

	// The servers on which to run the script.
	TargetType TargetType

	noSmithyDocumentSerde
}

// The summary of a step group in a workflow.
type WorkflowStepGroupSummary struct {

	// The ID of the step group.
	Id *string

	// The name of the step group.
	Name *string

	// The next step group.
	Next []string

	// The owner of the step group.
	Owner Owner

	// The previous step group.
	Previous []string

	// The status of the step group.
	Status StepGroupStatus

	noSmithyDocumentSerde
}

// The output of a step.
type WorkflowStepOutput struct {

	// The data type of the output.
	DataType DataType

	// The name of the step.
	Name *string

	// Determine if an output is required from a step.
	Required *bool

	// The value of the output.
	Value WorkflowStepOutputUnion

	noSmithyDocumentSerde
}

// A structure to hold multiple values of an output.
//
// The following types satisfy this interface:
//
//	WorkflowStepOutputUnionMemberIntegerValue
//	WorkflowStepOutputUnionMemberListOfStringValue
//	WorkflowStepOutputUnionMemberStringValue
type WorkflowStepOutputUnion interface {
	isWorkflowStepOutputUnion()
}

// The integer value.
type WorkflowStepOutputUnionMemberIntegerValue struct {
	Value int32

	noSmithyDocumentSerde
}

func (*WorkflowStepOutputUnionMemberIntegerValue) isWorkflowStepOutputUnion() {}

// The list of string value.
type WorkflowStepOutputUnionMemberListOfStringValue struct {
	Value []string

	noSmithyDocumentSerde
}

func (*WorkflowStepOutputUnionMemberListOfStringValue) isWorkflowStepOutputUnion() {}

// The string value.
type WorkflowStepOutputUnionMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*WorkflowStepOutputUnionMemberStringValue) isWorkflowStepOutputUnion() {}

// The summary of the step in a migration workflow.
type WorkflowStepSummary struct {

	// The description of the step.
	Description *string

	// The name of the step.
	Name *string

	// The next step.
	Next []string

	// The number of servers that have been migrated.
	NoOfSrvCompleted *int32

	// The number of servers that have failed to migrate.
	NoOfSrvFailed *int32

	// The owner of the step.
	Owner Owner

	// The previous step.
	Previous []string

	// The location of the script.
	ScriptLocation *string

	// The status of the step.
	Status StepStatus

	// The status message of the migration workflow.
	StatusMessage *string

	// The action type of the step. You must run and update the status of a manual step
	// for the workflow to continue after the completion of the step.
	StepActionType StepActionType

	// The ID of the step.
	StepId *string

	// The total number of servers that have been migrated.
	TotalNoOfSrv *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isStepInput()               {}
func (*UnknownUnionMember) isWorkflowStepOutputUnion() {}
