//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armtimeseriesinsights

import "time"

// AccessPoliciesClientCreateOrUpdateOptions contains the optional parameters for the AccessPoliciesClient.CreateOrUpdate
// method.
type AccessPoliciesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// AccessPoliciesClientDeleteOptions contains the optional parameters for the AccessPoliciesClient.Delete method.
type AccessPoliciesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// AccessPoliciesClientGetOptions contains the optional parameters for the AccessPoliciesClient.Get method.
type AccessPoliciesClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccessPoliciesClientListByEnvironmentOptions contains the optional parameters for the AccessPoliciesClient.ListByEnvironment
// method.
type AccessPoliciesClientListByEnvironmentOptions struct {
	// placeholder for future optional parameters
}

// AccessPoliciesClientUpdateOptions contains the optional parameters for the AccessPoliciesClient.Update method.
type AccessPoliciesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

type AccessPolicyCreateOrUpdateParameters struct {
	// REQUIRED
	Properties *AccessPolicyResourceProperties `json:"properties,omitempty"`
}

// AccessPolicyListResponse - The response of the List access policies operation.
type AccessPolicyListResponse struct {
	// Result of the List access policies operation.
	Value []*AccessPolicyResource `json:"value,omitempty"`
}

// AccessPolicyMutableProperties - An object that represents a set of mutable access policy resource properties.
type AccessPolicyMutableProperties struct {
	// An description of the access policy.
	Description *string `json:"description,omitempty"`

	// The list of roles the principal is assigned on the environment.
	Roles []*AccessPolicyRole `json:"roles,omitempty"`
}

// AccessPolicyResource - An access policy is used to grant users and applications access to the environment. Roles are assigned
// to service principals in Azure Active Directory. These roles define the actions the principal can
// perform through the Time Series Insights data plane APIs.
type AccessPolicyResource struct {
	Properties *AccessPolicyResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

type AccessPolicyResourceProperties struct {
	// An description of the access policy.
	Description *string `json:"description,omitempty"`

	// The objectId of the principal in Azure Active Directory.
	PrincipalObjectID *string `json:"principalObjectId,omitempty"`

	// The list of roles the principal is assigned on the environment.
	Roles []*AccessPolicyRole `json:"roles,omitempty"`
}

type AccessPolicyUpdateParameters struct {
	// An object that represents a set of mutable access policy resource properties.
	Properties *AccessPolicyMutableProperties `json:"properties,omitempty"`
}

// AzureEventSourceProperties - Properties of an event source that reads events from an event broker in Azure.
type AzureEventSourceProperties struct {
	// REQUIRED; The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`

	// An object that contains the details about the starting point in time to ingest events.
	IngressStartAt *IngressStartAtProperties `json:"ingressStartAt,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// CloudError - Contains information about an API error.
type CloudError struct {
	// Describes a particular API error with an error code and a message.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - Describes a particular API error with an error code and a message.
type CloudErrorBody struct {
	// An error code that describes the error condition more precisely than an HTTP status code. Can be used to programmatically
	// handle specific error cases.
	Code *string `json:"code,omitempty"`

	// Contains nested errors that are related to this error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message that describes the error in detail and provides debugging information.
	Message *string `json:"message,omitempty"`

	// The target of the particular error (for example, the name of the property in error).
	Target *string `json:"target,omitempty"`
}

// CreateOrUpdateTrackedResourceProperties - Properties required to create any resource tracked by Azure Resource Manager.
type CreateOrUpdateTrackedResourceProperties struct {
	// REQUIRED; The location of the resource.
	Location *string `json:"location,omitempty"`

	// Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// Dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// Display name of dimension.
	Name *string `json:"name,omitempty"`
}

// EnvironmentCreateOrUpdateParametersClassification provides polymorphic access to related types.
// Call the interface's GetEnvironmentCreateOrUpdateParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EnvironmentCreateOrUpdateParameters, *Gen1EnvironmentCreateOrUpdateParameters, *Gen2EnvironmentCreateOrUpdateParameters
type EnvironmentCreateOrUpdateParametersClassification interface {
	// GetEnvironmentCreateOrUpdateParameters returns the EnvironmentCreateOrUpdateParameters content of the underlying type.
	GetEnvironmentCreateOrUpdateParameters() *EnvironmentCreateOrUpdateParameters
}

// EnvironmentCreateOrUpdateParameters - Parameters supplied to the CreateOrUpdate Environment operation.
type EnvironmentCreateOrUpdateParameters struct {
	// REQUIRED; The kind of the environment.
	Kind *EnvironmentKind `json:"kind,omitempty"`

	// REQUIRED; The location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku
	// determines the capacity of the environment, the ingress rate, and the billing rate.
	SKU *SKU `json:"sku,omitempty"`

	// Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEnvironmentCreateOrUpdateParameters implements the EnvironmentCreateOrUpdateParametersClassification interface for type
// EnvironmentCreateOrUpdateParameters.
func (e *EnvironmentCreateOrUpdateParameters) GetEnvironmentCreateOrUpdateParameters() *EnvironmentCreateOrUpdateParameters {
	return e
}

// EnvironmentListResponse - The response of the List Environments operation.
type EnvironmentListResponse struct {
	// Result of the List Environments operation.
	Value []EnvironmentResourceClassification `json:"value,omitempty"`
}

// EnvironmentResourceClassification provides polymorphic access to related types.
// Call the interface's GetEnvironmentResource() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EnvironmentResource, *Gen1EnvironmentResource, *Gen2EnvironmentResource
type EnvironmentResourceClassification interface {
	// GetEnvironmentResource returns the EnvironmentResource content of the underlying type.
	GetEnvironmentResource() *EnvironmentResource
}

// EnvironmentResource - An environment is a set of time-series data available for query, and is the top level Azure Time
// Series Insights resource.
type EnvironmentResource struct {
	// REQUIRED; The kind of the environment.
	Kind *EnvironmentResourceKind `json:"kind,omitempty"`

	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku
	// determines the capacity of the environment, the ingress rate, and the billing rate.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetEnvironmentResource implements the EnvironmentResourceClassification interface for type EnvironmentResource.
func (e *EnvironmentResource) GetEnvironmentResource() *EnvironmentResource { return e }

// EnvironmentResourceProperties - Properties of the environment.
type EnvironmentResourceProperties struct {
	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified domain name used to access the environment data, e.g. to query the environment's events
	// or upload reference data for the environment.
	DataAccessFqdn *string `json:"dataAccessFqdn,omitempty" azure:"ro"`

	// READ-ONLY; An id used to access the environment data, e.g. to query the environment's events or upload reference data for
	// the environment.
	DataAccessID *string `json:"dataAccessId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; An object that represents the status of the environment, and its internal state in the Time Series Insights
	// service.
	Status *EnvironmentStatus `json:"status,omitempty" azure:"ro"`
}

// EnvironmentStateDetails - An object that contains the details about an environment's state.
type EnvironmentStateDetails struct {
	// Contains the code that represents the reason of an environment being in a particular state. Can be used to programmatically
	// handle specific cases.
	Code *string `json:"code,omitempty"`

	// A message that describes the state in detail.
	Message *string `json:"message,omitempty"`
}

// EnvironmentStatus - An object that represents the status of the environment, and its internal state in the Time Series
// Insights service.
type EnvironmentStatus struct {
	// READ-ONLY; An object that represents the status of ingress on an environment.
	Ingress *IngressEnvironmentStatus `json:"ingress,omitempty" azure:"ro"`

	// READ-ONLY; An object that represents the status of warm storage on an environment.
	WarmStorage *WarmStorageEnvironmentStatus `json:"warmStorage,omitempty" azure:"ro"`
}

// EnvironmentUpdateParametersClassification provides polymorphic access to related types.
// Call the interface's GetEnvironmentUpdateParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EnvironmentUpdateParameters, *Gen1EnvironmentUpdateParameters, *Gen2EnvironmentUpdateParameters
type EnvironmentUpdateParametersClassification interface {
	// GetEnvironmentUpdateParameters returns the EnvironmentUpdateParameters content of the underlying type.
	GetEnvironmentUpdateParameters() *EnvironmentUpdateParameters
}

// EnvironmentUpdateParameters - Parameters supplied to the Update Environment operation.
type EnvironmentUpdateParameters struct {
	// REQUIRED; The kind of the environment.
	Kind *EnvironmentKind `json:"kind,omitempty"`

	// Key-value pairs of additional properties for the environment.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEnvironmentUpdateParameters implements the EnvironmentUpdateParametersClassification interface for type EnvironmentUpdateParameters.
func (e *EnvironmentUpdateParameters) GetEnvironmentUpdateParameters() *EnvironmentUpdateParameters {
	return e
}

// EnvironmentsClientBeginCreateOrUpdateOptions contains the optional parameters for the EnvironmentsClient.BeginCreateOrUpdate
// method.
type EnvironmentsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientBeginUpdateOptions contains the optional parameters for the EnvironmentsClient.BeginUpdate method.
type EnvironmentsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// EnvironmentsClientDeleteOptions contains the optional parameters for the EnvironmentsClient.Delete method.
type EnvironmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientGetOptions contains the optional parameters for the EnvironmentsClient.Get method.
type EnvironmentsClientGetOptions struct {
	// Setting $expand=status will include the status of the internal services of the environment in the Time Series Insights
	// service.
	Expand *string
}

// EnvironmentsClientListByResourceGroupOptions contains the optional parameters for the EnvironmentsClient.ListByResourceGroup
// method.
type EnvironmentsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// EnvironmentsClientListBySubscriptionOptions contains the optional parameters for the EnvironmentsClient.ListBySubscription
// method.
type EnvironmentsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// EventHubEventSourceCommonProperties - Properties of the EventHub event source.
type EventHubEventSourceCommonProperties struct {
	// REQUIRED; The name of the event hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`

	// REQUIRED; The name of the event hub.
	EventHubName *string `json:"eventHubName,omitempty"`

	// REQUIRED; The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`

	// REQUIRED; The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access
	// policies for this key must grant 'Listen' permissions to the event hub.
	KeyName *string `json:"keyName,omitempty"`

	// REQUIRED; The name of the service bus that contains the event hub.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// An object that contains the details about the starting point in time to ingest events.
	IngressStartAt *IngressStartAtProperties `json:"ingressStartAt,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// EventHubEventSourceCreateOrUpdateParameters - Parameters supplied to the Create or Update Event Source operation for an
// EventHub event source.
type EventHubEventSourceCreateOrUpdateParameters struct {
	// REQUIRED; The kind of the event source.
	Kind *EventSourceKind `json:"kind,omitempty"`

	// REQUIRED; The location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the EventHub event source that are required on create or update requests.
	Properties *EventHubEventSourceCreationProperties `json:"properties,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEventSourceCreateOrUpdateParameters implements the EventSourceCreateOrUpdateParametersClassification interface for type
// EventHubEventSourceCreateOrUpdateParameters.
func (e *EventHubEventSourceCreateOrUpdateParameters) GetEventSourceCreateOrUpdateParameters() *EventSourceCreateOrUpdateParameters {
	return &EventSourceCreateOrUpdateParameters{
		Kind:           e.Kind,
		LocalTimestamp: e.LocalTimestamp,
		Location:       e.Location,
		Tags:           e.Tags,
	}
}

// EventHubEventSourceCreationProperties - Properties of the EventHub event source that are required on create or update requests.
type EventHubEventSourceCreationProperties struct {
	// REQUIRED; The name of the event hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`

	// REQUIRED; The name of the event hub.
	EventHubName *string `json:"eventHubName,omitempty"`

	// REQUIRED; The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`

	// REQUIRED; The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access
	// policies for this key must grant 'Listen' permissions to the event hub.
	KeyName *string `json:"keyName,omitempty"`

	// REQUIRED; The name of the service bus that contains the event hub.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// REQUIRED; The value of the shared access key that grants the Time Series Insights service read access to the event hub.
	// This property is not shown in event source responses.
	SharedAccessKey *string `json:"sharedAccessKey,omitempty"`

	// An object that contains the details about the starting point in time to ingest events.
	IngressStartAt *IngressStartAtProperties `json:"ingressStartAt,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// EventHubEventSourceMutableProperties - An object that represents a set of mutable EventHub event source resource properties.
type EventHubEventSourceMutableProperties struct {
	// The value of the shared access key that grants the Time Series Insights service read access to the event hub. This property
	// is not shown in event source responses.
	SharedAccessKey *string `json:"sharedAccessKey,omitempty"`

	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
}

// EventHubEventSourceResource - An event source that receives its data from an Azure EventHub.
type EventHubEventSourceResource struct {
	// REQUIRED; The kind of the event source.
	Kind *EventSourceResourceKind `json:"kind,omitempty"`

	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the EventHub event source resource.
	Properties *EventHubEventSourceResourceProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetEventSourceResource implements the EventSourceResourceClassification interface for type EventHubEventSourceResource.
func (e *EventHubEventSourceResource) GetEventSourceResource() *EventSourceResource {
	return &EventSourceResource{
		Kind:     e.Kind,
		Location: e.Location,
		Tags:     e.Tags,
		ID:       e.ID,
		Name:     e.Name,
		Type:     e.Type,
	}
}

// EventHubEventSourceResourceProperties - Properties of the EventHub event source resource.
type EventHubEventSourceResourceProperties struct {
	// REQUIRED; The name of the event hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`

	// REQUIRED; The name of the event hub.
	EventHubName *string `json:"eventHubName,omitempty"`

	// REQUIRED; The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`

	// REQUIRED; The name of the SAS key that grants the Time Series Insights service access to the event hub. The shared access
	// policies for this key must grant 'Listen' permissions to the event hub.
	KeyName *string `json:"keyName,omitempty"`

	// REQUIRED; The name of the service bus that contains the event hub.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`

	// An object that contains the details about the starting point in time to ingest events.
	IngressStartAt *IngressStartAtProperties `json:"ingressStartAt,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// EventHubEventSourceUpdateParameters - Parameters supplied to the Update Event Source operation to update an EventHub event
// source.
type EventHubEventSourceUpdateParameters struct {
	// REQUIRED; The kind of the event source.
	Kind *EventSourceKind `json:"kind,omitempty"`

	// Properties of the EventHub event source.
	Properties *EventHubEventSourceMutableProperties `json:"properties,omitempty"`

	// Key-value pairs of additional properties for the event source.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEventSourceUpdateParameters implements the EventSourceUpdateParametersClassification interface for type EventHubEventSourceUpdateParameters.
func (e *EventHubEventSourceUpdateParameters) GetEventSourceUpdateParameters() *EventSourceUpdateParameters {
	return &EventSourceUpdateParameters{
		Kind: e.Kind,
		Tags: e.Tags,
	}
}

// EventSourceCommonProperties - Properties of the event source.
type EventSourceCommonProperties struct {
	// An object that contains the details about the starting point in time to ingest events.
	IngressStartAt *IngressStartAtProperties `json:"ingressStartAt,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// EventSourceCreateOrUpdateParametersClassification provides polymorphic access to related types.
// Call the interface's GetEventSourceCreateOrUpdateParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EventHubEventSourceCreateOrUpdateParameters, *EventSourceCreateOrUpdateParameters, *IoTHubEventSourceCreateOrUpdateParameters
type EventSourceCreateOrUpdateParametersClassification interface {
	// GetEventSourceCreateOrUpdateParameters returns the EventSourceCreateOrUpdateParameters content of the underlying type.
	GetEventSourceCreateOrUpdateParameters() *EventSourceCreateOrUpdateParameters
}

// EventSourceCreateOrUpdateParameters - Parameters supplied to the Create or Update Event Source operation.
type EventSourceCreateOrUpdateParameters struct {
	// REQUIRED; The kind of the event source.
	Kind *EventSourceKind `json:"kind,omitempty"`

	// REQUIRED; The location of the resource.
	Location *string `json:"location,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEventSourceCreateOrUpdateParameters implements the EventSourceCreateOrUpdateParametersClassification interface for type
// EventSourceCreateOrUpdateParameters.
func (e *EventSourceCreateOrUpdateParameters) GetEventSourceCreateOrUpdateParameters() *EventSourceCreateOrUpdateParameters {
	return e
}

// EventSourceListResponse - The response of the List EventSources operation.
type EventSourceListResponse struct {
	// Result of the List EventSources operation.
	Value []EventSourceResourceClassification `json:"value,omitempty"`
}

// EventSourceMutableProperties - An object that represents a set of mutable event source resource properties.
type EventSourceMutableProperties struct {
	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
}

// EventSourceResourceClassification provides polymorphic access to related types.
// Call the interface's GetEventSourceResource() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EventHubEventSourceResource, *EventSourceResource, *IoTHubEventSourceResource
type EventSourceResourceClassification interface {
	// GetEventSourceResource returns the EventSourceResource content of the underlying type.
	GetEventSourceResource() *EventSourceResource
}

// EventSourceResource - An environment receives data from one or more event sources. Each event source has associated connection
// info that allows the Time Series Insights ingress pipeline to connect to and pull data from the
// event source
type EventSourceResource struct {
	// REQUIRED; The kind of the event source.
	Kind *EventSourceResourceKind `json:"kind,omitempty"`

	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetEventSourceResource implements the EventSourceResourceClassification interface for type EventSourceResource.
func (e *EventSourceResource) GetEventSourceResource() *EventSourceResource { return e }

// EventSourceUpdateParametersClassification provides polymorphic access to related types.
// Call the interface's GetEventSourceUpdateParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *EventHubEventSourceUpdateParameters, *EventSourceUpdateParameters, *IoTHubEventSourceUpdateParameters
type EventSourceUpdateParametersClassification interface {
	// GetEventSourceUpdateParameters returns the EventSourceUpdateParameters content of the underlying type.
	GetEventSourceUpdateParameters() *EventSourceUpdateParameters
}

// EventSourceUpdateParameters - Parameters supplied to the Update Event Source operation.
type EventSourceUpdateParameters struct {
	// REQUIRED; The kind of the event source.
	Kind *EventSourceKind `json:"kind,omitempty"`

	// Key-value pairs of additional properties for the event source.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEventSourceUpdateParameters implements the EventSourceUpdateParametersClassification interface for type EventSourceUpdateParameters.
func (e *EventSourceUpdateParameters) GetEventSourceUpdateParameters() *EventSourceUpdateParameters {
	return e
}

// EventSourcesClientCreateOrUpdateOptions contains the optional parameters for the EventSourcesClient.CreateOrUpdate method.
type EventSourcesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// EventSourcesClientDeleteOptions contains the optional parameters for the EventSourcesClient.Delete method.
type EventSourcesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// EventSourcesClientGetOptions contains the optional parameters for the EventSourcesClient.Get method.
type EventSourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// EventSourcesClientListByEnvironmentOptions contains the optional parameters for the EventSourcesClient.ListByEnvironment
// method.
type EventSourcesClientListByEnvironmentOptions struct {
	// placeholder for future optional parameters
}

// EventSourcesClientUpdateOptions contains the optional parameters for the EventSourcesClient.Update method.
type EventSourcesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Gen1EnvironmentCreateOrUpdateParameters - Parameters supplied to the Create or Update Environment operation for a Gen1
// environment.
type Gen1EnvironmentCreateOrUpdateParameters struct {
	// REQUIRED; The kind of the environment.
	Kind *EnvironmentKind `json:"kind,omitempty"`

	// REQUIRED; The location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties used to create a Gen1 environment.
	Properties *Gen1EnvironmentCreationProperties `json:"properties,omitempty"`

	// REQUIRED; The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku
	// determines the capacity of the environment, the ingress rate, and the billing rate.
	SKU *SKU `json:"sku,omitempty"`

	// Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEnvironmentCreateOrUpdateParameters implements the EnvironmentCreateOrUpdateParametersClassification interface for type
// Gen1EnvironmentCreateOrUpdateParameters.
func (g *Gen1EnvironmentCreateOrUpdateParameters) GetEnvironmentCreateOrUpdateParameters() *EnvironmentCreateOrUpdateParameters {
	return &EnvironmentCreateOrUpdateParameters{
		Kind:     g.Kind,
		SKU:      g.SKU,
		Location: g.Location,
		Tags:     g.Tags,
	}
}

// Gen1EnvironmentCreationProperties - Properties used to create a Gen1 environment.
type Gen1EnvironmentCreationProperties struct {
	// REQUIRED; ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
	DataRetentionTime *string `json:"dataRetentionTime,omitempty"`

	// The list of event properties which will be used to partition data in the environment. Currently, only a single partition
	// key property is supported.
	PartitionKeyProperties []*TimeSeriesIDProperty `json:"partitionKeyProperties,omitempty"`

	// The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress"
	// is specified, new events will not be read from the event source. If
	// "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The
	// default behavior is PurgeOldData.
	StorageLimitExceededBehavior *StorageLimitExceededBehavior `json:"storageLimitExceededBehavior,omitempty"`
}

// Gen1EnvironmentMutableProperties - An object that represents a set of mutable Gen1 environment resource properties.
type Gen1EnvironmentMutableProperties struct {
	// ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
	DataRetentionTime *string `json:"dataRetentionTime,omitempty"`

	// The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress"
	// is specified, new events will not be read from the event source. If
	// "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The
	// default behavior is PurgeOldData.
	StorageLimitExceededBehavior *StorageLimitExceededBehavior `json:"storageLimitExceededBehavior,omitempty"`
}

// Gen1EnvironmentResource - An environment is a set of time-series data available for query, and is the top level Azure Time
// Series Insights resource. Gen1 environments have data retention limits.
type Gen1EnvironmentResource struct {
	// REQUIRED; The kind of the environment.
	Kind *EnvironmentResourceKind `json:"kind,omitempty"`

	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the Gen1 environment.
	Properties *Gen1EnvironmentResourceProperties `json:"properties,omitempty"`

	// REQUIRED; The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku
	// determines the capacity of the environment, the ingress rate, and the billing rate.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetEnvironmentResource implements the EnvironmentResourceClassification interface for type Gen1EnvironmentResource.
func (g *Gen1EnvironmentResource) GetEnvironmentResource() *EnvironmentResource {
	return &EnvironmentResource{
		SKU:      g.SKU,
		Kind:     g.Kind,
		Location: g.Location,
		Tags:     g.Tags,
		ID:       g.ID,
		Name:     g.Name,
		Type:     g.Type,
	}
}

// Gen1EnvironmentResourceProperties - Properties of the Gen1 environment.
type Gen1EnvironmentResourceProperties struct {
	// REQUIRED; ISO8601 timespan specifying the minimum number of days the environment's events will be available for query.
	DataRetentionTime *string `json:"dataRetentionTime,omitempty"`

	// The list of event properties which will be used to partition data in the environment. Currently, only a single partition
	// key property is supported.
	PartitionKeyProperties []*TimeSeriesIDProperty `json:"partitionKeyProperties,omitempty"`

	// The behavior the Time Series Insights service should take when the environment's capacity has been exceeded. If "PauseIngress"
	// is specified, new events will not be read from the event source. If
	// "PurgeOldData" is specified, new events will continue to be read and old events will be deleted from the environment. The
	// default behavior is PurgeOldData.
	StorageLimitExceededBehavior *StorageLimitExceededBehavior `json:"storageLimitExceededBehavior,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified domain name used to access the environment data, e.g. to query the environment's events
	// or upload reference data for the environment.
	DataAccessFqdn *string `json:"dataAccessFqdn,omitempty" azure:"ro"`

	// READ-ONLY; An id used to access the environment data, e.g. to query the environment's events or upload reference data for
	// the environment.
	DataAccessID *string `json:"dataAccessId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; An object that represents the status of the environment, and its internal state in the Time Series Insights
	// service.
	Status *EnvironmentStatus `json:"status,omitempty" azure:"ro"`
}

// Gen1EnvironmentUpdateParameters - Parameters supplied to the Update Environment operation to update a Gen1 environment.
type Gen1EnvironmentUpdateParameters struct {
	// REQUIRED; The kind of the environment.
	Kind *EnvironmentKind `json:"kind,omitempty"`

	// Properties of the Gen1 environment.
	Properties *Gen1EnvironmentMutableProperties `json:"properties,omitempty"`

	// The sku of the environment.
	SKU *SKU `json:"sku,omitempty"`

	// Key-value pairs of additional properties for the environment.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEnvironmentUpdateParameters implements the EnvironmentUpdateParametersClassification interface for type Gen1EnvironmentUpdateParameters.
func (g *Gen1EnvironmentUpdateParameters) GetEnvironmentUpdateParameters() *EnvironmentUpdateParameters {
	return &EnvironmentUpdateParameters{
		Kind: g.Kind,
		Tags: g.Tags,
	}
}

// Gen2EnvironmentCreateOrUpdateParameters - Parameters supplied to the Create or Update Environment operation for a Gen2
// environment.
type Gen2EnvironmentCreateOrUpdateParameters struct {
	// REQUIRED; The kind of the environment.
	Kind *EnvironmentKind `json:"kind,omitempty"`

	// REQUIRED; The location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties used to create a Gen2 environment.
	Properties *Gen2EnvironmentCreationProperties `json:"properties,omitempty"`

	// REQUIRED; The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku
	// determines the capacity of the environment, the ingress rate, and the billing rate.
	SKU *SKU `json:"sku,omitempty"`

	// Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEnvironmentCreateOrUpdateParameters implements the EnvironmentCreateOrUpdateParametersClassification interface for type
// Gen2EnvironmentCreateOrUpdateParameters.
func (g *Gen2EnvironmentCreateOrUpdateParameters) GetEnvironmentCreateOrUpdateParameters() *EnvironmentCreateOrUpdateParameters {
	return &EnvironmentCreateOrUpdateParameters{
		Kind:     g.Kind,
		SKU:      g.SKU,
		Location: g.Location,
		Tags:     g.Tags,
	}
}

// Gen2EnvironmentCreationProperties - Properties used to create a Gen2 environment.
type Gen2EnvironmentCreationProperties struct {
	// REQUIRED; The storage configuration provides the connection details that allows the Time Series Insights service to connect
	// to the customer storage account that is used to store the environment's data.
	StorageConfiguration *Gen2StorageConfigurationInput `json:"storageConfiguration,omitempty"`

	// REQUIRED; The list of event properties which will be used to define the environment's time series id.
	TimeSeriesIDProperties []*TimeSeriesIDProperty `json:"timeSeriesIdProperties,omitempty"`

	// The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's
	// data available for faster query.
	WarmStoreConfiguration *WarmStoreConfigurationProperties `json:"warmStoreConfiguration,omitempty"`
}

// Gen2EnvironmentMutableProperties - An object that represents a set of mutable Gen2 environment resource properties.
type Gen2EnvironmentMutableProperties struct {
	// The storage configuration provides the connection details that allows the Time Series Insights service to connect to the
	// customer storage account that is used to store the environment's data.
	StorageConfiguration *Gen2StorageConfigurationMutableProperties `json:"storageConfiguration,omitempty"`

	// The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's
	// data available for faster query.
	WarmStoreConfiguration *WarmStoreConfigurationProperties `json:"warmStoreConfiguration,omitempty"`
}

// Gen2EnvironmentResource - An environment is a set of time-series data available for query, and is the top level Azure Time
// Series Insights resource. Gen2 environments do not have set data retention limits.
type Gen2EnvironmentResource struct {
	// REQUIRED; The kind of the environment.
	Kind *EnvironmentResourceKind `json:"kind,omitempty"`

	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the Gen2 environment.
	Properties *Gen2EnvironmentResourceProperties `json:"properties,omitempty"`

	// REQUIRED; The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku
	// determines the capacity of the environment, the ingress rate, and the billing rate.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetEnvironmentResource implements the EnvironmentResourceClassification interface for type Gen2EnvironmentResource.
func (g *Gen2EnvironmentResource) GetEnvironmentResource() *EnvironmentResource {
	return &EnvironmentResource{
		SKU:      g.SKU,
		Kind:     g.Kind,
		Location: g.Location,
		Tags:     g.Tags,
		ID:       g.ID,
		Name:     g.Name,
		Type:     g.Type,
	}
}

// Gen2EnvironmentResourceProperties - Properties of the Gen2 environment.
type Gen2EnvironmentResourceProperties struct {
	// REQUIRED; The storage configuration provides the connection details that allows the Time Series Insights service to connect
	// to the customer storage account that is used to store the environment's data.
	StorageConfiguration *Gen2StorageConfigurationOutput `json:"storageConfiguration,omitempty"`

	// REQUIRED; The list of event properties which will be used to define the environment's time series id.
	TimeSeriesIDProperties []*TimeSeriesIDProperty `json:"timeSeriesIdProperties,omitempty"`

	// The warm store configuration provides the details to create a warm store cache that will retain a copy of the environment's
	// data available for faster query.
	WarmStoreConfiguration *WarmStoreConfigurationProperties `json:"warmStoreConfiguration,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The fully qualified domain name used to access the environment data, e.g. to query the environment's events
	// or upload reference data for the environment.
	DataAccessFqdn *string `json:"dataAccessFqdn,omitempty" azure:"ro"`

	// READ-ONLY; An id used to access the environment data, e.g. to query the environment's events or upload reference data for
	// the environment.
	DataAccessID *string `json:"dataAccessId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; An object that represents the status of the environment, and its internal state in the Time Series Insights
	// service.
	Status *EnvironmentStatus `json:"status,omitempty" azure:"ro"`
}

// Gen2EnvironmentUpdateParameters - Parameters supplied to the Update Environment operation to update a Gen2 environment.
type Gen2EnvironmentUpdateParameters struct {
	// REQUIRED; The kind of the environment.
	Kind *EnvironmentKind `json:"kind,omitempty"`

	// Properties of the Gen2 environment.
	Properties *Gen2EnvironmentMutableProperties `json:"properties,omitempty"`

	// Key-value pairs of additional properties for the environment.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEnvironmentUpdateParameters implements the EnvironmentUpdateParametersClassification interface for type Gen2EnvironmentUpdateParameters.
func (g *Gen2EnvironmentUpdateParameters) GetEnvironmentUpdateParameters() *EnvironmentUpdateParameters {
	return &EnvironmentUpdateParameters{
		Kind: g.Kind,
		Tags: g.Tags,
	}
}

// Gen2StorageConfigurationInput - The storage configuration provides the connection details that allows the Time Series Insights
// service to connect to the customer storage account that is used to store the environment's data.
type Gen2StorageConfigurationInput struct {
	// REQUIRED; The name of the storage account that will hold the environment's Gen2 data.
	AccountName *string `json:"accountName,omitempty"`

	// REQUIRED; The value of the management key that grants the Time Series Insights service write access to the storage account.
	// This property is not shown in environment responses.
	ManagementKey *string `json:"managementKey,omitempty"`
}

// Gen2StorageConfigurationMutableProperties - The storage configuration provides the connection details that allows the Time
// Series Insights service to connect to the customer storage account that is used to store the environment's data.
type Gen2StorageConfigurationMutableProperties struct {
	// REQUIRED; The value of the management key that grants the Time Series Insights service write access to the storage account.
	// This property is not shown in environment responses.
	ManagementKey *string `json:"managementKey,omitempty"`
}

// Gen2StorageConfigurationOutput - The storage configuration provides the non-secret connection details about the customer
// storage account that is used to store the environment's data.
type Gen2StorageConfigurationOutput struct {
	// REQUIRED; The name of the storage account that will hold the environment's Gen2 data.
	AccountName *string `json:"accountName,omitempty"`
}

// IngressEnvironmentStatus - An object that represents the status of ingress on an environment.
type IngressEnvironmentStatus struct {
	// This string represents the state of ingress operations on an environment. It can be "Disabled", "Ready", "Running", "Paused"
	// or "Unknown"
	State *IngressState `json:"state,omitempty"`

	// READ-ONLY; An object that contains the details about an environment's state.
	StateDetails *EnvironmentStateDetails `json:"stateDetails,omitempty" azure:"ro"`
}

// IngressStartAtProperties - An object that contains the details about the starting point in time to ingest events.
type IngressStartAtProperties struct {
	// ISO8601 UTC datetime with seconds precision (milliseconds are optional), specifying the date and time that will be the
	// starting point for Events to be consumed.
	Time *string `json:"time,omitempty"`

	// The type of the ingressStartAt, It can be "EarliestAvailable", "EventSourceCreationTime", "CustomEnqueuedTime".
	Type *IngressStartAtType `json:"type,omitempty"`
}

// IoTHubEventSourceCommonProperties - Properties of the IoTHub event source.
type IoTHubEventSourceCommonProperties struct {
	// REQUIRED; The name of the iot hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`

	// REQUIRED; The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`

	// REQUIRED; The name of the iot hub.
	IotHubName *string `json:"iotHubName,omitempty"`

	// REQUIRED; The name of the Shared Access Policy key that grants the Time Series Insights service access to the iot hub.
	// This shared access policy key must grant 'service connect' permissions to the iot hub.
	KeyName *string `json:"keyName,omitempty"`

	// An object that contains the details about the starting point in time to ingest events.
	IngressStartAt *IngressStartAtProperties `json:"ingressStartAt,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IoTHubEventSourceCreateOrUpdateParameters - Parameters supplied to the Create or Update Event Source operation for an IoTHub
// event source.
type IoTHubEventSourceCreateOrUpdateParameters struct {
	// REQUIRED; The kind of the event source.
	Kind *EventSourceKind `json:"kind,omitempty"`

	// REQUIRED; The location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the IoTHub event source that are required on create or update requests.
	Properties *IoTHubEventSourceCreationProperties `json:"properties,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEventSourceCreateOrUpdateParameters implements the EventSourceCreateOrUpdateParametersClassification interface for type
// IoTHubEventSourceCreateOrUpdateParameters.
func (i *IoTHubEventSourceCreateOrUpdateParameters) GetEventSourceCreateOrUpdateParameters() *EventSourceCreateOrUpdateParameters {
	return &EventSourceCreateOrUpdateParameters{
		Kind:           i.Kind,
		LocalTimestamp: i.LocalTimestamp,
		Location:       i.Location,
		Tags:           i.Tags,
	}
}

// IoTHubEventSourceCreationProperties - Properties of the IoTHub event source that are required on create or update requests.
type IoTHubEventSourceCreationProperties struct {
	// REQUIRED; The name of the iot hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`

	// REQUIRED; The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`

	// REQUIRED; The name of the iot hub.
	IotHubName *string `json:"iotHubName,omitempty"`

	// REQUIRED; The name of the Shared Access Policy key that grants the Time Series Insights service access to the iot hub.
	// This shared access policy key must grant 'service connect' permissions to the iot hub.
	KeyName *string `json:"keyName,omitempty"`

	// REQUIRED; The value of the Shared Access Policy key that grants the Time Series Insights service read access to the iot
	// hub. This property is not shown in event source responses.
	SharedAccessKey *string `json:"sharedAccessKey,omitempty"`

	// An object that contains the details about the starting point in time to ingest events.
	IngressStartAt *IngressStartAtProperties `json:"ingressStartAt,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IoTHubEventSourceMutableProperties - An object that represents a set of mutable IoTHub event source resource properties.
type IoTHubEventSourceMutableProperties struct {
	// The value of the shared access key that grants the Time Series Insights service read access to the iot hub. This property
	// is not shown in event source responses.
	SharedAccessKey *string `json:"sharedAccessKey,omitempty"`

	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`
}

// IoTHubEventSourceResource - An event source that receives its data from an Azure IoTHub.
type IoTHubEventSourceResource struct {
	// REQUIRED; The kind of the event source.
	Kind *EventSourceResourceKind `json:"kind,omitempty"`

	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the IoTHub event source resource.
	Properties *IoTHubEventSourceResourceProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetEventSourceResource implements the EventSourceResourceClassification interface for type IoTHubEventSourceResource.
func (i *IoTHubEventSourceResource) GetEventSourceResource() *EventSourceResource {
	return &EventSourceResource{
		Kind:     i.Kind,
		Location: i.Location,
		Tags:     i.Tags,
		ID:       i.ID,
		Name:     i.Name,
		Type:     i.Type,
	}
}

// IoTHubEventSourceResourceProperties - Properties of the IoTHub event source resource.
type IoTHubEventSourceResourceProperties struct {
	// REQUIRED; The name of the iot hub's consumer group that holds the partitions from which events will be read.
	ConsumerGroupName *string `json:"consumerGroupName,omitempty"`

	// REQUIRED; The resource id of the event source in Azure Resource Manager.
	EventSourceResourceID *string `json:"eventSourceResourceId,omitempty"`

	// REQUIRED; The name of the iot hub.
	IotHubName *string `json:"iotHubName,omitempty"`

	// REQUIRED; The name of the Shared Access Policy key that grants the Time Series Insights service access to the iot hub.
	// This shared access policy key must grant 'service connect' permissions to the iot hub.
	KeyName *string `json:"keyName,omitempty"`

	// An object that contains the details about the starting point in time to ingest events.
	IngressStartAt *IngressStartAtProperties `json:"ingressStartAt,omitempty"`

	// An object that represents the local timestamp property. It contains the format of local timestamp that needs to be used
	// and the corresponding timezone offset information. If a value isn't specified
	// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
	LocalTimestamp *LocalTimestamp `json:"localTimestamp,omitempty"`

	// The event property that will be used as the event source's timestamp. If a value isn't specified for timestampPropertyName,
	// or if null or empty-string is specified, the event creation time will be
	// used.
	TimestampPropertyName *string `json:"timestampPropertyName,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// IoTHubEventSourceUpdateParameters - Parameters supplied to the Update Event Source operation to update an IoTHub event
// source.
type IoTHubEventSourceUpdateParameters struct {
	// REQUIRED; The kind of the event source.
	Kind *EventSourceKind `json:"kind,omitempty"`

	// Properties of the IoTHub event source.
	Properties *IoTHubEventSourceMutableProperties `json:"properties,omitempty"`

	// Key-value pairs of additional properties for the event source.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetEventSourceUpdateParameters implements the EventSourceUpdateParametersClassification interface for type IoTHubEventSourceUpdateParameters.
func (i *IoTHubEventSourceUpdateParameters) GetEventSourceUpdateParameters() *EventSourceUpdateParameters {
	return &EventSourceUpdateParameters{
		Kind: i.Kind,
		Tags: i.Tags,
	}
}

// LocalTimestamp - An object that represents the local timestamp property. It contains the format of local timestamp that
// needs to be used and the corresponding timezone offset information. If a value isn't specified
// for localTimestamp, or if null, then the local timestamp will not be ingressed with the events.
type LocalTimestamp struct {
	// An enum that represents the format of the local timestamp property that needs to be set.
	Format *LocalTimestampFormat `json:"format,omitempty"`

	// An object that represents the offset information for the local timestamp format specified. Should not be specified for
	// LocalTimestampFormat - Embedded.
	TimeZoneOffset *LocalTimestampTimeZoneOffset `json:"timeZoneOffset,omitempty"`
}

// LocalTimestampTimeZoneOffset - An object that represents the offset information for the local timestamp format specified.
// Should not be specified for LocalTimestampFormat - Embedded.
type LocalTimestampTimeZoneOffset struct {
	// The event property that will be contain the offset information to calculate the local timestamp. When the LocalTimestampFormat
	// is Iana, the property name will contain the name of the column which
	// contains IANA Timezone Name (eg: Americas/Los Angeles). When LocalTimestampFormat is Timespan, it contains the name of
	// property which contains values representing the offset (eg: P1D or 1.00:00:00)
	PropertyName *string `json:"propertyName,omitempty"`
}

// LogSpecification - The specification of an Azure Monitoring log.
type LogSpecification struct {
	// Log display name.
	DisplayName *string `json:"displayName,omitempty"`

	// Log name.
	Name *string `json:"name,omitempty"`
}

// MetricAvailability - Retention policy of a resource metric.
type MetricAvailability struct {
	BlobDuration *string `json:"blobDuration,omitempty"`
	TimeGrain    *string `json:"timeGrain,omitempty"`
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// Aggregation type could be Average.
	AggregationType *string `json:"aggregationType,omitempty"`

	// Retention policies of a resource metric.
	Availabilities []*MetricAvailability `json:"availabilities,omitempty"`

	// The category this metric specification belong to, could be Capacity.
	Category *string `json:"category,omitempty"`

	// Dimensions of blobs, including blob type and access tier.
	Dimensions []*Dimension `json:"dimensions,omitempty"`

	// Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of metric specification.
	Name *string `json:"name,omitempty"`

	// Account Resource Id.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// Unit could be Bytes or Count.
	Unit *string `json:"unit,omitempty"`
}

// Operation - A Time Series Insights REST API operation
type Operation struct {
	// Properties of operation, include metric specifications.
	OperationProperties *OperationProperties `json:"properties,omitempty"`

	// The intended executor of the operation.
	Origin *string `json:"origin,omitempty"`

	// READ-ONLY; Contains the localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - Contains the localized display information for this particular operation / action.
type OperationDisplay struct {
	// READ-ONLY; The localized friendly description for the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of the request to list Time Series Insights operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Time Series Insights operations supported by the Microsoft.TimeSeriesInsights resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

type ReferenceDataSetCreateOrUpdateParameters struct {
	// REQUIRED; The location of the resource.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties used to create a reference data set.
	Properties *ReferenceDataSetCreationProperties `json:"properties,omitempty"`

	// Key-value pairs of additional properties for the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ReferenceDataSetCreationProperties - Properties used to create a reference data set.
type ReferenceDataSetCreationProperties struct {
	// REQUIRED; The list of key properties for the reference data set.
	KeyProperties []*ReferenceDataSetKeyProperty `json:"keyProperties,omitempty"`

	// The reference data set key comparison behavior can be set using this property. By default, the value is 'Ordinal' - which
	// means case sensitive key comparison will be performed while joining reference
	// data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will
	// be used.
	DataStringComparisonBehavior *DataStringComparisonBehavior `json:"dataStringComparisonBehavior,omitempty"`
}

// ReferenceDataSetKeyProperty - A key property for the reference data set. A reference data set can have multiple key properties.
type ReferenceDataSetKeyProperty struct {
	// The name of the key property.
	Name *string `json:"name,omitempty"`

	// The type of the key property.
	Type *ReferenceDataKeyPropertyType `json:"type,omitempty"`
}

// ReferenceDataSetListResponse - The response of the List Reference Data Sets operation.
type ReferenceDataSetListResponse struct {
	// Result of the List Reference Data Sets operation.
	Value []*ReferenceDataSetResource `json:"value,omitempty"`
}

// ReferenceDataSetResource - A reference data set provides metadata about the events in an environment. Metadata in the reference
// data set will be joined with events as they are read from event sources. The metadata that makes up
// the reference data set is uploaded or modified through the Time Series Insights data plane APIs.
type ReferenceDataSetResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Properties of the reference data set.
	Properties *ReferenceDataSetResourceProperties `json:"properties,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReferenceDataSetResourceProperties - Properties of the reference data set.
type ReferenceDataSetResourceProperties struct {
	// REQUIRED; The list of key properties for the reference data set.
	KeyProperties []*ReferenceDataSetKeyProperty `json:"keyProperties,omitempty"`

	// The reference data set key comparison behavior can be set using this property. By default, the value is 'Ordinal' - which
	// means case sensitive key comparison will be performed while joining reference
	// data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set, case insensitive comparison will
	// be used.
	DataStringComparisonBehavior *DataStringComparisonBehavior `json:"dataStringComparisonBehavior,omitempty"`

	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ReferenceDataSetUpdateParameters - Parameters supplied to the Update Reference Data Set operation.
type ReferenceDataSetUpdateParameters struct {
	// Key-value pairs of additional properties for the reference data set.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ReferenceDataSetsClientCreateOrUpdateOptions contains the optional parameters for the ReferenceDataSetsClient.CreateOrUpdate
// method.
type ReferenceDataSetsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ReferenceDataSetsClientDeleteOptions contains the optional parameters for the ReferenceDataSetsClient.Delete method.
type ReferenceDataSetsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ReferenceDataSetsClientGetOptions contains the optional parameters for the ReferenceDataSetsClient.Get method.
type ReferenceDataSetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReferenceDataSetsClientListByEnvironmentOptions contains the optional parameters for the ReferenceDataSetsClient.ListByEnvironment
// method.
type ReferenceDataSetsClientListByEnvironmentOptions struct {
	// placeholder for future optional parameters
}

// ReferenceDataSetsClientUpdateOptions contains the optional parameters for the ReferenceDataSetsClient.Update method.
type ReferenceDataSetsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Resource - Time Series Insights resource
type Resource struct {
	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceProperties - Properties that are common to all tracked resources.
type ResourceProperties struct {
	// READ-ONLY; The time the resource was created.
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the resource.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SKU - The sku determines the type of environment, either Gen1 (S1 or S2) or Gen2 (L1). For Gen1 environments the sku determines
// the capacity of the environment, the ingress rate, and the billing rate.
type SKU struct {
	// REQUIRED; The capacity of the sku. For Gen1 environments, this value can be changed to support scale out of environments
	// after they have been created.
	Capacity *int32 `json:"capacity,omitempty"`

	// REQUIRED; The name of this SKU.
	Name *SKUName `json:"name,omitempty"`
}

// ServiceSpecification - One property of operation, include metric specifications.
type ServiceSpecification struct {
	// A list of Azure Monitoring log definitions.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// TimeSeriesIDProperty - The structure of the property that a time series id can have. An environment can have multiple such
// properties.
type TimeSeriesIDProperty struct {
	// The name of the property.
	Name *string `json:"name,omitempty"`

	// The type of the property.
	Type *PropertyType `json:"type,omitempty"`
}

// TrackedResource - Time Series Insights resource that is tracked by Azure Resource Manager.
type TrackedResource struct {
	// REQUIRED; Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource Id
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// WarmStorageEnvironmentStatus - An object that represents the status of warm storage on an environment.
type WarmStorageEnvironmentStatus struct {
	// READ-ONLY; An object that contains the status of warm storage properties usage.
	PropertiesUsage *WarmStoragePropertiesUsage `json:"propertiesUsage,omitempty" azure:"ro"`
}

// WarmStoragePropertiesUsage - An object that contains the status of warm storage properties usage.
type WarmStoragePropertiesUsage struct {
	// This string represents the state of warm storage properties usage. It can be "Ok", "Error", "Unknown".
	State *WarmStoragePropertiesState `json:"state,omitempty"`

	// READ-ONLY; An object that contains the details about warm storage properties usage state.
	StateDetails *WarmStoragePropertiesUsageStateDetails `json:"stateDetails,omitempty" azure:"ro"`
}

// WarmStoragePropertiesUsageStateDetails - An object that contains the details about warm storage properties usage state.
type WarmStoragePropertiesUsageStateDetails struct {
	// A value that represents the number of properties used by the environment for S1/S2 SKU and number of properties used by
	// Warm Store for PAYG SKU
	CurrentCount *int32 `json:"currentCount,omitempty"`

	// A value that represents the maximum number of properties used allowed by the environment for S1/S2 SKU and maximum number
	// of properties allowed by Warm Store for PAYG SKU.
	MaxCount *int32 `json:"maxCount,omitempty"`
}

// WarmStoreConfigurationProperties - The warm store configuration provides the details to create a warm store cache that
// will retain a copy of the environment's data available for faster query.
type WarmStoreConfigurationProperties struct {
	// REQUIRED; ISO8601 timespan specifying the number of days the environment's events will be available for query from the
	// warm store.
	DataRetention *string `json:"dataRetention,omitempty"`
}
