//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlinks

// Operation - Microsoft.Resources operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string `json:"description,omitempty"`

	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Resources
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Microsoft.Resources operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Microsoft.Resources operations.
	Value []*Operation `json:"value,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ResourceLink - The resource link.
type ResourceLink struct {
	// Properties for resource link.
	Properties *ResourceLinkProperties `json:"properties,omitempty"`

	// READ-ONLY; The fully qualified ID of the resource link.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource link.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource link object.
	Type interface{} `json:"type,omitempty" azure:"ro"`
}

// ResourceLinkFilter - Resource link filter.
type ResourceLinkFilter struct {
	// REQUIRED; The ID of the target resource.
	TargetID *string `json:"targetId,omitempty"`
}

// ResourceLinkProperties - The resource link properties.
type ResourceLinkProperties struct {
	// REQUIRED; The fully qualified ID of the target resource in the link.
	TargetID *string `json:"targetId,omitempty"`

	// Notes about the resource link.
	Notes *string `json:"notes,omitempty"`

	// READ-ONLY; The fully qualified ID of the source resource in the link.
	SourceID *string `json:"sourceId,omitempty" azure:"ro"`
}

// ResourceLinkResult - List of resource links.
type ResourceLinkResult struct {
	// REQUIRED; An array of resource links.
	Value []*ResourceLink `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ResourceLinksClientCreateOrUpdateOptions contains the optional parameters for the ResourceLinksClient.CreateOrUpdate method.
type ResourceLinksClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ResourceLinksClientDeleteOptions contains the optional parameters for the ResourceLinksClient.Delete method.
type ResourceLinksClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ResourceLinksClientGetOptions contains the optional parameters for the ResourceLinksClient.Get method.
type ResourceLinksClientGetOptions struct {
	// placeholder for future optional parameters
}

// ResourceLinksClientListAtSourceScopeOptions contains the optional parameters for the ResourceLinksClient.ListAtSourceScope
// method.
type ResourceLinksClientListAtSourceScopeOptions struct {
	// The filter to apply when getting resource links. To get links only at the specified scope (not below the scope), use Filter.atScope()..
	// Specifying any value will set the value to atScope().
	Filter *string
}

// ResourceLinksClientListAtSubscriptionOptions contains the optional parameters for the ResourceLinksClient.ListAtSubscription
// method.
type ResourceLinksClientListAtSubscriptionOptions struct {
	// The filter to apply on the list resource links operation. The supported filter for list resource links is targetId. For
	// example, $filter=targetId eq {value}
	Filter *string
}
