//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armfrontdoor

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// NameAvailabilityWithSubscriptionClient contains the methods for the FrontDoorNameAvailabilityWithSubscription group.
// Don't use this type directly, use NewNameAvailabilityWithSubscriptionClient() instead.
type NameAvailabilityWithSubscriptionClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewNameAvailabilityWithSubscriptionClient creates a new instance of NameAvailabilityWithSubscriptionClient with the specified values.
// subscriptionID - The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription
// ID forms part of the URI for every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewNameAvailabilityWithSubscriptionClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*NameAvailabilityWithSubscriptionClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &NameAvailabilityWithSubscriptionClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Check - Check the availability of a Front Door subdomain.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// checkFrontDoorNameAvailabilityInput - Input to check.
// options - NameAvailabilityWithSubscriptionClientCheckOptions contains the optional parameters for the NameAvailabilityWithSubscriptionClient.Check
// method.
func (client *NameAvailabilityWithSubscriptionClient) Check(ctx context.Context, checkFrontDoorNameAvailabilityInput CheckNameAvailabilityInput, options *NameAvailabilityWithSubscriptionClientCheckOptions) (NameAvailabilityWithSubscriptionClientCheckResponse, error) {
	req, err := client.checkCreateRequest(ctx, checkFrontDoorNameAvailabilityInput, options)
	if err != nil {
		return NameAvailabilityWithSubscriptionClientCheckResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return NameAvailabilityWithSubscriptionClientCheckResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return NameAvailabilityWithSubscriptionClientCheckResponse{}, runtime.NewResponseError(resp)
	}
	return client.checkHandleResponse(resp)
}

// checkCreateRequest creates the Check request.
func (client *NameAvailabilityWithSubscriptionClient) checkCreateRequest(ctx context.Context, checkFrontDoorNameAvailabilityInput CheckNameAvailabilityInput, options *NameAvailabilityWithSubscriptionClientCheckOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Network/checkFrontDoorNameAvailability"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, checkFrontDoorNameAvailabilityInput)
}

// checkHandleResponse handles the Check response.
func (client *NameAvailabilityWithSubscriptionClient) checkHandleResponse(resp *http.Response) (NameAvailabilityWithSubscriptionClientCheckResponse, error) {
	result := NameAvailabilityWithSubscriptionClientCheckResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CheckNameAvailabilityOutput); err != nil {
		return NameAvailabilityWithSubscriptionClientCheckResponse{}, err
	}
	return result, nil
}
