//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbotservice

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AlexaChannel.
func (a AlexaChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "AlexaChannel"
	populate(objectMap, "etag", a.Etag)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlexaChannel.
func (a *AlexaChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &a.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &a.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Bot.
func (b Bot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "sku", b.SKU)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	populate(objectMap, "zones", b.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type BotChannel.
func (b BotChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", b.Etag)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "sku", b.SKU)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	populate(objectMap, "zones", b.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BotChannel.
func (b *BotChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &b.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			b.Properties, err = unmarshalChannelClassification(val)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &b.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &b.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BotProperties.
func (b BotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "allSettings", b.AllSettings)
	populate(objectMap, "appPasswordHint", b.AppPasswordHint)
	populate(objectMap, "cmekEncryptionStatus", b.CmekEncryptionStatus)
	populate(objectMap, "cmekKeyVaultUrl", b.CmekKeyVaultURL)
	populate(objectMap, "configuredChannels", b.ConfiguredChannels)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "developerAppInsightKey", b.DeveloperAppInsightKey)
	populate(objectMap, "developerAppInsightsApiKey", b.DeveloperAppInsightsAPIKey)
	populate(objectMap, "developerAppInsightsApplicationId", b.DeveloperAppInsightsApplicationID)
	populate(objectMap, "disableLocalAuth", b.DisableLocalAuth)
	populate(objectMap, "displayName", b.DisplayName)
	populate(objectMap, "enabledChannels", b.EnabledChannels)
	populate(objectMap, "endpoint", b.Endpoint)
	populate(objectMap, "endpointVersion", b.EndpointVersion)
	populate(objectMap, "iconUrl", b.IconURL)
	populate(objectMap, "isCmekEnabled", b.IsCmekEnabled)
	populate(objectMap, "isDeveloperAppInsightsApiKeySet", b.IsDeveloperAppInsightsAPIKeySet)
	populate(objectMap, "isStreamingSupported", b.IsStreamingSupported)
	populate(objectMap, "luisAppIds", b.LuisAppIDs)
	populate(objectMap, "luisKey", b.LuisKey)
	populate(objectMap, "manifestUrl", b.ManifestURL)
	populate(objectMap, "migrationToken", b.MigrationToken)
	populate(objectMap, "msaAppId", b.MsaAppID)
	populate(objectMap, "msaAppMSIResourceId", b.MsaAppMSIResourceID)
	populate(objectMap, "msaAppTenantId", b.MsaAppTenantID)
	populate(objectMap, "msaAppType", b.MsaAppType)
	populate(objectMap, "openWithHint", b.OpenWithHint)
	populate(objectMap, "parameters", b.Parameters)
	populate(objectMap, "privateEndpointConnections", b.PrivateEndpointConnections)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", b.PublicNetworkAccess)
	populate(objectMap, "publishingCredentials", b.PublishingCredentials)
	populate(objectMap, "schemaTransformationVersion", b.SchemaTransformationVersion)
	populate(objectMap, "storageResourceId", b.StorageResourceID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ChannelSettings.
func (c ChannelSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "botId", c.BotID)
	populate(objectMap, "botIconUrl", c.BotIconURL)
	populate(objectMap, "channelDisplayName", c.ChannelDisplayName)
	populate(objectMap, "channelId", c.ChannelID)
	populate(objectMap, "disableLocalAuth", c.DisableLocalAuth)
	populate(objectMap, "extensionKey1", c.ExtensionKey1)
	populate(objectMap, "extensionKey2", c.ExtensionKey2)
	populate(objectMap, "isEnabled", c.IsEnabled)
	populate(objectMap, "sites", c.Sites)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionSetting.
func (c ConnectionSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "kind", c.Kind)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	populate(objectMap, "zones", c.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionSettingProperties.
func (c ConnectionSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "clientId", c.ClientID)
	populate(objectMap, "clientSecret", c.ClientSecret)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "parameters", c.Parameters)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "scopes", c.Scopes)
	populate(objectMap, "serviceProviderDisplayName", c.ServiceProviderDisplayName)
	populate(objectMap, "serviceProviderId", c.ServiceProviderID)
	populate(objectMap, "settingId", c.SettingID)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DirectLineChannel.
func (d DirectLineChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "DirectLineChannel"
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DirectLineChannel.
func (d *DirectLineChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &d.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DirectLineChannelProperties.
func (d DirectLineChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "DirectLineEmbedCode", d.DirectLineEmbedCode)
	populate(objectMap, "sites", d.Sites)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DirectLineSite.
func (d DirectLineSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "isBlockUserUploadEnabled", d.IsBlockUserUploadEnabled)
	populate(objectMap, "isEnabled", d.IsEnabled)
	populate(objectMap, "isSecureSiteEnabled", d.IsSecureSiteEnabled)
	populate(objectMap, "isV1Enabled", d.IsV1Enabled)
	populate(objectMap, "isV3Enabled", d.IsV3Enabled)
	populate(objectMap, "key", d.Key)
	populate(objectMap, "key2", d.Key2)
	populate(objectMap, "siteId", d.SiteID)
	populate(objectMap, "siteName", d.SiteName)
	populate(objectMap, "trustedOrigins", d.TrustedOrigins)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DirectLineSpeechChannel.
func (d DirectLineSpeechChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "DirectLineSpeechChannel"
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DirectLineSpeechChannel.
func (d *DirectLineSpeechChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &d.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailChannel.
func (e EmailChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "EmailChannel"
	populate(objectMap, "etag", e.Etag)
	populate(objectMap, "location", e.Location)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailChannel.
func (e *EmailChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &e.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &e.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &e.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FacebookChannel.
func (f FacebookChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "FacebookChannel"
	populate(objectMap, "etag", f.Etag)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FacebookChannel.
func (f *FacebookChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &f.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &f.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FacebookChannelProperties.
func (f FacebookChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "appId", f.AppID)
	populate(objectMap, "appSecret", f.AppSecret)
	populate(objectMap, "callbackUrl", f.CallbackURL)
	populate(objectMap, "isEnabled", f.IsEnabled)
	populate(objectMap, "pages", f.Pages)
	populate(objectMap, "verifyToken", f.VerifyToken)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type KikChannel.
func (k KikChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "KikChannel"
	populate(objectMap, "etag", k.Etag)
	populate(objectMap, "location", k.Location)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KikChannel.
func (k *KikChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &k.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &k.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &k.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LineChannel.
func (l LineChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "LineChannel"
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LineChannel.
func (l *LineChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &l.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LineChannelProperties.
func (l LineChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "callbackUrl", l.CallbackURL)
	populate(objectMap, "isValidated", l.IsValidated)
	populate(objectMap, "lineRegistrations", l.LineRegistrations)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ListChannelWithKeysResponse.
func (l ListChannelWithKeysResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "changedTime", l.ChangedTime)
	populate(objectMap, "entityTag", l.EntityTag)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "kind", l.Kind)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "resource", l.Resource)
	populate(objectMap, "sku", l.SKU)
	populate(objectMap, "setting", l.Setting)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	populate(objectMap, "zones", l.Zones)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListChannelWithKeysResponse.
func (l *ListChannelWithKeysResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulate(val, "ChangedTime", &l.ChangedTime)
			delete(rawMsg, key)
		case "entityTag":
			err = unpopulate(val, "EntityTag", &l.EntityTag)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &l.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			l.Properties, err = unmarshalChannelClassification(val)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "resource":
			l.Resource, err = unmarshalChannelClassification(val)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &l.SKU)
			delete(rawMsg, key)
		case "setting":
			err = unpopulate(val, "Setting", &l.Setting)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "zones":
			err = unpopulate(val, "Zones", &l.Zones)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MsTeamsChannel.
func (m MsTeamsChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "MsTeamsChannel"
	populate(objectMap, "etag", m.Etag)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MsTeamsChannel.
func (m *MsTeamsChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &m.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &m.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultsDescription.
func (o *OperationResultsDescription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "kind", r.Kind)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "zones", r.Zones)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Site.
func (s Site) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", s.ETag)
	populate(objectMap, "isBlockUserUploadEnabled", s.IsBlockUserUploadEnabled)
	populate(objectMap, "isEnabled", s.IsEnabled)
	populate(objectMap, "isSecureSiteEnabled", s.IsSecureSiteEnabled)
	populate(objectMap, "isTokenEnabled", s.IsTokenEnabled)
	populate(objectMap, "isV1Enabled", s.IsV1Enabled)
	populate(objectMap, "isV3Enabled", s.IsV3Enabled)
	populate(objectMap, "isWebchatPreviewEnabled", s.IsWebchatPreviewEnabled)
	populate(objectMap, "key", s.Key)
	populate(objectMap, "key2", s.Key2)
	populate(objectMap, "siteId", s.SiteID)
	populate(objectMap, "siteName", s.SiteName)
	populate(objectMap, "trustedOrigins", s.TrustedOrigins)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type SkypeChannel.
func (s SkypeChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "SkypeChannel"
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SkypeChannel.
func (s *SkypeChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &s.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SlackChannel.
func (s SlackChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "SlackChannel"
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SlackChannel.
func (s *SlackChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &s.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SmsChannel.
func (s SmsChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "SmsChannel"
	populate(objectMap, "etag", s.Etag)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SmsChannel.
func (s *SmsChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &s.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &s.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TelegramChannel.
func (t TelegramChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "TelegramChannel"
	populate(objectMap, "etag", t.Etag)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TelegramChannel.
func (t *TelegramChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &t.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &t.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &t.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebChatChannel.
func (w WebChatChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["channelName"] = "WebChatChannel"
	populate(objectMap, "etag", w.Etag)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebChatChannel.
func (w *WebChatChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "channelName":
			err = unpopulate(val, "ChannelName", &w.ChannelName)
			delete(rawMsg, key)
		case "etag":
			err = unpopulate(val, "Etag", &w.Etag)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WebChatChannelProperties.
func (w WebChatChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sites", w.Sites)
	populate(objectMap, "webChatEmbedCode", w.WebChatEmbedCode)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
