//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const std::array<std::array<typename table_type<T>::type, 4>, 435> igamma_inva_data = { {
      {{ SC_(0.11342023313045501708984375), SC_(0.097540400922298431396484375), SC_(1.035869900800721563193351335409353423054156223778352824799732510014114331303190861923913851617789576), SC_(0.05862165929221091309602935851268320728966552926925608108837955463403857541085640683871851098187935567) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.12698681652545928955078125), SC_(0.93513162632210132756150227031041961003749580131891848591112697892138664595709032559736553036690404), SC_(0.07702073629515159209895492482246819546302457039495283952439305125976814739590655422243170396591695024) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.135477006435394287109375), SC_(0.9100380607375349140135424653157145054283763683426464165277887838730942363760587929004439481331867906), SC_(0.08239454114833290164904666725589763295213501324448854257672874472236795673343348101283994380015493955) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.188381969928741455078125), SC_(0.779595202624673387363485521164023245809684162801375448392802218438362825559076033610794317185133861), SC_(0.1166391941338030559840976122781824609204768300357456413264936214065498992433137767918843993082512688) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.22103404998779296875), SC_(0.7145928353898281531229899766663421465043332388718242321020543488710755276457340056824233507290026167), SC_(0.1384900078344770795221486812547034082011104407568501332022902743558707268824034463784809050893959221) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.278498232364654541015625), SC_(0.6182586795562308310975349170899684675397900921120847475062459321020936519806102953807288680346855742), SC_(0.1784721480822330050905288284953586748392689370078276538971887861788093058242214704511862158537019216) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.308167040348052978515625), SC_(0.5750762878067446972629162563822329468974137308881623861798146424843915189358227607746127802679658861), SC_(0.1999745971366197606214810194646538480932240109343778328885211338343706229230203595508410364650077464) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.546881496906280517578125), SC_(0.3158581972518262198680262971873178145282238457421313069361242252141961771513906035921435181902024621), SC_(0.40399522554055015965171997281891601803562228187095717362147123937459020167864162427846789506528334) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.54722058773040771484375), SC_(0.3155616219617029735803748550238394725944210138946535670470388364147063820887200160768983610508607508), SC_(0.4043391538070912752469413697358973847567093976055568141867354582154449982775159287792880341381161789) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.6323592662811279296875), SC_(0.2451306925552628674700116671932204741230337234325446757090933316372456823776133088401164345457104668), SC_(0.4981721948503688022008818739022596218839268441108020243647633715157177066183221315388893154605681197) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.814723670482635498046875), SC_(0.1145907253421634340428550841021180213245634728137200905215078642375729374894281996476238899008128165), SC_(0.7862852295173094376574861816166162829803656701458377721112754273299144168379358322286031004477952406) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.835008561611175537109375), SC_(0.101331527591007847744573524795847576083929747580314104040226733069549334001280984610814567479857817), SC_(0.8326058923439134249687721563121076618130208457176003407255229510096659223637127918548740068611902389) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.905791938304901123046875), SC_(0.05656193657838154866774148682961754372226868790952633895057593923638262083267913677844800561062284631), SC_(1.04896840759462485702081614165933409290459738742990942007871315448214243965980816410908535790073786) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.9133758544921875), SC_(0.05189064964852823459637928419581919698509481017420310002496395476818562158762986899770261198573844241), SC_(1.080435768098731745020005560573961257374011084999542196321375433066538881295544756909074244422125722) }}, 
      {{ SC_(0.11342023313045501708984375), SC_(0.968867778778076171875), SC_(0.01835818396061160048337643098614074549706602146731102647725732066970461614194476008520575667903820769), SC_(1.448797407656090219493165071703219939123058592597047518890784499076538070587802667567859080671028321) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.097540400922298431396484375), SC_(1.124578830537963702051998473796288168586685310061027732355203576629632283960817297660062046074915143), SC_(0.0659284721147043282303849180640934562566897224895804233539249128398260667430925608435729540214754515) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.12698681652545928955078125), SC_(1.017033751189331824504325403924341720905739138565526684761461549984097760120918333327463981882765665), SC_(0.08649278031454385525728666007963182163925805103763420954040262025741180677454847460411841098791601186) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.135477006435394287109375), SC_(0.9902142921858343274435115921427109074354611809918110403382037220186217516256053009853608288056704689), SC_(0.09248877472325344088393739866931009589190859884078310814802341635680304235539767062268472977333731618) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.188381969928741455078125), SC_(0.8505785998195794526287491308010932266793339719426224792262622633066161829593612618292878964211114605), SC_(0.1305982554060110903644352571539294106230392294124679024676030185902887691963181187121592257303657878) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.22103404998779296875), SC_(0.7808395661964723025065274478432724703812506573362937686319290770429457825258588979051496462804184209), SC_(0.1548317951205897711220384965795747080251080507849479059158897171375778172596890940331713045635641511) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.278498232364654541015625), SC_(0.6772609184694136395829214678207043149699253868567694609654501808726365693498576674966232500529840506), SC_(0.1990250470315257234650602086315659437473047214824637904232710507788991505540315624327049715768915247) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.308167040348052978515625), SC_(0.630732340145806754814474818656317258739611054139979482135367574881529997048038535582075675545383329), SC_(0.2227203252084107833339010674280717585720589607238234483333954941372899120632213762241351353111801409) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.546881496906280517578125), SC_(0.349708717751391355159479214660277171464283691195026088708202769671562811924679353305737371727474314), SC_(0.4456482378008532807988050947059477473750827663770176898902670239364470277606341238138830195865284648) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.54722058773040771484375), SC_(0.34938505235700051109422458264248273843369824263538926665971457103150418551006634428413713838463443), SC_(0.4460217175733750342583186470185268231571709276780851712061443842332352649527336346223436093968900516) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.6323592662811279296875), SC_(0.2723365665725819880697084193348315672163942836223061717484924369936181601343161297604977832581277765), SC_(0.5476941234441064195196321208511198969055308360244560161002793861902290381370045763117008954093133652) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.814723670482635498046875), SC_(0.1283232223230380098811206610224084691036303771630733595757042570301959629906377767938930312924094034), SC_(0.8577498466883962411368177728739427398074845373836199107327704588709507726781916595107240718092847017) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.835008561611175537109375), SC_(0.1135836623459303051429194205019356086721666257185933943800095114966831710249674856235457280143561524), SC_(0.9073723077768857915584037443594473495284668640552456222581651191944986071977435720707982921349172822) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.905791938304901123046875), SC_(0.06362286490652974750551515900848775590349209643142950504238254147486041451220153135727937086746593346), SC_(1.138548958417806819877672656752528834516707875999494557854245128596101999842871365821587081467468729) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.9133758544921875), SC_(0.05839122910435104787959801317712985297073242431714212769707923902518190300188050313568727292734281841), SC_(1.172098433700713966567441591625443115999983390102098023915355276771621952667238157429389664117756093) }}, 
      {{ SC_(0.1419346332550048828125), SC_(0.968867778778076171875), SC_(0.02071934836253989804136051808125936032827483325843529223729374263952186251046878164288294079384678798), SC_(1.56377644811475640972171606288309488019030758199907780303791244112105872633625554623267734499110393) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.097540400922298431396484375), SC_(1.906240501146735627405728538719050272742196757761857063398095587230594456801036092842821773110568176), SC_(0.1557234989288209275828472080090140421199447184166737519995512435500240874319270398254513654236859738) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.12698681652545928955078125), SC_(1.746889660226439769707796999615493342006338076754771883758583845080036360375775016213480275141899151), SC_(0.2002596077596651342317325888043366373380954823329671027872122725030008232437680807213017399722523492) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.135477006435394287109375), SC_(1.706868853024925966866869647473148895344239016501717692391243187680702442620890834745165798505101534), SC_(0.2129795974646839776665682777757533210339641002049819348270911731567455898031637831725545721717175334) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.188381969928741455078125), SC_(1.496402036110226178753807596303443024792020848888375194926104618332228203462037726328030969815045359), SC_(0.2914634957363814616459251957253147303530562178568750069356253062641261676124313970417703556690757765) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.22103404998779296875), SC_(1.389780170786465257163165888411919682295334234979373288233859710186808614418780585928648487393921389), SC_(0.3395697694493451480454334226071565211789536369197603012170000008453482663877818774486999446935503578) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.278498232364654541015625), SC_(1.229174720073372984084496383837881179087223547169626664699876858397174598071709432222238442958855439), SC_(0.4244425653913050008718190012967890644774095596425806319360580424994718887595717604938855299440668093) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.308167040348052978515625), SC_(1.156013053768341543768168548522257409766109807965285308966336963040232539746733111463527005418183613), SC_(0.4686807520841755502989471241669846831690356034356557943101461745637370926841250627778710220335129588) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.546881496906280517578125), SC_(0.6947721882838627949038262091975689387764567019453173647065533321382744657450460331419286643574776482), SC_(0.856829730614052242405116918767233984406720091257778872793994440946733518700749262959776269533866004) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.54722058773040771484375), SC_(0.6942147568794122696200017270629557570076703163891712593315468480078768034853161200814111932265608757), SC_(0.8574495251440085350859678096982695288723874542394079979930290904412490567933548532369594229447389463) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.6323592662811279296875), SC_(0.5589786726957033422941602375813373046879722363449824559752641350510778309452479538716704122275528471), SC_(1.023577834553390956652648263292654002446782700792026164932025970575470481406702608985240964104843903) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.814723670482635498046875), SC_(0.2868813784860015606760412218035657927796176303339322211706677987987728973745366052832491215062119951), SC_(1.507304544624902338801973568545168892096379533153391150979079395057066736786348622620184780822628809) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.835008561611175537109375), SC_(0.2568935837272709908753487794187791358163818306778911259196867303174376772887052388030733749229137646), SC_(1.582455306019404084804450153498424040275078618162624951343780339565478307193874251513518564374071041) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.905791938304901123046875), SC_(0.1506347253417586905688255904812071536482537188067419956228297520577947931339130124933846650042800913), SC_(1.926816526440767605217362474417185267071949430556007186239551941147146911512829851333833992527160027) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.9133758544921875), SC_(0.1390101729626404216517230653577629330653433220311021371773880142236168201232166173456231945275187574), SC_(1.976122143213291899358992568071855876137809030571579600545815122411388046064230680375411764664967352) }}, 
      {{ SC_(0.476447999477386474609375), SC_(0.968867778778076171875), SC_(0.05159397411040075136949974586299580607266007906546148179746530906816283404219559283712915016000747068), SC_(2.542284263439527020342019073908337703600122253760234226452742497319688928938238882786942476219332789) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.097540400922298431396484375), SC_(2.711998557841879052132321087467458969561301949235923127317988801661751718689072320485397011128703986), SC_(0.3061726301503603217632600102982841385077346866054733051600433778645397037685762699828524837236533078) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.12698681652545928955078125), SC_(2.509481000222379121131178804027310310687727437209817740982526954619793535767106985904703722992173981), SC_(0.3822051519276465055012709548939149190375605300969726586966346488734400475030867035740034886129308152) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.135477006435394287109375), SC_(2.458409210485814187917904006480643468287677247468217091147712747506781222972039398943846725155879948), SC_(0.4033904746293868286037552553779666045026032923828053432961548353366544855928138858204135362515178604) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.188381969928741455078125), SC_(2.188248964434296112467156634950206924818018011278198740766069437791737828165048141277099236739551725), SC_(0.5300375057342607295562845813537553704534506915262751036671547908516811278232077346316361106969729471) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.22103404998779296875), SC_(2.050243382982923963771613947416005185164866835589951440724672287906538053173918759947072534032562479), SC_(0.6048995169040271003322175754589831184592352477602955261929277367710566412319010019463181893129013214) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.278498232364654541015625), SC_(1.840631137574182560855013545062548409741029645468452153402874633493413423156847336152022570467587485), SC_(0.7331919863823307457334371983903256057288007300574793309608612666249568883007906616479803455125253383) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.308167040348052978515625), SC_(1.744350708381118249251051701478690964927494924994787998202024870385872437865333693791226759370437478), SC_(0.7985270666248249234782341193466970190722648005544167202737339109655289100111981472583986555225269834) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.546881496906280517578125), SC_(1.120988275866673770933424378433083092381263297948091717184698217334546142305039146644397493122003849), SC_(1.343941442413945149850474141269272112823156571412458776367930311034335925948142892854504569698465968) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.54722058773040771484375), SC_(1.12021163514484362996010705205879519781898026543390250277090751119510005389176045018588094963985866), SC_(1.344784443064824053907594671456442484905035250569516857106637131628604155250443673173345917313602008) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.6323592662811279296875), SC_(0.9293240216825327545093352853305310256721640901685762721672904270184536206469799441561795745661528528), SC_(1.568574199499938310854235369190277325304253833542345228106276030673519607374432875846172300809994232) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.814723670482635498046875), SC_(0.5228096647734261169644972715486128823978656677454381890255197889068840629248497112570422338685429578), SC_(2.20231417304730726213995467539874784745519427853423454106752613869892059845988811356944299318984379) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.835008561611175537109375), SC_(0.4750345879979780591360684481722320160249196132715234673017520389736415383347278898531598719886329476), SC_(2.299046939087323467210160801656799534584651136565626984957054478236859866766997516372016929353644134) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.905791938304901123046875), SC_(0.2972761333051268065655642868001535283120520062023036586867261237897666211984999364868106369390852782), SC_(2.738057255257541590359936507361258972975839255336912632096628946858828235391499336475392632797750207) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.9133758544921875), SC_(0.2767701519129049112772997278822374874580856344211742795905110072800118855017824157767903835258124163), SC_(2.800421321050758702868412368794735484993523770111621005724736326060674113571953393614513799961240407) }}, 
      {{ SC_(0.91750431060791015625), SC_(0.968867778778076171875), SC_(0.1117851406612002011189532448213743771643246380186151461840751027472615492304135396880258366198990242), SC_(3.509662828594721378678565034582473146142482772870812219362439480434178792331392229534633450590419929) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.097540400922298431396484375), SC_(3.060838149397433339394387484318603242663389553622965304918339707400575306131043650395111828390494048), SC_(0.3909472575358788660674368944050986842711536568295345063981709934086423113461390895139007742503650417) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.12698681652545928955078125), SC_(2.841726505216374453769161868196316523987624607259717506501615251703601637448037023101734235939045411), SC_(0.4814628985458572856283403887948087137020311353476037833065337481262465777267284770780851299306733245) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.135477006435394287109375), SC_(2.786400088530337832477457826786432556780644404017319160448736154269583005985698184157152933408230071), SC_(0.5064482163019783309984728948020447518206163219591648115949953749169651962678820640916322576063944774) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.188381969928741455078125), SC_(2.493208595410759004800926145040037652002076652079618050097241223986335036211159239009344808077064865), SC_(0.654141381436128976141661331542933754990647597637260881070017714970543980851648666945514495352529338) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.22103404998779296875), SC_(2.343058090807411537552423784082983869893330572090052574149206635458941425090668385684616463599190097), SC_(0.7403632920423088673192561431964903700347573718927270985760783608522571686929777532683820207578515972) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.278498232364654541015625), SC_(2.11442424745433017619426164664136582139216609327386164797031179506364312661514951530393953883148662), SC_(0.8867294003697711962806206719572810715357940209911836639711508697595047503813271172052288325668806107) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.308167040348052978515625), SC_(2.009143652525874338112700813997349308733489832854564859723899567726312411719799778474151958563978719), SC_(0.9607196958937813560487339195404730113204456415819536143083946503756213104878142267264823134114550476) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.546881496906280517578125), SC_(1.322002402236170755152388972470598195867632017482510329538177899027517087226163486322954930870394776), SC_(1.569075363339806942678265350026298934922174180405594326925947297868393904547333123634625941775322743) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.54722058773040771484375), SC_(1.321138471763160774122261601070813856630606361965940620995802821172170057634692149264412848115388718), SC_(1.570006350054384458248292544528517589268555870393616358076205595127096382850890538912594627235561167) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.6323592662811279296875), SC_(1.107954190170831516784210470288076158391826550512733510595475818794428757594250542518006714548250499), SC_(1.816441317699414360914899094629897642305640427381086937596854923642839302274678606714374070793275801) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.814723670482635498046875), SC_(0.6457790094417581454292091283090858286935493487777614330171852598854175143043094420654217089974384243), SC_(2.508496256336587012606232966310825027874040590402560244141765653903330072457714261274471033413067883) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.835008561611175537109375), SC_(0.5903165832976030686564505574795938463337291115332481067409174390616544243261595307430313775233498983), SC_(2.613564169833158888075563017765131116470577474323369357208483477314808702531834221835415464239925397) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.905791938304901123046875), SC_(0.3802576531685206974868107618367987709426736792583771758191326459978927865969469166082047757877076848), SC_(3.089001742517857463056613356364969297036446190980929959940372316943032033095543329919178274895022522) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.9133758544921875), SC_(0.3555286795481053701131612229630707329685975582828392650526567873646332385452195287446770778411734531), SC_(3.156376787411160567363210990569768615012155556670487694072893089667354808216542304077599170343565169) }}, 
      {{ SC_(1.12698686122894287109375), SC_(0.968867778778076171875), SC_(0.1503204924819451569018944951570549785194256667617405588173560670427930456317841776365172249960929169), SC_(3.920321668903544763796268317751460362513513954160257913183125421213113648507200532314124056435029975) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.097540400922298431396484375), SC_(7.090647963117289564189563243229959353926454951303170352131076248253663584548037483924462684726634502), SC_(2.011216700845572256036623335613689465981597841005889551670812158931922263224024070520165586886489601) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.12698681652545928955078125), SC_(6.725669946437175204168730333398878198552113653772997339335035703302710070833162324985929449047416224), SC_(2.24704394901208610709070037938980015074842422718959678509831392308942886147793106261902386920958818) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.135477006435394287109375), SC_(6.632879131834657478533414512289630531926508511387666567081569398538264830185957676165589398235252955), SC_(2.309340255188215071480236453864466396519820378153039048823115643931639070446480965885815031528999041) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.188381969928741455078125), SC_(6.13640607648798591554025485550699382065069200001562944457944973860744771549814750255632943989393323), SC_(2.659382979057494703069966954699464757525097238470377096445747377274519501906606716557844162522163956) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.22103404998779296875), SC_(5.878723549745325950881325643773789855133330432642049860752936878610597201845721720562660144244963783), SC_(2.852597402686409917256581279350479527320941173313101946735332401524086274446967330148844983311957837) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.278498232364654541015625), SC_(5.481178255521565129569394468687453829585831765426562325651074369275833614609384957263638938939603751), SC_(3.167038240297619660789587970800347830123450003718245110393206026726911597682188417889392183471506756) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.308167040348052978515625), SC_(5.295757076086001603949677924629188345766492964487331828222586065096255937070250552272537124322882343), SC_(3.320804905068096156415483017375939423099758283044330089455026244358365928335488608038480696217934183) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.546881496906280517578125), SC_(4.036034645963503635857096465328501467548258107613608553328774892624204500309813275512251935180382404), SC_(4.500703658105621269648308224690952774639379575508669732731148657214888219359284211845825204827931833) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.54722058773040771484375), SC_(4.034380487162329240511745492762873954745447084990269676303379361351256316351768182143295362722723951), SC_(4.502425833082914056732146974946052475017749055588675565332181874432154190710134494693593626281294921) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.6323592662811279296875), SC_(3.61857988981435383424759454361890575572281254968904358359979943190119662321477180424668338408482285), SC_(4.951936856753917223713244107183498106114092578459125875206546426720584202671432857047490797313985057) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.814723670482635498046875), SC_(2.640263214154556624985135065822774499976183203041995606620077222804712425986005347458309586021935357), SC_(6.162504274833546820887889395330518839943927249164470643465300075003369371525636984240016347509906576) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.835008561611175537109375), SC_(2.511506118310711189343620597280621461788506619798274934193287861636903591274743437725341346272243603), SC_(6.341219788469070176667582159955083630314438785592725120336619035851095200008881326064279274188231938) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.905791938304901123046875), SC_(1.982121331479413542167773934440173449057060084209857151545100391655733552409059780505599514548353337), SC_(7.137285771670346760803883472878011942794091551511519991366832575578805361582357703629061463354800893) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.9133758544921875), SC_(1.913603146495061632202430044378667625906641719763340751137277981316031173427771035059404361566671949), SC_(7.248615867076294805062210009853896486132454969628669055957510147306520259235121899782604056791397928) }}, 
      {{ SC_(3.93773555755615234375), SC_(0.968867778778076171875), SC_(1.235749441203342479338639517888806005079940089764523656824278567245324018028423628973654513703399514), SC_(8.490196345283899149257749251053869237574935421169322171118219224052143145618427579437397223903863393) }}, 
      {{ SC_(7.65350341796875), SC_(0.097540400922298431396484375), SC_(11.82821444375285783760608743609941472872967864281969273300037753841922044097529240098854877166038861), SC_(4.705839144529878187674607785354144323612019668942317593816365715215983521041956152054701700048020412) }}, 
      {{ SC_(7.65350341796875), SC_(0.12698681652545928955078125), SC_(11.34080511153649760928711143464529195741889710618955561161208691315712432610412710794899548806299564), SC_(5.065554915728640496105573701027525314948644245206442424106254442496227345208920154103468817026020029) }}, 
      {{ SC_(7.65350341796875), SC_(0.135477006435394287109375), SC_(11.21653244252388383289654575966770688709916494323316877106867296058730610913590229742209841422042384), SC_(5.159632611361717034903762799778097484120311788122407176225121976448416043482472307785506845792539175) }}, 
      {{ SC_(7.65350341796875), SC_(0.188381969928741455078125), SC_(10.54898323429804471745403371196993703087567736440409589921710915181640168443043677099562579021927454), SC_(5.681960735344740448115245037772604947252870229760366147004618833414943868129560118017601403813693693) }}, 
      {{ SC_(7.65350341796875), SC_(0.22103404998779296875), SC_(10.20063381747422780049389733609895974336322035597938825470008770356421230276186335285421213718821308), SC_(5.966257390127426961622497147790282391424125510123110857233700335512440426376242465741562719929424846) }}, 
      {{ SC_(7.65350341796875), SC_(0.278498232364654541015625), SC_(9.660439939590268436606720698423541819841522269940047538334770157300537192447798295758789909423229695), SC_(6.423780026420278237200261749838215067723129632994012376897280553726771484202088950047489620025503985) }}, 
      {{ SC_(7.65350341796875), SC_(0.308167040348052978515625), SC_(9.407244974364920241058817551269902735989485324930290525676463346371730523201236546935900289625389987), SC_(6.645455812015936829799825459935783024976136680596093591793773789177912992332957590297337975556107638) }}, 
      {{ SC_(7.65350341796875), SC_(0.546881496906280517578125), SC_(7.661812385842159039275762799959905858955731658383662849059919581092767290244867383662608952041279704), SC_(8.311334842119552955373704185275923560508548498507102367013383135813846880539352565291392564739087051) }}, 
      {{ SC_(7.65350341796875), SC_(0.54722058773040771484375), SC_(7.659486434215634190761886459580451679937984565181400380471343494145026142761015678106542369746614956), SC_(8.313728622610802730750657029131451141060786082972729460337487080145745571478783112205950546003674194) }}, 
      {{ SC_(7.65350341796875), SC_(0.6323592662811279296875), SC_(7.071351104627572778401082621991324858856865712639826509023480985411675966780999596453565650447429659), SC_(8.935472593074735297916203481149108953072595227488793544221933995690433318702868009095097186121633008) }}, 
      {{ SC_(7.65350341796875), SC_(0.814723670482635498046875), SC_(5.653683203336037738089460090209247999635104099542249727314456501696262803880479670922250677407460979), SC_(10.58419001459481752655511494226810758243139734253542702358541233219928509949444226133524775413203295) }}, 
      {{ SC_(7.65350341796875), SC_(0.835008561611175537109375), SC_(5.462528491900321544333728562536379181045601055201809160466260248879217585507576771857597066547035661), SC_(10.82492659251818488010875904587742215225714774757498666787901038431764202089000299579714709443940435) }}, 
      {{ SC_(7.65350341796875), SC_(0.905791938304901123046875), SC_(4.661031959853754768698391705666755779259866074006758542093905877560020972580911283367070203700011912), SC_(11.89034212835679183217710407294842871142066815569962633033995901007794800708031921547821370558841429) }}, 
      {{ SC_(7.65350341796875), SC_(0.9133758544921875), SC_(4.55510776831161496593065717464504416204788013198388866461457712669902507452528889614763227226584724), SC_(12.03851197594705240852432780340279666035987757018785557034912980897472998034802267873596597318489823) }}, 
      {{ SC_(7.65350341796875), SC_(0.968867778778076171875), SC_(3.467336638191843306954572068679534884971681828698280843552674034068756081630051039571309882403763241), SC_(13.67906243469408205868423526242213772252907043476540759575274036953084454393317182655162273000243588) }}, 
      {{ SC_(9.76827239990234375), SC_(0.097540400922298431396484375), SC_(14.4105648252792364209416142925723870398950846351923774410777763413637731531230286406856598026355751), SC_(6.352970434171223554039596881213628468441380385675502419544601849304310820186870012003168223366246756) }}, 
      {{ SC_(9.76827239990234375), SC_(0.12698681652545928955078125), SC_(13.86714236092989436858686636875715132411457519212826786401036309920156365298055211449467361784733225), SC_(6.769082022928333111530944549388612904831057750619240945691281627437637392829936958437480891694054039) }}, 
      {{ SC_(9.76827239990234375), SC_(0.135477006435394287109375), SC_(13.72846202047042666533773172979216209581161419423382120459763585679857660770558255594807887340573806), SC_(6.877647586500867267712374639442446276279955409467393553154822539850680835207593994775613630333466403) }}, 
      {{ SC_(9.76827239990234375), SC_(0.188381969928741455078125), SC_(12.98258952844648675184274838612050158771828962153073999888539016602139041543914740559702798176462431), SC_(7.478631114910906893816793579646663230304874865600064923316398391448891241010756452357744969085604488) }}, 
      {{ SC_(9.76827239990234375), SC_(0.22103404998779296875), SC_(12.59271109847871144690846400455000221588787934664478120907968736169219662818383537966439175164694921), SC_(7.804575651181350395672004094804472296512808337755970826570508759165464889120707039208202532902234086) }}, 
      {{ SC_(9.76827239990234375), SC_(0.278498232364654541015625), SC_(11.98715491392014206538440016689059991373043251808804119872986554079275169824813619951132359322931648), SC_(8.327589634459012260309321150135556290212526013553493888471916164235670168370634197744287324438209851) }}, 
      {{ SC_(9.76827239990234375), SC_(0.308167040348052978515625), SC_(11.70289682534425720192891980774510139587823683853717738434776039639832592991108453107838840892994869), SC_(8.580370614990038339897074129919581197242101534022299009286159556441131833931235533225453748336937701) }}, 
      {{ SC_(9.76827239990234375), SC_(0.546881496906280517578125), SC_(9.734756535946634406365756903957805165451781805105000472235767006615251984223729215213579961547216894), SC_(10.46904631904159626092583399515073545442241060264284272586883987311807571829316095182382452823314885) }}, 
      {{ SC_(9.76827239990234375), SC_(0.54722058773040771484375), SC_(9.732122541662919880697945684191521474685662938003300712866043181451705674055850494824713556452367393), SC_(10.47174807673689826365572635933598272476721980592136418183456107235071360191077814995261542427199061) }}, 
      {{ SC_(9.76827239990234375), SC_(0.6323592662811279296875), SC_(9.064977708716869141234469897722650739470373264647415618990409585978654239856882540246818645517870436), SC_(11.17246694264266550055091808988627342657979208803499184743357347388415418152237276687703784607791298) }}, 
      {{ SC_(9.76827239990234375), SC_(0.814723670482635498046875), SC_(7.44616833628674753518017112491220756369103756458592894253909467727086294578114112415935873930441814), SC_(13.02196769463589095710015153016085873280003451596979905883925128529142594965930051994019912437428325) }}, 
      {{ SC_(9.76827239990234375), SC_(0.835008561611175537109375), SC_(7.226508967053949840491292811490355193973301068748385110216787313072958009550838756563042168979322499), SC_(13.2911039865177441851505152083681053854060050041321505905010014106894271377054475088432922327680502) }}, 
      {{ SC_(9.76827239990234375), SC_(0.905791938304901123046875), SC_(6.301021160915732239672603274832229478564498466110628983443648813263214143467683500070075229426498733), SC_(14.47977718265961712554883915859378396697948321247742010596447359838530331363806483181459699933602764) }}, 
      {{ SC_(9.76827239990234375), SC_(0.9133758544921875), SC_(6.178103654914974753796797063873020317957360521437136717807625099324255260203201083517528142943732992), SC_(14.64479469427112175252937784059402107479765867811497259902730874797930144389987560027081479400962574) }}, 
      {{ SC_(9.76827239990234375), SC_(0.968867778778076171875), SC_(4.905372725281246949612185947834554381474999110045505008192750020966689986262374382249963934919371615), SC_(16.46762353371676915197018232491217704145207031284511180917772791354977766865377418507272571536677291) }}, 
      {{ SC_(26.117748260498046875), SC_(0.097540400922298431396484375), SC_(33.33990082384103858804815999924061085034310275317991408596746305141428649011068027471010452186250575), SC_(20.12222302582320429357233791267293572738484185665423834032956023049649193876440766681287202830584524) }}, 
      {{ SC_(26.117748260498046875), SC_(0.12698681652545928955078125), SC_(32.4875867771145645789445947167149402088304086651188644609379714330023966546132637793598853589277825), SC_(20.84813623633734386096940259034878827640379586074196502977058777595738352422488682147847156322765165) }}, 
      {{ SC_(26.117748260498046875), SC_(0.135477006435394287109375), SC_(32.26943078388334692339709487489401751162593529601203818618740341989646187262425647692424063131459894), SC_(21.0363705267551419804134638311706857321663193970523006561356969917951031067660308918364563278930973) }}, 
      {{ SC_(26.117748260498046875), SC_(0.188381969928741455078125), SC_(31.0913615684399413529602676702134417853354304990513114238567759565079847728136998700613725411376766), SC_(22.07036282110167233976264625427889684408397543463852981557220278754094530653460871842677727639661595) }}, 
      {{ SC_(26.117748260498046875), SC_(0.22103404998779296875), SC_(30.47222798886510415817461763890960344102544043169095540627307846806099034721675634950383224245454021), SC_(22.6258600242481835159040209289063431946404483124165363143433417318648440120244259761961594410464883) }}, 
      {{ SC_(26.117748260498046875), SC_(0.278498232364654541015625), SC_(29.50573725334829167453109914471584743989233328846093644289195256683526407505478429442777708630922654), SC_(23.51013840099200647321872531752566278685298192598689467850775862843425746102144639359352237884847167) }}, 
      {{ SC_(26.117748260498046875), SC_(0.308167040348052978515625), SC_(29.04990648800448004241493334394888509808768954434284553424472325748623310201577334258931403657765221), SC_(23.93460187440268508686438247745571092406820020886530773199209426857056189254221297455000203710388948) }}, 
      {{ SC_(26.117748260498046875), SC_(0.546881496906280517578125), SC_(25.85131753575077816958987221603757055673022656278606498496706949091340823561238879307452535113731494), SC_(27.05396462325385652783916713227269767508939744633046261326519627665980319813823518802868091534590344) }}, 
      {{ SC_(26.117748260498046875), SC_(0.54722058773040771484375), SC_(25.84698166890532364681596780650204987385746195519768156756969022055798159421721229420005858724280682), SC_(27.05836807381215540678019982645375342749849698121470027868926257798008013414810173904459526165435717) }}, 
      {{ SC_(26.117748260498046875), SC_(0.6323592662811279296875), SC_(24.74339377253212250821444707736252648853072881666074852935267572682680406487098345833826487954043962), SC_(28.1954360302259404128030015974077624936275777608668539604726472555333304106516218919848541896298166) }}, 
      {{ SC_(26.117748260498046875), SC_(0.814723670482635498046875), SC_(22.01484146140679010742518125806649830101776181517267878930550859015232421229980080556882550365771876), SC_(31.15376391882797988979152776517421724393051466050904792356452666286764433193581914411332132286088209) }}, 
      {{ SC_(26.117748260498046875), SC_(0.835008561611175537109375), SC_(21.63818696209947718259805163962932931643628092839313672075094384063276124291334381714881183743914973), SC_(31.57963654870873685533101793033565521944177534670807629337716380204125585341839454596406209119994294) }}, 
      {{ SC_(26.117748260498046875), SC_(0.905791938304901123046875), SC_(20.03107961192446859932047683204027308493302340944206799255366857022177039230177368297122813821109631), SC_(33.44817213492703188883370875794647612017188121450759178467056915776772158869985978165025052437272738) }}, 
      {{ SC_(26.117748260498046875), SC_(0.9133758544921875), SC_(19.81494628334001181202049143085197374770748741303741820257836594356304024693875422292914356836360927), SC_(33.70606386718763895885508335847126648395262580882838685881039532496688778842423919276181984814220215) }}, 
      {{ SC_(26.117748260498046875), SC_(0.968867778778076171875), SC_(17.53225895554651110130631823827822796173920570644475433814452680320849341923828386812159297469698287), SC_(36.53278129475289433697110713377149482380867325121785160705042092233938295556914903018371613798544965) }}, 
      {{ SC_(41.8613433837890625), SC_(0.097540400922298431396484375), SC_(50.84758872762931257756077708280365160698576525649391550245556758816440226858108391902427383007718827), SC_(34.1016035956211416977128886832288869698621726531675863935651520593266630502880499107496518110969075) }}, 
      {{ SC_(41.8613433837890625), SC_(0.12698681652545928955078125), SC_(49.78415878283274461673079764109283278399107532527107595958065221583737636598488182508003590055049635), SC_(35.03884335828063527453183203735678044939899062433263746790553397081857374851239505345467527950992218) }}, 
      {{ SC_(41.8613433837890625), SC_(0.135477006435394287109375), SC_(49.51167355285024766689306226150596234919269659376528998575991699690273931946631611430406423824793311), SC_(35.28145203355297170923249420173395538448346460681592313218543269998338255220534671761402994260312812) }}, 
      {{ SC_(41.8613433837890625), SC_(0.188381969928741455078125), SC_(48.03808737248691239771040121922563103370739537441924134321802427612986812979423286068143741843851095), SC_(36.61115357744698521329196110680617915909902555620157044732819449307251929048137350676942096923691209) }}, 
      {{ SC_(41.8613433837890625), SC_(0.22103404998779296875), SC_(47.26215658975399961423359174263326025918145715961323569315835821237528846984447892777665259084685044), SC_(37.3235197466869339636477674708327289879518243956094948151883632822231118826556322233411669366016167) }}, 
      {{ SC_(41.8613433837890625), SC_(0.278498232364654541015625), SC_(46.04875752645910937851285439652872160593011366801135787731324740079312465280558122834565050738078119), SC_(38.45478729951312004486685081875559376132740251507414897603812561568880135389127045934399780177487875) }}, 
      {{ SC_(41.8613433837890625), SC_(0.308167040348052978515625), SC_(45.47553926100972654429097599466721362441665056832474180739909570968775787528150901078126749028246295), SC_(38.99666560962976436778718828502477519144467854105025250888081607522484116837186763708998173681485532) }}, 
      {{ SC_(41.8613433837890625), SC_(0.546881496906280517578125), SC_(41.43494003103211650786516904185315197990778939859275113340275820925889880595037606131347846966356423), SC_(42.95809908737562684343456281834612536895409401847938166273908119657768224519866557129839900663569079) }}, 
      {{ SC_(41.8613433837890625), SC_(0.54722058773040771484375), SC_(41.42943957175118163947140885999131428539035042882938929224602725973077075553911992348457343739037333), SC_(42.96366708403590436995854866013097658794509702452084139248356991110513808994276052984335104368280248) }}, 
      {{ SC_(41.8613433837890625), SC_(0.6323592662811279296875), SC_(40.02722158257055949562822111527091862421294333003034940258769271809846534657194106061342566625065851), SC_(44.39934108252066839317500794711394191951382933634067753229156853255267197987185290718512815488570964) }}, 
      {{ SC_(41.8613433837890625), SC_(0.814723670482635498046875), SC_(36.53987830487131128996233324629087304823439256476355659919481638609046107983436579314362010884951302), SC_(48.1162353942734400976899132295586675892676229901290016724299235143507233102173761352207392011761971) }}, 
      {{ SC_(41.8613433837890625), SC_(0.835008561611175537109375), SC_(36.05598193632130620335843541319383478397988823488531788877523171381733899255620502144493621205742257), SC_(48.64928819492224693144568283522176092621929740950015988905490146751344779817859379546985354351695164) }}, 
      {{ SC_(41.8613433837890625), SC_(0.905791938304901123046875), SC_(33.98373867019322860142622656813827646186558819511402294437569256316031988447582293745290243623691211), SC_(50.98255051578110882751891435960751174490350697263008054593739419666884848033941039675205204868903496) }}, 
      {{ SC_(41.8613433837890625), SC_(0.9133758544921875), SC_(33.70406723459434714902881341193492063157285044945840069835197192714498105616631324908493554952471404), SC_(51.30390219052774337941995066947827945565468081234460705826677067663657076021351369301184247269103546) }}, 
      {{ SC_(41.8613433837890625), SC_(0.968867778778076171875), SC_(30.73453340085556573940468808899655659820583600155378975618447793923225209255801641725856666790314133), SC_(54.81611890708030426038490784270245000476319788643657675383071629390954241753694211664284472956553441) }}, 
      {{ SC_(70.242584228515625), SC_(0.097540400922298431396484375), SC_(81.70723500289145157842037391347246142755454512104072931714892269573338383120862162875704915923742478), SC_(60.00434992650556478601970905339459702091235089186352438083048981139733111022182992617618954711557471) }}, 
      {{ SC_(70.242584228515625), SC_(0.12698681652545928955078125), SC_(80.34727754923494579433491456733191895273334801305964094347065873467395703454548720570639762609152318), SC_(61.23825934723536606421349257591137469365708235261711821801948033496439437255707710800018244369303014) }}, 
      {{ SC_(70.242584228515625), SC_(0.135477006435394287109375), SC_(79.99847687499868858756110348785817258532948958807560103568841025628275922639035795681926768291752961), SC_(61.55721402603703456338078863070972854805018240395343215955778973557714558932716818745233772758507978) }}, 
      {{ SC_(70.242584228515625), SC_(0.188381969928741455078125), SC_(78.10974303693652571131092353211609178518283472875055230233500975104846205296285161710227716678531497), SC_(63.30219387188488152941162564244961071332699748877037376043626892123087357812050538022710847732330534) }}, 
      {{ SC_(70.242584228515625), SC_(0.22103404998779296875), SC_(77.11351639974206491693620712548899334720435288150453638306013530941461417725872700379556527261633703), SC_(64.23490492285467693040556756667357194310242436306337294489621033655595802806444521883499337345259168) }}, 
      {{ SC_(70.242584228515625), SC_(0.278498232364654541015625), SC_(75.55318957974952875729454965595723297979560923313239713849632734884441955851045423472713920519974355), SC_(65.71315572846613170485541996611735966507512539175313776133214622902105019122652684372995868016756277) }}, 
      {{ SC_(70.242584228515625), SC_(0.308167040348052978515625), SC_(74.81502156616445042065706332449686409475989735241846158378807229977122150874065383680576161015177138), SC_(66.42000263546676431993198344422786930355593538867893494306805538227936484397941370286864269632216434) }}, 
      {{ SC_(70.242584228515625), SC_(0.546881496906280517578125), SC_(69.59116306205304548710887555589463810006900101678022621810000033691297106243496793304651075408095159), SC_(71.56473728957153592484504912936238288366256629935882965785706342544083558466959423130088301797706371) }}, 
      {{ SC_(70.242584228515625), SC_(0.54722058773040771484375), SC_(69.58402602628486218536961078290431952252834120581163525241938018772153900509053882658875600442559205), SC_(71.57194183045325409606724519711837655408455970143153372266760285988410323504621666434490361982338523) }}, 
      {{ SC_(70.242584228515625), SC_(0.6323592662811279296875), SC_(67.7621629638802043255387840895656506436219197695812744343040904601729644632470749228784751785959567), SC_(73.42724418816436742735520693828692202645396314774159579770782953985601362923273491433470727733676251) }}, 
      {{ SC_(70.242584228515625), SC_(0.814723670482635498046875), SC_(63.20879160261721314871277680959176167922363581809920055480950487453391098131195688221712718944562829), SC_(78.21001243614165089790180640846724705455150685824798382235126918483053883823362652726070293967124073) }}, 
      {{ SC_(70.242584228515625), SC_(0.835008561611175537109375), SC_(62.57427838827408590968673785000161156882034987738192925501658339636646812623460658091802486902696341), SC_(78.89364007728315701156486534231881684860202537479559914918704222509080148609099581473197587138764236) }}, 
      {{ SC_(70.242584228515625), SC_(0.905791938304901123046875), SC_(59.84897823120536758228793713181066348745647947188571401233241885397089057166624430932888773614692555), SC_(81.87968267135975731669594412405531572762004190345439432047508647885748871772014357679567149745535902) }}, 
      {{ SC_(70.242584228515625), SC_(0.9133758544921875), SC_(59.4801295315447293614588299794282654280973225257702290558341321666386442221246893840797656389323327), SC_(82.29015904890572796617479300320698359761749139519381871843299159257474786332545969307611311806583243) }}, 
      {{ SC_(70.242584228515625), SC_(0.968867778778076171875), SC_(55.54722922061878085352820690959216410167945205771185524530509593452176492622846979424482262142655786), SC_(86.76484441850837932799813405243124499191907809635724440594504685729966818206807157491043063479917747) }}, 
      {{ SC_(198.0442352294921875), SC_(0.097540400922298431396484375), SC_(216.8867699997764938588709237179690855450299344242071533206984037137387613603218157496431032342441646), SC_(180.4280267928622902546487519715989840184517805354243459143675386886019259745156758696906560334718378) }}, 
      {{ SC_(198.0442352294921875), SC_(0.12698681652545928955078125), SC_(214.6443096712521349200149407644337710586986791735906340355417342358772964518499054072082593107782584), SC_(182.5445750166871078537656641592134120020065261293238238286204401150898139589729057825464629671911012) }}, 
      {{ SC_(198.0442352294921875), SC_(0.135477006435394287109375), SC_(214.0683680005254290446401506986479679848108373519967281865124708665598084663114628998935585231815015), SC_(183.0906999832062858696065819845330081055212843202376608114903967390170498466619605483707176469085653) }}, 
      {{ SC_(198.0442352294921875), SC_(0.188381969928741455078125), SC_(210.94390452043755506094653574101945970713663634390288494610643776810856469740761667456866523260466), SC_(186.0715350616121428105802323126657915660079409513576084918744519528225781149953430959820481405880431) }}, 
      {{ SC_(198.0442352294921875), SC_(0.22103404998779296875), SC_(209.2918789001510294284927642347753747209012615247241852419472169544362566269841608631607596603822532), SC_(187.6600924271507608683798962315155735085393647819537012643381171138318877981934226135272418705950625) }}, 
      {{ SC_(198.0442352294921875), SC_(0.278498232364654541015625), SC_(206.6987063672509871590999543631770702792984595822508802827019181313842764788717581705822879095124016), SC_(190.1712427172873241595357641048089971649977527382443794419338833044911074990309676168427418277365432) }}, 
      {{ SC_(198.0442352294921875), SC_(0.308167040348052978515625), SC_(205.4694359688433272635751138705693672559872491518158048884305639786930933375830352231403389826368136), SC_(191.3692103348198595083987895395899902033187494987667754959475056271822714921475350833653686615221077) }}, 
      {{ SC_(198.0442352294921875), SC_(0.546881496906280517578125), SC_(196.7224301503654903490425281854633049768162293824068073725019129508873730270636604051048228596809632), SC_(200.0371332065500539650277661878068115106715261710999388648587449103707397966289696258293250571798921) }}, 
      {{ SC_(198.0442352294921875), SC_(0.54722058773040771484375), SC_(196.7104201954411636690934524225561231612721643538627675575202087559097657102262210922969132159520187), SC_(200.0492106349809845975160161223675834837569994126997708684959643263409046301527247031419638266939922) }}, 
      {{ SC_(198.0442352294921875), SC_(0.6323592662811279296875), SC_(193.6390914267177598722267662122769228341652365348420873959564584660799588471481389926094322470686288), SC_(203.1539623516991871112392850734120452314260354186413346378908110384506347555496797268467948200781642) }}, 
      {{ SC_(198.0442352294921875), SC_(0.814723670482635498046875), SC_(185.9122765671626576556596500283729027900999846445684488514991525411394804317096117986457165947734265), SC_(211.1100247282177863329882712616606876330024764676162689531184093691946168522511163771127329169559182) }}, 
      {{ SC_(198.0442352294921875), SC_(0.835008561611175537109375), SC_(184.8295046795777415832962017161269470841798306071716451818635684052726469718977942115350564911813712), SC_(212.2418705986810544523357733034441467384970464702585230878604420080926370556263779323641782678965857) }}, 
      {{ SC_(198.0442352294921875), SC_(0.905791938304901123046875), SC_(180.1610802340863953553474270105056985611869808295358348665892735768026728417526263091562725955362706), SC_(217.1707725951942304832889243038383443173224565788045343901734997365711985799551921419974416219383253) }}, 
      {{ SC_(198.0442352294921875), SC_(0.9133758544921875), SC_(179.5269608634142846763131536412786077350587833013935598887943189762788735737237677792031898028974388), SC_(217.846469518812062432820658109178275910352598081827681252385275500457225403399450867889741799667375) }}, 
      {{ SC_(198.0442352294921875), SC_(0.968867778778076171875), SC_(172.7297908786068673911462179186720819033392096461399228420718442674068119001451094660335503148592061), SC_(225.184574261862814737123791988434465113388134281819126131493257124682435292693369844606141854562684) }}, 
      {{ SC_(327.2955322265625), SC_(0.097540400922298431396484375), SC_(351.3458373055572414062306852147244918335751681786471255175122148822442375715415605195848963906007157), SC_(304.4715332448509165666582046764507286212060841035183523072254419487762127047530715653179698712802386) }}, 
      {{ SC_(327.2955322265625), SC_(0.12698681652545928955078125), SC_(348.4805325994454172919461950715138880832542268629104498505719326930174318289885056946360589850437697), SC_(307.2109554239725217795567051301355189024655486411578672970243223201165324010339467371531733869114779) }}, 
      {{ SC_(327.2955322265625), SC_(0.135477006435394287109375), SC_(347.7442757619503455682323786610352234484642565124616886750483858432358448761172894082993552688007067), SC_(307.9174019398675688497576565383334627767905914143984971730720459864621899654615651877102408004408546) }}, 
      {{ SC_(327.2955322265625), SC_(0.188381969928741455078125), SC_(343.7476024091150756577550508368348020041579849028724812974423516993965830940724234083728576261222), SC_(311.7704743046093440171273674701091933374884541396092014561956355825543576894501431717839815049998679) }}, 
      {{ SC_(327.2955322265625), SC_(0.22103404998779296875), SC_(341.6326743519805468962770195209395197212860121151912852843892283866958450188880820226413057291963398), SC_(313.8219444641881529741770387999566929148752971763191694610516628020381225209336397496001073914228608) }}, 
      {{ SC_(327.2955322265625), SC_(0.278498232364654541015625), SC_(338.3104310241027890919345858676960060106396233418208821209352091170986177757673455110268364032363044), SC_(317.0621773407840566912716247342552130802428081753718624671385974171874612493026707899335526097729001) }}, 
      {{ SC_(327.2955322265625), SC_(0.308167040348052978515625), SC_(336.7344892967135415513428071400898281371905306624919900704155784876170112463414450495221929875240247), SC_(318.6068203139390226027678091369578652714663131021814614017885478817695870608847094367126396649116299) }}, 
      {{ SC_(327.2955322265625), SC_(0.546881496906280517578125), SC_(325.5003915036225705112414885541395041003701107116559562250780205400029427509224484693670865654181379), SC_(329.7618441687552009811216230210521198645353916458832470249919536625188186056154994248096416593132772) }}, 
      {{ SC_(327.2955322265625), SC_(0.54722058773040771484375), SC_(325.4849415989607721525540923944237090132522055423295845919610388558680349482161790658128682798400122), SC_(329.7773615399484696280344203977612034847245879152380086025992964648063287811569840188184930767461425) }}, 
      {{ SC_(327.2955322265625), SC_(0.6323592662811279296875), SC_(321.5315840916234076099959456555847371644719281050423219315602477080271534950280979636232773879061473), SC_(333.7641383909217384474980756689710702710831104432970583358205768555569257558168239200554031595033577) }}, 
      {{ SC_(327.2955322265625), SC_(0.814723670482635498046875), SC_(311.5647339619416472927045469444391234887022110742212858667626276068046956081720107046099682467869453), SC_(343.9602032809021931786708208567718918584981355777918324381991304060807314365429667615301925649204153) }}, 
      {{ SC_(327.2955322265625), SC_(0.835008561611175537109375), SC_(310.1655834791022690835564651968048039143846756645510954987446660818728748765513438763355347130927622), SC_(345.4084189104732089179770981827813075634901208995142109486824633283828890779192320344757538836849112) }}, 
      {{ SC_(327.2955322265625), SC_(0.905791938304901123046875), SC_(304.1258528725503928648721616776709011058987164873150539155622154945930149398559519880423784716266147), SC_(351.7085693813198830125279009316843101818928212713495273121457394600257947176728216271389168342188087) }}, 
      {{ SC_(327.2955322265625), SC_(0.9133758544921875), SC_(303.3045467267113521360407408730096224257009866942497716581605719632671174193788615634672749554766729), SC_(352.5714421904149471437125036181369387000862683603744311590367422402334533803911842545083914664269368) }}, 
      {{ SC_(327.2955322265625), SC_(0.968867778778076171875), SC_(294.4866279687565860608887516580031078066083674400482488102182812454191753219929634665241636070156301), SC_(361.9301117273610688139103391284813467920051798481142041733051675879314538796398562702681558827541096) }}, 
      {{ SC_(608.4515380859375), SC_(0.097540400922298431396484375), SC_(641.022648088358236091929192360791291744187885746917672053329187321354975180516223188111952099107938), SC_(577.1067197102434102658189812061615222768395006019829711065419105714139352228529356389493246853999084) }}, 
      {{ SC_(608.4515380859375), SC_(0.12698681652545928955078125), SC_(637.1383176120511966097558299310870455075610771790825712219671456841829440785038809996641792307935837), SC_(580.8651886166040325650443729252803956263925723312333075429140679200143933183336550454562049615365436) }}, 
      {{ SC_(608.4515380859375), SC_(0.135477006435394287109375), SC_(636.1397679655600507219537180895093459293717158863043927173762333601565338336571279361490778067700379), SC_(581.833932465752693665290157721379976374111015710443841024655602170309746617451900688848426271945404) }}, 
      {{ SC_(608.4515380859375), SC_(0.188381969928741455078125), SC_(630.7160419637329981452509249430200937937292538082039665167384093760645546528916303080704258508495713), SC_(587.1140769215408184269478289914261548542366507901415178407370181772567838979201548002301036047122119) }}, 
      {{ SC_(608.4515380859375), SC_(0.22103404998779296875), SC_(627.8437288299239577503366877054396900122853556634058096602635211885503543496699197528305522929892679), SC_(589.9229395087973630606126279179930823001284541129254328504830893976841500707993521999870354772638802) }}, 
      {{ SC_(608.4515380859375), SC_(0.278498232364654541015625), SC_(623.3285882814008066577006050009706371334624447991009406329202245170558589582095768874497989195740786), SC_(594.3560779804170005236807925607568182700410909208228307755437007001886508166854269573545189526072339) }}, 
      {{ SC_(608.4515380859375), SC_(0.308167040348052978515625), SC_(621.1854210084759427355528414803598908075590741061109293862850277227838489927788577359668484393376332), SC_(596.4679493605775786887237741782165172628959512871451159825355332289552533930040749558511186064542) }}, 
      {{ SC_(608.4515380859375), SC_(0.546881496906280517578125), SC_(605.8818731682726645888400533764095355771571315311332175904460688648094003629418611026648548926511819), SC_(611.6924296687384590739907105677410851717524876695701143259220643441629047935056819347501671476903968) }}, 
      {{ SC_(608.4515380859375), SC_(0.54722058773040771484375), SC_(605.8607947080665863933756489348809235646181863304910108929831062116722768685014736068076449001414319), SC_(611.7135755905127347674818100517657292894350831998981272074621079816967665658872882446472452239923428) }}, 
      {{ SC_(608.4515380859375), SC_(0.6323592662811279296875), SC_(600.4642387696996761093583299024916314146965568400122969664686607885656834242868778450999135397338516), SC_(617.1435483084643313770994629047987135583816596935941664407724124866570971268994974088947710824197703) }}, 
      {{ SC_(608.4515380859375), SC_(0.814723670482635498046875), SC_(586.8322861852037585966194943394530021540391274073476873259634445306496370833922665914475546439320388), SC_(631.0046923889258878567535559532241022934811563097253134380289830262047072818017125802499752255705786) }}, 
      {{ SC_(608.4515380859375), SC_(0.835008561611175537109375), SC_(584.915502271994854645083910096611759992358586304546756930645173571957360148734661526338057238411958), SC_(632.9705351804093583366688765735502466987364539428029284347264249934501150484015548505498780109179533) }}, 
      {{ SC_(608.4515380859375), SC_(0.905791938304901123046875), SC_(576.6322299461169346318272702317922892583951376100702032052520302869250244878139120971528241710854905), SC_(641.5141864867748219273081097564620312756309405566318282939738847683679891482540954695736931630019532) }}, 
      {{ SC_(608.4515380859375), SC_(0.9133758544921875), SC_(575.5046863471268610330124146566672354479632601777494536001966325481286429046303973048973127245333486), SC_(642.6832890369547874525921675538688798891958885152122612751518433957491619412135416353762957860287378) }}, 
      {{ SC_(608.4515380859375), SC_(0.968867778778076171875), SC_(563.381051349770210444415929474825958146269686177352122601648824881234332630485902279510780610066527), SC_(655.347544679444166682809453921908338081812791889009510207772625870599778577762723031074200355380006) }}, 
      {{ SC_(1584.006591796875), SC_(0.097540400922298431396484375), SC_(1636.18616124072132404306529904918168481458713616730288246119646040168628226487411416577426953678142), SC_(1533.053303532697840424614498629338572467146416221595356194444731084945502194402184916109672707786329) }}, 
      {{ SC_(1584.006591796875), SC_(0.12698681652545928955078125), SC_(1629.956898819518018582640940209721826972530721097100926192055403614829753653950749694822422091918194), SC_(1539.156719416718283410266833993913696662408591807048591301158895812798541976317014449011609686771494) }}, 
      {{ SC_(1584.006591796875), SC_(0.135477006435394287109375), SC_(1628.354767452109159626516209267702256186233865007676016540021513572934144687542059787907335454649768), SC_(1540.729048233069559073165596030765513069927287240444068362701905219663854348653129927705462273534516) }}, 
      {{ SC_(1584.006591796875), SC_(0.188381969928741455078125), SC_(1619.647102293724252570108398195955104988721079537174331871930311695544576789225487211520716466382423), SC_(1549.293145800832540535885803696126135747308617843336628800741329900396562522155990919377102450505005) }}, 
      {{ SC_(1584.006591796875), SC_(0.22103404998779296875), SC_(1615.031866803023948900533356198964609388577045942878653567724793350069045336904401664534192576659705), SC_(1553.844936024330152583297870028265598172402440241704712671845508989983437430098194838270704546363077) }}, 
      {{ SC_(1584.006591796875), SC_(0.278498232364654541015625), SC_(1607.771558808198943618665349990872577226620952732923596388244490204448915599582250914550385946010841), SC_(1561.023247959319304759120987840546396581352786787796960427598843007487000961279603548560599445079336) }}, 
      {{ SC_(1584.006591796875), SC_(0.308167040348052978515625), SC_(1604.323047534673736560488493143025256638472985830400832380669765470592671145136457471686870325246903), SC_(1564.440465396953075065631607877466694195985503739415010488261207535487176016478902943220124171497894) }}, 
      {{ SC_(1584.006591796875), SC_(0.546881496906280517578125), SC_(1579.654463509233606711155267157909532320647489004918620731811578357111952211986846943644079431280252), SC_(1589.029986497553225745119599240438652866804113102020719622088997259239741276838671219360866513448974) }}, 
      {{ SC_(1584.006591796875), SC_(0.54722058773040771484375), SC_(1579.620432014005873751491448459183064231782357776940773545101751344506085817940463006320990557044973), SC_(1589.064085450778156736101464284598485885619420105663607746864173473826747338218175267557127880732413) }}, 
      {{ SC_(1584.006591796875), SC_(0.6323592662811279296875), SC_(1570.902641408860442304912612866153900835843515933333655424261914626526411537250228682253475584807473), SC_(1597.815290991064021746673395374661389850479622310692312253850380570187147357134915704693110703762541) }}, 
      {{ SC_(1584.006591796875), SC_(0.814723670482635498046875), SC_(1548.8363473184752695598449525840183882730683980568968124494229884464437921130963647285171958165226), SC_(1620.110759861592793143936816492952160620996646309400992993057662731930141764479312353912518023709925) }}, 
      {{ SC_(1584.006591796875), SC_(0.835008561611175537109375), SC_(1545.728386893342861260266105515323865701625663558190603060590752527214654544861759653560337471546282), SC_(1623.267774664636327469375058305143892504528843787978678262612707085161769222775205356733375409293463) }}, 
      {{ SC_(1584.006591796875), SC_(0.905791938304901123046875), SC_(1532.282411783278742579322491429020848660483041675940581350241574996724846171974801959137639191077003), SC_(1636.97409942341670114755200677641387829537037920381992601376728045570427375954514415114655963962453) }}, 
      {{ SC_(1584.006591796875), SC_(0.9133758544921875), SC_(1530.450191783583474896466854482563081853851486522239973716768395405075897136142890426776759621810284), SC_(1638.847872844237702149647988101211209474226205855815515581260535306924858671217338799318565327378729) }}, 
      {{ SC_(1584.006591796875), SC_(0.968867778778076171875), SC_(1510.720206718709451392621643036990376392205660382068574784192806110121803515108802249281510366378873), SC_(1659.118385320999663107926512119481242116697514738383600591372268216955591233909058285156793142156256) }}, 
      {{ SC_(4081.4208984375), SC_(0.097540400922298431396484375), SC_(4164.80973031512388159466663366844904343432869453832506602242106183241251671227760448244736657710359), SC_(3999.258343736642504587446154812069656467385774299237318283381403325698043942076424087966857377236085) }}, 
      {{ SC_(4081.4208984375), SC_(0.12698681652545928955078125), SC_(4154.848303749601483885600709319139741875213733099243982923140943864120862530918065402212453299233475), SC_(4009.093929503746392084957889413798888975445649628901092561923595209933054651539000154235299128739666) }}, 
      {{ SC_(4081.4208984375), SC_(0.135477006435394287109375), SC_(4152.285513928028164216105364377505212731304490617834590347219089497778295043469344270908635764187156), SC_(4011.626918013747491597920788929743386804948801699775549501229264615286824009656312472618511418720204) }}, 
      {{ SC_(4081.4208984375), SC_(0.188381969928741455078125), SC_(4138.351108948657212301891953219910125155549437838445124199714620554022373999166540080152489657105504), SC_(4025.4177607320468667568363915662475760120803785812929685922761092128347814906232577840435331452293) }}, 
      {{ SC_(4081.4208984375), SC_(0.22103404998779296875), SC_(4130.961805621813089677127965461306672928237108260379696180019437757391298467620930091783886530827855), SC_(4032.743620808486834012109493608434202506409247586681529390650175149875171289247737732620407672691769) }}, 
      {{ SC_(4081.4208984375), SC_(0.278498232364654541015625), SC_(4119.332213887684908923150605439127920892858183044938572759076288943585816184710552796483031638503428), SC_(4044.291218782003186642267208088490352135039576855857948638778939664057935213844238298508844672010232) }}, 
      {{ SC_(4081.4208984375), SC_(0.308167040348052978515625), SC_(4113.806072832367671425803645091977332145898085250234770996608810519608715018472333506291722350389806), SC_(4049.786066787588861170912190035697335932844438229948965621535356409960990438319395111641461586428672) }}, 
      {{ SC_(4081.4208984375), SC_(0.546881496906280517578125), SC_(4074.231697026389091695417858616515583560958302803267968701835027820278409397569699679161484085693514), SC_(4089.281381430156733148745102691192294545307428081465292114891806621235087716587578511306991420717209) }}, 
      {{ SC_(4081.4208984375), SC_(0.54722058773040771484375), SC_(4074.177048903722987226307237485296696525502643207603622973418281332241690871196512835603966170993615), SC_(4089.336097009454430160725251536947208479718648224571394903194424018622389737039543995864090338884541) }}, 
      {{ SC_(4081.4208984375), SC_(0.6323592662811279296875), SC_(4060.17303966288722592697217710081067681674709696958770130600974969681236886570185302776233290336846), SC_(4103.373520480163900312546105803241458972551470057057100608620205427478696347311387600786873286972741) }}, 
      {{ SC_(4081.4208984375), SC_(0.814723670482635498046875), SC_(4024.682418114815871409401651595637806478357542318968541322603400135186521348662941359650554366799885), SC_(4139.093310420937593610343976451924096922781445879139237235167602573586912038000658330620533408801011) }}, 
      {{ SC_(4081.4208984375), SC_(0.835008561611175537109375), SC_(4019.678573199243121585798063093577497223396744052940747332062463235147084796449453195296336862254174), SC_(4144.146207995543512083301635815249402677350835381588718481766335351736414120627338982365070514548428) }}, 
      {{ SC_(4081.4208984375), SC_(0.905791938304901123046875), SC_(3998.015707493737481722936807651537597041876441514029798598639692744103014786692675738079903304625963), SC_(4166.069412151186737013845894639109444219646242453767753462186360654290139408485034260765488922351391) }}, 
      {{ SC_(4081.4208984375), SC_(0.9133758544921875), SC_(3995.06194845757464489019358850704394391831108071505696718058660603911275763472606412295683910279123), SC_(4169.064722497789214901081201895642371777216175290982606939140233903109130377822073864240796399024825) }}, 
      {{ SC_(4081.4208984375), SC_(0.968867778778076171875), SC_(3963.226238510626090027570498742066215155757875331520660054051707419114367920397446919437298567681525), SC_(4201.440924289725591612374919078740248603669401464931264657249777908344314361913683850166554623648272) }}, 
      {{ SC_(8017.9482421875), SC_(0.097540400922298431396484375), SC_(8134.580997388667477561705420100725328396365207359918665586460158095049474494708434471688925823084157), SC_(7902.541762914811970314211999746373443894863807848764794328315623793389838738001660651941281011434622) }}, 
      {{ SC_(8017.9482421875), SC_(0.12698681652545928955078125), SC_(8120.644123041925063365876385879290454906099307301356768188824911898719459704061019524702071806082329), SC_(7916.352798250364870899533560980165508579152382494715719488108831070335491894693692569725418280623521) }}, 
      {{ SC_(8017.9482421875), SC_(0.135477006435394287109375), SC_(8117.058051543911074880559223494830743775039934683707386985722148557177855732869915838708701336807789), SC_(7919.909068822844978562386905104120773309699368209423101522443364203969775103871619659210158053428811) }}, 
      {{ SC_(8017.9482421875), SC_(0.188381969928741455078125), SC_(8097.55617396756076440044131709887620721754266540782867799192436975262535700223706743038687564248251), SC_(7939.26738579814351099899021847257830124450889805268481718054205653681885250508420974888473127010211) }}, 
      {{ SC_(8017.9482421875), SC_(0.22103404998779296875), SC_(8087.211952566802327089642174759857454460974405850695362830594554905045107249286123142601786520062252), SC_(7949.548164576749736951242268220791553668178068161629438582084174149861225424551099572420601696901631) }}, 
      {{ SC_(8017.9482421875), SC_(0.278498232364654541015625), SC_(8070.928220637878396747385142967932026205882433538672072578245119606773871192609477783387530625601486), SC_(7965.749903461360250075117818332888356583303822072987358115267067461589259661111980175987737522643674) }}, 
      {{ SC_(8017.9482421875), SC_(0.308167040348052978515625), SC_(8063.188995026142187593657733514912118288180422904012608055229571359416535141180721600491318791863953), SC_(7973.457836268306357272111341982683504712234981598372357028919012833395056553521412627677573407370773) }}, 
      {{ SC_(8017.9482421875), SC_(0.546881496906280517578125), SC_(8007.736986263124078210686780528958447940987450153171190977257334486400339216550396831702175495429065), SC_(8028.830784416773880143660806401912383229269548184225101836201617834556265974409436264050652409909329) }}, 
      {{ SC_(8017.9482421875), SC_(0.54722058773040771484375), SC_(8007.660377322158698717680475905621769584492814551586692390677687667741873589553643603354789612050049), SC_(8028.907460813945292355484846558147262392050834729076516527626559256986008925939686728112027708110522) }}, 
      {{ SC_(8017.9482421875), SC_(0.6323592662811279296875), SC_(7988.025493685224016652750193069780003844624242361100296732335307799407648000474767489946201955687325), SC_(8048.575758460982096664247715002567299069272229809432007384579164159335557799147089408360257475662959) }}, 
      {{ SC_(8017.9482421875), SC_(0.814723670482635498046875), SC_(7938.235340328894296003494610569291128896876468120582431382519990428132024250423069817628244486033303), SC_(8098.595078220071189079900417972291896868940318419987803146773305544191003922185190677072613578377164) }}, 
      {{ SC_(8017.9482421875), SC_(0.835008561611175537109375), SC_(7931.212016901570388356504749634346581624732243278756791191816869426026200711546215985642350338813849), SC_(8105.667453771019184405186919380081742116350370212986329625573950483227615922272570550529246360525464) }}, 
      {{ SC_(8017.9482421875), SC_(0.905791938304901123046875), SC_(7900.796632785216729619041231709398013201746973179045641457419948412251010433680583292687005047746755), SC_(8136.343172849795123126407640816238212368649583820322350673781265790978775885534093264044182827281766) }}, 
      {{ SC_(8017.9482421875), SC_(0.9133758544921875), SC_(7896.648231210388635721789230567964836395036794818445262932406633603353926175632783113358764252945171), SC_(8140.533125077776992956578419649920269687449129308036378627895148129612581444682199759840944931837049) }}, 
      {{ SC_(8017.9482421875), SC_(0.968867778778076171875), SC_(7851.917830671838672565549963803467188367333621614310943181004386200530101359178987782102363602568163), SC_(8185.804006387489464895725304849296455790875148197665635147671414463249319574520134526871983487982858) }}, 
      {{ SC_(16355.01171875), SC_(0.097540400922298431396484375), SC_(16521.32643453776344654479113292701464846101596871418246487107709163166378216583879741887539158295709), SC_(16189.9232782306300058829047368501769083996266775916016794956993511561273352424247813686604183922167) }}, 
      {{ SC_(16355.01171875), SC_(0.12698681652545928955078125), SC_(16501.44840225115683149134599359124212070605587073625543824794808834775385614846339963613836479323449), SC_(16209.67547245066680726457896402592183348271203905896487462447905892907961970374745672004290623721066) }}, 
      {{ SC_(16355.01171875), SC_(0.135477006435394287109375), SC_(16496.33307333544360388934329483765819788362813687314090411239760847090528833560767286038016311171503), SC_(16214.76100064488699973587543423183637084498413154000662362890489200534162046566861461303885248556461) }}, 
      {{ SC_(16355.01171875), SC_(0.188381969928741455078125), SC_(16468.51080162452772953376174746488721271288290068177986196206844324535165727966776345420788753827906), SC_(16242.43971263218045015564031234122964329535523548294236569691334633892347720576934339769413009697673) }}, 
      {{ SC_(16355.01171875), SC_(0.22103404998779296875), SC_(16453.75055316027942842503760513330522896602155736834609382640579016584782059207563427560246574956291), SC_(16257.13651880636239475475721431018464873805257031548150424476237163740508732984276088084873763628127) }}, 
      {{ SC_(16355.01171875), SC_(0.278498232364654541015625), SC_(16430.51135757798972551295401279500018301232365127492908502064959714113867023747137215042759204330831), SC_(16280.29372172297784816760893004544278807966240735687725456848031105517743853138456928062305753266575) }}, 
      {{ SC_(16355.01171875), SC_(0.308167040348052978515625), SC_(16419.46474593277792861159529800049127186739928047338104010198379991848737445715580507387935398224758), SC_(16291.30904069288109797113143930282684356579788540117425924147193267923747698817215670204060869103719) }}, 
      {{ SC_(16355.01171875), SC_(0.546881496906280517578125), SC_(16340.28408942386142758289474439564684682283723730323713287415709547136463557561826716301016129839631), SC_(16370.41063687739770968204794858508411516314935914079696963183830508095023680607058128512213817755046) }}, 
      {{ SC_(16355.01171875), SC_(0.54722058773040771484375), SC_(16340.17466069056217028944539174171189207382895568480587887059120782071992392495527959367613945423429), SC_(16370.52013306667802344470526500048521494969131474696576810756052858595957468963101658449651116958698) }}, 
      {{ SC_(16355.01171875), SC_(0.6323592662811279296875), SC_(16312.12460343775104601525683562156454153601927827059983559908346347661478519417937787737603029077644), SC_(16398.60360421340860069873639100672138770138924997019826639099123396913530368058389881157056626122267) }}, 
      {{ SC_(16355.01171875), SC_(0.814723670482635498046875), SC_(16240.96425482972812902054552370917758823751231252026333656002556604758997684687722035257726713286025), SC_(16469.99311817229551369511971508257087283469961934745672924458763429813840181386740694314171553909172) }}, 
      {{ SC_(16355.01171875), SC_(0.835008561611175537109375), SC_(16230.9228903037153965834813441508690579323093956331186124853565331743909669585246657221502670676359), SC_(16480.08353453892925950744875184551043419955299539477442041732479627547053771805439094369663548810416) }}, 
      {{ SC_(16355.01171875), SC_(0.905791938304901123046875), SC_(16187.42719062496053042940902367510296946346005782433913708518126081514786755912357002988663473365749), SC_(16523.83956733668874775776513159518241539596650848548844963803293931225600223597386879766865603425243) }}, 
      {{ SC_(16355.01171875), SC_(0.9133758544921875), SC_(16181.49344305047980062099266881062371970200117808181845463244579170581605944151542326498035149813298), SC_(16529.81486521693127973064705423543271465180497325245583806980754888437151710807218071144666299186728) }}, 
      {{ SC_(16355.01171875), SC_(0.968867778778076171875), SC_(16117.49249805215154913274915531178224729859464371893849316568472637824454008808632335164373941772991), SC_(16594.35628513401538946461353795014800717480446171474522092088199255446509411147021023291447057460433) }}, 
      {{ SC_(32192.734375), SC_(0.097540400922298431396484375), SC_(32425.82495293049792395039802542641339589459790572089222344428663682001744429932609194384099363360593), SC_(31960.87007202550314805704320644909550100467437823108025255042853041901382414778055756800098665755799) }}, 
      {{ SC_(32192.734375), SC_(0.12698681652545928955078125), SC_(32397.9616220057850194815242476914617378821569407177891509205855595521374674586442764791341014748141), SC_(31988.60756533058741825199893191888330414404883199457873279406362518077917335921737528822813658053989) }}, 
      {{ SC_(32192.734375), SC_(0.135477006435394287109375), SC_(32390.7908718553793270672544131052181148279668451032828053782164870190310958731309716976698507019268), SC_(31995.74851485604190380036583598274150164984504647266175837577337920090208769480851988503628467572172) }}, 
      {{ SC_(32192.734375), SC_(0.188381969928741455078125), SC_(32351.78544498920440734235353820686117735636326411360993019112203345213394520211596389987837370346472), SC_(32034.61038241375562513019675322967521689870191907559675111525720651014556276225893560381751961597877) }}, 
      {{ SC_(32192.734375), SC_(0.22103404998779296875), SC_(32331.0897634209448410151523918081622209727182666922041847975891806189146493220354266307529906147819), SC_(32055.24262184908060028478208548424470760970658828458451430813634969941997383941408390279030306803327) }}, 
      {{ SC_(32192.734375), SC_(0.278498232364654541015625), SC_(32298.5019599122608899162324169522681318489419473882954403893402387349660057876853080789109808710495), SC_(32087.74843287125267053977066098396517446093027603677239987122298433278177223124555632486284422709352) }}, 
      {{ SC_(32192.734375), SC_(0.308167040348052978515625), SC_(32283.00999911208388410702698271865594316323366433765636620165807103723316402878862335009270945621816), SC_(32103.20910105738949856220393077334870111931526476090179529659753584025012217684411424383789357013257) }}, 
      {{ SC_(32192.734375), SC_(0.546881496906280517578125), SC_(32171.93643198380995150780818333179951506375943179563199538238314883715455771254411723233109050663908), SC_(32214.20360799856032288463489645633736324070439038824100567544575673084592934924336600218113736716156) }}, 
      {{ SC_(32192.734375), SC_(0.54722058773040771484375), SC_(32171.78289122135135760951549721123944957400207912792666490555611501872707536713438916894744600180337), SC_(32214.35721621689351469017050149732549482486267563464043834637643521367880915455386578253496390317305) }}, 
      {{ SC_(32192.734375), SC_(0.6323592662811279296875), SC_(32132.42227018556572622864952194458442327989185606143548655417041666389854084006285276511644352632268), SC_(32253.75125109162146552619835560007251284041251845717052535328975510226097677992410906464845485577538) }}, 
      {{ SC_(32192.734375), SC_(0.814723670482635498046875), SC_(32032.5389491904466952956623772352240238214958166620227223144989042106941769237401295252813122237434), SC_(32353.86373693987429342941733694189721601541946271494739962134671172621894231513254409837115187292622) }}, 
      {{ SC_(32192.734375), SC_(0.835008561611175537109375), SC_(32018.44113899795613803729783445621001370364238949502244875045039107530118034893324437861180224615303), SC_(32368.01059883908015165260374631786612616014578234166151117339573092178706893981431433636843495779537) }}, 
      {{ SC_(32192.734375), SC_(0.905791938304901123046875), SC_(31957.36464975499122412220937065890370586204119213288955609760532680034867149408278025424492055564263), SC_(32429.34742032884155772455287730939393255755082744519092677666977528714809147612399269569455707657653) }}, 
      {{ SC_(32192.734375), SC_(0.9133758544921875), SC_(31949.03128386695925460834169884369803085925554596380258521917700460949724615657120928055744920370048), SC_(32437.72233635827106809172377426644477809105281105952350054270460185353992021770682610894069664290817) }}, 
      {{ SC_(32192.734375), SC_(0.968867778778076171875), SC_(31859.12954446904998533712672994010438882018647466592517391780601370883831924807031311352184443104575), SC_(32528.16454790603467136951893051785596757247216314755180213045437382597822932026186236049013817800186) }}, 
      {{ SC_(64477.4296875), SC_(0.097540400922298431396484375), SC_(64807.0505427630929914525864172477763838207066557118744603812989823067100092085190775552287206316464), SC_(64149.03510703135936734127349990647229298113055287970500075139887493497336977222497286781051406615455) }}, 
      {{ SC_(64477.4296875), SC_(0.12698681652545928955078125), SC_(64767.64378227641905418339947177122474414473211244751248201062699093524574938600194411955681358390047), SC_(64188.31603012950552205012115592831882847827664692923005500535728313449502599311842579197023206118781) }}, 
      {{ SC_(64477.4296875), SC_(0.135477006435394287109375), SC_(64757.5017449941416871237799136670686472819522026976447570016883382044464880061167958010891249241271), SC_(64198.42826683675105802890591387216956003460211292892927063840120558498714987614044374397266122383897) }}, 
      {{ SC_(64477.4296875), SC_(0.188381969928741455078125), SC_(64702.33010734999943945134436233584289208178747052764931325494987086622179457700826617749178398735683), SC_(64253.45634538710313911520979974557798212415112876103681392160927039065967941948163953314798121102414) }}, 
      {{ SC_(64477.4296875), SC_(0.22103404998779296875), SC_(64673.05424538304980484178544174186230624107303416681337825040820440019356932976635824050232726244945), SC_(64282.66876530236849254501959280812844322582215348694070522166266571889532597305950369134084443277842) }}, 
      {{ SC_(64477.4296875), SC_(0.278498232364654541015625), SC_(64626.95222026643859674066531556676981814703266619788616447580821308951898696860157275874283861680294), SC_(64328.68879802511059531303575436102976953998363089768278638964661051053871570277458488381637174394599) }}, 
      {{ SC_(64477.4296875), SC_(0.308167040348052978515625), SC_(64605.0341216983781599168282973868471683748578110647908371593784160764622091333430422020815904075839), SC_(64350.57560401081226936802491717219195961608613834249399167521363480873301834071023703240372683172769) }}, 
      {{ SC_(64477.4296875), SC_(0.546881496906280517578125), SC_(64447.85657672009685126510895215249339071076823082130700031291419722367883089873107871613457405965164), SC_(64507.67408887298626992680448584116502708156383048098024048497428002815336690551655430566386526661864) }}, 
      {{ SC_(64477.4296875), SC_(0.54722058773040771484375), SC_(64447.63926817753910356149490644675066845186071066892486758663609294179965377073850119925895759229989), SC_(64507.89146487136356565474895096912259493364142820636729226718688671438335473824215726356323864179445) }}, 
      {{ SC_(64477.4296875), SC_(0.6323592662811279296875), SC_(64391.92824273149626537582416005742713427764021382223388084035584573321398742187221807591507828306315), SC_(64563.63590412792006608434648954051791873041475859408934713310893465818670188649997352376336518696343) }}, 
      {{ SC_(64477.4296875), SC_(0.814723670482635498046875), SC_(64250.52337839777895074462370236729595001445475398503820146283182620246598383130948687130376544634925), SC_(64705.26993305740063094242233538163188216037780023788138853293761365022683607438998646442164311391428) }}, 
      {{ SC_(64477.4296875), SC_(0.835008561611175537109375), SC_(64230.56162730248463956156058772066253658908150155263067786972985400825928192397796735295909572743749), SC_(64725.28073579017019148033368050361514985576438786423904478503758765518466156903628906874425803971563) }}, 
      {{ SC_(64477.4296875), SC_(0.905791938304901123046875), SC_(64144.07060584699385907827312605105472297437768092158219599227421106926277422343643835601882058410658), SC_(64812.03208904146137603431842552439844110838857519985468491314707081282416706827953479763262578004012) }}, 
      {{ SC_(64477.4296875), SC_(0.9133758544921875), SC_(64132.26838832436540369532805606418027941149540828562912719544945752354444168151777920485209415948377), SC_(64823.87585662049973391821075349245675482856817401671691790524424811974590483212518931353174882417978) }}, 
      {{ SC_(64477.4296875), SC_(0.968867778778076171875), SC_(64004.92488410780836353304712656544976503347491480358045814017266235773233360828573823673189564078906), SC_(64951.75983155522184664424166006374363245093228346453405225975203059011665907751439080627403945325992) }}, 
      {{ SC_(75865.328125), SC_(0.097540400922298431396484375), SC_(76222.82269155096109100383549738236079909682485927693875123853981693903032795484769471288492656326357), SC_(75509.05983321930956661717458355626301247896079079621170079654347413495837561174926592990236780905104) }}, 
      {{ SC_(75865.328125), SC_(0.12698681652545928955078125), SC_(76180.0826957503877592260430882376471703662648227114565512678461476530061861630501609889088901798996), SC_(75551.67399166594623080758920555419205779017345296059223309330814502697555192868325494354030105054918) }}, 
      {{ SC_(75865.328125), SC_(0.135477006435394287109375), SC_(76169.08268122138145470531450520490177072397878828438302295772059764032384966509645502809999881891144), SC_(75562.64420562739263987220787633500821434893767582532921339694784595671762411138380819011948219835098) }}, 
      {{ SC_(75865.328125), SC_(0.188381969928741455078125), SC_(76109.24295141063974534706839908706964920372284649924897977799682465648359681594171979865964714221013), SC_(75622.34037637647624543500037622857316297747749859722939468451417199082934107616099572458782467516942) }}, 
      {{ SC_(75865.328125), SC_(0.22103404998779296875), SC_(76077.48950967478281873178934548332278131802517547842585356752389721055946588202286572395764378766444), SC_(75654.03037607281052420352414170078074554850538493499959308640216926229635495707975629189679682106014) }}, 
      {{ SC_(75865.328125), SC_(0.278498232364654541015625), SC_(76027.48516982408918516087861827849502598921279473647288896135560943840404175591819986551261713068033), SC_(75703.95272354350196881117015091035221724957391445693875794169717063361775381746791009783540439555972) }}, 
      {{ SC_(75865.328125), SC_(0.308167040348052978515625), SC_(76003.71148429472573962869966425278620791820590301768256945474707383072016197575947774999891436323399), SC_(75727.69511649524879052954214062561012913070768455251611573745656924439385198219379404708441889670731) }}, 
      {{ SC_(75865.328125), SC_(0.546881496906280517578125), SC_(75833.22113006699971011674562796879590711928177851198274213854353670805562890651296840278423067445005), SC_(75898.10641061749434730132402605494657429045684795242038161439094883115707744473746410884619498547629) }}, 
      {{ SC_(75865.328125), SC_(0.54722058773040771484375), SC_(75832.98540818254367387842761363512146209320287390044923096555918970629339268301900418637469635605512), SC_(75898.34219995776169152881286069309694225953754477602022479322311582182112363485047994966697413161055) }}, 
      {{ SC_(75865.328125), SC_(0.6323592662811279296875), SC_(75772.55310214621142843803091653954700532347762188301208446197892714621834872595623759227047058710156), SC_(75958.80791980035231663878755001531847551164378215765931103560234745836747946066071380790985199890494) }}, 
      {{ SC_(75865.328125), SC_(0.814723670482635498046875), SC_(75619.15863623250154445720921548519686399244865009769466811784459445074272963322250020203007107611472), SC_(76112.43155027130181938409111225642799510176169669687168310127089011746717337290891907967756554465972) }}, 
      {{ SC_(75865.328125), SC_(0.835008561611175537109375), SC_(75597.50363631084430309098793081801274075222368946941278879513998186328488168100804519928043333368324), SC_(76134.13560182007041088999197883741720199723469293129759060291740358840897057677009838810911818904056) }}, 
      {{ SC_(75865.328125), SC_(0.905791938304901123046875), SC_(75503.67401418081049526580361680077254301138713654066281553485593999653302677902521814064481594127221), SC_(76228.22555567839955693724734632674399042441873244671352224679680708640096015364979115507250037412881) }}, 
      {{ SC_(75865.328125), SC_(0.9133758544921875), SC_(75490.87014481341853025482969050215923720606085412056100079085335805080879165586968461546289204007955), SC_(76241.0709750894805292047336953308839399093925221117482536851029483173358849345712644326294458953708) }}, 
      {{ SC_(75865.328125), SC_(0.968867778778076171875), SC_(75352.71510793759418450204002726307008067365054664626018174491080300192826066000984956352924301776981), SC_(76379.76648246917699138837974378930070071267894212615603433453710874094094372061535363945857586400172) }}, 
      {{ SC_(226209.15625), SC_(0.097540400922298431396484375), SC_(226826.0202829692439728575216858848753797406905170206481766625871777258977568000880540646288661951271), SC_(225593.5184917100269759557302861059369380040829042175259410004769889124594215807262411619035472272178) }}, 
      {{ SC_(226209.15625), SC_(0.12698681652545928955078125), SC_(226752.2639924273910799882912156968388928437002065579447789075008914652403444808781318802743651474961), SC_(225667.1489450281114631918626707093036289980332740609744779417864857494629592855039495614068211882259) }}, 
      {{ SC_(226209.15625), SC_(0.135477006435394287109375), SC_(226733.2803600784016884850755284076344492693369703312607066863327479100298375229807874965474846687895), SC_(225686.1027768376583011802441838216802940331053220531923414011099917573370794903140406335894664456915) }}, 
      {{ SC_(226209.15625), SC_(0.188381969928741455078125), SC_(226630.0032702466268336600023326826433415284183522744239523216837800735415567778997611446325012795611), SC_(225789.2363077286901369263288987706320572509607903476618579611829872153950660127453284324212762112244) }}, 
      {{ SC_(226209.15625), SC_(0.22103404998779296875), SC_(226575.1955421749934982865772338226913746751228249821797778957795638319243949152699122734108722862235), SC_(225843.9805938065659698989352838986201115599118262470036775980103176446428407854046523513698779336398) }}, 
      {{ SC_(226209.15625), SC_(0.278498232364654541015625), SC_(226488.8795211116969370819223196761906291107148375893389525414212912366012740317209375260646135706217), SC_(225930.2146225420427053064468107429980631500611854361527609098850220463385129337492237659699836415015) }}, 
      {{ SC_(226209.15625), SC_(0.308167040348052978515625), SC_(226447.8392925501542365366683006373550364816340955252257121594838806263141057519401401556960385971289), SC_(225971.2235585438138813582597453964697878602561081859480231938132545638004532790660331222148302358595) }}, 
      {{ SC_(226209.15625), SC_(0.546881496906280517578125), SC_(226153.4710425303029835089927692019667706431268628820672004474473848684457908614108766482129082326359), SC_(226265.5127484981744983526700601938929633600615285202710088228357513051685181673883275114190493894134) }}, 
      {{ SC_(226209.15625), SC_(0.54722058773040771484375), SC_(226153.0639814461409396590994002860873963267448056494020572161074338716743315579958038301019360762586), SC_(226265.9198770381168420604365533217915202183308738621246324912874108726736916953702211107333421701159) }}, 
      {{ SC_(226209.15625), SC_(0.6323592662811279296875), SC_(226048.69937714432138545343417754724573877170288907249717725640892829565145068124215177281801780034), SC_(226370.3178951301817075647464340739710747219839279891532524049616326461151311869610603639280050274226) }}, 
      {{ SC_(226209.15625), SC_(0.814723670482635498046875), SC_(225783.7396926319143784281800179283681353393356807402089652715084381923684207607271514290610478593759), SC_(226635.5067440548606868773026338940097771748813867695170816373962501605414485016069898451577888706875) }}, 
      {{ SC_(226209.15625), SC_(0.835008561611175537109375), SC_(225746.3287353936242966335111062329717858136016841538794390681953843673543749900105304991570404274489), SC_(226672.9667528812620429168046039483476034674287171165013383776521460864319919109754730291001294327828) }}, 
      {{ SC_(226209.15625), SC_(0.905791938304901123046875), SC_(225584.2122420286991063608225948125552493129317450685223999918641330162001021559062611937697732816649), SC_(226835.3435777204570991596374599629241887103968812111810003283598385723001952056238034445619043254054) }}, 
      {{ SC_(226209.15625), SC_(0.9133758544921875), SC_(225562.087840785409162587382569184108323354678741070477199671394526178497219898060312322580296239142), SC_(226857.509528959566699179476664450369389861046245900630379618782269539769856897432219286882866461782) }}, 
      {{ SC_(226209.15625), SC_(0.968867778778076171875), SC_(225323.3297731976615039884996133592811392218991459935743028405616673965911216575131257793653717400608), SC_(227096.8080662447948073322118261897807601196393395505343588466536694194222208371148831670579641182149) }}, 
      {{ SC_(516579.0625), SC_(0.097540400922298431396484375), SC_(517510.9355928878591703111786346257806981399743631006858036197931689120309576104950210549218761556626), SC_(515648.4156817655995006123951890706937413181838034617328606819367886743198844833984093896427982364455) }}, 
      {{ SC_(516579.0625), SC_(0.12698681652545928955078125), SC_(517399.5094400365962283503113701069904336024918846223137184815206059900936703603208740111524464541827), SC_(515759.7159974300154785953606416049053434918655652002430577036533334976288973799371312915054690577552) }}, 
      {{ SC_(516579.0625), SC_(0.135477006435394287109375), SC_(517370.8295560884465447477278643642547097579055271449491292115982419165159744620430339225903363904512), SC_(515788.366080846697934069853865120656564962918365269845674610757017494202496217658115382323567508747) }}, 
      {{ SC_(516579.0625), SC_(0.188381969928741455078125), SC_(517214.796985839471436741745776201689199746741515208790529459780958597781869780530331292759157534732), SC_(515944.2550921892269634915417627135106581869884485435334492263854900320219452079450319611343136996384) }}, 
      {{ SC_(516579.0625), SC_(0.22103404998779296875), SC_(517131.9893972077504282222912973731970890328584531916215785304155993622763557764161124394009814677223), SC_(516026.9992388401715494578551274043279374625132890892884885003496321500459827999398989342118833496413) }}, 
      {{ SC_(516579.0625), SC_(0.278498232364654541015625), SC_(517001.5721604400010438712525908241298056643495322218488376017597587616100833878695033195863655999779), SC_(516157.3344832949024343945507169495994755489218612063624810206507044262446175979442447262782829988944) }}, 
      {{ SC_(516579.0625), SC_(0.308167040348052978515625), SC_(516939.5613918776689028938556804212250958696790435014071896480187991283087706479728969219536922853837), SC_(516219.3139593025247546019457834086049873887296726122678501396024496824811480753611254943742853088472) }}, 
      {{ SC_(516579.0625), SC_(0.546881496906280517578125), SC_(516494.7411098774738011265225390064080564873376917778743088993729884058139836357232581236733017549366), SC_(516664.0551812485722320681775205423371842734417336464136213751733024183890861655274161575645164122853) }}, 
      {{ SC_(516579.0625), SC_(0.54722058773040771484375), SC_(516494.125954113786647607617010710473841855088628117767550837781434843950315420386668883385426387316), SC_(516664.6704044680308900528091176314093094299591166296830858822688739588540781464028994654819599578514) }}, 
      {{ SC_(516579.0625), SC_(0.6323592662811279296875), SC_(516336.404748008478698490626760000075318317669110023062030751067483798233670277314055780365953393772), SC_(516822.4250243590420808212921892036912567875051827767103148382043665258713782629467202115353181887635) }}, 
      {{ SC_(516579.0625), SC_(0.814723670482635498046875), SC_(515935.9470183695763918874471746835684562186493975724331015965000343086642859571474227085833828233064), SC_(517223.1119183690968428614213699067279948471890613570491954090021623128861663084291477581612526477191) }}, 
      {{ SC_(516579.0625), SC_(0.835008561611175537109375), SC_(515879.4001579768626868282382206281199535788191691114774150127306186858738613518802718725936555644871), SC_(517279.7078303388596415040680392840317580454970952827665965609685430955189026644064922204838773461159) }}, 
      {{ SC_(516579.0625), SC_(0.905791938304901123046875), SC_(515634.3479969449423015563194382172953941968755763993831322500823581493206223910863836633051196794225), SC_(517525.0203227729970410793778128766571591346205865088385422149969102750855016382593631120603586904694) }}, 
      {{ SC_(516579.0625), SC_(0.9133758544921875), SC_(515600.903638465575226772975438181151407032792758292277139009560608855602506183227834671606747233999), SC_(517558.5062312346059413116973188241237668715839937525128163778485706181476856736924669582989651991235) }}, 
      {{ SC_(516579.0625), SC_(0.968867778778076171875), SC_(515239.9613614718905924415997446091707043170654798160874019603099536275157310393932297651443188283863), SC_(517919.9889776970441843829886251060348881751152985953183240319944389735946351475168575824547913893585) }}, 
      {{ SC_(1038672.0), SC_(0.097540400922298431396484375), SC_(1039993.123344155948444390909911807923653882879753155366737722888703892710376448302925459584454084826), SC_(1037352.102930487402382281844865098111975958928817716953560018738332914201534783955218909747853403934) }}, 
      {{ SC_(1038672.0), SC_(0.12698681652545928955078125), SC_(1039835.149315842430036753081071567668080356240781036138697017695796689402643326048362720140248675939), SC_(1037509.951121628531782935336084355977121762085374418151412871345116401739775692642708044566994262753) }}, 
      {{ SC_(1038672.0), SC_(0.135477006435394287109375), SC_(1039794.487972686997346157664944579139933137786941628610454290652218293019704933767138703866012914221), SC_(1037550.582664255620280571507283048939601134989407732087440714697007411008733529208328579422870796214) }}, 
      {{ SC_(1038672.0), SC_(0.188381969928741455078125), SC_(1039573.266536299955656845102561202997939756640469183190762933283595381149364590234033862222096164854), SC_(1037771.660541749646140575376174264933187697095736329065217888444741363743142297226243000469914887701) }}, 
      {{ SC_(1038672.0), SC_(0.22103404998779296875), SC_(1039455.860093036279412436319356109700106606904989200941294821719439740105358349910763079588615788335), SC_(1037889.003543037629193438974762034449723137556727981105829960171001661090462770510620224332700398402) }}, 
      {{ SC_(1038672.0), SC_(0.278498232364654541015625), SC_(1039270.94788584276773301124108140409577969840053991352105445294111197358344707365006770815859943912), SC_(1038073.833757923918394351864029124758927186608439764595603342218424299073791461754012201879139362014) }}, 
      {{ SC_(1038672.0), SC_(0.308167040348052978515625), SC_(1039183.02424954714222774349876757311179226469890988686951745625484165465382310513156303615393771035), SC_(1038161.726101666816182187534956051775563256753775574050510754523412476523942429812165448578674924493) }}, 
      {{ SC_(1038672.0), SC_(0.546881496906280517578125), SC_(1038552.29346346086939063971953753418435291009416102738346293634425105836884659855955981674730198758), SC_(1038792.377827703383187427470966807112545507260571343031248281875679504401909882240273826790481452983) }}, 
      {{ SC_(1038672.0), SC_(0.54722058773040771484375), SC_(1038551.421169349531912052227889607485847056343006936762569956411450298573930468309626038848271402694), SC_(1038793.250189270488726304564642597997169463410179450870069476228240325295897144900768641849827830973) }}, 
      {{ SC_(1038672.0), SC_(0.6323592662811279296875), SC_(1038327.768299746329920265763977689753250219933479151314980909971487343500995937536971484724684162792), SC_(1039016.936472657615337102164799291183542707890146035188125040822910674452580533104959912853400193023) }}, 
      {{ SC_(1038672.0), SC_(0.814723670482635498046875), SC_(1037759.878405952645373535683495405564523079148698441571327746313089445399810325213062065522035191912), SC_(1039585.055530806350432130602269033531340276895922270056898643323629041630713133375899885100665100403) }}, 
      {{ SC_(1038672.0), SC_(0.835008561611175537109375), SC_(1037679.685701980251846869440893782386785585267275366747697580533307742300441830762824057723243083607), SC_(1039665.297286351461240747354237473149155751724201167845607547506523668744833830475498916720707379591) }}, 
      {{ SC_(1038672.0), SC_(0.905791938304901123046875), SC_(1037332.151638109014208141917995483845046810004084672255296689457371474617480488051337817821547914199), SC_(1040013.091681596700925701129424372964904824656076325793987685884707977584929221294267794586602260659) }}, 
      {{ SC_(1038672.0), SC_(0.9133758544921875), SC_(1037284.719441169657467932531837576930104662471667121936691141049108563099425495864192866330874495483), SC_(1040060.565428512982591779925470307206621191310177799052151176600349975053787196210309716992622044307) }}, 
      {{ SC_(1038672.0), SC_(0.968867778778076171875), SC_(1036772.796656464105607231920830659776186334050684419370977689526072902975858488481897938814591567751), SC_(1040573.02868259772175619209122481592511708136416323735380618660561260682499739109123412754917051063) }}, 
      {{ SC_(2052238.25), SC_(0.097540400922298431396484375), SC_(2054095.027583465223686841978248452556033512641190275730056584715812256080478161168484230836100947052), SC_(2050382.698691173187745922372534387551045895940517684724175215901533960809913513534366769474593763921) }}, 
      {{ SC_(2052238.25), SC_(0.12698681652545928955078125), SC_(2053872.998192082546723955677339777747836479367344948387773619073183201466370740450206544170555895289), SC_(2050604.602245390540835807465989462437852374721362129721172434953805912731953522818518779820048873869) }}, 
      {{ SC_(2052238.25), SC_(0.135477006435394287109375), SC_(2053815.848948738672362662387412345896497387388112675249006412886435587608425425685664841188035880858), SC_(2050661.721688207597130264684349124298252696427878190340316893838593627893365881282281425663488084513) }}, 
      {{ SC_(2052238.25), SC_(0.188381969928741455078125), SC_(2053504.919947703498278038867147328446853767981914290411952526534972183450857608605657672915443848792), SC_(2050972.507130356318314811204479254999541923555062067166889360904521810004836133251034317909725280304) }}, 
      {{ SC_(2052238.25), SC_(0.22103404998779296875), SC_(2053339.901401341805907104897212095957118651882953731817043730068280829854989833022072007826683459789), SC_(2051137.462234744801505878750082320379542374302606696363007525477859483770662648606525079056227839451) }}, 
      {{ SC_(2052238.25), SC_(0.278498232364654541015625), SC_(2053079.997689542575296546864223375113926930469449376074035048577439532566749507686783023854207182323), SC_(2051397.283954239641967895180682960542155760358735088770405586016773863546747869621404064727339758829) }}, 
      {{ SC_(2052238.25), SC_(0.308167040348052978515625), SC_(2052956.414891788683806764206551298054476242455564807691702654925660369363547425428367051736672596977), SC_(2051520.83545944177433097624476440369994595188677665298285942396516791751278175717498481882134161834) }}, 
      {{ SC_(2052238.25), SC_(0.546881496906280517578125), SC_(2052069.849329213082510337689726538696073912717561995945305414570452369066145302556713000996633019125), SC_(2052407.32196196984035858364025834548401399648935817922598350562581122762250640792202487287141730989) }}, 
      {{ SC_(2052238.25), SC_(0.54722058773040771484375), SC_(2052068.623182412664967654109888912911112017296589588879658216057212486728014858087494611267360157036), SC_(2052408.5481762260242784967888910268174797785721626516356813867200692400601652133144156629969140318) }}, 
      {{ SC_(2052238.25), SC_(0.6323592662811279296875), SC_(2051754.240569037547802142594373829006051459599308119674378730431448217035911319362271900655587977869), SC_(2052722.964203384196906439350465837421826322692035205923675364495412885462078877240220643964205556274) }}, 
      {{ SC_(2052238.25), SC_(0.814723670482635498046875), SC_(2050955.944275709730983841422789858755211669613104602430204931646053312682843491102068166094255929979), SC_(2053521.489661059195786150000462277494838397684632133050026341425875585562325269833891474670670367515) }}, 
      {{ SC_(2052238.25), SC_(0.835008561611175537109375), SC_(2050843.21210336092371390960727350094853324740373648052249876224738041497777078278635094223667696696), SC_(2053634.270884978603521287169507823951565301637541523753361730343333350257935273971575210584216670402) }}, 
      {{ SC_(2052238.25), SC_(0.905791938304901123046875), SC_(2050354.650861367231473825090782534818921809420363821320930988865832550934997364545718954344213568815), SC_(2054123.092458332510067650567465482251849879954069948032901338716521198293368849528571732240279017728) }}, 
      {{ SC_(2052238.25), SC_(0.9133758544921875), SC_(2050287.969750181148873042707384685319074169442528674372925794051806460528476505943046782195572041022), SC_(2054189.815119492919398705560963459087891293979039395550646733858539500957775171385998864317618354795) }}, 
      {{ SC_(2052238.25), SC_(0.968867778778076171875), SC_(2049568.279998083978083717070005223652136966985879331037425478106519463013914740524256840211610720664), SC_(2054910.045340925509379347848542946674008434059729678497889265125108172395728162426345323483570406674) }}, 
      {{ SC_(2327548.75), SC_(0.097540400922298431396484375), SC_(2329526.114082296801454515301749916711685327592448700487411930368448822290616084217730068271714360125), SC_(2325572.612192341011257115457310472858239651932516576627739504475639092927758206070364154135493711917) }}, 
      {{ SC_(2327548.75), SC_(0.12698681652545928955078125), SC_(2329289.664545735704613883153418430866175802581351679286037018431794089164081203052786433572592057633), SC_(2325808.935891737640613040680885071381536312145425180785579314299200735594918690005492545573784766532) }}, 
      {{ SC_(2327548.75), SC_(0.135477006435394287109375), SC_(2329228.80354581862311698961187648491661647766481942239632595971585572557525627543642925973885202791), SC_(2325869.767091128089029913234295812204399571291611266591967535346154503730431476798901360516233992553) }}, 
      {{ SC_(2327548.75), SC_(0.188381969928741455078125), SC_(2328897.679575152003689265505829966265021530958723621499513615353122882777916041302543254337542639196), SC_(2326200.747502909051072070412784133099144772573156100988795274468974724396700640824237340780935046666) }}, 
      {{ SC_(2327548.75), SC_(0.22103404998779296875), SC_(2328721.942590688711496393210017238743734685882987330731336806058435964241299292085371919430715822137), SC_(2326376.421045399435180440353833085577392501041602161094172048871438136863090874283198971210345881252) }}, 
      {{ SC_(2327548.75), SC_(0.278498232364654541015625), SC_(2328445.15678905003228088229678439200658769886245365571048518441037844941196896735464747263849534909), SC_(2326653.124854734067563633339568376362848269550954365023090632937676635387549254860647893189580559379) }}, 
      {{ SC_(2327548.75), SC_(0.308167040348052978515625), SC_(2328313.546399751652059713274678372017164383348891447194993162164660829885071412959572752394521233103), SC_(2326784.703951480806064245714717217613575306191844571593409016843210074078710477882506598476346106392) }}, 
      {{ SC_(2327548.75), SC_(0.546881496906280517578125), SC_(2327369.387304154662410096752126928601205253740576963609663284517925484417216142711670278541786961623), SC_(2327728.783987030523546329567280321796383027755109763464107192906728693179609996052842943543500035192) }}, 
      {{ SC_(2327548.75), SC_(0.54722058773040771484375), SC_(2327368.081498025582089401907318503213215730025503618025975862059284890621332840713954877115416251501), SC_(2327730.089860615370040244563745093475979746507775795075985262243438365291378880992534385389978678901) }}, 
      {{ SC_(2327548.75), SC_(0.6323592662811279296875), SC_(2327033.273801844088415206376643110113826445785303219943120801547928132438418103340213979231412894001), SC_(2328064.930970579813823457468264159708586111712861082462442844708647663456049027616263351822455409326) }}, 
      {{ SC_(2327548.75), SC_(0.814723670482635498046875), SC_(2326183.108412690357616768899081097031188537381782138357737910342416420245413967281606903655593452032), SC_(2328915.325524079772917592305014897329288870488064276913169357434509954800375172709607861098443244384) }}, 
      {{ SC_(2327548.75), SC_(0.835008561611175537109375), SC_(2326063.050954241613569920181064667103319468137735199060976212458546583325105462081245924778898223872), SC_(2329035.432034098860843227435663627629861084927695603790221290342905612446508160126831989950903483755) }}, 
      {{ SC_(2327548.75), SC_(0.905791938304901123046875), SC_(2325542.741669800113444930187473766546401748113894048427332848619782119518386971117888443401924877391), SC_(2329556.001649898904016797542482546183791200134818148114806366610367086534751227989400150443040016348) }}, 
      {{ SC_(2327548.75), SC_(0.9133758544921875), SC_(2325471.727242497392773449639911571066022914913370149675655043817114137532777832647461474174075784684), SC_(2329627.057627175636482679321890332587124140179464134521091120057293262780055485755607840175871399635) }}, 
      {{ SC_(2327548.75), SC_(0.968867778778076171875), SC_(2324705.264985226344294745203011389326002772462961055280128731391064922559949044503112872046703368467), SC_(2330394.060353776798876224782809597216579299224955719757290503934606630340754068086724147607390669768) }}, 
      {{ SC_(6230117.0), SC_(0.097540400922298431396484375), SC_(6233351.692472792061056579423995328493857103363396239930285849771856937399508188067562089564731873418), SC_(6226883.533801842955995418263348267065006324244587298450820602128533786716023362663081376081505278596) }}, 
      {{ SC_(6230117.0), SC_(0.12698681652545928955078125), SC_(6232964.887316261881701097347977065367130687058335028215195760161155574674778388777016592959892786101), SC_(6227270.213121212666669646893421478332353213715522094655483973849209986323367490884986293265596032224) }}, 
      {{ SC_(6230117.0), SC_(0.135477006435394287109375), SC_(6232865.324662868111190527453037563536761042866213055644551828614498129899296431946798065713700170309), SC_(6227369.745974080667874198600668355855866443350107162047433655601935476580330379827328115355241930538) }}, 
      {{ SC_(6230117.0), SC_(0.188381969928741455078125), SC_(6232323.63227185115778658441373123602508832270222793713035148463068189665774304541385361276622984635), SC_(6227911.294806215678453456704655164982523620764595109639499042366654806988561384785145329706145958711) }}, 
      {{ SC_(6230117.0), SC_(0.22103404998779296875), SC_(6232036.136536250933679987772671460235733726477628676496527697942146593792117713490188974877896657093), SC_(6228198.727099844400404830340828350312187148760053110689306546858635128471089524390627975414927556548) }}, 
      {{ SC_(6230117.0), SC_(0.278498232364654541015625), SC_(6231583.324968307181681406950097442146625275486837869234235041148491080696490646684242945262614873862), SC_(6228651.456675485708645793762391965898293897905472473126963140667980274570043834720563802098830776494) }}, 
      {{ SC_(6230117.0), SC_(0.308167040348052978515625), SC_(6231368.01268140366726819175665186638268466543674045388244783605009365981150484906350062278363002165), SC_(6228866.737669838129552659768389036176940614109203793210530779899481841299310894708215176090916781291) }}, 
      {{ SC_(6230117.0), SC_(0.546881496906280517578125), SC_(6229823.338725792076249396465479515707976738291090698907050753153528364353246948669279119423361512767), SC_(6230411.332565403676924567021771163447589886484281784991639253912767759502501563110172430307851857965) }}, 
      {{ SC_(6230117.0), SC_(0.54722058773040771484375), SC_(6229821.20232969720644266921283636481256709952913709169187035576735749241917052776040711574219186358), SC_(6230413.469028954311951916289817041956497186222746860523204205914506151906118372519765070461530163706) }}, 
      {{ SC_(6230117.0), SC_(0.6323592662811279296875), SC_(6229273.426873074414556366664038917730342926119497520622955950028248233012730923731157371779835274121), SC_(6230961.277899359562011793446984848521160452797500133271897124953410729884385903965899957485493616226) }}, 
      {{ SC_(6230117.0), SC_(0.814723670482635498046875), SC_(6227882.434048976058402554738706177641614293741446680191726074222637100597948821666067849039597462162), SC_(6232352.49988779969296455486124268083236030976120352890683487451263766450087335752456747789340459989) }}, 
      {{ SC_(6230117.0), SC_(0.835008561611175537109375), SC_(6227685.997474726247688087235059841375491699004535827525396018185766370072460519898747215701210901658), SC_(6232548.985513618649457852034579253993054240803224395784331070556455526838927599609658335554516685135) }}, 
      {{ SC_(6230117.0), SC_(0.905791938304901123046875), SC_(6226834.658470939251130269088475617573565344834275615564082295817604878528766465312582574980965566951), SC_(6233400.584848756385324680328194932048486178740428764315512985319315075751357006490348772335643597714) }}, 
      {{ SC_(6230117.0), SC_(0.9133758544921875), SC_(6226718.46152837504987605910618350148896811668349713499970654969426128470753421783619578121107382213), SC_(6233516.823341293127817703348946693534220889012539925157887472970468357261827764647617813444939050571) }}, 
      {{ SC_(6230117.0), SC_(0.968867778778076171875), SC_(6225464.31285320598579378900341589648562621739072429909204840552840676406014931804970799580191477189), SC_(6234771.512485767533460305424549342618110995053933756316716261789635898723192636506248708591368854061) }}, 
      {{ SC_(15083605.0), SC_(0.097540400922298431396484375), SC_(15088637.78129839240544084967639490379844477975678197902399407486600207945266721185803386193838048788), SC_(15078573.44497624163292763488000992712939959763710279840335208548585316282432025007551150520834892593) }}, 
      {{ SC_(15083605.0), SC_(0.12698681652545928955078125), SC_(15088035.95454486752580740261889753816930358428372354823140840080143163186851089423134281705030456187), SC_(15079175.14589260744374955642608743874599125416522689478871576618133114925591835305586515102168450869) }}, 
      {{ SC_(15083605.0), SC_(0.135477006435394287109375), SC_(15087881.04516515058008645681821244786240897066985410758979447193614902902100508841528459831467151797), SC_(15079330.02547179892254772110264023468178754075598873509528620157408889322324875656941277086187068723) }}, 
      {{ SC_(15083605.0), SC_(0.188381969928741455078125), SC_(15087038.22164129576331239830876873353215959212349671143829660806147341521657730913830483880795924604), SC_(15080172.70543677309686154480478630061895108326075818775376184189438877404905927698452585456460439436) }}, 
      {{ SC_(15083605.0), SC_(0.22103404998779296875), SC_(15086590.90118294501418553538586701765236949743021493354695067962707784877870875603880811865737188093), SC_(15080619.96245315283600996122158277029601757754302700450619766582009047870716487351388585974357884923) }}, 
      {{ SC_(15083605.0), SC_(0.278498232364654541015625), SC_(15085886.35747723304468589943584481796024609839822718371399281266195551388857413330568267228846771924), SC_(15081324.42416656292294392879954060790691623450955961557020548135058993368970804049112726766191292319) }}, 
      {{ SC_(15083605.0), SC_(0.308167040348052978515625), SC_(15085551.34420515641571775001974011059238876676606782093094374386448901839125525873664701387018457173), SC_(15081659.4061460886503203161240084124632660964064929967501551529928113396007364677184216561021748007) }}, 
      {{ SC_(15083605.0), SC_(0.546881496906280517578125), SC_(15083147.88182872830072612604647044724558765934450113173248706039646401749665137590731770281561564279), SC_(15084062.78946247115173608372375734029812941014549468133844220227152081657865687456247081611122282205) }}, 
      {{ SC_(15083605.0), SC_(0.54722058773040771484375), SC_(15083144.55761682266607161006212263153448991348641093068040602030513183087566712109971802285493643745), SC_(15084066.11374183255127774349397874273282083208958473269307345912470558386422663180275755856718286894) }}, 
      {{ SC_(15083605.0), SC_(0.6323592662811279296875), SC_(15082292.21976072050789874456495350894784125555141581904825165790430182222017429560913482757052410598), SC_(15084918.4850117169954112119454349395093713303826023318028934780952962765491698393599514678303984078) }}, 
      {{ SC_(15083605.0), SC_(0.814723670482635498046875), SC_(15080127.79672086471855145296910274760322807117874269748523561539117756164468929742101440033412619451), SC_(15087083.13721591300051187437457165132686653041492870555194851269781626386717551279263922333330837915) }}, 
      {{ SC_(15083605.0), SC_(0.835008561611175537109375), SC_(15079822.13137600794879441883791234166660844799568532069150956980805393588464890726312515528384620475), SC_(15087388.85161233849662625412502891217716929149866356777620050803844415678951962999244150794846728711) }}, 
      {{ SC_(15083605.0), SC_(0.905791938304901123046875), SC_(15078497.39111859196942643525234208299210155465881136002686264100877073259043613787120296293082019187), SC_(15088713.85220110248343127416083317298417971060035075742320769629655969166242700390981290477097864291) }}, 
      {{ SC_(15083605.0), SC_(0.9133758544921875), SC_(15078316.57925461811008046272040141036219718278649375130100601062440179434244992344435579799277359019), SC_(15088894.70561504836921552772384009007949176914160796656104057265657981769338965029262519632953830189) }}, 
      {{ SC_(15083605.0), SC_(0.968867778778076171875), SC_(15076364.99664491882324687003477038147511063884443803257690739420141880711939968486790583272510921072), SC_(15090846.82869404432549959125993359239420390163029355290721639099401542481263745861685706736887672797) }}, 
      {{ SC_(30203694.0), SC_(0.097540400922298431396484375), SC_(30210815.47566831752036352507646724966902397170938923180599788499483624078712473926944711066637024068), SC_(30196573.75060631617324365602586584702812846344145665137998045911407907692772654641163877762705456397) }}, 
      {{ SC_(30203694.0), SC_(0.12698681652545928955078125), SC_(30209963.8757157795480995601711819490850855177202359573561810789532756328719973708836474351335854889), SC_(30197425.22472169556982870125185614985218844456494507799910460728140621558219262938938751348734740307) }}, 
      {{ SC_(30203694.0), SC_(0.135477006435394287109375), SC_(30209744.67452031337899415070813774353602917889889616197547160928602825672821125303891065223640309171), SC_(30197644.39611663637853198149681272295131038344158276965149015781362885264090975193062615327536605494) }}, 
      {{ SC_(30203694.0), SC_(0.188381969928741455078125), SC_(30208552.05131349505367548465974563992383024423755241876800896941592304014554064168696807336242707805), SC_(30198836.87576457451947027519100177908268502372878129639212126829680623490205917339927211144716523626) }}, 
      {{ SC_(30203694.0), SC_(0.22103404998779296875), SC_(30207919.07540045596968115923357225804129946123666237495696182304373656661881886764705270512529825631), SC_(30199469.78823564276686545281804196696004068558549613806405242745080779095956522018947522727857563533) }}, 
      {{ SC_(30203694.0), SC_(0.278498232364654541015625), SC_(30206922.11482883621349902576400149622677934703180000493881690157818678904256430739792356870432623573), SC_(30200466.66681496083817322221637013993723066065566124378008761476684957400999798723604743234095626697) }}, 
      {{ SC_(30203694.0), SC_(0.308167040348052978515625), SC_(30206448.05460290491450971241953253008423903107052255039907494646751223838472473892280165946724898133), SC_(30200940.69574834130317660059010636635891931231336377577854780281206532038547042794469057516760843273) }}, 
      {{ SC_(30203694.0), SC_(0.546881496906280517578125), SC_(30203047.00717058636669137357304329205959160149968637834771106489786699129221742385725439984711498261), SC_(30204341.66412061438892037858238817499573385966690259844837484508562445579642440156011876568390745967) }}, 
      {{ SC_(30203694.0), SC_(0.54722058773040771484375), SC_(30203042.30316911510841423755943355619862052255525737384753926509535075864473371673718417804236785854), SC_(30204346.36818954141196718386901594529173091315276193703386689325465835489738438729376667618975581351) }}, 
      {{ SC_(30203694.0), SC_(0.6323592662811279296875), SC_(30201836.17980432310579115059624887819436825142777050805037400727522822838623497800967776780877762698), SC_(30205552.52496811563988534014867005476936232886423535822792563048853981792883735017378794452129469264) }}, 
      {{ SC_(30203694.0), SC_(0.814723670482635498046875), SC_(30198773.32543295466384303637189930446471572734223223892225111721858159661322380144370334171399592945), SC_(30208615.60850382374838123766556759581715316364613287151987225419255301976073762617401758260722361711) }}, 
      {{ SC_(30203694.0), SC_(0.835008561611175537109375), SC_(30198340.77785915372227694900099056895390988180231312503107906339171260486697177517187178707615377744), SC_(30209048.20512919326855490888268848804451625500482635894067819189284827655903055503571740161890393015) }}, 
      {{ SC_(30203694.0), SC_(0.905791938304901123046875), SC_(30196466.12565226888150073567973527983647592469381424487408323665472782970590030369753565377529416458), SC_(30210923.11766742515441063993124028259470221758493890083864245553374244107973324231229306719090975719) }}, 
      {{ SC_(30203694.0), SC_(0.9133758544921875), SC_(30196210.25585998280064237944520762297790392031265667224175460272447471873119884901896113469469345057), SC_(30211179.02900968308035831437060149239618022354135751179509266594271502924955014841375878474172002289) }}, 
      {{ SC_(30203694.0), SC_(0.968867778778076171875), SC_(30193448.52065679169569881618335847186614165117290739943799101539336869203467308211264064437967727749), SC_(30213941.30468216779982532499490538896952642738252393109170337539122327630305298668623088994994675055) }}
   } };

