/*
 * Copyright (c) 2022-2023 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#if __aarch64__ && defined(ARM_COMPUTE_ENABLE_SVE)
#include <cstddef>

namespace arm_conv {
namespace winograd {
namespace input_transform {

void sve_fp32_6x6(
  const unsigned int num_channels,
  const float *input,
  const size_t input_row_stride,
  const size_t input_col_stride,
  float *output,
  const size_t output_col_stride
)
{
  const float B_values[4] = { 1.0f, 2.0f, 4.0f, 5.0f };
  long long_channels = num_channels;

  // Generated by armasmgen (February 04th, 2021)
  __asm__ __volatile__(
      "fmov z16.s, #4.0\n"
      "ptrue p1.b\n"
      "ld1rqw { z2.s }, p1/Z, [%x[B_values]]\n"
      "add x16, %x[input_row_0], %x[input_row_stride], LSL #2\n"
      "add x15, %x[output_row_0], %x[output_row_stride], LSL #2\n"
      "add x14, %x[input_row_0], %x[input_row_stride], LSL #3\n"
      "add x13, %x[output_row_0], %x[output_row_stride], LSL #3\n"
      "add x12, x14, %x[input_row_stride], LSL #2\n"
      "add x11, x13, %x[output_row_stride], LSL #2\n"
      "add x10, %x[input_row_0], %x[input_row_stride], LSL #4\n"
      "add x9, %x[output_row_0], %x[output_row_stride], LSL #4\n"
      "add x28, x10, %x[input_row_stride], LSL #2\n"
      "add x27, x9, %x[output_row_stride], LSL #2\n"
      "lsl x26, %x[input_col_1_stride], #0x1\n"
      "lsl x25, %x[output_col_1_stride], #0x1\n"
      "add x24, x26, %x[input_col_1_stride]\n"
      "add x23, x25, %x[output_col_1_stride]\n"
      "lsl x22, %x[input_col_1_stride], #0x2\n"
      "lsl x21, %x[output_col_1_stride], #0x2\n"
      "add x20, x22, %x[input_col_1_stride]\n"
      "add x8, x21, %x[output_col_1_stride]\n"
      "whilelt p0.s, XZR, %x[num_channels]\n"
      "beq 2f\n"
      "1:"  // channel_loop
      "ld1w { z31.s }, p0/Z, [%x[input_row_0]]\n"
      "decw %x[num_channels]\n"
      "ld1w { z28.s }, p0/Z, [%x[input_row_0], %x[input_col_1_stride], LSL #2]\n"
      "fmul z13.s, z28.s, z2.s[1]\n"
      "ld1w { z27.s }, p0/Z, [%x[input_row_0], x26, LSL #2]\n"
      "ld1w { z11.s }, p0/Z, [%x[input_row_0], x24, LSL #2]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "ld1w { z7.s }, p0/Z, [%x[input_row_0], x22, LSL #2]\n"
      "fsub z15.s, z7.s, z27.s\n"
      "fmad z31.s, p1/M, z16.s, z7.s\n"
      "ld1w { z3.s }, p0/Z, [%x[input_row_0], x20, LSL #2]\n"
      "fmla z13.s, z11.s, z2.s[1]\n"
      "ld1w { z12.s }, p0/Z, [x14]\n"
      "incb %x[input_row_0]\n"
      "fmls z31.s, z27.s, z2.s[3]\n"
      "ld1w { z14.s }, p0/Z, [x14, %x[input_col_1_stride], LSL #2]\n"
      "fsub z25.s, z15.s, z13.s\n"
      "fadd z8.s, z13.s, z15.s\n"
      "ld1w { z24.s }, p0/Z, [x14, x26, LSL #2]\n"
      "fmsb z27.s, p1/M, z16.s, z7.s\n"
      "ld1w { z22.s }, p0/Z, [x14, x24, LSL #2]\n"
      "fmul z7.s, z28.s, z2.s[2]\n"
      "ld1w { z1.s }, p0/Z, [x14, x22, LSL #2]\n"
      "fsub z15.s, z1.s, z24.s\n"
      "fneg z7.s, p1/M, z7.s\n"
      "ld1w { z20.s }, p0/Z, [x14, x20, LSL #2]\n"
      "fadd z7.s, z7.s, z11.s\n"
      "ld1w { z29.s }, p0/Z, [x10]\n"
      "incb x14\n"
      "fmad z28.s, p1/M, z16.s, z3.s\n"
      "ld1w { z10.s }, p0/Z, [x10, %x[input_col_1_stride], LSL #2]\n"
      "fmad z12.s, p1/M, z16.s, z1.s\n"
      "ld1w { z18.s }, p0/Z, [x10, x26, LSL #2]\n"
      "fmul z13.s, z14.s, z2.s[1]\n"
      "ld1w { z19.s }, p0/Z, [x10, x24, LSL #2]\n"
      "fadd z17.s, z7.s, z27.s\n"
      "ld1w { z9.s }, p0/Z, [x10, x22, LSL #2]\n"
      "fsub z27.s, z27.s, z7.s\n"
      "fmls z28.s, z11.s, z2.s[3]\n"
      "ld1w { z21.s }, p0/Z, [x10, x20, LSL #2]\n"
      "incb x10\n"
      "fmls z12.s, z24.s, z2.s[3]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "fmla z13.s, z22.s, z2.s[1]\n"
      "fsub z30.s, z15.s, z13.s\n"
      "fadd z4.s, z13.s, z15.s\n"
      "fmsb z24.s, p1/M, z16.s, z1.s\n"
      "fsub z15.s, z9.s, z18.s\n"
      "fmul z1.s, z14.s, z2.s[2]\n"
      "fmad z14.s, p1/M, z16.s, z20.s\n"
      "fmad z29.s, p1/M, z16.s, z9.s\n"
      "fmul z13.s, z10.s, z2.s[1]\n"
      "fneg z1.s, p1/M, z1.s\n"
      "fadd z1.s, z1.s, z22.s\n"
      "fmls z14.s, z22.s, z2.s[3]\n"
      "fmls z29.s, z18.s, z2.s[3]\n"
      "fadd z5.s, z1.s, z24.s\n"
      "fsub z24.s, z24.s, z1.s\n"
      "fneg z13.s, p1/M, z13.s\n"
      "fmla z13.s, z19.s, z2.s[1]\n"
      "fsub z23.s, z15.s, z13.s\n"
      "fadd z11.s, z13.s, z15.s\n"
      "fmsb z18.s, p1/M, z16.s, z9.s\n"
      "fmul z9.s, z10.s, z2.s[2]\n"
      "fmad z10.s, p1/M, z16.s, z21.s\n"
      "fmad z31.s, p1/M, z16.s, z29.s\n"
      "fmad z8.s, p1/M, z16.s, z11.s\n"
      "fneg z9.s, p1/M, z9.s\n"
      "fadd z9.s, z9.s, z19.s\n"
      "fmls z10.s, z19.s, z2.s[3]\n"
      "fmls z31.s, z12.s, z2.s[3]\n"
      "st1w { z31.s }, p0, [%x[output_row_0]]\n"
      "fadd z26.s, z9.s, z18.s\n"
      "fsub z18.s, z18.s, z9.s\n"
      "fmls z8.s, z4.s, z2.s[3]\n"
      "fmad z25.s, p1/M, z16.s, z23.s\n"
      "fmad z28.s, p1/M, z16.s, z10.s\n"
      "fmad z17.s, p1/M, z16.s, z26.s\n"
      "fmad z27.s, p1/M, z16.s, z18.s\n"
      "fmls z25.s, z30.s, z2.s[3]\n"
      "fmls z28.s, z14.s, z2.s[3]\n"
      "fmls z17.s, z5.s, z2.s[3]\n"
      "st1w { z17.s }, p0, [%x[output_row_0], %x[output_col_1_stride], LSL #2]\n"
      "fmls z27.s, z24.s, z2.s[3]\n"
      "st1w { z27.s }, p0, [%x[output_row_0], x25, LSL #2]\n"
      "st1w { z8.s }, p0, [%x[output_row_0], x23, LSL #2]\n"
      "st1w { z25.s }, p0, [%x[output_row_0], x21, LSL #2]\n"
      "st1w { z28.s }, p0, [%x[output_row_0], x8, LSL #2]\n"
      "incb %x[output_row_0]\n"
      "ld1w { z19.s }, p0/Z, [x16]\n"
      "ld1w { z7.s }, p0/Z, [x16, %x[input_col_1_stride], LSL #2]\n"
      "fmul z13.s, z7.s, z2.s[1]\n"
      "ld1w { z6.s }, p0/Z, [x16, x26, LSL #2]\n"
      "ld1w { z27.s }, p0/Z, [x16, x24, LSL #2]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "ld1w { z25.s }, p0/Z, [x16, x22, LSL #2]\n"
      "fsub z15.s, z25.s, z6.s\n"
      "fmad z19.s, p1/M, z16.s, z25.s\n"
      "ld1w { z20.s }, p0/Z, [x16, x20, LSL #2]\n"
      "fmla z13.s, z27.s, z2.s[1]\n"
      "ld1w { z0.s }, p0/Z, [x12]\n"
      "incb x16\n"
      "fmls z19.s, z6.s, z2.s[3]\n"
      "ld1w { z31.s }, p0/Z, [x12, %x[input_col_1_stride], LSL #2]\n"
      "fsub z8.s, z15.s, z13.s\n"
      "fadd z28.s, z13.s, z15.s\n"
      "ld1w { z1.s }, p0/Z, [x12, x26, LSL #2]\n"
      "fmsb z6.s, p1/M, z16.s, z25.s\n"
      "ld1w { z21.s }, p0/Z, [x12, x24, LSL #2]\n"
      "fmul z25.s, z7.s, z2.s[2]\n"
      "ld1w { z22.s }, p0/Z, [x12, x22, LSL #2]\n"
      "fsub z15.s, z22.s, z1.s\n"
      "fneg z25.s, p1/M, z25.s\n"
      "ld1w { z17.s }, p0/Z, [x12, x20, LSL #2]\n"
      "fadd z25.s, z25.s, z27.s\n"
      "incb x12\n"
      "fmad z7.s, p1/M, z16.s, z20.s\n"
      "fmad z0.s, p1/M, z16.s, z22.s\n"
      "fmul z13.s, z31.s, z2.s[1]\n"
      "fadd z3.s, z25.s, z6.s\n"
      "fsub z6.s, z6.s, z25.s\n"
      "fmls z7.s, z27.s, z2.s[3]\n"
      "fmls z0.s, z1.s, z2.s[3]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "fmla z13.s, z21.s, z2.s[1]\n"
      "fsub z9.s, z15.s, z13.s\n"
      "fadd z27.s, z13.s, z15.s\n"
      "fmsb z1.s, p1/M, z16.s, z22.s\n"
      "fsub z15.s, z29.s, z12.s\n"
      "fmul z22.s, z31.s, z2.s[2]\n"
      "fmad z31.s, p1/M, z16.s, z17.s\n"
      "fmul z13.s, z19.s, z2.s[1]\n"
      "fmsb z12.s, p1/M, z16.s, z29.s\n"
      "fneg z22.s, p1/M, z22.s\n"
      "fadd z22.s, z22.s, z21.s\n"
      "fmls z31.s, z21.s, z2.s[3]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "fadd z25.s, z22.s, z1.s\n"
      "fsub z1.s, z1.s, z22.s\n"
      "fmla z13.s, z0.s, z2.s[1]\n"
      "fmul z29.s, z19.s, z2.s[2]\n"
      "fadd z22.s, z13.s, z15.s\n"
      "st1w { z22.s }, p0, [x11]\n"
      "fneg z29.s, p1/M, z29.s\n"
      "fsub z22.s, z15.s, z13.s\n"
      "fadd z29.s, z29.s, z0.s\n"
      "st1w { z22.s }, p0, [x9]\n"
      "fadd z22.s, z29.s, z12.s\n"
      "fsub z15.s, z26.s, z5.s\n"
      "fmul z13.s, z3.s, z2.s[1]\n"
      "fsub z12.s, z12.s, z29.s\n"
      "fmsb z5.s, p1/M, z16.s, z26.s\n"
      "fmul z26.s, z3.s, z2.s[2]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "fmla z13.s, z25.s, z2.s[1]\n"
      "fneg z26.s, p1/M, z26.s\n"
      "fadd z26.s, z26.s, z25.s\n"
      "fadd z21.s, z13.s, z15.s\n"
      "st1w { z21.s }, p0, [x11, %x[output_col_1_stride], LSL #2]\n"
      "fsub z21.s, z15.s, z13.s\n"
      "fmul z13.s, z6.s, z2.s[1]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "st1w { z21.s }, p0, [x9, %x[output_col_1_stride], LSL #2]\n"
      "fadd z21.s, z26.s, z5.s\n"
      "fsub z15.s, z18.s, z24.s\n"
      "fmla z13.s, z1.s, z2.s[1]\n"
      "fsub z5.s, z5.s, z26.s\n"
      "fmsb z24.s, p1/M, z16.s, z18.s\n"
      "fmul z18.s, z6.s, z2.s[2]\n"
      "fadd z20.s, z13.s, z15.s\n"
      "st1w { z20.s }, p0, [x11, x25, LSL #2]\n"
      "fneg z18.s, p1/M, z18.s\n"
      "fsub z20.s, z15.s, z13.s\n"
      "fadd z18.s, z18.s, z1.s\n"
      "st1w { z20.s }, p0, [x9, x25, LSL #2]\n"
      "fadd z20.s, z18.s, z24.s\n"
      "fsub z15.s, z11.s, z4.s\n"
      "fmul z13.s, z28.s, z2.s[1]\n"
      "fsub z24.s, z24.s, z18.s\n"
      "fmsb z4.s, p1/M, z16.s, z11.s\n"
      "fmul z11.s, z28.s, z2.s[2]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "fmla z13.s, z27.s, z2.s[1]\n"
      "fneg z11.s, p1/M, z11.s\n"
      "fadd z11.s, z11.s, z27.s\n"
      "fadd z26.s, z13.s, z15.s\n"
      "st1w { z26.s }, p0, [x11, x23, LSL #2]\n"
      "fsub z26.s, z15.s, z13.s\n"
      "fmul z13.s, z8.s, z2.s[1]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "st1w { z26.s }, p0, [x9, x23, LSL #2]\n"
      "fadd z26.s, z11.s, z4.s\n"
      "fsub z15.s, z23.s, z30.s\n"
      "fmla z13.s, z9.s, z2.s[1]\n"
      "fsub z4.s, z4.s, z11.s\n"
      "fmsb z30.s, p1/M, z16.s, z23.s\n"
      "fmul z23.s, z8.s, z2.s[2]\n"
      "fadd z18.s, z13.s, z15.s\n"
      "st1w { z18.s }, p0, [x11, x21, LSL #2]\n"
      "fneg z23.s, p1/M, z23.s\n"
      "fsub z18.s, z15.s, z13.s\n"
      "fadd z23.s, z23.s, z9.s\n"
      "st1w { z18.s }, p0, [x9, x21, LSL #2]\n"
      "fadd z18.s, z23.s, z30.s\n"
      "fsub z15.s, z10.s, z14.s\n"
      "fmul z13.s, z7.s, z2.s[1]\n"
      "fsub z30.s, z30.s, z23.s\n"
      "fmsb z14.s, p1/M, z16.s, z10.s\n"
      "fmul z10.s, z7.s, z2.s[2]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "fmla z13.s, z31.s, z2.s[1]\n"
      "fneg z10.s, p1/M, z10.s\n"
      "fadd z10.s, z10.s, z31.s\n"
      "fadd z17.s, z13.s, z15.s\n"
      "st1w { z17.s }, p0, [x11, x8, LSL #2]\n"
      "fsub z17.s, z15.s, z13.s\n"
      "incb x11\n"
      "st1w { z17.s }, p0, [x9, x8, LSL #2]\n"
      "fadd z17.s, z10.s, z14.s\n"
      "fsub z14.s, z14.s, z10.s\n"
      "st1w { z22.s }, p0, [x15]\n"
      "incb x9\n"
      "st1w { z12.s }, p0, [x13]\n"
      "st1w { z21.s }, p0, [x15, %x[output_col_1_stride], LSL #2]\n"
      "st1w { z5.s }, p0, [x13, %x[output_col_1_stride], LSL #2]\n"
      "st1w { z20.s }, p0, [x15, x25, LSL #2]\n"
      "st1w { z24.s }, p0, [x13, x25, LSL #2]\n"
      "st1w { z26.s }, p0, [x15, x23, LSL #2]\n"
      "st1w { z4.s }, p0, [x13, x23, LSL #2]\n"
      "st1w { z18.s }, p0, [x15, x21, LSL #2]\n"
      "st1w { z30.s }, p0, [x13, x21, LSL #2]\n"
      "st1w { z17.s }, p0, [x15, x8, LSL #2]\n"
      "incb x15\n"
      "st1w { z14.s }, p0, [x13, x8, LSL #2]\n"
      "incb x13\n"
      "ld1w { z23.s }, p0/Z, [x28]\n"
      "ld1w { z22.s }, p0/Z, [x28, %x[input_col_1_stride], LSL #2]\n"
      "fmul z13.s, z22.s, z2.s[1]\n"
      "ld1w { z21.s }, p0/Z, [x28, x26, LSL #2]\n"
      "ld1w { z20.s }, p0/Z, [x28, x24, LSL #2]\n"
      "fneg z13.s, p1/M, z13.s\n"
      "ld1w { z26.s }, p0/Z, [x28, x22, LSL #2]\n"
      "fsub z15.s, z26.s, z21.s\n"
      "fmad z23.s, p1/M, z16.s, z26.s\n"
      "ld1w { z18.s }, p0/Z, [x28, x20, LSL #2]\n"
      "fmla z13.s, z20.s, z2.s[1]\n"
      "incb x28\n"
      "fmls z23.s, z21.s, z2.s[3]\n"
      "fsub z17.s, z15.s, z13.s\n"
      "fadd z30.s, z13.s, z15.s\n"
      "fmsb z21.s, p1/M, z16.s, z26.s\n"
      "fmul z26.s, z22.s, z2.s[2]\n"
      "fmad z22.s, p1/M, z16.s, z18.s\n"
      "fmad z19.s, p1/M, z16.s, z23.s\n"
      "fmad z28.s, p1/M, z16.s, z30.s\n"
      "fneg z26.s, p1/M, z26.s\n"
      "fadd z26.s, z26.s, z20.s\n"
      "fmls z22.s, z20.s, z2.s[3]\n"
      "fmls z19.s, z0.s, z2.s[3]\n"
      "st1w { z19.s }, p0, [x27]\n"
      "fadd z23.s, z26.s, z21.s\n"
      "fsub z21.s, z21.s, z26.s\n"
      "fmls z28.s, z27.s, z2.s[3]\n"
      "fmad z8.s, p1/M, z16.s, z17.s\n"
      "fmad z7.s, p1/M, z16.s, z22.s\n"
      "fmad z3.s, p1/M, z16.s, z23.s\n"
      "fmad z6.s, p1/M, z16.s, z21.s\n"
      "fmls z8.s, z9.s, z2.s[3]\n"
      "fmls z7.s, z31.s, z2.s[3]\n"
      "fmls z3.s, z25.s, z2.s[3]\n"
      "st1w { z3.s }, p0, [x27, %x[output_col_1_stride], LSL #2]\n"
      "fmls z6.s, z1.s, z2.s[3]\n"
      "st1w { z6.s }, p0, [x27, x25, LSL #2]\n"
      "st1w { z28.s }, p0, [x27, x23, LSL #2]\n"
      "st1w { z8.s }, p0, [x27, x21, LSL #2]\n"
      "st1w { z7.s }, p0, [x27, x8, LSL #2]\n"
      "incb x27\n"
      "whilelt p0.s, XZR, %x[num_channels]\n"
      "bne 1b\n"
      "2:"  // channel_loop_end

      : [input_row_0] "+&r" (input), [num_channels] "+&r" (long_channels), [output_row_0] "+&r" (output)
      : [B_values] "r" (B_values), [input_col_1_stride] "r" ((long) input_col_stride), [input_row_stride] "r" ((long) input_row_stride), [output_col_1_stride] "r" ((long) output_col_stride), [output_row_stride] "r" (6 * (long) output_col_stride)
      : "cc", "memory", "p0", "p1", "x9", "x10", "x11", "x12", "x13", "x14", "x15", "x16", "x8", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28", "z0", "z1", "z2", "z3", "z4", "z5", "z6", "z7", "z8", "z9", "z10", "z11", "z12", "z13", "z14", "z15", "z16", "z17", "z18", "z19", "z20", "z21", "z22", "z23", "z24", "z25", "z26", "z27", "z28", "z29", "z30", "z31"
  );
}

}  // namespace input_transform
}  // namespace winograd
}  // namespace arm_conv

#endif // __aarch64__ && defined(ARM_COMPUTE_ENABLE_SVE)
