#include <gtest/gtest.h>

#include <filesystem>

#include "aevol.h"

namespace fs = std::filesystem;
using namespace aevol;

TEST(CheckpointExplorerTest, OpenDefaultFromTime) {
  auto checkpoint_explorer = CheckpointExplorer::make_from_checkpoint(100);
}

TEST(CheckpointExplorerTest, OpenDefaultFromFileName) {
  auto checkpoint_explorer =
      CheckpointExplorer::make_from_checkpoint_path("./checkpoints/checkpoint_000000100/checkpoint_000000100.ae");
}

TEST(CheckpointExplorerTest, OpenCustomYetCanonical) {
  auto checkpoint_explorer = CheckpointExplorer::make_from_checkpoint_path("./ckpts/ckpt/my_checkpoint_100.ae");
}

TEST(CheckpointExplorerTest, OpenCustom) {
  auto checkpoint_explorer = CheckpointExplorer::make_from_checkpoint_path("./ckpts/custom_ckpt/foo.ae");
}
